/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.compiler.rule.builder.dialect.java;

import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.List;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.compiler.rule.builder.RuleBuildContext;
import org.drools.compiler.rule.builder.RuleBuilder;
import org.drools.core.base.EnabledBoolean;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.rule.GroupElement;
import org.drools.core.rule.Pattern;
import org.drools.core.time.TimeUtils;
import org.drools.core.time.impl.IntervalTimer;
import org.drools.core.time.impl.Timer;
import org.drools.core.util.DateUtils;
import org.drools.drl.ast.descr.AndDescr;
import org.drools.drl.ast.descr.AttributeDescr;
import org.drools.drl.ast.descr.BaseDescr;
import org.drools.drl.ast.descr.ExprConstraintDescr;
import org.drools.drl.ast.descr.PackageDescr;
import org.drools.drl.ast.descr.PatternDescr;
import org.drools.drl.ast.descr.RuleDescr;
import org.drools.drl.parser.DrlParser;
import org.drools.mvel.MVELConstraint;
import org.junit.Assert;
import org.junit.Test;
import org.kie.internal.builder.conf.LanguageLevelOption;
import org.mockito.Mockito;

public class RuleBuilderTest {
    @Test
    public void testBuild() throws Exception {
        DrlParser parser = new DrlParser(LanguageLevelOption.DRL5);
        KnowledgeBuilderImpl kBuilder = new KnowledgeBuilderImpl();
        kBuilder.addPackage(new PackageDescr("org.drools"));
        InternalKnowledgePackage pkg = kBuilder.getPackage("org.drools");
        PackageDescr pkgDescr = parser.parse((Reader)new InputStreamReader(this.getClass().getResourceAsStream("nestedConditionalElements.drl")));
        Assert.assertFalse((String)parser.getErrors().toString(), (boolean)parser.hasErrors());
        pkg.addGlobal("results", List.class);
        RuleDescr ruleDescr = (RuleDescr)pkgDescr.getRules().get(0);
        String ruleClassName = "RuleClassName.java";
        ruleDescr.setClassName("RuleClassName.java");
        ruleDescr.addAttribute(new AttributeDescr("dialect", "java"));
        kBuilder.addPackage(pkgDescr);
        Assert.assertTrue((String)kBuilder.getErrors().toString(), (boolean)kBuilder.getErrors().isEmpty());
        RuleImpl rule = kBuilder.getPackage("org.drools.mvel.compiler").getRule("test nested CEs");
        Assert.assertEquals((String)"There should be 2 rule level declarations", (long)2L, (long)rule.getDeclarations().size());
        GroupElement not = (GroupElement)rule.getLhs().getChildren().get(1);
        Assert.assertTrue((boolean)not.isNot());
        Assert.assertTrue((boolean)not.getOuterDeclarations().isEmpty());
        Assert.assertEquals((long)1L, (long)not.getInnerDeclarations().size());
        Assert.assertTrue((boolean)not.getInnerDeclarations().keySet().contains("$state"));
        GroupElement not2 = (GroupElement)((GroupElement)not.getChildren().get(0)).getChildren().get(1);
        Assert.assertTrue((boolean)not2.isNot());
        Assert.assertTrue((boolean)not2.getOuterDeclarations().isEmpty());
        Assert.assertEquals((long)1L, (long)not2.getInnerDeclarations().size());
        Assert.assertTrue((boolean)not2.getInnerDeclarations().keySet().contains("$likes"));
    }

    @Test
    public void testBuildAttributes() throws Exception {
        RuleBuildContext context = (RuleBuildContext)Mockito.mock(RuleBuildContext.class);
        RuleImpl rule = (RuleImpl)Mockito.mock(RuleImpl.class);
        RuleDescr ruleDescr = new RuleDescr("my rule");
        ruleDescr.addAttribute(new AttributeDescr("no-loop", "true"));
        ruleDescr.addAttribute(new AttributeDescr("auto-focus", "false"));
        ruleDescr.addAttribute(new AttributeDescr("agenda-group", "my agenda"));
        ruleDescr.addAttribute(new AttributeDescr("activation-group", "my activation"));
        ruleDescr.addAttribute(new AttributeDescr("lock-on-active", ""));
        ruleDescr.addAttribute(new AttributeDescr("enabled", "false"));
        ruleDescr.addAttribute(new AttributeDescr("duration", "60"));
        ruleDescr.addAttribute(new AttributeDescr("calendars", "\"cal1\""));
        ruleDescr.addAttribute(new AttributeDescr("date-effective", "10-Jul-1974"));
        ruleDescr.addAttribute(new AttributeDescr("date-expires", "10-Jul-2040"));
        Calendar effective = Calendar.getInstance();
        effective.setTime(DateUtils.parseDate((String)"10-Jul-1974"));
        Calendar expires = Calendar.getInstance();
        expires.setTime(DateUtils.parseDate((String)"10-Jul-2040"));
        Mockito.when((Object)context.getRule()).thenReturn((Object)rule);
        Mockito.when((Object)context.getRuleDescr()).thenReturn((Object)ruleDescr);
        Mockito.when((Object)context.getKnowledgeBuilder()).thenReturn((Object)new KnowledgeBuilderImpl());
        RuleBuilder.buildAttributes((RuleBuildContext)context);
        ((RuleImpl)Mockito.verify((Object)rule)).setNoLoop(true);
        ((RuleImpl)Mockito.verify((Object)rule)).setAutoFocus(false);
        ((RuleImpl)Mockito.verify((Object)rule)).setAgendaGroup("my agenda");
        ((RuleImpl)Mockito.verify((Object)rule)).setActivationGroup("my activation");
        ((RuleImpl)Mockito.verify((Object)rule)).setLockOnActive(true);
        ((RuleImpl)Mockito.verify((Object)rule)).setEnabled(EnabledBoolean.ENABLED_FALSE);
        ((RuleImpl)Mockito.verify((Object)rule)).setTimer((Timer)new IntervalTimer(null, null, -1, TimeUtils.parseTimeString((String)"60"), 0L));
        ((RuleImpl)Mockito.verify((Object)rule)).setCalendars(new String[]{"cal1"});
        ((RuleImpl)Mockito.verify((Object)rule)).setDateEffective(effective);
        ((RuleImpl)Mockito.verify((Object)rule)).setDateExpires(expires);
    }

    @Test
    public void testBuildMetaAttributes() throws Exception {
        RuleBuildContext context = (RuleBuildContext)Mockito.mock(RuleBuildContext.class);
        RuleImpl rule = (RuleImpl)Mockito.mock(RuleImpl.class);
        RuleDescr ruleDescr = new RuleDescr("my rule");
        ruleDescr.addAnnotation("ruleId", "123");
        ruleDescr.addAnnotation("author", "Bob Doe");
        ruleDescr.addAnnotation("text", "\"It's a quoted\\\" string\"");
        Mockito.when((Object)context.getRule()).thenReturn((Object)rule);
        Mockito.when((Object)context.getRuleDescr()).thenReturn((Object)ruleDescr);
        Mockito.when((Object)context.getKnowledgeBuilder()).thenReturn((Object)new KnowledgeBuilderImpl());
        RuleBuilder.buildMetaAttributes((RuleBuildContext)context);
        ((RuleImpl)Mockito.verify((Object)rule)).addMetaAttribute("ruleId", (Object)123);
        ((RuleImpl)Mockito.verify((Object)rule)).addMetaAttribute("author", (Object)"Bob Doe");
        ((RuleImpl)Mockito.verify((Object)rule)).addMetaAttribute("text", (Object)"It's a quoted\" string");
    }

    @Test
    public void testBuildDurationExpression() throws Exception {
        RuleBuildContext context = (RuleBuildContext)Mockito.mock(RuleBuildContext.class);
        RuleImpl rule = (RuleImpl)Mockito.mock(RuleImpl.class);
        RuleDescr ruleDescr = new RuleDescr("my rule");
        ruleDescr.addAttribute(new AttributeDescr("duration", "( 1h30m )"));
        ruleDescr.addAttribute(new AttributeDescr("calendars", "[\"cal1\", \"cal2\"]"));
        Mockito.when((Object)context.getRule()).thenReturn((Object)rule);
        Mockito.when((Object)context.getRuleDescr()).thenReturn((Object)ruleDescr);
        RuleBuilder.buildAttributes((RuleBuildContext)context);
        ((RuleImpl)Mockito.verify((Object)rule)).setTimer((Timer)new IntervalTimer(null, null, -1, TimeUtils.parseTimeString((String)"1h30m"), 0L));
        ((RuleImpl)Mockito.verify((Object)rule)).setCalendars(new String[]{"cal1", "cal2"});
    }

    @Test
    public void testBuildBigDecimalLiteralConstraint() throws Exception {
        PackageDescr pkgDescr = new PackageDescr("org.drools");
        RuleDescr ruleDescr = new RuleDescr("Test Rule");
        AndDescr andDescr = new AndDescr();
        PatternDescr patDescr = new PatternDescr("java.math.BigDecimal", "$bd");
        ExprConstraintDescr fcd = new ExprConstraintDescr("this == 10");
        patDescr.addConstraint((BaseDescr)fcd);
        andDescr.addDescr((BaseDescr)patDescr);
        ruleDescr.setLhs(andDescr);
        ruleDescr.setConsequence((Object)"");
        pkgDescr.addRule(ruleDescr);
        KnowledgeBuilderImpl kBuilder = new KnowledgeBuilderImpl();
        kBuilder.addPackage(pkgDescr);
        Assert.assertTrue((String)kBuilder.getErrors().toString(), (boolean)kBuilder.getErrors().isEmpty());
        RuleImpl rule = kBuilder.getPackages()[0].getRule("Test Rule");
        GroupElement and = rule.getLhs();
        Pattern pat = (Pattern)and.getChildren().get(0);
        if (pat.getConstraints().get(0) instanceof MVELConstraint) {
            MVELConstraint fc = (MVELConstraint)pat.getConstraints().get(0);
            Assert.assertTrue((String)("Wrong class. Expected java.math.BigDecimal. Found: " + fc.getField().getValue().getClass()), (boolean)(fc.getField().getValue() instanceof BigDecimal));
        }
    }

    @Test
    public void testInvalidDialect() throws Exception {
        PackageDescr pkgDescr = new PackageDescr("org.drools");
        RuleDescr ruleDescr = new RuleDescr("Test Rule");
        ruleDescr.addAttribute(new AttributeDescr("dialect", "mvl"));
        ruleDescr.setConsequence((Object)"");
        pkgDescr.addRule(ruleDescr);
        KnowledgeBuilderImpl kBuilder = new KnowledgeBuilderImpl();
        kBuilder.addPackage(pkgDescr);
        Assert.assertFalse((String)kBuilder.getErrors().toString(), (boolean)kBuilder.getErrors().isEmpty());
    }

    @Test
    public void testBuildBigIntegerLiteralConstraint() throws Exception {
        PackageDescr pkgDescr = new PackageDescr("org.drools");
        RuleDescr ruleDescr = new RuleDescr("Test Rule");
        AndDescr andDescr = new AndDescr();
        PatternDescr patDescr = new PatternDescr("java.math.BigInteger", "$bd");
        ExprConstraintDescr fcd = new ExprConstraintDescr("this==10");
        patDescr.addConstraint((BaseDescr)fcd);
        andDescr.addDescr((BaseDescr)patDescr);
        ruleDescr.setLhs(andDescr);
        ruleDescr.setConsequence((Object)"");
        pkgDescr.addRule(ruleDescr);
        KnowledgeBuilderImpl kBuilder = new KnowledgeBuilderImpl();
        kBuilder.addPackage(pkgDescr);
        Assert.assertTrue((String)kBuilder.getErrors().toString(), (boolean)kBuilder.getErrors().isEmpty());
        RuleImpl rule = kBuilder.getPackages()[0].getRule("Test Rule");
        GroupElement and = rule.getLhs();
        Pattern pat = (Pattern)and.getChildren().get(0);
        if (pat.getConstraints().get(0) instanceof MVELConstraint) {
            MVELConstraint fc = (MVELConstraint)pat.getConstraints().get(0);
            Assert.assertTrue((String)("Wrong class. Expected java.math.BigInteger. Found: " + fc.getField().getValue().getClass()), (boolean)(fc.getField().getValue() instanceof BigInteger));
        }
    }
}

