/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import org.drools.core.common.ActivationsManager;
import org.drools.core.common.InternalAgenda;
import org.drools.core.common.InternalAgendaGroup;
import org.drools.core.common.InternalRuleFlowGroup;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.phreak.RuleAgendaItem;
import org.drools.core.spi.AgendaGroup;
import org.drools.mvel.compiler.Cell;
import org.drools.mvel.compiler.Cheese;
import org.drools.mvel.compiler.FactA;
import org.drools.mvel.compiler.Foo;
import org.drools.mvel.compiler.Message;
import org.drools.mvel.compiler.Neighbor;
import org.drools.mvel.compiler.Person;
import org.drools.mvel.compiler.Pet;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.event.rule.AfterMatchFiredEvent;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.event.rule.DefaultAgendaEventListener;
import org.kie.api.event.rule.MatchCancelledEvent;
import org.kie.api.event.rule.MatchCreatedEvent;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.FactHandle;

@RunWith(value=Parameterized.class)
public class ExecutionFlowControlTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public ExecutionFlowControlTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    @Test(timeout=10000L)
    public void testSalienceIntegerAndLoadOrder() throws Exception {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_salienceIntegerRule.drl"});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Person person = new Person("Edson", "cheese");
        ksession.insert((Object)person);
        ksession.fireAllRules();
        Assert.assertEquals((String)"Three rules should have been fired", (long)3L, (long)list.size());
        Assert.assertEquals((String)"Rule 4 should have been fired first", (Object)"Rule 4", list.get(0));
        Assert.assertEquals((String)"Rule 2 should have been fired second", (Object)"Rule 2", list.get(1));
        Assert.assertEquals((String)"Rule 3 should have been fired third", (Object)"Rule 3", list.get(2));
    }

    @Test
    public void testSalienceExpression() throws Exception {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_salienceExpressionRule.drl"});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Person person10 = new Person("bob", "cheese", 10);
        ksession.insert((Object)person10);
        Person person20 = new Person("mic", "cheese", 20);
        ksession.insert((Object)person20);
        ksession.fireAllRules();
        Assert.assertEquals((String)"Two rules should have been fired", (long)2L, (long)list.size());
        Assert.assertEquals((String)"Rule 3 should have been fired first", (Object)"Rule 3", list.get(0));
        Assert.assertEquals((String)"Rule 2 should have been fired second", (Object)"Rule 2", list.get(1));
    }

    @Test
    public void testSalienceExpressionWithOr() throws Exception {
        String text = "package org.kie.test\nglobal java.util.List list\nimport " + FactA.class.getCanonicalName() + "\nimport " + Foo.class.getCanonicalName() + "\nimport " + Pet.class.getCanonicalName() + "\nrule r1 salience (f1.field2)\nwhen\n    foo: Foo()\n    ( Pet()  and f1 : FactA( field1 == 'f1') ) or \n    f1 : FactA(field1 == 'f2') \nthen\n    list.add( f1 );\n    foo.setId( 'xxx' );\nend\n\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{text});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)new Foo(null, null));
        ksession.insert((Object)new Pet(null));
        FactA fact1 = new FactA();
        fact1.setField1("f1");
        fact1.setField2(10);
        FactA fact2 = new FactA();
        fact2.setField1("f1");
        fact2.setField2(30);
        FactA fact3 = new FactA();
        fact3.setField1("f2");
        fact3.setField2(20);
        ksession.insert((Object)fact1);
        ksession.insert((Object)fact2);
        ksession.insert((Object)fact3);
        ksession.fireAllRules();
        System.out.println(list);
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertEquals((Object)fact2, list.get(0));
        Assert.assertEquals((Object)fact3, list.get(1));
        Assert.assertEquals((Object)fact1, list.get(2));
    }

    @Test
    public void testSalienceMinInteger() throws Exception {
        String text = "package org.kie.test\nglobal java.util.List list\nrule a\nwhen\nthen\n    list.add( \"a\" );\nend\n\nrule b\n   salience ( Integer.MIN_VALUE )\nwhen\nthen\n    list.add( \"b\" );\nend\n\nrule c\nwhen\nthen\n    list.add( \"c\" );\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{text});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        Assert.assertEquals((Object)"b", list.get(2));
    }

    @Test
    public void testLoadOrderConflictResolver() throws Exception {
        String text = "package org.kie.test\nglobal java.util.List list\nrule a\nwhen\n      s : String( this == 'a') \nthen\n    list.add( s );\nend\n\nrule b\nwhen\n      s : String( this == 'b') \nthen\n    list.add( s );\nend\n\nrule c\nwhen\n      s : String( this == 'c') \nthen\n    list.add( s );\n    insert( new String(\"a\") ); \n    insert( new String(\"b\") ); \nend\n\nrule d\nwhen\n    s : String( this == 'd') \nthen\n    list.add( s );\n    insert( new String(\"b\") ); \n    insert( new String(\"a\") ); \nend\n\nrule e\nwhen\n    s : String( this == 'e') \nthen\n    list.add( s );\nend\n\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{text});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)"a");
        ksession.insert((Object)"b");
        ksession.insert((Object)"c");
        ksession.insert((Object)"d");
        ksession.insert((Object)"e");
        ksession.fireAllRules();
        Assert.assertEquals((long)9L, (long)list.size());
        Assert.assertEquals((Object)"a", list.get(0));
        Assert.assertEquals((Object)"b", list.get(1));
        Assert.assertEquals((Object)"c", list.get(2));
        Assert.assertEquals((Object)"a", list.get(3));
        Assert.assertEquals((Object)"b", list.get(4));
        Assert.assertEquals((Object)"d", list.get(5));
        Assert.assertEquals((Object)"a", list.get(6));
        Assert.assertEquals((Object)"b", list.get(7));
        Assert.assertEquals((Object)"e", list.get(8));
    }

    @Test
    public void testEnabledExpressionWithOr() throws Exception {
        String text = "package org.kie.test\nglobal java.util.List list\nimport " + FactA.class.getCanonicalName() + "\nimport " + Foo.class.getCanonicalName() + "\nimport " + Pet.class.getCanonicalName() + "\nrule r1 salience(f1.field2) enabled(f1.field2 >= 20)\nwhen\n    foo: Foo()\n    ( Pet()  and f1 : FactA( field1 == 'f1') ) or \n    f1 : FactA(field1 == 'f2') \nthen\n    list.add( f1 );\n    foo.setId( 'xxx' );\nend\n\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{text});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)new Foo(null, null));
        ksession.insert((Object)new Pet(null));
        FactA fact1 = new FactA();
        fact1.setField1("f1");
        fact1.setField2(10);
        FactA fact2 = new FactA();
        fact2.setField1("f1");
        fact2.setField2(30);
        FactA fact3 = new FactA();
        fact3.setField1("f2");
        fact3.setField2(20);
        ksession.insert((Object)fact1);
        ksession.insert((Object)fact2);
        ksession.insert((Object)fact3);
        ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((Object)fact2, list.get(0));
        Assert.assertEquals((Object)fact3, list.get(1));
    }

    @Test
    public void testNoLoop() throws Exception {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"no-loop.drl"});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Cheese brie = new Cheese("brie", 12);
        ksession.insert((Object)brie);
        ksession.fireAllRules();
        Assert.assertEquals((String)"Should not loop  and thus size should be 1", (long)1L, (long)list.size());
    }

    @Test
    public void testNoLoopWithModify() throws Exception {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"no-loop_with_modify.drl"});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Cheese brie = new Cheese("brie", 12);
        ksession.insert((Object)brie);
        ksession.fireAllRules();
        Assert.assertEquals((String)"Should not loop  and thus size should be 1", (long)1L, (long)list.size());
        Assert.assertEquals((long)50L, (long)brie.getPrice());
    }

    @Test
    public void testLockOnActive() throws Exception {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_LockOnActive.drl"});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Cheese brie12 = new Cheese("brie", 12);
        ksession.insert((Object)brie12);
        ((InternalWorkingMemory)ksession).flushPropagations();
        InternalAgenda agenda = (InternalAgenda)ksession.getAgenda();
        InternalAgendaGroup group1 = agenda.getAgendaGroupsManager().getAgendaGroup("group1");
        Assert.assertEquals((long)1L, (long)group1.size());
        ksession.getAgenda().getAgendaGroup("group1").setFocus();
        Cheese brie10 = new Cheese("brie", 10);
        ksession.insert((Object)brie10);
        Assert.assertEquals((long)1L, (long)group1.size());
        Cheese cheddar20 = new Cheese("cheddar", 20);
        ksession.insert((Object)cheddar20);
        InternalAgendaGroup group2 = agenda.getAgendaGroupsManager().getAgendaGroup("group1");
        Assert.assertEquals((long)1L, (long)group2.size());
        agenda.getAgendaGroupsManager().setFocus((AgendaGroup)group2);
        Cheese cheddar17 = new Cheese("cheddar", 17);
        ksession.insert((Object)cheddar17);
        Assert.assertEquals((long)1L, (long)group2.size());
    }

    @Test
    public void testLockOnActiveForMain() {
        String str = "";
        str = str + "package org.kie \n";
        str = str + "global java.util.List list \n";
        str = str + "rule rule1 \n";
        str = str + "    lock-on-active true \n";
        str = str + "when \n";
        str = str + "    $str : String() \n";
        str = str + "then \n";
        str = str + "    list.add( $str ); \n";
        str = str + "end \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)"hello1");
        ksession.insert((Object)"hello2");
        ksession.insert((Object)"hello3");
        ksession.fireAllRules();
        Assert.assertEquals((long)3L, (long)list.size());
        ksession.insert((Object)"hello4");
        ksession.insert((Object)"hello5");
        ksession.insert((Object)"hello6");
        ksession.fireAllRules();
        Assert.assertEquals((long)6L, (long)list.size());
    }

    @Test
    public void testLockOnActiveForMainWithHalt() {
        String str = "";
        str = str + "package org.kie \n";
        str = str + "global java.util.List list \n";
        str = str + "rule rule1 \n";
        str = str + "    lock-on-active true \n";
        str = str + "when \n";
        str = str + "    $str : String() \n";
        str = str + "then \n";
        str = str + "    list.add( $str ); \n";
        str = str + "    if ( list.size() == 2 ) {\n";
        str = str + "        drools.halt();\n";
        str = str + "    }";
        str = str + "end \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)"hello1");
        ksession.insert((Object)"hello2");
        ksession.insert((Object)"hello3");
        ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)list.size());
        ksession.insert((Object)"hello4");
        ksession.insert((Object)"hello5");
        ksession.insert((Object)"hello6");
        ksession.fireAllRules();
        Assert.assertEquals((long)3L, (long)list.size());
    }

    @Test
    public void testLockOnActiveWithModify() throws Exception {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_LockOnActiveWithUpdate.drl"});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Cheese brie = new Cheese("brie", 13);
        Person bob = new Person("bob");
        bob.setCheese(brie);
        Person mic = new Person("mic");
        mic.setCheese(brie);
        Person mark = new Person("mark");
        mark.setCheese(brie);
        FactHandle brieHandle = ksession.insert((Object)brie);
        ksession.insert((Object)bob);
        ksession.insert((Object)mic);
        ksession.insert((Object)mark);
        InternalWorkingMemory wm = (InternalWorkingMemory)ksession;
        wm.flushPropagations();
        InternalAgenda agenda = (InternalAgenda)ksession.getAgenda();
        InternalAgendaGroup group1 = agenda.getAgendaGroupsManager().getAgendaGroup("group1");
        agenda.getAgendaGroupsManager().setFocus((AgendaGroup)group1);
        Assert.assertEquals((long)1L, (long)group1.size());
        RuleAgendaItem ruleItem1 = (RuleAgendaItem)group1.getActivations()[0];
        ruleItem1.getRuleExecutor().evaluateNetwork((ActivationsManager)wm.getAgenda());
        Assert.assertEquals((long)3L, (long)ruleItem1.getRuleExecutor().getLeftTupleList().size());
        agenda.fireNextItem(null, 0, 0);
        Assert.assertEquals((long)1L, (long)group1.size());
        Assert.assertEquals((long)2L, (long)ruleItem1.getRuleExecutor().getLeftTupleList().size());
        ksession.update(brieHandle, (Object)brie);
        Assert.assertEquals((long)1L, (long)group1.size());
        ruleItem1.getRuleExecutor().evaluateNetwork((ActivationsManager)wm.getAgenda());
        Assert.assertEquals((long)2L, (long)ruleItem1.getRuleExecutor().getLeftTupleList().size());
        InternalAgendaGroup group2 = agenda.getAgendaGroupsManager().getAgendaGroup("group2");
        agenda.getAgendaGroupsManager().setFocus((AgendaGroup)group2);
        Assert.assertEquals((long)1L, (long)group2.size());
        RuleAgendaItem ruleItem2 = (RuleAgendaItem)group2.getActivations()[0];
        ruleItem2.getRuleExecutor().evaluateNetwork((ActivationsManager)wm.getAgenda());
        Assert.assertEquals((long)3L, (long)ruleItem2.getRuleExecutor().getLeftTupleList().size());
        agenda.fireNextItem(null, 0, 0);
        Assert.assertEquals((long)1L, (long)group2.size());
        Assert.assertEquals((long)2L, (long)ruleItem2.getRuleExecutor().getLeftTupleList().size());
        ksession.update(brieHandle, (Object)brie);
        Assert.assertEquals((long)1L, (long)group2.size());
        Assert.assertEquals((long)2L, (long)ruleItem2.getRuleExecutor().getLeftTupleList().size());
    }

    @Test
    public void testLockOnActiveWithModify2() throws Exception {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_LockOnActiveWithModify.drl"});
        KieSession ksession = kbase.newKieSession();
        int size = 3;
        Cell[][] cells = new Cell[3][];
        FactHandle[][] handles = new FactHandle[3][];
        for (int row = 0; row < 3; ++row) {
            cells[row] = new Cell[3];
            handles[row] = new FactHandle[3];
            for (int col = 0; col < 3; ++col) {
                cells[row][col] = new Cell(2, row, col);
                handles[row][col] = ksession.insert((Object)cells[row][col]);
                if (row >= 1 && col >= 1) {
                    ksession.insert((Object)new Neighbor(cells[row - 1][col - 1], cells[row][col]));
                    ksession.insert((Object)new Neighbor(cells[row][col], cells[row - 1][col - 1]));
                }
                if (row >= 1) {
                    ksession.insert((Object)new Neighbor(cells[row - 1][col], cells[row][col]));
                    ksession.insert((Object)new Neighbor(cells[row][col], cells[row - 1][col]));
                }
                if (row >= 1 && col < 2) {
                    ksession.insert((Object)new Neighbor(cells[row - 1][col + 1], cells[row][col]));
                    ksession.insert((Object)new Neighbor(cells[row][col], cells[row - 1][col + 1]));
                }
                if (col < 1) continue;
                ksession.insert((Object)new Neighbor(cells[row][col - 1], cells[row][col]));
                ksession.insert((Object)new Neighbor(cells[row][col], cells[row][col - 1]));
            }
        }
        ksession.getAgenda().getAgendaGroup("calculate").clear();
        int fired = ksession.fireAllRules(100);
        Assert.assertEquals((long)0L, (long)fired);
        ksession.getAgenda().getAgendaGroup("calculate").setFocus();
        fired = ksession.fireAllRules(100);
        Assert.assertEquals((long)0L, (long)fired);
        Assert.assertEquals((Object)"MAIN", (Object)((InternalAgenda)ksession.getAgenda()).getFocusName());
        cells[0][0].setState(1);
        ksession.update(handles[0][0], (Object)cells[0][0]);
        ksession.getAgenda().getAgendaGroup("birth").setFocus();
        ksession.getAgenda().getAgendaGroup("calculate").setFocus();
        fired = ksession.fireAllRules(100);
        int[][] expected = new int[][]{{0, 1, 0}, {1, 1, 0}, {0, 0, 0}};
        this.assertEqualsMatrix(3, cells, expected);
        Assert.assertEquals((Object)"MAIN", (Object)((InternalAgenda)ksession.getAgenda()).getFocusName());
        cells[1][1].setState(1);
        ksession.update(handles[1][1], (Object)cells[1][1]);
        ksession.getAgenda().getAgendaGroup("calculate").setFocus();
        ksession.fireAllRules(100);
        expected = new int[][]{{1, 2, 1}, {2, 1, 1}, {1, 1, 1}};
        this.assertEqualsMatrix(3, cells, expected);
        Assert.assertEquals((Object)"MAIN", (Object)((InternalAgenda)ksession.getAgenda()).getFocusName());
        ksession.getAgenda().getAgendaGroup("birth").setFocus();
        ksession.fireAllRules(100);
        expected = new int[][]{{1, 2, 1}, {2, 1, 1}, {1, 1, 1}};
        this.assertEqualsMatrix(3, cells, expected);
        Assert.assertEquals((Object)"MAIN", (Object)((InternalAgenda)ksession.getAgenda()).getFocusName());
        System.out.println("--------");
        ksession.getAgenda().getAgendaGroup("calculate").setFocus();
        ksession.fireAllRules(100);
        expected = new int[][]{{3, 3, 2}, {3, 3, 2}, {2, 2, 1}};
        this.assertEqualsMatrix(3, cells, expected);
        Assert.assertEquals((Object)"MAIN", (Object)((InternalAgenda)ksession.getAgenda()).getFocusName());
        System.out.println("--------");
        cells[0][0].setState(2);
        ksession.update(handles[0][0], (Object)cells[0][0]);
        ksession.getAgenda().getAgendaGroup("calculate").setFocus();
        ksession.fireAllRules(100);
        expected = new int[][]{{3, 2, 2}, {2, 2, 2}, {2, 2, 1}};
        this.assertEqualsMatrix(3, cells, expected);
        Assert.assertEquals((Object)"MAIN", (Object)((InternalAgenda)ksession.getAgenda()).getFocusName());
    }

    private void assertEqualsMatrix(int size, Cell[][] cells, int[][] expected) {
        for (int row = 0; row < size; ++row) {
            for (int col = 0; col < size; ++col) {
                Assert.assertEquals((String)("Wrong value at " + row + "," + col + ": "), (long)expected[row][col], (long)cells[row][col].getValue());
            }
        }
    }

    @Test
    public void testAgendaGroups() throws Exception {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_AgendaGroups.drl"});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Cheese brie = new Cheese("brie", 12);
        ksession.insert((Object)brie);
        ksession.fireAllRules();
        Assert.assertEquals((long)7L, (long)list.size());
        Assert.assertEquals((Object)"group3", list.get(0));
        Assert.assertEquals((Object)"group4", list.get(1));
        Assert.assertEquals((Object)"group3", list.get(2));
        Assert.assertEquals((Object)"MAIN", list.get(3));
        Assert.assertEquals((Object)"group1", list.get(4));
        Assert.assertEquals((Object)"group1", list.get(5));
        Assert.assertEquals((Object)"MAIN", list.get(6));
        ksession.getAgenda().getAgendaGroup("group2").setFocus();
        ksession.fireAllRules();
        Assert.assertEquals((long)8L, (long)list.size());
        Assert.assertEquals((Object)"group2", list.get(7));
    }

    @Test
    public void testActivationGroups() throws Exception {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_ActivationGroups.drl"});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Cheese brie = new Cheese("brie", 12);
        ksession.insert((Object)brie);
        ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((Object)"rule0", list.get(0));
        Assert.assertEquals((Object)"rule2", list.get(1));
    }

    @Test
    public void testActivationGroupWithTroubledSyntax() {
        String str = "package BROKEN_TEST;\nimport " + Holder.class.getCanonicalName() + ";\nrule \"_12\"\n    \n    salience 3\n    activation-group \"BROKEN\"\n    when\n        $a : Holder(value in (0))\n    then\n        System.out.println(\"setting 0\");\n        $a.setOutcome(\"setting 0\");\nend\n\nrule \"_13\"\n    \n    salience 2\n    activation-group \"BROKEN\"\n    when\n        $a : Holder(value in (1))\n    then\n        System.out.println(\"setting 1\");\n        $a.setOutcome(\"setting 1\");\nend\n\nrule \"_22\"\n    \n    salience 1\n    activation-group \"BROKEN\"\n    when\n        $a : Holder(value == null)\n    then\n        System.out.println(\"setting null\");\n        $a.setOutcome(\"setting null\");\nend\n\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        Holder inrec = new Holder(1);
        System.out.println("Holds: " + inrec.getValue());
        ksession.insert((Object)inrec);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)ksession.getFactHandles().size());
        Assert.assertEquals((Object)"setting 1", (Object)inrec.getOutcome());
        ksession.dispose();
        ksession = kbase.newKieSession();
        inrec = new Holder(null);
        System.out.println("Holds: " + inrec.getValue());
        ksession.insert((Object)inrec);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)ksession.getFactHandles().size());
        Assert.assertEquals((Object)"setting null", (Object)inrec.getOutcome());
        ksession.dispose();
        ksession = kbase.newKieSession();
        inrec = new Holder(0);
        System.out.println("Holds: " + inrec.getValue());
        ksession.insert((Object)inrec);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)ksession.getFactHandles().size());
        Assert.assertEquals((Object)"setting 0", (Object)inrec.getOutcome());
    }

    @Test
    public void testInsertRetractNoloop() throws Exception {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_Insert_Retract_Noloop.drl"});
        KieSession ksession = kbase.newKieSession();
        ksession.insert((Object)new Cheese("stilton", 15));
        ksession.fireAllRules();
        Assert.assertEquals((long)0L, (long)ksession.getObjects().size());
    }

    @Test
    public void testUpdateNoLoop() throws Exception {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_UpdateNoloop.drl"});
        KieSession ksession = kbase.newKieSession();
        Cheese cheese = new Cheese("stilton", 15);
        ksession.insert((Object)cheese);
        ksession.fireAllRules();
        Assert.assertEquals((long)14L, (long)cheese.getPrice());
    }

    @Test
    public void testUpdateActivationCreationNoLoop() throws Exception {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_UpdateActivationCreationNoLoop.drl"});
        KieSession ksession = kbase.newKieSession();
        final ArrayList created = new ArrayList();
        final ArrayList cancelled = new ArrayList();
        DefaultAgendaEventListener l = new DefaultAgendaEventListener(){

            public void matchCreated(MatchCreatedEvent event) {
                created.add(event);
            }

            public void matchCancelled(MatchCancelledEvent event) {
                cancelled.add(event);
            }
        };
        ksession.addEventListener((AgendaEventListener)l);
        Cheese stilton = new Cheese("stilton", 15);
        FactHandle stiltonHandle = ksession.insert((Object)stilton);
        Person p1 = new Person("p1");
        p1.setCheese(stilton);
        ksession.insert((Object)p1);
        Person p2 = new Person("p2");
        p2.setCheese(stilton);
        ksession.insert((Object)p2);
        Person p3 = new Person("p3");
        p3.setCheese(stilton);
        ksession.insert((Object)p3);
        ksession.fireAllRules();
        Assert.assertEquals((long)3L, (long)created.size());
        Assert.assertEquals((long)0L, (long)cancelled.size());
        ksession.update(stiltonHandle, (Object)stilton);
        Assert.assertEquals((long)3L, (long)created.size());
        Assert.assertEquals((long)0L, (long)cancelled.size());
    }

    @Test
    public void testRuleFlowGroup() throws Exception {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"ruleflowgroup.drl"});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)"Test");
        ksession.fireAllRules();
        Assert.assertEquals((long)0L, (long)list.size());
        ((InternalAgenda)ksession.getAgenda()).activateRuleFlowGroup("Group1");
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
    }

    @Test
    public void testRuleFlowGroupDeactivate() throws Exception {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"ruleflowgroup2.drl"});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)"Test");
        ksession.fireAllRules();
        Assert.assertEquals((long)0L, (long)list.size());
        Assert.assertEquals((long)2L, (long)((InternalRuleFlowGroup)ksession.getAgenda().getRuleFlowGroup("Group1")).size());
        ((InternalAgenda)ksession.getAgenda()).activateRuleFlowGroup("Group1");
        ksession.fireAllRules();
        Assert.assertEquals((long)0L, (long)list.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testRuleFlowGroupInActiveMode() throws Exception {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"ruleflowgroup.drl"});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        final AtomicBoolean fired = new AtomicBoolean(false);
        ksession.addEventListener((AgendaEventListener)new DefaultAgendaEventListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void afterMatchFired(AfterMatchFiredEvent event) {
                AtomicBoolean atomicBoolean = fired;
                synchronized (atomicBoolean) {
                    fired.set(true);
                    fired.notifyAll();
                }
            }
        });
        new Thread(() -> ((KieSession)ksession).fireUntilHalt()).start();
        try {
            ksession.insert((Object)"Test");
            Assert.assertEquals((long)0L, (long)list.size());
            ((InternalAgenda)ksession.getAgenda()).activateRuleFlowGroup("Group1");
            AtomicBoolean atomicBoolean = fired;
            synchronized (atomicBoolean) {
                if (!fired.get()) {
                    fired.wait();
                }
            }
            Assert.assertEquals((long)1L, (long)list.size());
        }
        finally {
            ksession.halt();
            ksession.dispose();
        }
    }

    @Test
    public void testDateEffective() throws Exception {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_EffectiveDate.drl"});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Message message = new Message("hola");
        ksession.insert((Object)message);
        ksession.fireAllRules();
        Assert.assertFalse((boolean)message.isFired());
    }

    @Test
    public void testNullPointerOnModifyWithLockOnActive() {
        String str = "package org.kie.test \nimport org.drools.mvel.compiler.Person; \nrule 'Rule 1' agenda-group 'g1' lock-on-active\twhen \n\t\t$p : Person( age != 35 ) \n\tthen \n\t\tmodify( $p ) { setAge( 35 ) };\t\nend \nrule 'Rule 2' agenda-group 'g1' no-loop when \n\t\t$p:  Person( age == 35) \n\tthen \n\t\tmodify( $p ) { setAge( 36 ) }; \nend \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        Person p = new Person("darth", 36);
        FactHandle fh = ksession.insert((Object)p);
        ksession.getAgenda().getAgendaGroup("g1").setFocus();
        ksession.fireAllRules();
        ksession.update(fh, (Object)p);
        Assert.assertEquals((long)36L, (long)p.getAge());
    }

    @Test
    public void testAgendaGroupGivewaySequence() {
        String str = "global java.util.List ruleList\n\nrule r1 agenda-group \"g1\" salience 20\n when    String( this == 'r1' )\nthen\n    ruleList.add(1);\nend\nrule r2 agenda-group \"g1\" salience 15\n when    String( this == 'r2' )\nthen\n    ruleList.add(2);\n    kcontext.getKnowledgeRuntime().getAgenda().getAgendaGroup(\"g2\").setFocus();\nend\nrule r3 agenda-group \"g1\" salience 10\n when    String( this == 'r3' )\nthen\n    ruleList.add(3);\nend\nrule r4 agenda-group \"g2\" salience 5\n when    String( this == 'r4' )\nthen\n    ruleList.add(4);\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ArrayList ruleList = new ArrayList();
        ksession.setGlobal("ruleList", ruleList);
        ksession.insert((Object)new String("r1"));
        ksession.insert((Object)new String("r1"));
        ksession.insert((Object)new String("r2"));
        ksession.insert((Object)new String("r2"));
        ksession.insert((Object)new String("r3"));
        ksession.insert((Object)new String("r3"));
        ksession.insert((Object)new String("r4"));
        ksession.insert((Object)new String("r4"));
        ksession.getAgenda().getAgendaGroup("g1").setFocus();
        Assert.assertEquals((long)8L, (long)ksession.fireAllRules());
        Assert.assertEquals((long)8L, (long)ruleList.size());
        Assert.assertEquals((Object)1, ruleList.get(0));
        Assert.assertEquals((Object)1, ruleList.get(1));
        Assert.assertEquals((Object)2, ruleList.get(2));
        Assert.assertEquals((Object)4, ruleList.get(3));
        Assert.assertEquals((Object)4, ruleList.get(4));
        Assert.assertEquals((Object)2, ruleList.get(5));
        Assert.assertEquals((Object)3, ruleList.get(6));
        Assert.assertEquals((Object)3, ruleList.get(7));
    }

    @Test
    public void testActivationGroupWithNots() {
        String drl = "global java.util.List list;\nrule R1 activation-group \"fatal\" when\n    $s : String()\n    not Integer( this.toString() == $s )\nthen\n    list.add(\"R1\");\nend\nrule R2 activation-group \"fatal\" when\n    $s : String()\n    not Long( this.toString() == $s )\nthen\n    list.add(\"R2\");\nend\nrule R3 activation-group \"fatal\" when\n    Long( )\nthen\n    list.add(\"R3\");\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)"1");
        ksession.insert((Object)2);
        ksession.insert((Object)3L);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
    }

    public static class Holder {
        private Integer val;
        private String outcome;

        public Holder(Integer val) {
            this.val = val;
        }

        public void setValue(Integer val) {
            this.val = val;
        }

        public Integer getValue() {
            return this.val;
        }

        public void setOutcome(String outcome) {
            this.outcome = outcome;
        }

        public String getOutcome() {
            return this.outcome;
        }
    }
}

