/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.drools.mvel.compiler.StockTick;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.conf.EventProcessingOption;
import org.kie.api.io.Resource;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.conf.ClockTypeOption;
import org.kie.api.runtime.rule.EntryPoint;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.api.time.SessionPseudoClock;

@RunWith(value=Parameterized.class)
public class LifecycleTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;
    private KieSession kieSession;

    public LifecycleTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    @Before
    public void initSession() {
        String drlString = "package org.jboss.brms\nimport org.drools.mvel.compiler.StockTick\ndeclare StockTick\n    @role( event )\n    @expires( 4s )\nend\nrule \"TestEventReceived\"\n    when\n        $event : StockTick() over window:time(4s) from entry-point EventStream\n    then\n        // do something;\nend";
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem();
        Resource drl = ks.getResources().newByteArrayResource(drlString.getBytes()).setTargetPath("org/jboss/brms/lifecycle.drl");
        kfs.write(drl);
        KieModuleModel kmoduleModel = ks.newKieModuleModel();
        kmoduleModel.newKieBaseModel("defaultKBase").addPackage("*").setEventProcessingMode(EventProcessingOption.STREAM).newKieSessionModel("defaultKieSession").setDefault(true).setClockType(ClockTypeOption.PSEUDO);
        kfs.writeKModuleXML(kmoduleModel.toXML());
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromKieFileSystem((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieFileSystem)kfs, (boolean)false);
        Assert.assertEquals((long)0L, (long)kieBuilder.getResults().getMessages().size());
        this.kieSession = ks.newKieContainer(ks.getRepository().getDefaultReleaseId()).newKieSession();
    }

    @After
    public void cleanup() {
        if (this.kieSession != null) {
            this.kieSession.dispose();
        }
    }

    @Test
    public void testExpires() throws Exception {
        EntryPoint entryPoint = this.kieSession.getEntryPoint("EventStream");
        StockTick event = new StockTick();
        FactHandle handle = entryPoint.insert((Object)event);
        Assert.assertTrue((boolean)entryPoint.getFactHandles().contains(handle));
        this.kieSession.fireAllRules();
        Assert.assertTrue((boolean)entryPoint.getFactHandles().contains(handle));
        this.advanceTime(5L, TimeUnit.SECONDS);
        this.kieSession.fireAllRules();
        Assert.assertFalse((boolean)entryPoint.getFactHandles().contains(handle));
    }

    private void advanceTime(long amount, TimeUnit unit) throws InterruptedException {
        if (this.kieSession.getSessionClock() instanceof SessionPseudoClock) {
            SessionPseudoClock clock = (SessionPseudoClock)this.kieSession.getSessionClock();
            clock.advanceTime(amount, unit);
        } else {
            Thread.sleep(TimeUnit.MILLISECONDS.convert(amount, unit));
        }
    }
}

