/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests;

import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.assertj.core.api.Assertions;
import org.drools.commands.runtime.rule.InsertElementsCommand;
import org.drools.compiler.integrationtests.incrementalcompilation.TestUtil;
import org.drools.core.SessionConfiguration;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.testcoverage.common.model.Cheese;
import org.drools.testcoverage.common.model.Cheesery;
import org.drools.testcoverage.common.model.Order;
import org.drools.testcoverage.common.model.OrderItem;
import org.drools.testcoverage.common.model.OuterClass;
import org.drools.testcoverage.common.model.Person;
import org.drools.testcoverage.common.model.StockTick;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.Message;
import org.kie.api.builder.ReleaseId;
import org.kie.api.command.Command;
import org.kie.api.event.rule.AfterMatchFiredEvent;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.conf.KieSessionOption;
import org.kie.api.runtime.rule.AccumulateFunction;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.api.runtime.rule.Match;
import org.kie.api.runtime.rule.QueryResults;
import org.kie.api.runtime.rule.QueryResultsRow;
import org.kie.api.runtime.rule.Variable;
import org.kie.internal.runtime.conf.ForceEagerActivationOption;
import org.kie.util.maven.support.ReleaseIdImpl;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=Parameterized.class)
public class AccumulateTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public AccumulateTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testAccumulateModify() {
        String drl = "package org.drools.compiler.integrationtests;\n\nimport " + Cheese.class.getCanonicalName() + ";\nimport " + Cheesery.class.getCanonicalName() + ";\nimport " + Person.class.getCanonicalName() + ";\n\nglobal java.util.List results;\n\nrule \"Constraints everywhere\" salience 80\n    when\n        $person      : Person( $likes : likes )\n        $cheesery    : Cheesery( totalAmount > 20 )\n                               from accumulate( $cheese : Cheese( type == $likes ),\n                                                init( Cheesery cheesery = new Cheesery(); ),\n                                                action( cheesery.addCheese( $cheese ); ),\n                                                result( cheesery ) );\n    then\n        results.add( $cheesery );\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"accumulate-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession wm = kbase.newKieSession();
        try {
            ArrayList results = new ArrayList();
            wm.setGlobal("results", results);
            Cheese[] cheese = new Cheese[]{new Cheese("stilton", 10), new Cheese("stilton", 2), new Cheese("stilton", 5), new Cheese("brie", 15), new Cheese("brie", 16), new Cheese("provolone", 8)};
            Person bob = new Person("Bob", "stilton");
            FactHandle[] cheeseHandles = new FactHandle[cheese.length];
            for (int i = 0; i < cheese.length; ++i) {
                cheeseHandles[i] = wm.insert((Object)cheese[i]);
            }
            FactHandle bobHandle = wm.insert((Object)bob);
            wm.fireAllRules();
            Assert.assertEquals((long)0L, (long)results.size());
            boolean index = true;
            cheese[1].setPrice(9);
            wm.update(cheeseHandles[1], (Object)cheese[1]);
            wm.fireAllRules();
            Assert.assertEquals((long)1L, (long)results.size());
            Assert.assertEquals((long)24L, (long)((Cheesery)results.get(results.size() - 1)).getTotalAmount());
            bob.setLikes("brie");
            wm.update(bobHandle, (Object)bob);
            wm.fireAllRules();
            Assert.assertEquals((long)2L, (long)results.size());
            Assert.assertEquals((long)31L, (long)((Cheesery)results.get(results.size() - 1)).getTotalAmount());
            wm.delete(cheeseHandles[3]);
            wm.fireAllRules();
            Assert.assertEquals((long)2L, (long)results.size());
        }
        finally {
            wm.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testAccumulate() {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources((String)"accumulate-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"org/drools/compiler/integrationtests/test_Accumulate.drl"});
        KieSession wm = kbase.newKieSession();
        try {
            ArrayList results = new ArrayList();
            wm.setGlobal("results", results);
            wm.insert((Object)new Person("Bob", "stilton", 20));
            wm.insert((Object)new Person("Mark", "provolone"));
            wm.insert((Object)new Cheese("stilton", 10));
            wm.insert((Object)new Cheese("brie", 5));
            wm.insert((Object)new Cheese("provolone", 150));
            wm.fireAllRules();
            System.out.println(results);
            Assert.assertEquals((long)5L, (long)results.size());
            Assert.assertEquals((Object)165, results.get(0));
            Assert.assertEquals((Object)10, results.get(1));
            Assert.assertEquals((Object)150, results.get(2));
            Assert.assertEquals((Object)10, results.get(3));
            Assert.assertEquals((Object)210, results.get(4));
        }
        finally {
            wm.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testAccumulateModifyMVEL() {
        String drl = "package org.drools.compiler.test;\n\nimport " + Cheese.class.getCanonicalName() + ";\nimport " + Person.class.getCanonicalName() + ";\nimport " + Cheesery.class.getCanonicalName() + ";\n\nglobal java.util.List results;\n\nrule \"Constraints everywhere\" salience 80\n    dialect \"mvel\"\n    when\n        $person      : Person( $likes : likes )\n        $cheesery    : Cheesery( totalAmount > 20 )\n                               from accumulate( $cheese : Cheese( type == $likes ),\n                                                init( cheesery = new Cheesery(); ),\n                                                action( cheesery.addCheese( $cheese ); ),\n                                                result( cheesery ) );\n    then\n        results.add( $cheesery );\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"accumulate-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession wm = kbase.newKieSession();
        try {
            ArrayList results = new ArrayList();
            wm.setGlobal("results", results);
            Cheese[] cheese = new Cheese[]{new Cheese("stilton", 10), new Cheese("stilton", 2), new Cheese("stilton", 5), new Cheese("brie", 15), new Cheese("brie", 16), new Cheese("provolone", 8)};
            Person bob = new Person("Bob", "stilton");
            FactHandle[] cheeseHandles = new FactHandle[cheese.length];
            for (int i = 0; i < cheese.length; ++i) {
                cheeseHandles[i] = wm.insert((Object)cheese[i]);
            }
            FactHandle bobHandle = wm.insert((Object)bob);
            wm.fireAllRules();
            Assert.assertEquals((long)0L, (long)results.size());
            boolean index = true;
            cheese[1].setPrice(9);
            wm.update(cheeseHandles[1], (Object)cheese[1]);
            wm.fireAllRules();
            Assert.assertEquals((long)1L, (long)results.size());
            Assert.assertEquals((long)24L, (long)((Cheesery)results.get(results.size() - 1)).getTotalAmount());
            bob.setLikes("brie");
            wm.update(bobHandle, (Object)bob);
            wm.fireAllRules();
            Assert.assertEquals((long)2L, (long)results.size());
            Assert.assertEquals((long)31L, (long)((Cheesery)results.get(results.size() - 1)).getTotalAmount());
            wm.delete(cheeseHandles[3]);
            wm.fireAllRules();
            Assert.assertEquals((long)2L, (long)results.size());
        }
        finally {
            wm.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAccumulateReverseModify() {
        String drl = "package org.drools.compiler.test;\n\nimport " + Cheese.class.getCanonicalName() + ";\nimport " + Person.class.getCanonicalName() + ";\nimport " + Cheesery.class.getCanonicalName() + ";\n\nglobal java.util.List results;\n\nrule \"Constraints everywhere\" salience 80\n    when\n        $person      : Person( $likes : likes )\n        $cheesery    : Cheesery( totalAmount > 20 )\n                               from accumulate( $cheese : Cheese( type == $likes ),\n                                                init( Cheesery cheesery = new Cheesery(); ),\n                                                action( cheesery.addCheese( $cheese ); ),\n                                                reverse( cheesery.removeCheese( $cheese ); ),\n                                                result( cheesery ) );\n    then\n        //System.out.println($person.getName() +\" is spending a lot buying cheese ( US$ \"+$cheesery.getTotalAmount()+\" )!\");\n        results.add( $cheesery );\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"accumulate-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession wm = kbase.newKieSession();
        try {
            ArrayList results = new ArrayList();
            wm.setGlobal("results", results);
            Cheese[] cheese = new Cheese[]{new Cheese("stilton", 10), new Cheese("stilton", 2), new Cheese("stilton", 5), new Cheese("brie", 15), new Cheese("brie", 16), new Cheese("provolone", 8)};
            Person bob = new Person("Bob", "stilton");
            FactHandle[] cheeseHandles = new FactHandle[cheese.length];
            for (int i = 0; i < cheese.length; ++i) {
                cheeseHandles[i] = wm.insert((Object)cheese[i]);
            }
            FactHandle bobHandle = wm.insert((Object)bob);
            wm.fireAllRules();
            Assert.assertEquals((long)0L, (long)results.size());
            boolean index = true;
            cheese[1].setPrice(9);
            wm.update(cheeseHandles[1], (Object)cheese[1]);
            wm.fireAllRules();
            Assert.assertEquals((long)1L, (long)results.size());
            Assert.assertEquals((long)24L, (long)((Cheesery)results.get(results.size() - 1)).getTotalAmount());
            bob.setLikes("brie");
            wm.update(bobHandle, (Object)bob);
            cheese[3].setPrice(20);
            wm.update(cheeseHandles[3], (Object)cheese[3]);
            wm.fireAllRules();
            Assert.assertEquals((long)2L, (long)results.size());
            Assert.assertEquals((long)36L, (long)((Cheesery)results.get(results.size() - 1)).getTotalAmount());
            wm.delete(cheeseHandles[3]);
            wm.fireAllRules();
            Assert.assertEquals((long)2L, (long)results.size());
        }
        finally {
            wm.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testAccumulateReverseModify2() {
        String drl = "package org.drools.compiler.test;\n\nimport " + Cheese.class.getCanonicalName() + ";\nimport " + Person.class.getCanonicalName() + ";\nimport " + Cheesery.class.getCanonicalName() + ";\n\nglobal java.util.List results;\n\nrule \"Constraints everywhere\" salience 80\n    when\n        $person      : Person( $likes : likes )\n        $total       : Number( intValue > 20 )\n                               from accumulate( Cheese( type == $likes, $p : price ),\n                                                init( int total = 0; ),\n                                                action( total += $p; ),\n                                                reverse( total -= $p; ),\n                                                result( new Integer( total ) ) )\n    then\n        results.add( $total );\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"accumulate-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession wm = kbase.newKieSession();
        try {
            ArrayList results = new ArrayList();
            wm.setGlobal("results", results);
            Cheese[] cheese = new Cheese[]{new Cheese("stilton", 10), new Cheese("stilton", 2), new Cheese("stilton", 5), new Cheese("brie", 15), new Cheese("brie", 16), new Cheese("provolone", 8)};
            Person bob = new Person("Bob", "stilton");
            FactHandle[] cheeseHandles = new FactHandle[cheese.length];
            for (int i = 0; i < cheese.length; ++i) {
                cheeseHandles[i] = wm.insert((Object)cheese[i]);
            }
            FactHandle bobHandle = wm.insert((Object)bob);
            wm.fireAllRules();
            Assert.assertEquals((long)0L, (long)results.size());
            boolean index = true;
            cheese[1].setPrice(9);
            wm.update(cheeseHandles[1], (Object)cheese[1]);
            wm.fireAllRules();
            Assert.assertEquals((long)1L, (long)results.size());
            Assert.assertEquals((long)24L, (long)((Number)results.get(results.size() - 1)).intValue());
            bob.setLikes("brie");
            wm.update(bobHandle, (Object)bob);
            cheese[3].setPrice(20);
            wm.update(cheeseHandles[3], (Object)cheese[3]);
            wm.fireAllRules();
            Assert.assertEquals((long)2L, (long)results.size());
            Assert.assertEquals((long)36L, (long)((Number)results.get(results.size() - 1)).intValue());
            wm.delete(cheeseHandles[3]);
            wm.fireAllRules();
            Assert.assertEquals((long)2L, (long)results.size());
        }
        finally {
            wm.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testAccumulateReverseModifyInsertLogical2() {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources((String)"accumulate-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"org/drools/compiler/integrationtests/test_AccumulateReverseModifyInsertLogical2.drl"});
        KieSession wm = kbase.newKieSession();
        try {
            ArrayList results = new ArrayList();
            wm.setGlobal("results", results);
            Cheese[] cheese = new Cheese[]{new Cheese("stilton", 10), new Cheese("stilton", 2), new Cheese("stilton", 5), new Cheese("brie", 15), new Cheese("brie", 16), new Cheese("provolone", 8)};
            Person alice = new Person("Alice", "brie");
            Person bob = new Person("Bob", "stilton");
            Person doug = new Person("Doug", "stilton");
            FactHandle[] cheeseHandles = new FactHandle[cheese.length];
            for (int i = 0; i < cheese.length; ++i) {
                cheeseHandles[i] = wm.insert((Object)cheese[i]);
            }
            wm.insert((Object)alice);
            wm.insert((Object)bob);
            wm.insert((Object)doug);
            wm.fireAllRules();
            Assert.assertEquals((long)31L, (long)((Number)results.get(results.size() - 1)).intValue());
            wm.delete(cheeseHandles[1]);
            wm.fireAllRules();
            Assert.assertEquals((long)30L, (long)((Number)results.get(results.size() - 1)).intValue());
        }
        finally {
            wm.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testAccumulateReverseModifyMVEL() {
        String drl = "package org.drools.compiler.test;\n\nimport " + Cheese.class.getCanonicalName() + ";\nimport " + Person.class.getCanonicalName() + ";\nimport " + Cheesery.class.getCanonicalName() + ";\n\nglobal java.util.List results;\n\nrule \"Constraints everywhere\" salience 80\n    dialect \"mvel\"\n    when\n        $person      : Person( $likes : likes )\n        $cheesery    : Cheesery( totalAmount > 20 )\n                               from accumulate( $cheese : Cheese( type == $likes ),\n                                                init( cheesery = new Cheesery(); ),\n                                                action( cheesery.addCheese( $cheese ); ),\n                                                reverse( cheesery.removeCheese( $cheese ); ),\n                                                result( cheesery ) );\n    then\n        results.add( $cheesery );\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"accumulate-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession wm = kbase.newKieSession();
        try {
            ArrayList results = new ArrayList();
            wm.setGlobal("results", results);
            Cheese[] cheese = new Cheese[]{new Cheese("stilton", 10), new Cheese("stilton", 2), new Cheese("stilton", 5), new Cheese("brie", 15), new Cheese("brie", 16), new Cheese("provolone", 8)};
            Person bob = new Person("Bob", "stilton");
            FactHandle[] cheeseHandles = new FactHandle[cheese.length];
            for (int i = 0; i < cheese.length; ++i) {
                cheeseHandles[i] = wm.insert((Object)cheese[i]);
            }
            FactHandle bobHandle = wm.insert((Object)bob);
            wm.fireAllRules();
            Assert.assertEquals((long)0L, (long)results.size());
            boolean index = true;
            cheese[1].setPrice(9);
            wm.update(cheeseHandles[1], (Object)cheese[1]);
            wm.fireAllRules();
            Assert.assertEquals((long)1L, (long)results.size());
            Assert.assertEquals((long)24L, (long)((Cheesery)results.get(results.size() - 1)).getTotalAmount());
            bob.setLikes("brie");
            wm.update(bobHandle, (Object)bob);
            wm.fireAllRules();
            Assert.assertEquals((long)2L, (long)results.size());
            Assert.assertEquals((long)31L, (long)((Cheesery)results.get(results.size() - 1)).getTotalAmount());
            wm.delete(cheeseHandles[3]);
            wm.fireAllRules();
            Assert.assertEquals((long)2L, (long)results.size());
        }
        finally {
            wm.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testAccumulateReverseModifyMVEL2() {
        String drl = "package org.drools.compiler.test;\n\nimport " + Cheese.class.getCanonicalName() + ";\nimport " + Person.class.getCanonicalName() + ";\nimport " + Cheesery.class.getCanonicalName() + ";\n\nglobal java.util.List results;\n\nrule \"Constraints everywhere\" salience 80\n    dialect \"mvel\"\n    when\n        $person      : Person( $likes : likes )\n        $total       : Number( intValue > 20 )\n                               from accumulate( $cheese : Cheese( type == $likes, $p : price ),\n                                                init( int total = 0; ),\n                                                action( total += $p; ),\n                                                reverse( total -= $p; ),\n                                                result( new Integer( total ) ) )\n    then\n        results.add( $total );\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"accumulate-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession wm = kbase.newKieSession();
        try {
            ArrayList results = new ArrayList();
            wm.setGlobal("results", results);
            Cheese[] cheese = new Cheese[]{new Cheese("stilton", 10), new Cheese("stilton", 2), new Cheese("stilton", 5), new Cheese("brie", 15), new Cheese("brie", 16), new Cheese("provolone", 8)};
            Person bob = new Person("Bob", "stilton");
            FactHandle[] cheeseHandles = new FactHandle[cheese.length];
            for (int i = 0; i < cheese.length; ++i) {
                cheeseHandles[i] = wm.insert((Object)cheese[i]);
            }
            FactHandle bobHandle = wm.insert((Object)bob);
            wm.fireAllRules();
            Assert.assertEquals((long)0L, (long)results.size());
            boolean index = true;
            cheese[1].setPrice(9);
            wm.update(cheeseHandles[1], (Object)cheese[1]);
            wm.fireAllRules();
            Assert.assertEquals((long)1L, (long)results.size());
            Assert.assertEquals((long)24L, (long)((Number)results.get(results.size() - 1)).intValue());
            bob.setLikes("brie");
            wm.update(bobHandle, (Object)bob);
            wm.fireAllRules();
            Assert.assertEquals((long)2L, (long)results.size());
            Assert.assertEquals((long)31L, (long)((Number)results.get(results.size() - 1)).intValue());
            wm.delete(cheeseHandles[3]);
            wm.fireAllRules();
            Assert.assertEquals((long)2L, (long)results.size());
        }
        finally {
            wm.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testAccumulateWithFromChaining() {
        String drl = "package org.drools.compiler\n\nimport java.util.List;\nimport java.util.ArrayList;\n\nimport " + Cheese.class.getCanonicalName() + ";\nimport " + Person.class.getCanonicalName() + ";\nimport " + Cheesery.class.getCanonicalName() + ";\n\nglobal java.util.List results;\n\nrule \"Accumulate with From Chaining\" salience 80\n    when\n        $cheesery : Cheesery()\n        $person   : Person( $likes : likes )\n        $list     : List( size > 2 )\n                               from accumulate( $cheese : Cheese( type == $likes  ) from $cheesery.getCheeses(),\n                                                init( List l = new ArrayList(); ),\n                                                action( l.add( $cheese ); )\n                                                result( l ) )\n    then\n        results.add( $list );\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"accumulate-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession wm = kbase.newKieSession();
        try {
            ArrayList results = new ArrayList();
            wm.setGlobal("results", results);
            Cheese[] cheese = new Cheese[]{new Cheese("stilton", 8), new Cheese("stilton", 10), new Cheese("stilton", 9), new Cheese("brie", 4), new Cheese("brie", 1), new Cheese("provolone", 8)};
            Cheesery cheesery = new Cheesery();
            for (Cheese aCheese : cheese) {
                cheesery.addCheese(aCheese);
            }
            FactHandle cheeseryHandle = wm.insert((Object)cheesery);
            Person bob = new Person("Bob", "stilton");
            FactHandle bobHandle = wm.insert((Object)bob);
            wm.fireAllRules();
            Assert.assertEquals((long)1L, (long)results.size());
            Assert.assertEquals((long)3L, (long)((List)results.get(results.size() - 1)).size());
            boolean index = true;
            cheese[1].setType("brie");
            wm.update(cheeseryHandle, (Object)cheesery);
            wm.fireAllRules();
            Assert.assertEquals((long)1L, (long)results.size());
            System.out.println(results);
            bob.setLikes("brie");
            wm.update(bobHandle, (Object)bob);
            wm.fireAllRules();
            Assert.assertEquals((long)2L, (long)results.size());
            Assert.assertEquals((long)3L, (long)((List)results.get(results.size() - 1)).size());
            cheesery.getCheeses().remove(cheese[3]);
            wm.update(cheeseryHandle, (Object)cheesery);
            wm.fireAllRules();
            Assert.assertEquals((long)2L, (long)results.size());
        }
        finally {
            wm.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testAccumulateInnerClass() {
        String drl = "package org.drools.compiler\n\nimport " + OuterClass.InnerClass.class.getCanonicalName() + ";\n\nglobal java.util.List results;\n\nrule \"Accumulate Inner Class\" \n    when\n        $totalAmount : Number() from accumulate( $inner : InnerClass( $val : intAttr ),\n                                                  init( int total = 0; ),\n                                                  action( total += $val; ),\n                                                  result( new Integer( total ) ) );\n    then\n        //System.out.println(\"Total amount = US$ \"+$totalAmount );\n        results.add($totalAmount);\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"accumulate-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession wm = kbase.newKieSession();
        try {
            ArrayList results = new ArrayList();
            wm.setGlobal("results", results);
            wm.insert((Object)new OuterClass.InnerClass(10));
            wm.insert((Object)new OuterClass.InnerClass(5));
            wm.fireAllRules();
            Assert.assertEquals((Object)15, results.get(0));
        }
        finally {
            wm.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testAccumulateReturningNull() {
        String drl = "package org.drools.compiler\n\nimport " + Cheese.class.getCanonicalName() + ";\n\nglobal java.util.List results;\n\nrule \"Accumulate Returning Null\" salience 100\n    when\n        // emulating a null return value for accumulate\n        $totalAmount : Number() from accumulate( Cheese( $price : price ),\n                                                 init( ),\n                                                 action( ),\n                                                 result( null ) );\n    then\n        //System.out.println(\"Total amount = US$ \"+$totalAmount );\n        results.add($totalAmount);\nend ";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"accumulate-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession wm = kbase.newKieSession();
        try {
            ArrayList results = new ArrayList();
            wm.setGlobal("results", results);
            wm.insert((Object)new Cheese("stilton", 10));
        }
        finally {
            wm.dispose();
        }
    }

    @Test(timeout=10000L)
    public void testAccumulateSumJava() {
        this.execTestAccumulateSum("org/drools/compiler/integrationtests/test_AccumulateSum.drl");
    }

    @Test(timeout=10000L)
    public void testAccumulateSumMVEL() {
        this.execTestAccumulateSum("org/drools/compiler/integrationtests/test_AccumulateSumMVEL.drl");
    }

    @Test(timeout=10000L)
    public void testAccumulateMultiPatternWithFunctionJava() {
        this.execTestAccumulateSum("org/drools/compiler/integrationtests/test_AccumulateMultiPatternFunctionJava.drl");
    }

    @Test(timeout=10000L)
    public void testAccumulateMultiPatternWithFunctionMVEL() {
        this.execTestAccumulateSum("org/drools/compiler/integrationtests/test_AccumulateMultiPatternFunctionMVEL.drl");
    }

    @Test(timeout=10000L)
    public void testAccumulateCountJava() {
        this.execTestAccumulateCount("org/drools/compiler/integrationtests/test_AccumulateCount.drl");
    }

    @Test(timeout=10000L)
    public void testAccumulateCountMVEL() {
        this.execTestAccumulateCount("org/drools/compiler/integrationtests/test_AccumulateCountMVEL.drl");
    }

    @Test(timeout=10000L)
    public void testAccumulateAverageJava() {
        this.execTestAccumulateAverage("org/drools/compiler/integrationtests/test_AccumulateAverage.drl");
    }

    @Test(timeout=10000L)
    public void testAccumulateAverageMVEL() {
        this.execTestAccumulateAverage("org/drools/compiler/integrationtests/test_AccumulateAverageMVEL.drl");
    }

    @Test(timeout=10000L)
    public void testAccumulateMinJava() {
        this.execTestAccumulateMin("org/drools/compiler/integrationtests/test_AccumulateMin.drl");
    }

    @Test(timeout=10000L)
    public void testAccumulateMinMVEL() {
        this.execTestAccumulateMin("org/drools/compiler/integrationtests/test_AccumulateMinMVEL.drl");
    }

    @Test(timeout=10000L)
    public void testAccumulateMaxJava() {
        this.execTestAccumulateMax("org/drools/compiler/integrationtests/test_AccumulateMax.drl");
    }

    @Test(timeout=10000L)
    public void testAccumulateMaxMVEL() {
        this.execTestAccumulateMax("org/drools/compiler/integrationtests/test_AccumulateMaxMVEL.drl");
    }

    @Test(timeout=10000L)
    public void testAccumulateMultiPatternJava() {
        this.execTestAccumulateReverseModifyMultiPattern("org/drools/compiler/integrationtests/test_AccumulateMultiPattern.drl");
    }

    @Test(timeout=10000L)
    public void testAccumulateMultiPatternMVEL() {
        this.execTestAccumulateReverseModifyMultiPattern("org/drools/compiler/integrationtests/test_AccumulateMultiPatternMVEL.drl");
    }

    @Test(timeout=10000L)
    public void testAccumulateCollectListJava() {
        this.execTestAccumulateCollectList("org/drools/compiler/integrationtests/test_AccumulateCollectList.drl");
    }

    @Test(timeout=10000L)
    public void testAccumulateCollectListMVEL() {
        this.execTestAccumulateCollectList("org/drools/compiler/integrationtests/test_AccumulateCollectListMVEL.drl");
    }

    @Test(timeout=10000L)
    public void testAccumulateCollectSetJava() {
        this.execTestAccumulateCollectSet("org/drools/compiler/integrationtests/test_AccumulateCollectSet.drl");
    }

    @Test(timeout=10000L)
    public void testAccumulateCollectSetMVEL() {
        this.execTestAccumulateCollectSet("org/drools/compiler/integrationtests/test_AccumulateCollectSetMVEL.drl");
    }

    @Test(timeout=10000L)
    public void testAccumulateMultipleFunctionsJava() {
        this.execTestAccumulateMultipleFunctions("org/drools/compiler/integrationtests/test_AccumulateMultipleFunctions.drl");
    }

    @Test(timeout=10000L)
    public void testAccumulateMultipleFunctionsMVEL() {
        this.execTestAccumulateMultipleFunctions("org/drools/compiler/integrationtests/test_AccumulateMultipleFunctionsMVEL.drl");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testAccumulateMultipleFunctionsConstraint() {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources((String)"accumulate-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"org/drools/compiler/integrationtests/test_AccumulateMultipleFunctionsConstraint.drl"});
        KieSession ksession = kbase.newKieSession();
        try {
            AgendaEventListener ael = (AgendaEventListener)Mockito.mock(AgendaEventListener.class);
            ksession.addEventListener(ael);
            Cheese[] cheese = new Cheese[]{new Cheese("stilton", 10), new Cheese("stilton", 3), new Cheese("stilton", 5), new Cheese("brie", 3), new Cheese("brie", 17), new Cheese("provolone", 8)};
            Person bob = new Person("Bob", "stilton");
            FactHandle[] cheeseHandles = new FactHandle[cheese.length];
            for (int i = 0; i < cheese.length; ++i) {
                cheeseHandles[i] = ksession.insert((Object)cheese[i]);
            }
            FactHandle bobHandle = ksession.insert((Object)bob);
            ksession.fireAllRules();
            ArgumentCaptor cap = ArgumentCaptor.forClass(AfterMatchFiredEvent.class);
            ((AgendaEventListener)Mockito.verify((Object)ael)).afterMatchFired((AfterMatchFiredEvent)cap.capture());
            Match activation = ((AfterMatchFiredEvent)cap.getValue()).getMatch();
            Assertions.assertThat((int)((Number)activation.getDeclarationValue("$sum")).intValue()).isEqualTo(18);
            Assertions.assertThat((int)((Number)activation.getDeclarationValue("$min")).intValue()).isEqualTo(3);
            Assertions.assertThat((int)((Number)activation.getDeclarationValue("$avg")).intValue()).isEqualTo(6);
            Mockito.reset((Object[])new AgendaEventListener[]{ael});
            boolean index = true;
            cheese[1].setPrice(9);
            ksession.update(cheeseHandles[1], (Object)cheese[1]);
            ksession.fireAllRules();
            ((AgendaEventListener)Mockito.verify((Object)ael, (VerificationMode)Mockito.never())).afterMatchFired((AfterMatchFiredEvent)Mockito.any(AfterMatchFiredEvent.class));
            Mockito.reset((Object[])new AgendaEventListener[]{ael});
            bob.setLikes("brie");
            ksession.update(bobHandle, (Object)bob);
            ksession.fireAllRules();
            ((AgendaEventListener)Mockito.verify((Object)ael)).afterMatchFired((AfterMatchFiredEvent)cap.capture());
            activation = ((AfterMatchFiredEvent)cap.getValue()).getMatch();
            Assertions.assertThat((int)((Number)activation.getDeclarationValue("$sum")).intValue()).isEqualTo(20);
            Assertions.assertThat((int)((Number)activation.getDeclarationValue("$min")).intValue()).isEqualTo(3);
            Assertions.assertThat((int)((Number)activation.getDeclarationValue("$avg")).intValue()).isEqualTo(10);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testAccumulateWithAndOrCombinations() {
        String drl = "package org.drools.compiler.test;\nimport " + Cheese.class.getCanonicalName() + ";\nimport " + Person.class.getCanonicalName() + ";\nrule \"Class cast causer\"\n    when\n        $person      : Person( $likes : likes )\n        $total       : Number() from accumulate( $p : Person(likes != $likes, $l : likes) and $c : Cheese( type == $l ),\n                                                min($c.getPrice()) )\n        ($p2 : Person(name == 'nobody') or $p2 : Person(name == 'Doug'))\n    then\n        System.out.println($p2.getName());\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"accumulate-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            ksession.insert((Object)new Cheese("stilton", 10));
            ksession.insert((Object)new Person("Alice", "brie"));
            ksession.insert((Object)new Person("Bob", "stilton"));
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execTestAccumulateSum(String fileName) {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources((String)"accumulate-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{fileName});
        KieSession session = kbase.newKieSession();
        try {
            DataSet data = new DataSet();
            data.results = new ArrayList();
            session.setGlobal("results", data.results);
            data.cheese = new Cheese[]{new Cheese("stilton", 8, 0), new Cheese("stilton", 10, 1), new Cheese("stilton", 9, 2), new Cheese("brie", 11, 3), new Cheese("brie", 4, 4), new Cheese("provolone", 8, 5)};
            data.bob = new Person("Bob", "stilton");
            data.cheeseHandles = new FactHandle[data.cheese.length];
            for (int i = 0; i < data.cheese.length; ++i) {
                data.cheeseHandles[i] = session.insert((Object)data.cheese[i]);
            }
            data.bobHandle = session.insert((Object)data.bob);
            session.fireAllRules();
            Assert.assertEquals((long)1L, (long)data.results.size());
            Assert.assertEquals((long)27L, (long)((Number)data.results.get(data.results.size() - 1)).intValue());
            this.updateReferences(session, data);
            boolean index = true;
            data.cheese[1].setPrice(3);
            session.update(data.cheeseHandles[1], (Object)data.cheese[1]);
            int count = session.fireAllRules();
            Assert.assertEquals((long)1L, (long)count);
            Assert.assertEquals((long)2L, (long)data.results.size());
            Assert.assertEquals((long)20L, (long)((Number)data.results.get(data.results.size() - 1)).intValue());
            data.bob.setLikes("brie");
            session.update(data.bobHandle, (Object)data.bob);
            session.fireAllRules();
            Assert.assertEquals((long)3L, (long)data.results.size());
            Assert.assertEquals((long)15L, (long)((Number)data.results.get(data.results.size() - 1)).intValue());
            session.delete(data.cheeseHandles[3]);
            session.fireAllRules();
            Assert.assertEquals((long)3L, (long)data.results.size());
        }
        finally {
            session.dispose();
        }
    }

    private void updateReferences(KieSession session, DataSet data) {
        data.results = (List)session.getGlobal("results");
        for (Object next : session.getObjects()) {
            if (next instanceof Cheese) {
                Cheese c;
                data.cheese[c.getOldPrice()] = c = (Cheese)next;
                data.cheeseHandles[c.getOldPrice()] = session.getFactHandle((Object)c);
                Assert.assertNotNull((Object)data.cheeseHandles[c.getOldPrice()]);
                continue;
            }
            if (!(next instanceof Person)) continue;
            data.bob = (Person)next;
            data.bobHandle = session.getFactHandle((Object)data.bob);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execTestAccumulateCount(String fileName) {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources((String)"accumulate-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{fileName});
        KieSession wm = kbase.newKieSession();
        try {
            ArrayList results = new ArrayList();
            wm.setGlobal("results", results);
            Cheese[] cheese = new Cheese[]{new Cheese("stilton", 8), new Cheese("stilton", 10), new Cheese("stilton", 9), new Cheese("brie", 4), new Cheese("brie", 1), new Cheese("provolone", 8)};
            Person bob = new Person("Bob", "stilton");
            FactHandle[] cheeseHandles = new FactHandle[cheese.length];
            for (int i = 0; i < cheese.length; ++i) {
                cheeseHandles[i] = wm.insert((Object)cheese[i]);
            }
            FactHandle bobHandle = wm.insert((Object)bob);
            wm.fireAllRules();
            Assert.assertEquals((long)1L, (long)results.size());
            Assert.assertEquals((long)3L, (long)((Number)results.get(results.size() - 1)).intValue());
            boolean index = true;
            cheese[1].setPrice(3);
            wm.update(cheeseHandles[1], (Object)cheese[1]);
            wm.fireAllRules();
            Assert.assertEquals((long)2L, (long)results.size());
            Assert.assertEquals((long)3L, (long)((Number)results.get(results.size() - 1)).intValue());
            bob.setLikes("brie");
            wm.update(bobHandle, (Object)bob);
            wm.fireAllRules();
            Assert.assertEquals((long)3L, (long)results.size());
            Assert.assertEquals((long)2L, (long)((Number)results.get(results.size() - 1)).intValue());
            wm.delete(cheeseHandles[3]);
            wm.fireAllRules();
            Assert.assertEquals((long)3L, (long)results.size());
        }
        finally {
            wm.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execTestAccumulateAverage(String fileName) {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources((String)"accumulate-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{fileName});
        KieSession wm = kbase.newKieSession();
        try {
            ArrayList results = new ArrayList();
            wm.setGlobal("results", results);
            Cheese[] cheese = new Cheese[]{new Cheese("stilton", 10), new Cheese("stilton", 2), new Cheese("stilton", 11), new Cheese("brie", 15), new Cheese("brie", 17), new Cheese("provolone", 8)};
            Person bob = new Person("Bob", "stilton");
            FactHandle[] cheeseHandles = new FactHandle[cheese.length];
            for (int i = 0; i < cheese.length; ++i) {
                cheeseHandles[i] = wm.insert((Object)cheese[i]);
            }
            FactHandle bobHandle = wm.insert((Object)bob);
            wm.fireAllRules();
            Assert.assertEquals((long)0L, (long)results.size());
            boolean index = true;
            cheese[1].setPrice(9);
            wm.update(cheeseHandles[1], (Object)cheese[1]);
            wm.fireAllRules();
            Assert.assertEquals((long)1L, (long)results.size());
            Assert.assertEquals((long)10L, (long)((Number)results.get(results.size() - 1)).intValue());
            bob.setLikes("brie");
            wm.update(bobHandle, (Object)bob);
            wm.fireAllRules();
            Assert.assertEquals((long)2L, (long)results.size());
            Assert.assertEquals((long)16L, (long)((Number)results.get(results.size() - 1)).intValue());
            wm.delete(cheeseHandles[3]);
            wm.delete(cheeseHandles[4]);
            wm.fireAllRules();
            Assert.assertEquals((long)2L, (long)results.size());
        }
        finally {
            wm.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execTestAccumulateMin(String fileName) {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources((String)"accumulate-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{fileName});
        KieSession wm = kbase.newKieSession();
        try {
            ArrayList results = new ArrayList();
            wm.setGlobal("results", results);
            Cheese[] cheese = new Cheese[]{new Cheese("stilton", 8), new Cheese("stilton", 10), new Cheese("stilton", 9), new Cheese("brie", 4), new Cheese("brie", 1), new Cheese("provolone", 8)};
            Person bob = new Person("Bob", "stilton");
            FactHandle[] cheeseHandles = new FactHandle[cheese.length];
            for (int i = 0; i < cheese.length; ++i) {
                cheeseHandles[i] = wm.insert((Object)cheese[i]);
            }
            FactHandle bobHandle = wm.insert((Object)bob);
            wm.fireAllRules();
            Assert.assertEquals((long)0L, (long)results.size());
            boolean index = true;
            cheese[1].setPrice(3);
            wm.update(cheeseHandles[1], (Object)cheese[1]);
            wm.fireAllRules();
            Assert.assertEquals((long)1L, (long)results.size());
            Assert.assertEquals((long)3L, (long)((Number)results.get(results.size() - 1)).intValue());
            bob.setLikes("brie");
            wm.update(bobHandle, (Object)bob);
            wm.fireAllRules();
            Assert.assertEquals((long)2L, (long)results.size());
            Assert.assertEquals((long)1L, (long)((Number)results.get(results.size() - 1)).intValue());
            wm.delete(cheeseHandles[3]);
            wm.delete(cheeseHandles[4]);
            wm.fireAllRules();
            Assert.assertEquals((long)2L, (long)results.size());
        }
        finally {
            wm.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execTestAccumulateMax(String fileName) {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources((String)"accumulate-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{fileName});
        KieSession wm = kbase.newKieSession();
        try {
            ArrayList results = new ArrayList();
            wm.setGlobal("results", results);
            Cheese[] cheese = new Cheese[]{new Cheese("stilton", 4), new Cheese("stilton", 2), new Cheese("stilton", 3), new Cheese("brie", 15), new Cheese("brie", 17), new Cheese("provolone", 8)};
            Person bob = new Person("Bob", "stilton");
            FactHandle[] cheeseHandles = new FactHandle[cheese.length];
            for (int i = 0; i < cheese.length; ++i) {
                cheeseHandles[i] = wm.insert((Object)cheese[i]);
            }
            FactHandle bobHandle = wm.insert((Object)bob);
            wm.fireAllRules();
            Assert.assertEquals((long)0L, (long)results.size());
            boolean index = true;
            cheese[1].setPrice(9);
            wm.update(cheeseHandles[1], (Object)cheese[1]);
            wm.fireAllRules();
            Assert.assertEquals((long)1L, (long)results.size());
            Assert.assertEquals((long)9L, (long)((Number)results.get(results.size() - 1)).intValue());
            bob.setLikes("brie");
            wm.update(bobHandle, (Object)bob);
            wm.fireAllRules();
            Assert.assertEquals((long)2L, (long)results.size());
            Assert.assertEquals((long)17L, (long)((Number)results.get(results.size() - 1)).intValue());
            wm.delete(cheeseHandles[3]);
            wm.delete(cheeseHandles[4]);
            wm.fireAllRules();
            Assert.assertEquals((long)2L, (long)results.size());
        }
        finally {
            wm.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execTestAccumulateCollectList(String fileName) {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources((String)"accumulate-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{fileName});
        KieSession wm = kbase.newKieSession();
        try {
            ArrayList results = new ArrayList();
            wm.setGlobal("results", results);
            Cheese[] cheese = new Cheese[]{new Cheese("stilton", 4), new Cheese("stilton", 2), new Cheese("stilton", 3), new Cheese("brie", 15), new Cheese("brie", 17), new Cheese("provolone", 8)};
            FactHandle[] cheeseHandles = new FactHandle[cheese.length];
            for (int i = 0; i < cheese.length; ++i) {
                cheeseHandles[i] = wm.insert((Object)cheese[i]);
            }
            wm.fireAllRules();
            Assert.assertEquals((long)1L, (long)results.size());
            Assert.assertEquals((long)6L, (long)((List)results.get(results.size() - 1)).size());
            boolean index = true;
            cheese[1].setPrice(9);
            wm.update(cheeseHandles[1], (Object)cheese[1]);
            wm.fireAllRules();
            Assert.assertEquals((long)2L, (long)results.size());
            Assert.assertEquals((long)6L, (long)((List)results.get(results.size() - 1)).size());
            wm.delete(cheeseHandles[3]);
            wm.delete(cheeseHandles[4]);
            wm.fireAllRules();
            Assert.assertEquals((long)2L, (long)results.size());
        }
        finally {
            wm.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execTestAccumulateCollectSet(String fileName) {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources((String)"accumulate-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{fileName});
        KieSession wm = kbase.newKieSession();
        try {
            ArrayList results = new ArrayList();
            wm.setGlobal("results", results);
            Cheese[] cheese = new Cheese[]{new Cheese("stilton", 4), new Cheese("stilton", 2), new Cheese("stilton", 3), new Cheese("brie", 15), new Cheese("brie", 17), new Cheese("provolone", 8)};
            FactHandle[] cheeseHandles = new FactHandle[cheese.length];
            for (int i = 0; i < cheese.length; ++i) {
                cheeseHandles[i] = wm.insert((Object)cheese[i]);
            }
            wm.fireAllRules();
            Assert.assertEquals((long)1L, (long)results.size());
            Assert.assertEquals((long)3L, (long)((Set)results.get(results.size() - 1)).size());
            boolean index = true;
            cheese[1].setPrice(9);
            wm.update(cheeseHandles[1], (Object)cheese[1]);
            wm.fireAllRules();
            Assert.assertEquals((long)2L, (long)results.size());
            Assert.assertEquals((long)3L, (long)((Set)results.get(results.size() - 1)).size());
            wm.delete(cheeseHandles[3]);
            wm.fireAllRules();
            Assert.assertEquals((long)3L, (long)results.size());
            Assert.assertEquals((long)3L, (long)((Set)results.get(results.size() - 1)).size());
            wm.delete(cheeseHandles[4]);
            wm.fireAllRules();
            Assert.assertEquals((long)3L, (long)results.size());
        }
        finally {
            wm.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execTestAccumulateReverseModifyMultiPattern(String fileName) {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources((String)"accumulate-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{fileName});
        KieSession wm = kbase.newKieSession();
        try {
            ArrayList results = new ArrayList();
            wm.setGlobal("results", results);
            Cheese[] cheese = new Cheese[]{new Cheese("stilton", 10), new Cheese("stilton", 2), new Cheese("stilton", 5), new Cheese("brie", 15), new Cheese("brie", 16), new Cheese("provolone", 8)};
            Person bob = new Person("Bob", "stilton");
            Person mark = new Person("Mark", "provolone");
            FactHandle[] cheeseHandles = new FactHandle[cheese.length];
            for (int i = 0; i < cheese.length; ++i) {
                cheeseHandles[i] = wm.insert((Object)cheese[i]);
            }
            FactHandle bobHandle = wm.insert((Object)bob);
            wm.insert((Object)mark);
            wm.fireAllRules();
            Assert.assertEquals((long)0L, (long)results.size());
            boolean index = true;
            cheese[1].setPrice(9);
            wm.update(cheeseHandles[1], (Object)cheese[1]);
            wm.fireAllRules();
            Assert.assertEquals((long)1L, (long)results.size());
            Assert.assertEquals((long)32L, (long)((Cheesery)results.get(results.size() - 1)).getTotalAmount());
            bob.setLikes("brie");
            wm.update(bobHandle, (Object)bob);
            wm.fireAllRules();
            Assert.assertEquals((long)2L, (long)results.size());
            Assert.assertEquals((long)39L, (long)((Cheesery)results.get(results.size() - 1)).getTotalAmount());
            wm.delete(cheeseHandles[3]);
            wm.fireAllRules();
            Assert.assertEquals((long)2L, (long)results.size());
        }
        finally {
            wm.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testAccumulateWithPreviouslyBoundVariables() {
        String drl = "package org.drools.compiler\n\nimport " + Cheese.class.getCanonicalName() + ";\n\nglobal java.util.List results;\n\nrule \"Accumulate with bound var \" salience 100\n    when\n        Cheese( type == \"stilton\", $price : price )\n        $totalAmount : Number() from accumulate(  $c : Cheese( type == \"brie\" ),\n                                                  init( int total = 0; ),\n                                                  action( total += $c.getPrice() + $price; ),\n                                                  reverse( total -= $c.getPrice() + $price; ),\n                                                  result( new Integer( total ) ) );\n    then\n        //System.out.println(\"Total amount = US$ \"+$totalAmount );\n        results.add($totalAmount);\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"accumulate-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession wm = kbase.newKieSession();
        try {
            ArrayList results = new ArrayList();
            wm.setGlobal("results", results);
            wm.insert((Object)new Cheese("stilton", 10));
            wm.insert((Object)new Cheese("brie", 5));
            wm.insert((Object)new Cheese("provolone", 150));
            wm.insert((Object)new Cheese("brie", 20));
            wm.fireAllRules();
            Assert.assertEquals((long)1L, (long)results.size());
            Assert.assertEquals((Object)45, results.get(0));
        }
        finally {
            wm.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testAccumulateMVELWithModify() {
        String drl = "package org.drools.compiler\n\nimport " + Order.class.getCanonicalName() + ";\nimport " + OrderItem.class.getCanonicalName() + ";\n\nglobal java.util.List results;\n\nrule \"Accumulate with modify\" \n        dialect \"mvel\"\n    when\n        $o : Order( total == 0 )\n        Number( $total : doubleValue ) from accumulate(\n              OrderItem( order == $o, $p : price ),\n              sum( $p ) )\n    then\n        modify( $o ) { total = $total }\n        results.add( $total );\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"accumulate-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession wm = kbase.newKieSession();
        try {
            ArrayList results = new ArrayList();
            wm.setGlobal("results", results);
            Order order = new Order(1, "Bob");
            OrderItem item1 = new OrderItem(order, 1, "maquilage", 1, 10);
            OrderItem item2 = new OrderItem(order, 2, "perfume", 1, 5);
            order.addItem(item1);
            order.addItem(item2);
            wm.insert((Object)order);
            wm.insert((Object)item1);
            wm.insert((Object)item2);
            wm.fireAllRules();
            Assert.assertEquals((long)1L, (long)results.size());
            Assert.assertEquals((long)15L, (long)((Number)results.get(0)).intValue());
            Assert.assertEquals((double)15.0, (double)order.getTotal(), (double)0.0);
        }
        finally {
            wm.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testAccumulateGlobals() {
        String drl = "package org.drools.compiler\nimport " + Cheese.class.getCanonicalName() + ";\nglobal java.util.List results;\nglobal Integer globalValue;\n\nrule \"Accumulate globals\"\n    when\n        $totalAmount : Number() from accumulate(  Cheese( type == \"brie\" ),\n                                                  init( int total = 0; ),\n                                                  action( total += globalValue.intValue(); ),\n                                                  reverse( total -= globalValue.intValue(); ),\n                                                  result( new Integer( total ) ) );\n    then\n        results.add($totalAmount);\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"accumulate-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession wm = kbase.newKieSession();
        try {
            ArrayList results = new ArrayList();
            wm.setGlobal("results", results);
            wm.setGlobal("globalValue", (Object)50);
            wm.insert((Object)new Cheese("stilton", 10));
            wm.insert((Object)new Cheese("brie", 5));
            wm.insert((Object)new Cheese("provolone", 150));
            wm.insert((Object)new Cheese("brie", 20));
            wm.fireAllRules();
            Assert.assertEquals((long)1L, (long)results.size());
            Assert.assertEquals((Object)100, results.get(0));
        }
        finally {
            wm.dispose();
        }
    }

    @Test(timeout=10000L)
    public void testAccumulateNonExistingFunction() {
        String drl = "package org.drools.compiler\nimport " + StockTick.class.getCanonicalName() + ";\nrule \"Accumulate non existing function - Java\"\n    dialect \"java\"\n    when\n        $val : Number() from accumulate( $st : StockTick(),\n                                         nonExistingFunction( 1 ) );\n    then\n        // no-op\nend  \n\nrule \"Accumulate non existing function - MVEL\"\n    dialect \"mvel\"\n    when\n        $val : Number() from accumulate( $st : StockTick(),\n                                         nonExistingFunction( 1 ) );\n    then\n        // no-op\nend";
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{drl});
        Assertions.assertThat((List)kieBuilder.getResults().getMessages()).isNotEmpty();
        Assertions.assertThat((List)kieBuilder.getResults().getMessages()).extracting(Message::getText).anySatisfy(text -> Assertions.assertThat((String)text).contains(new CharSequence[]{"Unknown accumulate function: 'nonExistingFunction' on rule 'Accumulate non existing function - Java'."}));
        Assertions.assertThat((List)kieBuilder.getResults().getMessages()).extracting(Message::getText).anySatisfy(text -> Assertions.assertThat((String)text).contains(new CharSequence[]{"Unknown accumulate function: 'nonExistingFunction' on rule 'Accumulate non existing function - MVEL'."}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testAccumulateZeroParams() {
        String drl = "global java.util.List list;\nrule fromIt\nwhen\n    Number( $c: intValue ) from accumulate( Integer(), count( ) )\nthen\n    list.add( $c );\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"accumulate-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"global java.util.List list;\nrule fromIt\nwhen\n    Number( $c: intValue ) from accumulate( Integer(), count( ) )\nthen\n    list.add( $c );\nend"});
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            ksession.insert((Object)1);
            ksession.insert((Object)2);
            ksession.insert((Object)3);
            ksession.fireAllRules();
            Assert.assertEquals((long)1L, (long)list.size());
            Assert.assertEquals((Object)3, list.get(0));
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execTestAccumulateMultipleFunctions(String fileName) {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources((String)"accumulate-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{fileName});
        KieSession ksession = kbase.newKieSession();
        try {
            AgendaEventListener ael = (AgendaEventListener)Mockito.mock(AgendaEventListener.class);
            ksession.addEventListener(ael);
            Cheese[] cheese = new Cheese[]{new Cheese("stilton", 10), new Cheese("stilton", 3), new Cheese("stilton", 5), new Cheese("brie", 15), new Cheese("brie", 17), new Cheese("provolone", 8)};
            Person bob = new Person("Bob", "stilton");
            FactHandle[] cheeseHandles = new FactHandle[cheese.length];
            for (int i = 0; i < cheese.length; ++i) {
                cheeseHandles[i] = ksession.insert((Object)cheese[i]);
            }
            FactHandle bobHandle = ksession.insert((Object)bob);
            ksession.fireAllRules();
            ArgumentCaptor cap = ArgumentCaptor.forClass(AfterMatchFiredEvent.class);
            ((AgendaEventListener)Mockito.verify((Object)ael)).afterMatchFired((AfterMatchFiredEvent)cap.capture());
            Match activation = ((AfterMatchFiredEvent)cap.getValue()).getMatch();
            Assertions.assertThat((int)((Number)activation.getDeclarationValue("$sum")).intValue()).isEqualTo(18);
            Assertions.assertThat((int)((Number)activation.getDeclarationValue("$min")).intValue()).isEqualTo(3);
            Assertions.assertThat((int)((Number)activation.getDeclarationValue("$avg")).intValue()).isEqualTo(6);
            Mockito.reset((Object[])new AgendaEventListener[]{ael});
            boolean index = true;
            cheese[1].setPrice(9);
            ksession.update(cheeseHandles[1], (Object)cheese[1]);
            ksession.fireAllRules();
            ((AgendaEventListener)Mockito.verify((Object)ael)).afterMatchFired((AfterMatchFiredEvent)cap.capture());
            activation = ((AfterMatchFiredEvent)cap.getValue()).getMatch();
            Assertions.assertThat((int)((Number)activation.getDeclarationValue("$sum")).intValue()).isEqualTo(24);
            Assertions.assertThat((int)((Number)activation.getDeclarationValue("$min")).intValue()).isEqualTo(5);
            Assertions.assertThat((int)((Number)activation.getDeclarationValue("$avg")).intValue()).isEqualTo(8);
            Mockito.reset((Object[])new AgendaEventListener[]{ael});
            bob.setLikes("brie");
            ksession.update(bobHandle, (Object)bob);
            ksession.fireAllRules();
            ((AgendaEventListener)Mockito.verify((Object)ael)).afterMatchFired((AfterMatchFiredEvent)cap.capture());
            activation = ((AfterMatchFiredEvent)cap.getValue()).getMatch();
            Assertions.assertThat((int)((Number)activation.getDeclarationValue("$sum")).intValue()).isEqualTo(32);
            Assertions.assertThat((int)((Number)activation.getDeclarationValue("$min")).intValue()).isEqualTo(15);
            Assertions.assertThat((int)((Number)activation.getDeclarationValue("$avg")).intValue()).isEqualTo(16);
            Mockito.reset((Object[])new AgendaEventListener[]{ael});
            ksession.delete(cheeseHandles[3]);
            ksession.fireAllRules();
            ((AgendaEventListener)Mockito.verify((Object)ael)).afterMatchFired((AfterMatchFiredEvent)cap.capture());
            activation = ((AfterMatchFiredEvent)cap.getValue()).getMatch();
            Assertions.assertThat((int)((Number)activation.getDeclarationValue("$sum")).intValue()).isEqualTo(17);
            Assertions.assertThat((int)((Number)activation.getDeclarationValue("$min")).intValue()).isEqualTo(17);
            Assertions.assertThat((int)((Number)activation.getDeclarationValue("$avg")).intValue()).isEqualTo(17);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testAccumulateMinMax() {
        String drl = "package org.drools.compiler.test \nimport " + Cheese.class.getCanonicalName() + ";\nglobal java.util.List results \n rule minMax \nwhen \n    accumulate( Cheese( $p: price ), $min: min($p), $max: max($p) ) \nthen \n    results.add($min); results.add($max); \nend \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"accumulate-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            Cheese[] cheese;
            ArrayList results = new ArrayList();
            ksession.setGlobal("results", results);
            for (Cheese aCheese : cheese = new Cheese[]{new Cheese("Emmentaler", 4), new Cheese("Appenzeller", 6), new Cheese("Greyerzer", 2), new Cheese("Raclette", 3), new Cheese("Olm\u00fctzer Quargel", 15), new Cheese("Brie", 17), new Cheese("Dolcelatte", 8)}) {
                ksession.insert((Object)aCheese);
            }
            ksession.fireAllRules();
            Assert.assertEquals((long)2L, (long)results.size());
            Assert.assertEquals((long)((Number)results.get(0)).intValue(), (long)2L);
            Assert.assertEquals((long)((Number)results.get(1)).intValue(), (long)17L);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testAccumulateCE() {
        String drl = "package org.drools.compiler\nimport " + Cheese.class.getCanonicalName() + ";\nglobal java.util.List results\nrule \"ocount\"\nwhen\n    accumulate( Cheese(), $c: count(1) )\nthen\n    results.add( $c + \" facts\" );\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"accumulate-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            Cheese[] cheese;
            ArrayList results = new ArrayList();
            ksession.setGlobal("results", results);
            for (Cheese aCheese : cheese = new Cheese[]{new Cheese("Emmentaler", 4), new Cheese("Appenzeller", 6), new Cheese("Greyerzer", 2), new Cheese("Raclette", 3), new Cheese("Olm\u00fctzer Quargel", 15), new Cheese("Brie", 17), new Cheese("Dolcelatte", 8)}) {
                ksession.insert((Object)aCheese);
            }
            ksession.fireAllRules();
            Assert.assertEquals((long)1L, (long)results.size());
            Assert.assertEquals((Object)"7 facts", results.get(0));
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testAccumulateAndRetract() {
        String drl = "package org.drools.compiler;\n\nimport java.util.ArrayList;\n\nglobal ArrayList list;\n\ndeclare Holder\n    list : ArrayList\nend\n\nrule \"Init\"\nwhen\n    $l : ArrayList()\nthen\n    insert( new Holder($l) );\nend\n\nrule \"axx\"\nwhen\n    $h : Holder( $l : list )\n    $n : Long() from accumulate (\n                    $b : String( ) from $l;\n                    count($b))\nthen\n    System.out.println($n);\n    list.add($n);\nend\n\nrule \"clean\"\nsalience -10\nwhen\n    $h : Holder()\nthen\n    retract($h);\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"accumulate-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.drools.compiler;\n\nimport java.util.ArrayList;\n\nglobal ArrayList list;\n\ndeclare Holder\n    list : ArrayList\nend\n\nrule \"Init\"\nwhen\n    $l : ArrayList()\nthen\n    insert( new Holder($l) );\nend\n\nrule \"axx\"\nwhen\n    $h : Holder( $l : list )\n    $n : Long() from accumulate (\n                    $b : String( ) from $l;\n                    count($b))\nthen\n    System.out.println($n);\n    list.add($n);\nend\n\nrule \"clean\"\nsalience -10\nwhen\n    $h : Holder()\nthen\n    retract($h);\nend\n"});
        KieSession ks = kbase.newKieSession();
        try {
            ArrayList resList = new ArrayList();
            ks.setGlobal("list", resList);
            ArrayList<String> list = new ArrayList<String>();
            list.add("x");
            list.add("y");
            list.add("z");
            ks.insert(list);
            ks.fireAllRules();
            Assert.assertEquals((Object)3L, resList.get(0));
        }
        finally {
            ks.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testAccumulateWithNull() {
        String drl = "rule foo\nwhen\nObject() from accumulate( Object(),\ninit( Object res = null; )\naction( res = null; )\nresult( res ) )\nthen\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"accumulate-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"rule foo\nwhen\nObject() from accumulate( Object(),\ninit( Object res = null; )\naction( res = null; )\nresult( res ) )\nthen\nend"});
        KieSession ksession = kbase.newKieSession();
        try {
            ksession.fireAllRules();
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testAccumulateWithBoundExpression() {
        String drl = "package org.drools.compiler;\nimport " + MyObj.class.getCanonicalName() + ";\nglobal java.util.List results\nrule init\n   when\n   then\n       insert( new MyObj(5) );\n       insert( new MyObj(4) );\nend\nrule foo\n   salience -10\n   when\n       $n : Number() from accumulate( MyObj( $val : nestedObj.value ),\n                                      sum( $val ) )\n   then\n       results.add($n);\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"accumulate-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList results = new ArrayList();
            ksession.setGlobal("results", results);
            ksession.fireAllRules();
            ksession.dispose();
            Assert.assertEquals((long)1L, (long)results.size());
            Assert.assertEquals((Object)9L, results.get(0));
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testInfiniteLoopAddingPkgAfterSession() {
        String drl = "package org.drools.compiler.test;\nimport " + Triple.class.getCanonicalName() + ";\nrule \"accumulate 2 times\"\nwhen\n  $LIST : java.util.List( )  from accumulate( $Triple_1 : Triple( $CN : subject,    predicate == \"<http://deductions.sf.net/samples/princing.n3p.n3#number>\", $N : object ),      collectList( $N ) )\n  $NUMBER : Number() from accumulate(    $NUMBER_STRING_ : String() from $LIST , sum( Double.parseDouble( $NUMBER_STRING_)) )\nthen\n  System.out.println(\"ok\");\nend\n";
        InternalKnowledgeBase kbase = (InternalKnowledgeBase)KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"accumulate-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[0]);
        KieSession ksession = kbase.newKieSession();
        try {
            ksession.insert((Object)new Triple("<http://deductions.sf.net/samples/princing.n3p.n3#CN1>", "<http://deductions.sf.net/samples/princing.n3p.n3#number>", "200"));
            ksession.insert((Object)new Triple("<http://deductions.sf.net/samples/princing.n3p.n3#CN2>", "<http://deductions.sf.net/samples/princing.n3p.n3#number>", "100"));
            ksession.insert((Object)new Triple("<http://deductions.sf.net/samples/princing.n3p.n3#CN3>", "<http://deductions.sf.net/samples/princing.n3p.n3#number>", "100"));
            kbase.addPackages(TestUtil.createKnowledgeBuilder(null, drl).getKnowledgePackages());
            ksession.fireAllRules();
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testAccumulateWithVarsOutOfHashOrder() {
        String drl = "package com.sample;\n\nimport java.util.List;\n\ndeclare MessageHolder\n  id : String\n  msg: String\nend\n\nquery getResults( String $mId, List $holders )\n  accumulate(  \n    $holder  : MessageHolder( id == $mId, $ans : msg ),\n    $holders := collectList( $holder )\n  ) \nend\n\nrule \"Init\"\nwhen\nthen\n  insert( new MessageHolder( \"1\", \"x\" ) );\nend\n";
        InternalKnowledgeBase kbase = (InternalKnowledgeBase)KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"accumulate-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[0]);
        KieSession ksession = kbase.newKieSession();
        try {
            kbase.addPackages(TestUtil.createKnowledgeBuilder(null, "package com.sample;\n\nimport java.util.List;\n\ndeclare MessageHolder\n  id : String\n  msg: String\nend\n\nquery getResults( String $mId, List $holders )\n  accumulate(  \n    $holder  : MessageHolder( id == $mId, $ans : msg ),\n    $holders := collectList( $holder )\n  ) \nend\n\nrule \"Init\"\nwhen\nthen\n  insert( new MessageHolder( \"1\", \"x\" ) );\nend\n").getKnowledgePackages());
            ksession.fireAllRules();
            QueryResults res = ksession.getQueryResults("getResults", new Object[]{"1", Variable.v});
            Assert.assertEquals((long)1L, (long)res.size());
            Object o = ((QueryResultsRow)res.iterator().next()).get("$holders");
            Assert.assertTrue((boolean)(o instanceof List));
            Assert.assertEquals((long)1L, (long)((List)o).size());
        }
        finally {
            ksession.dispose();
        }
    }

    @Test(timeout=10000L)
    public void testAccumulateWithWindow() {
        String drl = "global java.util.Map map;\n \ndeclare Double\n@role(event)\nend\n \ndeclare window Streem\n    Double() over window:length( 10 )\nend\n \nrule \"See\"\nwhen\n    $a : Double() from accumulate (\n        $d: Double()\n            from window Streem,\n        sum( $d )\n    )\nthen\n    System.out.println( \"We have a sum \" + $a );\nend\n";
        this.testAccumulateEntryPointWindow("global java.util.Map map;\n \ndeclare Double\n@role(event)\nend\n \ndeclare window Streem\n    Double() over window:length( 10 )\nend\n \nrule \"See\"\nwhen\n    $a : Double() from accumulate (\n        $d: Double()\n            from window Streem,\n        sum( $d )\n    )\nthen\n    System.out.println( \"We have a sum \" + $a );\nend\n", null);
    }

    @Test(timeout=10000L)
    public void testAccumulateWithEntryPoint() {
        String drl = "global java.util.Map map;\n \ndeclare Double\n@role(event)\nend\n \nrule \"See\"\nwhen\n    $a : Double() from accumulate (\n        $d: Double()\n            from entry-point data,\n        sum( $d )\n    )\nthen\n    System.out.println( \"We have a sum \" + $a );\nend\n";
        this.testAccumulateEntryPointWindow("global java.util.Map map;\n \ndeclare Double\n@role(event)\nend\n \nrule \"See\"\nwhen\n    $a : Double() from accumulate (\n        $d: Double()\n            from entry-point data,\n        sum( $d )\n    )\nthen\n    System.out.println( \"We have a sum \" + $a );\nend\n", "data");
    }

    @Test(timeout=10000L)
    public void testAccumulateWithWindowAndEntryPoint() {
        String drl = "global java.util.Map map;\n \ndeclare Double\n@role(event)\nend\n \ndeclare window Streem\n    Double() over window:length( 10 ) from entry-point data\nend\n \nrule \"See\"\nwhen\n    $a : Double() from accumulate (\n        $d: Double()\n            from window Streem,\n        sum( $d )\n    )\nthen\n    System.out.println( \"We have a sum \" + $a );\nend\n";
        this.testAccumulateEntryPointWindow("global java.util.Map map;\n \ndeclare Double\n@role(event)\nend\n \ndeclare window Streem\n    Double() over window:length( 10 ) from entry-point data\nend\n \nrule \"See\"\nwhen\n    $a : Double() from accumulate (\n        $d: Double()\n            from window Streem,\n        sum( $d )\n    )\nthen\n    System.out.println( \"We have a sum \" + $a );\nend\n", "data");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testAccumulateEntryPointWindow(String drl, String entryPointName) {
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"accumulate-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            HashMap res = new HashMap();
            ksession.setGlobal("map", res);
            ksession.fireAllRules();
            for (int j = 0; j < 33; ++j) {
                if (entryPointName != null && !"".equals(entryPointName)) {
                    ksession.getEntryPoint("data").insert((Object)(1.0 * (double)j));
                } else {
                    ksession.insert((Object)(1.0 * (double)j));
                }
                ksession.fireAllRules();
            }
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void test2AccumulatesWithOr() {
        String drl = "import java.util.*;\nimport " + MyPerson.class.getCanonicalName() + ";\nglobal java.util.Map map;\ndialect \"mvel\"\n\nrule \"Test\"\n    when\n        $total : Number()\n             from accumulate( MyPerson( $age: age ),\n                              sum( $age ) )\n\n        $p: MyPerson();\n        $k: List( size > 0 ) from accumulate( MyPerson($kids: kids) from $p.kids,\n            init( ArrayList myList = new ArrayList(); ),\n            action( myList.addAll($kids); ),\n            reverse( myList.removeAll($kids); ),\n            result( myList )\n        )\n\n        $r : MyPerson(name == \"Jos Jr Jr\")\n        or\n        $r : MyPerson(name == \"Jos\")\n    then\n        Map pMap = map.get( $r.getName() );\n        pMap.put( 'total', $total );\n        pMap.put( 'p', $p );\n        pMap.put( 'k', $k );\n        pMap.put( 'r', $r );\n        map.put('count', ((Integer)map.get('count')) + 1 );\n end\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"accumulate-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            HashMap<String, Serializable> map = new HashMap<String, Serializable>();
            ksession.setGlobal("map", map);
            map.put("Jos Jr Jr", new HashMap());
            map.put("Jos", new HashMap());
            map.put("count", Integer.valueOf(0));
            MyPerson josJr = new MyPerson("Jos Jr Jr", 20, Arrays.asList(new MyPerson("John Jr 1st", 10, Collections.singletonList(new MyPerson("John Jr Jrx", 4, Collections.emptyList()))), new MyPerson("John Jr 2nd", 8, Collections.emptyList())));
            MyPerson jos = new MyPerson("Jos", 30, Arrays.asList(new MyPerson("Jeff Jr 1st", 10, Collections.emptyList()), new MyPerson("Jeff Jr 2nd", 8, Collections.emptyList())));
            ksession.execute((Command)new InsertElementsCommand(Arrays.asList(josJr, jos)));
            ksession.fireAllRules();
            Assert.assertEquals((Object)2, map.get("count"));
            Map pMap = (Map)map.get("Jos Jr Jr");
            Assert.assertEquals((double)50.0, (double)((Number)pMap.get("total")).doubleValue(), (double)1.0);
            List kids = (List)pMap.get("k");
            Assert.assertEquals((long)1L, (long)kids.size());
            Assert.assertEquals((Object)"John Jr Jrx", (Object)((MyPerson)kids.get(0)).getName());
            Assert.assertEquals((Object)josJr, pMap.get("p"));
            Assert.assertEquals((Object)josJr, pMap.get("r"));
            pMap = (Map)map.get("Jos");
            Assert.assertEquals((double)50.0, (double)((Number)pMap.get("total")).doubleValue(), (double)1.0);
            kids = (List)pMap.get("k");
            Assert.assertEquals((long)1L, (long)kids.size());
            Assert.assertEquals((Object)"John Jr Jrx", (Object)((MyPerson)kids.get(0)).getName());
            Assert.assertEquals((Object)josJr, pMap.get("p"));
            Assert.assertEquals((Object)jos, pMap.get("r"));
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAccumulateWithExists() {
        String drl = "import " + Course.class.getCanonicalName() + "\nimport " + Lecture.class.getCanonicalName() + "\nglobal java.util.List list; \nrule \"minimumWorkingDays\"\n    when\n        $course : Course($minWorkingDaySize : minWorkingDaySize)\n        $dayCount : Number(intValue <= $minWorkingDaySize) from accumulate(\n            $day : Integer()\n            and exists Lecture(course == $course, day == $day),\n            count($day)\n        )\n        // An uninitialized schedule should have no constraints broken\n        exists Lecture(course == $course)\n    then\n       list.add( $course );\n       list.add( $dayCount );\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"accumulate-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            Integer day1 = 1;
            Integer day2 = 2;
            Integer day3 = 3;
            Course c = new Course(2);
            Lecture l1 = new Lecture(c, day1);
            Lecture l2 = new Lecture(c, day2);
            ksession.insert((Object)day1);
            ksession.insert((Object)day2);
            ksession.insert((Object)day3);
            ksession.insert((Object)c);
            ksession.insert((Object)l1);
            ksession.insert((Object)l2);
            Assert.assertEquals((long)1L, (long)ksession.fireAllRules());
            Assert.assertEquals((long)2L, (long)list.size());
            Assert.assertEquals((Object)c, list.get(0));
            Assert.assertEquals((Object)2L, list.get(1));
        }
        finally {
            ksession.dispose();
        }
    }

    @Test
    public void testImportAccumulateFunction() {
        String drl = "package org.foo.bar\nimport accumulate " + TestFunction.class.getCanonicalName() + " f\nrule X when\n    accumulate( $s : String(),\n                $v : f( $s ) )\nthen\nend\n";
        this.testImportAccumulateFunction(drl);
    }

    @Test
    public void testImportAccumulateFunctionWithDeclaration() {
        String drl = "package org.foo.bar\nimport accumulate " + TestFunction.class.getCanonicalName() + " f;\nimport " + Person.class.getCanonicalName() + ";\ndeclare Person \n  @propertyReactive\nend\nrule X when\n    accumulate( $s : String(),\n                $v : f( $s ) )\nthen\nend\n";
        this.testImportAccumulateFunction(drl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testImportAccumulateFunction(String drl) {
        ReleaseIdImpl releaseId = new ReleaseIdImpl("foo", "bar", "1.0");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieContainer kc = KieServices.get().newKieContainer((ReleaseId)releaseId);
        KieSession ksession = kc.newKieSession();
        try {
            AgendaEventListener ael = (AgendaEventListener)Mockito.mock(AgendaEventListener.class);
            ksession.addEventListener(ael);
            ksession.insert((Object)"x");
            ksession.fireAllRules();
            ArgumentCaptor ac = ArgumentCaptor.forClass(AfterMatchFiredEvent.class);
            ((AgendaEventListener)Mockito.verify((Object)ael)).afterMatchFired((AfterMatchFiredEvent)ac.capture());
            Assertions.assertThat((Object)((AfterMatchFiredEvent)ac.getValue()).getMatch().getDeclarationValue("$v")).isEqualTo((Object)1);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAccumulateWithSharedNode() {
        String drl = "rule A when   Double() then end rule B  when    Double()    String()    $list : java.util.List(  this not contains \"XX\" )    $sum  : Integer( ) from accumulate ( $i : Integer(),                                         sum( $i ) ) then     $list.add( \"XX\" );\n    update( $list );\nend ";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"accumulate-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"rule A when   Double() then end rule B  when    Double()    String()    $list : java.util.List(  this not contains \"XX\" )    $sum  : Integer( ) from accumulate ( $i : Integer(),                                         sum( $i ) ) then     $list.add( \"XX\" );\n    update( $list );\nend "});
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            ksession.insert(list);
            ksession.insert((Object)42.0);
            ksession.insert((Object)9000);
            ksession.insert((Object)"a");
            ksession.insert((Object)"b");
            ksession.fireAllRules();
            Assert.assertEquals((long)1L, (long)list.size());
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEmptyAccumulateInSubnetwork() {
        String drl = "global java.util.List list;\nrule R when\n    $count : Number( ) from accumulate (\n        Integer() and\n        $s: String();\n        count($s)\n    )\nthen\n    list.add($count);\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"accumulate-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"global java.util.List list;\nrule R when\n    $count : Number( ) from accumulate (\n        Integer() and\n        $s: String();\n        count($s)\n    )\nthen\n    list.add($count);\nend"});
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            ksession.insert((Object)1);
            ksession.fireAllRules();
            Assert.assertEquals((long)1L, (long)list.size());
            Assert.assertEquals((long)0L, (long)((Long)list.get(0)));
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEmptyAccumulateInSubnetworkFollwedByPattern() {
        String drl = "global java.util.List list;\nrule R when\n    $count : Number( ) from accumulate (\n        Integer() and\n        $s: String();\n        count($s)\n    )\n    Long()\nthen\n    list.add($count);\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"accumulate-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"global java.util.List list;\nrule R when\n    $count : Number( ) from accumulate (\n        Integer() and\n        $s: String();\n        count($s)\n    )\n    Long()\nthen\n    list.add($count);\nend"});
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            ksession.insert((Object)1);
            ksession.insert((Object)1L);
            ksession.fireAllRules();
            Assert.assertEquals((long)1L, (long)list.size());
            Assert.assertEquals((long)0L, (long)((Long)list.get(0)));
        }
        finally {
            ksession.dispose();
        }
    }

    @Test
    public void testAccumulateWithoutSeparator() {
        String drl = "package org.drools.compiler\nimport " + Person.class.getCanonicalName() + ";\nrule \"Constraints everywhere\" \n    when\n        $person : Person( $likes : likes )\n        accumulate( Cheese( type == $likes, $price : price )\n                    $sum : sum( $price ),\n                    $avg : average( $price ),\n                    $min : min( $price );\n                    $min == 3,\n                    $sum > 10 )\n    then\n        // do something\nend  ";
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{drl});
        Assertions.assertThat((List)kieBuilder.getResults().getMessages()).isNotEmpty();
    }

    @Test
    public void testFromAccumulateWithoutSeparator() {
        String drl = "rule R when\n    $count : Number( ) from accumulate (\n        $s: String()\n        count($s)\n    )\nthen\n    System.out.println($count);\nend";
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{"rule R when\n    $count : Number( ) from accumulate (\n        $s: String()\n        count($s)\n    )\nthen\n    System.out.println($count);\nend"});
        Assertions.assertThat((List)kieBuilder.getResults().getMessages()).isNotEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReaccumulateForLeftTuple() {
        String drl = "import " + ExpectedMessage.class.getCanonicalName() + ";\nimport " + List.class.getCanonicalName() + ";\nimport " + ExpectedMessageToRegister.class.getCanonicalName() + ";\n\n\nrule \"Modify\"\n when\n $etr: ExpectedMessageToRegister(registered == false) then\n modify( $etr ) { setRegistered( true ) } end\nrule \"Collect\"\n salience 200 \n when\n etr: ExpectedMessageToRegister($type: type) $l : List( ) from collect( ExpectedMessage( type == $type ) from etr.expectedMessages ) then\n java.lang.System.out.println( $l.size() ); end\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"accumulate-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            ExpectedMessage psExpMsg1 = new ExpectedMessage("Index");
            ExpectedMessageToRegister etr1 = new ExpectedMessageToRegister("Index");
            etr1.msgs.add(psExpMsg1);
            ksession.insert((Object)etr1);
            ksession.fireAllRules();
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNoLoopAccumulate() {
        String drl = "import " + AtomicInteger.class.getCanonicalName() + ";\nrule NoLoopAccumulate\nno-loop\nwhen\n    accumulate( $s : String() ; $val : count($s) )\n    $a : AtomicInteger( )\nthen\n    modify($a) { set($val.intValue()) }\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"accumulate-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            AtomicInteger counter = new AtomicInteger(0);
            ksession.insert((Object)counter);
            ksession.insert((Object)"1");
            ksession.fireAllRules();
            Assert.assertEquals((long)1L, (long)counter.get());
            ksession.insert((Object)"2");
            ksession.fireAllRules();
            Assert.assertEquals((long)2L, (long)counter.get());
        }
        finally {
            ksession.dispose();
        }
    }

    @Test
    public void testAccumulateWithOr() {
        String drl = "import " + Converter.class.getCanonicalName() + ";\nglobal java.util.List list;\nrule R when\n  (or\n    Integer (this == 1)\n    Integer (this == 2)\n  )\nString( $length : length )\naccumulate ( $c : Converter(), $result : sum( $c.convert($length) ) )\nthen\n    list.add($result);\nend";
        this.testAccumulateWithOr(drl);
    }

    @Test
    public void testMvelAccumulateWithOr() {
        String drl = "import " + Converter.class.getCanonicalName() + ";\nglobal java.util.List list;\nrule R dialect \"mvel\" when\n  (or\n    Integer (this == 1)\n    Integer (this == 2)\n  )\nString( $length : length )\naccumulate ( $c : Converter(), $result : sum( $c.convert($length) ) )\nthen\n    list.add($result);\nend";
        this.testAccumulateWithOr(drl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testAccumulateWithOr(String drl) {
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"accumulate-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            ksession.insert((Object)1);
            ksession.insert((Object)"hello");
            ksession.insert((Object)new Converter());
            ksession.fireAllRules();
            Assert.assertEquals((long)1L, (long)list.size());
            Assert.assertEquals((long)5L, (long)((Number)list.get(0)).intValue());
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNormalizeStagedTuplesInAccumulate() {
        String drl = "global java.util.List list;\nrule R when\n    not( String() )\n    accumulate(\n        $l: Long();\n        count($l)\n    )\n    ( Boolean() or not( Float() ) )\nthen\n    list.add( \"fired\" ); \n    insert(new String());\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"accumulate-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"global java.util.List list;\nrule R when\n    not( String() )\n    accumulate(\n        $l: Long();\n        count($l)\n    )\n    ( Boolean() or not( Float() ) )\nthen\n    list.add( \"fired\" ); \n    insert(new String());\nend\n"});
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            ksession.fireAllRules();
            Assert.assertEquals((long)1L, (long)list.size());
        }
        finally {
            ksession.dispose();
        }
    }

    @Test
    public void testIncompatibleTypeOnAccumulateFunction() {
        String drl = "import " + MyPerson.class.getCanonicalName() + ";\nimport " + BigDecimal.class.getCanonicalName() + ";\nglobal java.util.List list;\nrule R when\n  $theFrom : BigDecimal() from accumulate(MyPerson( $val : age ); \n                                          sum( $val ) )\nthen\n  list.add($theFrom);\nend\n";
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{drl});
        Assertions.assertThat((List)kieBuilder.getResults().getMessages()).isNotEmpty();
    }

    @Test
    public void testIncompatibleListOnAccumulateFunction() {
        String drl = "import " + MyPerson.class.getCanonicalName() + ";\nimport " + BigDecimal.class.getCanonicalName() + ";\nglobal java.util.List list;\nrule R when\n  $theFrom : String() from accumulate(MyPerson( $val : age ); \n                                          collectList( $val ) )\nthen\n  list.add($theFrom);\nend\n";
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{drl});
        Assertions.assertThat((List)kieBuilder.getResults().getMessages()).isNotEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTypedSumOnAccumulate() {
        String drl = "global java.util.List list;\nrule R when\n  $i : Integer()\n  accumulate ( $s : String(), $result : sum( $s.length() ) )\nthen\n  list.add($result);\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"accumulate-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"global java.util.List list;\nrule R when\n  $i : Integer()\n  accumulate ( $s : String(), $result : sum( $s.length() ) )\nthen\n  list.add($result);\nend"});
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            ksession.insert((Object)1);
            ksession.insert((Object)"hello");
            ksession.insert((Object)"hi");
            ksession.fireAllRules();
            Assert.assertEquals((long)1L, (long)list.size());
            Assert.assertEquals((long)("hello".length() + "hi".length()), (long)((Integer)list.get(0)).intValue());
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSumAccumulateOnNullValue() {
        String drl = "import " + PersonWithBoxedAge.class.getCanonicalName() + ";\nglobal java.util.List list;\nrule R when\n  accumulate ( $p : PersonWithBoxedAge(), $result : sum( $p.getAge() ) )\nthen\n  list.add($result);\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"accumulate-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            ksession.insert((Object)new PersonWithBoxedAge("me", 30));
            ksession.insert((Object)new PersonWithBoxedAge("you", 40));
            ksession.insert((Object)new PersonWithBoxedAge("she", null));
            ksession.fireAllRules();
            Assert.assertEquals((long)1L, (long)list.size());
            Assert.assertEquals((long)70L, (long)((Integer)list.get(0)).intValue());
        }
        finally {
            ksession.dispose();
        }
    }

    @Test
    public void testMinAccumulateOnComparable() {
        this.testMinMaxAccumulateOnComparable("min", "she");
    }

    @Test
    public void testMaxAccumulateOnComparable() {
        this.testMinMaxAccumulateOnComparable("max", "you");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testMinMaxAccumulateOnComparable(String minMaxFunction, String expectedResult) {
        String drl = "import " + PersonWithBoxedAge.class.getCanonicalName() + ";\nglobal java.util.List list;\nrule R when\n  accumulate ( $p : PersonWithBoxedAge(), $result : " + minMaxFunction + "( $p ) )\nthen\n  list.add($result);\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"accumulate-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            ksession.insert((Object)new PersonWithBoxedAge("me", 30));
            ksession.insert((Object)new PersonWithBoxedAge("you", 40));
            ksession.insert((Object)new PersonWithBoxedAge("she", 25));
            ksession.fireAllRules();
            Assert.assertEquals((long)1L, (long)list.size());
            Assert.assertEquals((Object)expectedResult, (Object)((PersonWithBoxedAge)list.get(0)).getName());
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTypedMaxOnAccumulate() {
        String drl = "global java.util.List list;\nrule R when\n  $i : Integer()\n  $result : Integer() from accumulate ( $s : String(), max( $s.length() ) )\nthen\n  list.add($result);\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"accumulate-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"global java.util.List list;\nrule R when\n  $i : Integer()\n  $result : Integer() from accumulate ( $s : String(), max( $s.length() ) )\nthen\n  list.add($result);\nend"});
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            ksession.insert((Object)1);
            ksession.insert((Object)"hello");
            ksession.insert((Object)"hi");
            ksession.fireAllRules();
            Assert.assertEquals((long)1L, (long)list.size());
            Assert.assertEquals((long)"hello".length(), (long)((Integer)list.get(0)).intValue());
        }
        finally {
            ksession.dispose();
        }
    }

    @Test
    public void testVarianceDouble() {
        String drl = "import " + Cheese.class.getCanonicalName() + ";\nglobal java.util.List list;\nrule R when\n  accumulate(\n    Cheese($price : price);\n    $result : variance($price)\n  )\nthen\n  list.add($result);\nend";
        KieBase kieBase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"accumulate-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        Assert.assertEquals((double)0.0, (double)this.cheeseInsertsFunction(kieBase, 3, 3, 3, 3, 3), (double)0.01);
        Assert.assertEquals((double)0.8, (double)this.cheeseInsertsFunction(kieBase, 4, 4, 3, 2, 2), (double)0.01);
        Assert.assertEquals((double)1.2, (double)this.cheeseInsertsFunction(kieBase, 5, 3, 3, 2, 2), (double)0.01);
        Assert.assertEquals((double)2.8, (double)this.cheeseInsertsFunction(kieBase, 5, 5, 2, 2, 1), (double)0.01);
        Assert.assertEquals((double)2.8, (double)this.cheeseInsertsFunction(kieBase, 6, 3, 3, 2, 1), (double)0.01);
        Assert.assertEquals((double)4.4, (double)this.cheeseInsertsFunction(kieBase, 6, 5, 2, 1, 1), (double)0.01);
        Assert.assertEquals((double)16.0, (double)this.cheeseInsertsFunction(kieBase, 11, 1, 1, 1, 1), (double)0.01);
        Assert.assertEquals((double)36.0, (double)this.cheeseInsertsFunction(kieBase, 15, 0, 0, 0, 0), (double)0.01);
    }

    @Test
    public void testStandardDeviationDouble() {
        String drl = "import " + Cheese.class.getCanonicalName() + ";\nglobal java.util.List list;\nrule R when\n  accumulate(\n    Cheese($price : price);\n    $result : standardDeviation($price)\n  )\nthen\n  list.add($result);\nend";
        KieBase kieBase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"accumulate-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        Assert.assertEquals((double)0.0, (double)this.cheeseInsertsFunction(kieBase, 3, 3, 3, 3, 3), (double)0.01);
        Assert.assertEquals((double)0.89, (double)this.cheeseInsertsFunction(kieBase, 4, 4, 3, 2, 2), (double)0.01);
        Assert.assertEquals((double)1.1, (double)this.cheeseInsertsFunction(kieBase, 5, 3, 3, 2, 2), (double)0.01);
        Assert.assertEquals((double)1.67, (double)this.cheeseInsertsFunction(kieBase, 5, 5, 2, 2, 1), (double)0.01);
        Assert.assertEquals((double)1.67, (double)this.cheeseInsertsFunction(kieBase, 6, 3, 3, 2, 1), (double)0.01);
        Assert.assertEquals((double)2.1, (double)this.cheeseInsertsFunction(kieBase, 6, 5, 2, 1, 1), (double)0.01);
        Assert.assertEquals((double)4.0, (double)this.cheeseInsertsFunction(kieBase, 11, 1, 1, 1, 1), (double)0.01);
        Assert.assertEquals((double)6.0, (double)this.cheeseInsertsFunction(kieBase, 15, 0, 0, 0, 0), (double)0.01);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private double cheeseInsertsFunction(KieBase kieBase, int ... prices) {
        KieSession ksession = kieBase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            for (int price : prices) {
                ksession.insert((Object)new Cheese("stilton", price));
            }
            ksession.fireAllRules();
            Assert.assertEquals((long)1L, (long)list.size());
            double result = (Double)list.get(0);
            FactHandle triggerReverseHandle = ksession.insert((Object)new Cheese("triggerReverse", 7));
            ksession.fireAllRules();
            ksession.delete(triggerReverseHandle);
            list.clear();
            ksession.fireAllRules();
            Assert.assertEquals((long)1L, (long)list.size());
            Assert.assertEquals((double)result, (double)((Double)list.get(0)), (double)0.001);
            double d = (Double)list.get(0);
            return d;
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConcurrentLeftAndRightUpdate() {
        String drl = "package P;\nimport " + Visit.class.getCanonicalName() + ";\nglobal java.util.List list\nrule OvercommittedMechanic\nwhen\n  Visit($bucket : bucket)\n  $weeklyCommitment : Number() from accumulate(\n\t     Visit($duration : duration, bucket == $bucket),\n\t          sum($duration)\n      )\nthen\n  list.add($weeklyCommitment);end";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"accumulate-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession kieSession = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            kieSession.setGlobal("list", list);
            Visit visit1 = new Visit(1.0);
            Visit visit2 = new Visit(2.0);
            Visit visit3 = new Visit(3.0);
            Visit visit4 = new Visit(4.0);
            boolean bucketA = true;
            int bucketB = 2;
            visit1.setBucket(1);
            visit2.setBucket(2);
            visit3.setBucket(2);
            visit4.setBucket(2);
            FactHandle fhVisit1 = kieSession.insert((Object)visit1);
            kieSession.insert((Object)visit2);
            FactHandle fhVisit3 = kieSession.insert((Object)visit3);
            FactHandle fhVisit4 = kieSession.insert((Object)visit4);
            kieSession.fireAllRules();
            Assert.assertTrue((boolean)this.containsExactlyAndClear(list, 9.0, 9.0, 9.0, 1.0));
            kieSession.update(fhVisit4, (Object)visit4);
            kieSession.update(fhVisit3, (Object)visit3.setBucket(1));
            kieSession.update(fhVisit1, (Object)visit1.setBucket(2));
            kieSession.fireAllRules();
            Assert.assertTrue((boolean)this.containsExactlyAndClear(list, 7.0, 7.0, 3.0, 7.0));
            kieSession.update(fhVisit1, (Object)visit1.setBucket(1));
            kieSession.fireAllRules();
            Assert.assertTrue((boolean)list.containsAll(Arrays.asList(6.0, 4.0, 6.0, 4.0)));
        }
        finally {
            kieSession.dispose();
        }
    }

    private <T> boolean containsExactlyAndClear(List<T> list, T ... values) {
        if (list.size() != values.length) {
            return false;
        }
        for (T value : values) {
            if (list.remove(value)) continue;
            System.err.println(value + " not present");
            return false;
        }
        return list.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDoubleAccumulate() {
        String drl = "package P;import " + BusStop.class.getCanonicalName() + ";\nimport " + Coach.class.getCanonicalName() + ";\nimport " + Shuttle.class.getCanonicalName() + ";\n\nglobal java.util.List result;\n\nrule coachCapacity\n    when\n        $coach : Coach()\n        accumulate(\n            BusStop(bus == $coach);\n            count()\n        )\n\n        $shuttle : Shuttle()\n        accumulate(\n            BusStop(bus == $coach)\n            and BusStop(bus == $shuttle);\n            $result : count()\n        )\n    then\n        result.add($result);\nend";
        KieBase kieBase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"accumulate-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession kieSession = kieBase.newKieSession();
        try {
            ArrayList result = new ArrayList();
            kieSession.setGlobal("result", result);
            int id = 1;
            Coach coach1 = new Coach(id++);
            Coach coach2 = new Coach(id++);
            Shuttle shuttle = new Shuttle(id++);
            BusStop stop1 = new BusStop(id++);
            BusStop stop2 = new BusStop(id);
            stop2.setBus(coach2);
            kieSession.insert((Object)coach1);
            kieSession.insert((Object)coach2);
            FactHandle fhShuttle = kieSession.insert((Object)shuttle);
            FactHandle fhStop1 = kieSession.insert((Object)stop1);
            FactHandle fhStop2 = kieSession.insert((Object)stop2);
            kieSession.fireAllRules();
            result.clear();
            kieSession.update(fhShuttle, (Object)shuttle);
            kieSession.update(fhStop2, (Object)stop2);
            kieSession.fireAllRules();
            result.clear();
            kieSession.update(fhShuttle, (Object)shuttle);
            stop1.setBus(shuttle);
            kieSession.update(fhStop1, (Object)stop1);
            kieSession.fireAllRules();
            ArrayList actual = new ArrayList(result);
            Collections.sort(actual);
            result.clear();
            kieSession.dispose();
            kieSession = kieBase.newKieSession();
            kieSession.setGlobal("result", result);
            kieSession.insert((Object)coach1);
            kieSession.insert((Object)coach2);
            kieSession.insert((Object)shuttle);
            kieSession.insert((Object)stop1);
            kieSession.insert((Object)stop2);
            kieSession.fireAllRules();
            ArrayList expected = new ArrayList(result);
            Collections.sort(expected);
            Assert.assertEquals(expected, actual);
        }
        finally {
            kieSession.dispose();
        }
    }

    @Test
    public void testCompileFailureOnMissingImport() {
        String drl = "import " + BusStop.class.getCanonicalName() + ";\nrule \"sample rule\"\nwhen\n\n    $bus: Bus()\n    \n    accumulate(\n         $sample: BusStop(bus == $bus);\n    $count: count()\n    )\nthen\n    System.out.println(\"wierd error: \" + $count );\nend";
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{drl});
        Assertions.assertThat((List)kieBuilder.getResults().getMessages()).isNotEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAccumulateWithFrom() {
        String drl = "import " + Person.class.getCanonicalName() + "\nglobal java.util.List persons;\nglobal java.util.List list;\nrule AccumulateAdults when\n   accumulate( $p: Person( $age: age >= 18 ) from persons, \n               $sum : sum( $age ) )\nthen\n   list.add($sum); \nend\n";
        KieBase kieBase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"accumulate-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession kieSession = kieBase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            kieSession.setGlobal("list", list);
            List<Person> persons = Arrays.asList(new Person("Mario", 42), new Person("Marilena", 44), new Person("Sofia", 4));
            kieSession.setGlobal("persons", persons);
            Assert.assertEquals((long)1L, (long)kieSession.fireAllRules());
            Assert.assertEquals((long)1L, (long)list.size());
            Assert.assertEquals((long)86L, (long)((Integer)list.get(0)).intValue());
        }
        finally {
            kieSession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAccumulateWith2EntryPoints() {
        String drl = "import " + Person.class.getCanonicalName() + "\nglobal java.util.List list;\nrule AccumulateAdults when\n   String() from entry-point strings   accumulate( $p: Person( $age: age >= 18 ) from entry-point persons, \n               $sum : sum( $age ) )\nthen\n   list.add($sum); \nend\n";
        KieBase kieBase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"accumulate-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession kieSession = kieBase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            kieSession.setGlobal("list", list);
            kieSession.getEntryPoint("strings").insert((Object)"test");
            kieSession.getEntryPoint("persons").insert((Object)new Person("Mario", 42));
            kieSession.getEntryPoint("persons").insert((Object)new Person("Marilena", 44));
            kieSession.getEntryPoint("persons").insert((Object)new Person("Sofia", 4));
            Assert.assertEquals((long)1L, (long)kieSession.fireAllRules());
            Assert.assertEquals((long)1L, (long)list.size());
            Assert.assertEquals((long)86L, (long)((Integer)list.get(0)).intValue());
        }
        finally {
            kieSession.dispose();
        }
    }

    @Test
    public void testNumericMax() {
        Assert.assertEquals((long)44L, (long)((Integer)this.testMax("age")).intValue());
    }

    @Test
    public void testComparableMax() {
        Assert.assertEquals((Object)"Sofia", (Object)this.testMax("name"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object testMax(String fieldToUse) {
        String drl = "import " + Person.class.getCanonicalName() + "\nglobal java.util.List list;\nrule AccumulateAdults when\n   accumulate( $p: Person( ${fieldToUse} : {fieldToUse} ) , \n               $max : max( ${fieldToUse} ) )\nthen\n   list.add($max); \nend\n";
        KieBase kieBase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"accumulate-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl.replace("{fieldToUse}", fieldToUse)});
        KieSession kieSession = kieBase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            kieSession.setGlobal("list", list);
            kieSession.insert((Object)new Person("Mario", 42));
            kieSession.insert((Object)new Person("Marilena", 44));
            kieSession.insert((Object)new Person("Sofia", 4));
            Assert.assertEquals((long)1L, (long)kieSession.fireAllRules());
            Assert.assertEquals((long)1L, (long)list.size());
            Object e = list.get(0);
            return e;
        }
        finally {
            kieSession.dispose();
        }
    }

    @Test
    public void testAccumlateResultCannotBeUsedInFunctions() {
        String drl = "import java.util.*;rule \"Rule X\" when\n    openAlarms: Collection( ) from accumulate (\n            $s : String(),\n            init( Map map = new HashMap(); ),\n            action( map.put($s, openAlarms); ),\n            result( map.values() ) )\nthen\nend";
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{"import java.util.*;rule \"Rule X\" when\n    openAlarms: Collection( ) from accumulate (\n            $s : String(),\n            init( Map map = new HashMap(); ),\n            action( map.put($s, openAlarms); ),\n            result( map.values() ) )\nthen\nend"});
        Assertions.assertThat((List)kieBuilder.getResults().getMessages()).isNotEmpty();
        Assertions.assertThat((List)kieBuilder.getResults().getMessages()).extracting(Message::getText).anySatisfy(text -> Assertions.assertThat((String)text).contains(new CharSequence[]{"openAlarms"}));
    }

    @Test
    public void testAverageWithNoFacts() throws Exception {
        String drl = "import " + Person.class.getCanonicalName() + "\nglobal java.util.List list;\nrule R when\n   accumulate( String( $l : length ) , \n               $avg : average( $l ) )\nthen\n   list.add($avg); \nend\n";
        KieBase kieBase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"accumulate-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession kieSession = kieBase.newKieSession();
        ArrayList list = new ArrayList();
        kieSession.setGlobal("list", list);
        FactHandle fh = kieSession.insert((Object)"test");
        Assert.assertEquals((long)1L, (long)kieSession.fireAllRules());
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)4L, (long)((Number)list.get(0)).intValue());
        list.clear();
        kieSession.delete(fh);
        if (((SessionConfiguration)kieSession.getSessionConfiguration()).isAccumulateNullPropagation()) {
            Assert.assertEquals((long)1L, (long)kieSession.fireAllRules());
            Assert.assertEquals((long)1L, (long)list.size());
            Assert.assertNull(list.get(0));
        } else {
            Assert.assertEquals((long)0L, (long)kieSession.fireAllRules());
            Assert.assertEquals((long)0L, (long)list.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAverageFunctionRounding() {
        String drl = "import java.math.BigDecimal; \nimport java.util.List; \nglobal List<BigDecimal> resultList; \nrule \"accumulateTest\"\nwhen\n accumulate(\n    $bd: java.math.BigDecimal();\n    $ave: average( $bd ))\nthen\n     resultList.add($ave);\nend";
        KieBase kieBase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"accumulate-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"import java.math.BigDecimal; \nimport java.util.List; \nglobal List<BigDecimal> resultList; \nrule \"accumulateTest\"\nwhen\n accumulate(\n    $bd: java.math.BigDecimal();\n    $ave: average( $bd ))\nthen\n     resultList.add($ave);\nend"});
        KieSession kieSession = kieBase.newKieSession();
        ArrayList resultList = new ArrayList();
        kieSession.setGlobal("resultList", resultList);
        try {
            kieSession.insert((Object)new BigDecimal(0));
            kieSession.insert((Object)new BigDecimal(0));
            kieSession.insert((Object)new BigDecimal(1));
            Assert.assertEquals((long)1L, (long)kieSession.fireAllRules());
            Assert.assertEquals((long)1L, (long)resultList.size());
            Assert.assertEquals((Object)BigDecimal.ZERO, resultList.get(0));
        }
        finally {
            kieSession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNestedAccumulateWithPrefixAnd() {
        String drl = "rule R when\n    String($l: length)\n    accumulate(\n        (and\n            Integer(this == $l) \n            accumulate(\n                Long() \n                ;$counter: count(1);$counter <= 4)\n         )\n        ;$mainCounter: count(1);$mainCounter <= 2\n    )\nthen\n end";
        KieBase kieBase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"accumulate-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"rule R when\n    String($l: length)\n    accumulate(\n        (and\n            Integer(this == $l) \n            accumulate(\n                Long() \n                ;$counter: count(1);$counter <= 4)\n         )\n        ;$mainCounter: count(1);$mainCounter <= 2\n    )\nthen\n end"});
        KieSession kieSession = kieBase.newKieSession();
        try {
            kieSession.insert((Object)"test");
            kieSession.insert((Object)4);
            Assert.assertEquals((long)1L, (long)kieSession.fireAllRules());
        }
        finally {
            kieSession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNestedAccumulateWithInfixAnd() {
        String drl = "rule R when\n    String($l: length)\n    accumulate(\n        (\n            Integer(this == $l) and\n            accumulate(\n                Long() \n                ;$counter: count(1);$counter <= 4)\n         )\n        ;$mainCounter: count(1);$mainCounter <= 2\n    )\nthen\n end";
        KieBase kieBase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"accumulate-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"rule R when\n    String($l: length)\n    accumulate(\n        (\n            Integer(this == $l) and\n            accumulate(\n                Long() \n                ;$counter: count(1);$counter <= 4)\n         )\n        ;$mainCounter: count(1);$mainCounter <= 2\n    )\nthen\n end"});
        KieSession kieSession = kieBase.newKieSession();
        try {
            kieSession.insert((Object)"test");
            kieSession.insert((Object)4);
            Assert.assertEquals((long)1L, (long)kieSession.fireAllRules());
        }
        finally {
            kieSession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPeerCollectWithEager() {
        String drl = "import " + PersonsContainer.class.getCanonicalName() + ";\nimport " + Person.class.getCanonicalName() + ";\nimport " + List.class.getCanonicalName() + ";\nrule R1 when\n    $pc : PersonsContainer()\n    List(size == 0) from collect( Person( name.startsWith(\"t\") ) from $pc.persons )\nthen\nend\nrule R2 when\n    $pc : PersonsContainer()\n    List(size == 0) from collect( Person( name.endsWith(\"x\") ) from $pc.persons )\nthen\nend";
        KieSessionConfiguration config = KieServices.Factory.get().newKieSessionConfiguration(null);
        config.setOption((KieSessionOption)ForceEagerActivationOption.YES);
        KieBase kieBase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"collect-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession kieSession = kieBase.newKieSession(config, null);
        try {
            kieSession.insert((Object)new PersonsContainer());
            Assert.assertEquals((long)1L, (long)kieSession.fireAllRules());
        }
        finally {
            kieSession.dispose();
        }
    }

    public static final class PersonsContainer {
        public List<Person> getPersons() {
            ArrayList<Person> persons = new ArrayList<Person>();
            persons.add(null);
            persons.add(new Person("test"));
            return persons;
        }
    }

    public static class BusStop {
        private final int id;
        private Bus bus;

        public BusStop(int id) {
            this.id = id;
        }

        public Bus getBus() {
            return this.bus;
        }

        public void setBus(Bus bus) {
            this.bus = bus;
        }

        public int getId() {
            return this.id;
        }

        public String toString() {
            return "BusStop[" + this.id + "]";
        }
    }

    public static class Shuttle
    implements Bus {
        private final int id;

        public Shuttle(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public String toString() {
            return "Shuttle[" + this.id + "]";
        }
    }

    public static class Coach
    implements Bus {
        private final int id;

        public Coach(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public String toString() {
            return "Coach[" + this.id + "]";
        }
    }

    public static interface Bus {
    }

    public static class Visit {
        private static int TAG = 1;
        private final double duration;
        private int bucket;
        private final int tag;

        public Visit(double duration) {
            this.duration = duration;
            this.tag = TAG++;
        }

        public int getBucket() {
            return this.bucket;
        }

        public Visit setBucket(int bucket) {
            this.bucket = bucket;
            return this;
        }

        public double getDuration() {
            return this.duration;
        }

        public String toString() {
            return "Visit[" + this.tag + "]";
        }
    }

    public static class PersonWithBoxedAge
    implements Comparable<PersonWithBoxedAge> {
        private final String name;
        private final Integer age;

        public PersonWithBoxedAge(String name, Integer age) {
            this.name = name;
            this.age = age;
        }

        public String getName() {
            return this.name;
        }

        public Integer getAge() {
            return this.age;
        }

        @Override
        public int compareTo(PersonWithBoxedAge other) {
            return this.age.compareTo(other.getAge());
        }
    }

    public static class Converter {
        public static int convert(int i) {
            return i;
        }
    }

    public static class ExpectedMessageToRegister {
        String type;
        boolean registered = false;
        List<ExpectedMessage> msgs = new ArrayList<ExpectedMessage>();

        public ExpectedMessageToRegister(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }

        public List<ExpectedMessage> getExpectedMessages() {
            return this.msgs;
        }

        public boolean isRegistered() {
            return this.registered;
        }

        public void setRegistered(boolean registered) {
            this.registered = registered;
        }
    }

    public static class ExpectedMessage {
        String type;

        public ExpectedMessage(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }
    }

    public static class TestFunction
    implements AccumulateFunction<Serializable> {
        public void writeExternal(ObjectOutput out) {
        }

        public void readExternal(ObjectInput in) {
        }

        public Serializable createContext() {
            return null;
        }

        public void init(Serializable context) {
        }

        public void accumulate(Serializable context, Object value) {
        }

        public void reverse(Serializable context, Object value) {
        }

        public Object getResult(Serializable context) {
            return 1;
        }

        public boolean supportsReverse() {
            return true;
        }

        public Class<?> getResultType() {
            return Number.class;
        }
    }

    public static class Lecture {
        private Course course;
        private int day;

        public Lecture(Course course, int day) {
            this.course = course;
            this.day = day;
        }

        public Course getCourse() {
            return this.course;
        }

        public void setCourse(Course course) {
            this.course = course;
        }

        public int getDay() {
            return this.day;
        }

        public void setDay(int day) {
            this.day = day;
        }
    }

    public static class Course {
        private int minWorkingDaySize;

        public Course(int minWorkingDaySize) {
            this.minWorkingDaySize = minWorkingDaySize;
        }

        public int getMinWorkingDaySize() {
            return this.minWorkingDaySize;
        }

        public void setMinWorkingDaySize(int minWorkingDaySize) {
            this.minWorkingDaySize = minWorkingDaySize;
        }
    }

    public static class MyPerson {
        private String name;
        private Integer age;
        private Collection<MyPerson> kids;

        public MyPerson(String name, Integer age, Collection<MyPerson> kids) {
            this.name = name;
            this.age = age;
            this.kids = kids;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Integer getAge() {
            return this.age;
        }

        public void setAge(Integer age) {
            this.age = age;
        }

        public Collection<MyPerson> getKids() {
            return this.kids;
        }

        public void setKids(Collection<MyPerson> kids) {
            this.kids = kids;
        }
    }

    public static class Triple {
        private String subject;
        private String predicate;
        private String object;

        public Triple() {
        }

        public Triple(String subject, String predicate, String object) {
            this.subject = subject;
            this.predicate = predicate;
            this.object = object;
        }

        public String getSubject() {
            return this.subject;
        }

        public String getPredicate() {
            return this.predicate;
        }

        public String getObject() {
            return this.object;
        }
    }

    public static class MyObj {
        private final NestedObj nestedObj;

        public MyObj(long value) {
            this.nestedObj = new NestedObj(value);
        }

        public NestedObj getNestedObj() {
            return this.nestedObj;
        }

        public static class NestedObj {
            public long value;

            public NestedObj(long value) {
                this.value = value;
            }
        }
    }

    public static class DataSet {
        public Cheese[] cheese;
        public FactHandle[] cheeseHandles;
        public Person bob;
        public FactHandle bobHandle;
        public List<?> results;
    }
}

