/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests;

import java.util.Collection;
import java.util.HashMap;
import org.drools.testcoverage.common.model.Person;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieSessionTestConfiguration;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.builder.KieModule;
import org.kie.api.builder.ReleaseId;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.internal.builder.conf.PropertySpecificOption;

@RunWith(value=Parameterized.class)
public class PropertyReactivityTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public PropertyReactivityTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    @Test
    public void testDisablePropertyReactivity() {
        String drl = "import " + Person.class.getCanonicalName() + "\nrule R1 when\n    Person( $name: name == \"Mario\" )\n    String( this == $name )\nthen\nend\n";
        ReleaseId releaseId1 = KieServices.get().newReleaseId("org.kie", "test", "1");
        HashMap<String, String> kieModuleConfigurationProperties = new HashMap<String, String>();
        kieModuleConfigurationProperties.put("drools.propertySpecific", PropertySpecificOption.ALLOWED.toString());
        KieModule kieModule = KieUtil.getKieModuleFromDrls((ReleaseId)releaseId1, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieSessionTestConfiguration)KieSessionTestConfiguration.STATEFUL_REALTIME, kieModuleConfigurationProperties, (String[])new String[]{drl});
        KieContainer kieContainer = KieServices.get().newKieContainer(kieModule.getReleaseId());
        KieBase kbase = kieContainer.getKieBase();
        KieSession ksession = kbase.newKieSession();
        ksession.insert((Object)"Mario");
        Person me = new Person("Mario", 45);
        FactHandle meFh = ksession.insert((Object)me);
        Assert.assertEquals((long)1L, (long)ksession.fireAllRules());
        me.setAge(46);
        ksession.update(meFh, (Object)me, new String[]{"age"});
        Assert.assertEquals((long)1L, (long)ksession.fireAllRules());
    }
}

