/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests.drl;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.drools.drl.ast.descr.AttributeDescr;
import org.drools.drl.ast.descr.PackageDescr;
import org.drools.drl.ast.descr.RuleDescr;
import org.drools.drl.parser.DrlParser;
import org.drools.testcoverage.common.model.Address;
import org.drools.testcoverage.common.model.Cheese;
import org.drools.testcoverage.common.model.Person;
import org.drools.testcoverage.common.model.State;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;
import org.kie.internal.builder.conf.LanguageLevelOption;

@RunWith(value=Parameterized.class)
public class NestingTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public NestingTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNesting() throws Exception {
        String drl = "package org.drools.compiler.integrationtests.drl;\n\ndialect \"mvel\"\n\nimport " + Person.class.getCanonicalName() + ";\nimport " + Address.class.getCanonicalName() + ";\n\nrule \"test something\"\n\n    when\n        p: Person( name==\"Michael\",\n                                (addresses[1].street == \"Low\" &&\n                                addresses[0].street == \"High\"  )\n                                )\n    then\n        p.name = \"goober\";\n        System.out.println(p.name);\n        insert(new Address(\"Latona\"));\nend";
        Person p = new Person();
        p.setName("Michael");
        Address add1 = new Address();
        add1.setStreet("High");
        Address add2 = new Address();
        add2.setStreet("Low");
        ArrayList<Address> l = new ArrayList<Address>();
        l.add(add1);
        l.add(add2);
        p.setAddresses(l);
        DrlParser parser = new DrlParser(LanguageLevelOption.DRL5);
        PackageDescr desc = parser.parse((Reader)new StringReader(drl));
        List packageAttrs = desc.getAttributes();
        Assert.assertEquals((long)1L, (long)desc.getRules().size());
        Assert.assertEquals((long)1L, (long)packageAttrs.size());
        RuleDescr rule = (RuleDescr)desc.getRules().get(0);
        Map ruleAttrs = rule.getAttributes();
        Assert.assertEquals((long)1L, (long)ruleAttrs.size());
        Assert.assertEquals((Object)"mvel", (Object)((AttributeDescr)ruleAttrs.get("dialect")).getValue());
        Assert.assertEquals((Object)"dialect", (Object)((AttributeDescr)ruleAttrs.get("dialect")).getName());
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"nesting-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            ksession.insert((Object)p);
            ksession.fireAllRules();
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNestedConditionalElements() {
        String drl = "package org.drools.compiler.integrationtests.drl;\nimport " + Person.class.getCanonicalName() + ";\nimport " + Cheese.class.getCanonicalName() + ";\nimport " + State.class.getCanonicalName() + ";\nglobal java.util.List results\n\nrule \"test nested CEs\"  salience 100\n    when\n        not ( State( $state : state ) and\n              not( Person( name == $state, $likes : likes ) and\n                   Cheese( type == $likes ) ) )\n    then\n        results.add(\"OK1\");\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"nesting-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("results", list);
            State state = new State("SP");
            ksession.insert((Object)state);
            Person bob = new Person(state.getState());
            bob.setLikes("stilton");
            ksession.insert((Object)bob);
            ksession.fireAllRules();
            Assert.assertEquals((long)0L, (long)list.size());
            ksession.insert((Object)new Cheese(bob.getLikes(), 10));
            ksession.fireAllRules();
            Assert.assertEquals((long)1L, (long)list.size());
        }
        finally {
            ksession.dispose();
        }
    }
}

