/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests.equalitymode;

import java.util.ArrayList;
import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.drools.compiler.integrationtests.equalitymode.FactWithEquals;
import org.drools.testcoverage.common.util.EngineTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;

@RunWith(value=Parameterized.class)
public class EqualityModeTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public EqualityModeTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseConfigurations((EngineTestConfiguration[])new EngineTestConfiguration[]{EngineTestConfiguration.ALPHA_NETWORK_COMPILER_FALSE, EngineTestConfiguration.EQUALITY_MODE, EngineTestConfiguration.CLOUD_MODE, EngineTestConfiguration.EXECUTABLE_MODEL_OFF, EngineTestConfiguration.EXECUTABLE_MODEL_FLOW, EngineTestConfiguration.EXECUTABLE_MODEL_PATTERN});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBasicFactEquality() {
        String drl = "import " + FactWithEquals.class.getCanonicalName() + " \nrule R \nwhen \n    $a: FactWithEquals() \nthen \nend \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"equality-mode-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            ksession.insert((Object)new FactWithEquals(10));
            ksession.insert((Object)new FactWithEquals(10));
            Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(1);
            ksession.insert((Object)new FactWithEquals(10));
            ksession.insert((Object)new FactWithEquals(11));
            ksession.insert((Object)new FactWithEquals(12));
            Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(2);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAccumulate() {
        String drl = "import " + FactWithEquals.class.getCanonicalName() + " \nglobal java.util.List result; \nrule R \nwhen \n accumulate( \n    $fact: FactWithEquals();\n    $factCount: count($fact))\nthen \n    result.add($factCount); \nend \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"equality-mode-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList resultList = new ArrayList();
            ksession.setGlobal("result", resultList);
            ksession.insert((Object)new FactWithEquals(10));
            ksession.insert((Object)new FactWithEquals(10));
            ksession.insert((Object)new FactWithEquals(11));
            Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(1);
            Assertions.assertThat(resultList).hasSize(1);
            Assertions.assertThat(resultList).containsExactly((Object[])new Long[]{2L});
        }
        finally {
            ksession.dispose();
        }
    }
}

