/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.compiler.commons.jci.compilers;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.data.Index;
import org.junit.Test;
import org.kie.memorycompiler.jdknative.NativeJavaCompilerSettings;

public class NativeJavaCompilerSettingsTest {
    @Test
    public void defaultSettings() {
        NativeJavaCompilerSettings settings = new NativeJavaCompilerSettings();
        List options = settings.toOptionsList();
        Assertions.assertThat((List)options).hasSize(6);
        Assertions.assertThat((List)options).contains((Object[])new String[]{"-source", "-target", "-encoding"});
        Assertions.assertThat((List)options).contains((Object)"1.8", Index.atIndex((int)(options.indexOf("-source") + 1)));
        Assertions.assertThat((List)options).contains((Object)"1.8", Index.atIndex((int)(options.indexOf("-target") + 1)));
        Assertions.assertThat((List)options).contains((Object)"UTF-8", Index.atIndex((int)(options.indexOf("-encoding") + 1)));
    }

    @Test
    public void allSettings() {
        NativeJavaCompilerSettings settings = new NativeJavaCompilerSettings();
        settings.setDebug(true);
        settings.setWarnings(true);
        settings.setDeprecations(true);
        settings.setSourceEncoding("My-Custom-Encoding");
        settings.setSourceVersion("1.9");
        settings.setTargetVersion("1.9");
        List options = settings.toOptionsList();
        Assertions.assertThat((List)options).hasSize(9);
        Assertions.assertThat((List)options).contains((Object[])new String[]{"-g"});
        Assertions.assertThat((List)options).contains((Object[])new String[]{"-Xlint:all"});
        Assertions.assertThat((List)options).contains((Object[])new String[]{"-deprecation"});
        Assertions.assertThat((List)options).contains((Object)"1.9", Index.atIndex((int)(options.indexOf("-source") + 1)));
        Assertions.assertThat((List)options).contains((Object)"1.9", Index.atIndex((int)(options.indexOf("-target") + 1)));
        Assertions.assertThat((List)options).contains((Object)"My-Custom-Encoding", Index.atIndex((int)(options.indexOf("-encoding") + 1)));
    }
}

