/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.compiler.compiler.xml.rules;

import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.drools.compiler.builder.impl.KnowledgeBuilderConfigurationImpl;
import org.drools.compiler.compiler.xml.XmlPackageReader;
import org.drools.drl.ast.descr.AccumulateDescr;
import org.drools.drl.ast.descr.AndDescr;
import org.drools.drl.ast.descr.ExistsDescr;
import org.drools.drl.ast.descr.ExprConstraintDescr;
import org.drools.drl.ast.descr.ForallDescr;
import org.drools.drl.ast.descr.FromDescr;
import org.drools.drl.ast.descr.FunctionDescr;
import org.drools.drl.ast.descr.FunctionImportDescr;
import org.drools.drl.ast.descr.GlobalDescr;
import org.drools.drl.ast.descr.ImportDescr;
import org.drools.drl.ast.descr.MVELExprDescr;
import org.drools.drl.ast.descr.NotDescr;
import org.drools.drl.ast.descr.PackageDescr;
import org.drools.drl.ast.descr.PatternDescr;
import org.drools.drl.ast.descr.QueryDescr;
import org.drools.drl.ast.descr.RuleDescr;
import org.drools.mvel.CommonTestMethodBase;
import org.drools.mvel.DrlDumper;
import org.drools.util.StringUtils;
import org.junit.Assert;
import org.junit.Test;

public class XmlPackageReaderTest
extends CommonTestMethodBase {
    @Test
    public void testParseFrom() throws Exception {
        XmlPackageReader xmlPackageReader = this.getXmReader();
        xmlPackageReader.read((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_ParseFrom.xml")));
        PackageDescr packageDescr = xmlPackageReader.getPackageDescr();
        Assert.assertNotNull((Object)packageDescr);
        RuleDescr obj = (RuleDescr)packageDescr.getRules().get(0);
        PatternDescr patterndescr = (PatternDescr)obj.getLhs().getDescrs().get(0);
        FromDescr from = (FromDescr)patterndescr.getSource();
        MVELExprDescr accessordescriptor = (MVELExprDescr)from.getDataSource();
        Assert.assertEquals((Object)"cheesery.getCheeses(i+4)", (Object)accessordescriptor.getExpression());
        Assert.assertEquals((Object)patterndescr.getObjectType(), (Object)"Cheese");
        Assert.assertEquals((Object)patterndescr.getIdentifier(), (Object)"cheese");
    }

    @Test
    public void testAccumulate() throws Exception {
        XmlPackageReader xmlPackageReader = this.getXmReader();
        xmlPackageReader.read((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_ParseAccumulate.xml")));
        PackageDescr packageDescr = xmlPackageReader.getPackageDescr();
        Assert.assertNotNull((Object)packageDescr);
        RuleDescr obj = (RuleDescr)packageDescr.getRules().get(0);
        Object patternobj = obj.getLhs().getDescrs().get(0);
        Assert.assertTrue((boolean)(patternobj instanceof PatternDescr));
        PatternDescr patterncheese = (PatternDescr)patternobj;
        Assert.assertEquals((Object)patterncheese.getIdentifier(), (Object)"cheese");
        Assert.assertEquals((Object)patterncheese.getObjectType(), (Object)"Cheese");
        AccumulateDescr accumulatedescr = (AccumulateDescr)patterncheese.getSource();
        Assert.assertEquals((Object)"total += $cheese.getPrice();", (Object)accumulatedescr.getActionCode());
        Assert.assertEquals((Object)"int total = 0;", (Object)accumulatedescr.getInitCode());
        Assert.assertEquals((Object)"new Integer( total ) );", (Object)accumulatedescr.getResultCode());
        patternobj = obj.getLhs().getDescrs().get(1);
        Assert.assertTrue((boolean)(patternobj instanceof PatternDescr));
        PatternDescr patternmax = (PatternDescr)patternobj;
        Assert.assertEquals((Object)patternmax.getIdentifier(), (Object)"max");
        Assert.assertEquals((Object)patternmax.getObjectType(), (Object)"Number");
        accumulatedescr = (AccumulateDescr)patternmax.getSource();
        Assert.assertTrue((boolean)accumulatedescr.isExternalFunction());
        Assert.assertEquals((Object)"max", (Object)((AccumulateDescr.AccumulateFunctionCallDescr)accumulatedescr.getFunctions().get(0)).getFunction());
        Assert.assertNull((Object)accumulatedescr.getInitCode());
        Assert.assertNull((Object)accumulatedescr.getActionCode());
        Assert.assertNull((Object)accumulatedescr.getResultCode());
        Assert.assertNull((Object)accumulatedescr.getReverseCode());
    }

    @Test
    public void testAccumulateMultiPattern() throws Exception {
        XmlPackageReader xmlPackageReader = this.getXmReader();
        xmlPackageReader.read((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_ParseAccumulate.xml")));
        PackageDescr packageDescr = xmlPackageReader.getPackageDescr();
        Assert.assertNotNull((Object)packageDescr);
        RuleDescr obj = (RuleDescr)packageDescr.getRules().get(1);
        Object patternobj = obj.getLhs().getDescrs().get(0);
        Assert.assertTrue((boolean)(patternobj instanceof PatternDescr));
        PatternDescr patterncheese = (PatternDescr)patternobj;
        Assert.assertEquals((Object)patterncheese.getIdentifier(), (Object)"cheese");
        Assert.assertEquals((Object)patterncheese.getObjectType(), (Object)"Cheese");
        AccumulateDescr accumulatedescr = (AccumulateDescr)patterncheese.getSource();
        Assert.assertEquals((Object)"total += $cheese.getPrice();", (Object)accumulatedescr.getActionCode());
        Assert.assertEquals((Object)"int total = 0;", (Object)accumulatedescr.getInitCode());
        Assert.assertEquals((Object)"new Integer( total ) );", (Object)accumulatedescr.getResultCode());
        AndDescr anddescr = (AndDescr)accumulatedescr.getInput();
        List descrlist = anddescr.getDescrs();
        PatternDescr[] listpattern = descrlist.toArray(new PatternDescr[descrlist.size()]);
        Assert.assertEquals((Object)listpattern[0].getObjectType(), (Object)"Milk");
        Assert.assertEquals((Object)listpattern[1].getObjectType(), (Object)"Cup");
    }

    @Test
    public void testParseForall() throws Exception {
        XmlPackageReader xmlPackageReader = this.getXmReader();
        xmlPackageReader.read((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_ParseForall.xml")));
        PackageDescr packageDescr = xmlPackageReader.getPackageDescr();
        Assert.assertNotNull((Object)packageDescr);
        RuleDescr obj = (RuleDescr)packageDescr.getRules().get(0);
        ForallDescr forall = (ForallDescr)obj.getLhs().getDescrs().get(0);
        List forallPaterns = forall.getDescrs();
        PatternDescr pattarnState = (PatternDescr)forallPaterns.get(0);
        PatternDescr personState = (PatternDescr)forallPaterns.get(1);
        PatternDescr cheeseState = (PatternDescr)forallPaterns.get(2);
        Assert.assertEquals((Object)pattarnState.getObjectType(), (Object)"State");
        Assert.assertEquals((Object)personState.getObjectType(), (Object)"Person");
        Assert.assertEquals((Object)cheeseState.getObjectType(), (Object)"Cheese");
    }

    @Test
    public void testParseExists() throws Exception {
        XmlPackageReader xmlPackageReader = this.getXmReader();
        xmlPackageReader.read((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_ParseExists.xml")));
        PackageDescr packageDescr = xmlPackageReader.getPackageDescr();
        Assert.assertNotNull((Object)packageDescr);
        RuleDescr obj = (RuleDescr)packageDescr.getRules().get(0);
        Object existdescr = obj.getLhs().getDescrs().get(0);
        Assert.assertTrue((boolean)(existdescr instanceof ExistsDescr));
        Object patternDescriptor = ((ExistsDescr)existdescr).getDescrs().get(0);
        Assert.assertTrue((boolean)(patternDescriptor instanceof PatternDescr));
        Assert.assertEquals((Object)((PatternDescr)patternDescriptor).getObjectType(), (Object)"Person");
        Object notDescr = obj.getLhs().getDescrs().get(1);
        Assert.assertEquals((Object)notDescr.getClass().getName(), (Object)NotDescr.class.getName());
        existdescr = ((NotDescr)notDescr).getDescrs().get(0);
        patternDescriptor = ((ExistsDescr)existdescr).getDescrs().get(0);
        Assert.assertTrue((boolean)(patternDescriptor instanceof PatternDescr));
        Assert.assertEquals((Object)((PatternDescr)patternDescriptor).getObjectType(), (Object)"Cheese");
    }

    @Test
    public void testParseCollect() throws Exception {
        XmlPackageReader xmlPackageReader = this.getXmReader();
        xmlPackageReader.read((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_ParseCollect.xml")));
        PackageDescr packageDescr = xmlPackageReader.getPackageDescr();
        String expected = StringUtils.readFileAsString((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_ParseCollect.drl")));
        String expectedWithoutHeader = this.removeLicenseHeader(expected);
        String actual = new DrlDumper().dump(packageDescr);
        Assertions.assertThat((String)expectedWithoutHeader).isEqualToIgnoringWhitespace((CharSequence)actual);
    }

    @Test
    public void testParsePackageName() throws Exception {
        XmlPackageReader xmlPackageReader = this.getXmReader();
        xmlPackageReader.read((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_ParsePackageName.xml")));
        PackageDescr packageDescr = xmlPackageReader.getPackageDescr();
        Assert.assertNotNull((Object)packageDescr);
        Assert.assertEquals((Object)"com.sample", (Object)packageDescr.getName());
    }

    @Test
    public void testParseImport() throws Exception {
        XmlPackageReader xmlPackageReader = this.getXmReader();
        xmlPackageReader.read((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_ParseImport.xml")));
        PackageDescr packageDescr = xmlPackageReader.getPackageDescr();
        Assert.assertNotNull((Object)packageDescr);
        Assert.assertEquals((Object)"com.sample", (Object)packageDescr.getName());
        List imports = packageDescr.getImports();
        Assert.assertEquals((long)2L, (long)imports.size());
        Assert.assertEquals((Object)"java.util.HashMap", (Object)((ImportDescr)imports.get(0)).getTarget());
        Assert.assertEquals((Object)"org.drools.mvel.compiler.*", (Object)((ImportDescr)imports.get(1)).getTarget());
        List functionImport = packageDescr.getFunctionImports();
        Assert.assertEquals((Object)"org.drools.function", (Object)((FunctionImportDescr)functionImport.get(0)).getTarget());
    }

    @Test
    public void testParseGlobal() throws Exception {
        XmlPackageReader xmlPackageReader = this.getXmReader();
        xmlPackageReader.read((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_ParseGlobal.xml")));
        PackageDescr packageDescr = xmlPackageReader.getPackageDescr();
        Assert.assertNotNull((Object)packageDescr);
        Assert.assertEquals((Object)"com.sample", (Object)packageDescr.getName());
        List imports = packageDescr.getImports();
        Assert.assertEquals((long)2L, (long)imports.size());
        Assert.assertEquals((Object)"java.util.HashMap", (Object)((ImportDescr)imports.get(0)).getTarget());
        Assert.assertEquals((Object)"org.drools.mvel.compiler.*", (Object)((ImportDescr)imports.get(1)).getTarget());
        List globals = packageDescr.getGlobals();
        Assert.assertEquals((long)2L, (long)globals.size());
        GlobalDescr x = (GlobalDescr)globals.get(0);
        GlobalDescr yada = (GlobalDescr)globals.get(1);
        Assert.assertEquals((Object)"com.sample.X", (Object)x.getType());
        Assert.assertEquals((Object)"x", (Object)x.getIdentifier());
        Assert.assertEquals((Object)"com.sample.Yada", (Object)yada.getType());
        Assert.assertEquals((Object)"yada", (Object)yada.getIdentifier());
    }

    @Test
    public void testParseFunction() throws Exception {
        XmlPackageReader xmlPackageReader = this.getXmReader();
        xmlPackageReader.read((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_ParseFunction.xml")));
        PackageDescr packageDescr = xmlPackageReader.getPackageDescr();
        Assert.assertNotNull((Object)packageDescr);
        Assert.assertEquals((Object)"com.sample", (Object)packageDescr.getName());
        List imports = packageDescr.getImports();
        Assert.assertEquals((long)2L, (long)imports.size());
        Assert.assertEquals((Object)"java.util.HashMap", (Object)((ImportDescr)imports.get(0)).getTarget());
        Assert.assertEquals((Object)"org.drools.mvel.compiler.*", (Object)((ImportDescr)imports.get(1)).getTarget());
        List globals = packageDescr.getGlobals();
        Assert.assertEquals((long)2L, (long)globals.size());
        GlobalDescr x = (GlobalDescr)globals.get(0);
        GlobalDescr yada = (GlobalDescr)globals.get(1);
        Assert.assertEquals((Object)"com.sample.X", (Object)x.getType());
        Assert.assertEquals((Object)"x", (Object)x.getIdentifier());
        Assert.assertEquals((Object)"com.sample.Yada", (Object)yada.getType());
        Assert.assertEquals((Object)"yada", (Object)yada.getIdentifier());
        FunctionDescr functionDescr = (FunctionDescr)packageDescr.getFunctions().get(0);
        List names = functionDescr.getParameterNames();
        Assert.assertEquals((Object)"foo", names.get(0));
        Assert.assertEquals((Object)"bada", names.get(1));
        List types = functionDescr.getParameterTypes();
        Assert.assertEquals((Object)"Bar", types.get(0));
        Assert.assertEquals((Object)"Bing", types.get(1));
        Assert.assertEquals((Object)"System.out.println(\"hello world\");", (Object)functionDescr.getText().trim());
    }

    @Test
    public void testParseRule() throws Exception {
        XmlPackageReader xmlPackageReader = this.getXmReader();
        xmlPackageReader.read((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_ParseRule.xml")));
        PackageDescr packageDescr = xmlPackageReader.getPackageDescr();
        String expected = StringUtils.readFileAsString((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_ParseRule.drl")));
        String expectedWithoutHeader = this.removeLicenseHeader(expected);
        System.out.println(expectedWithoutHeader);
        String actual = new DrlDumper().dump(packageDescr);
        Assertions.assertThat((String)expectedWithoutHeader).isEqualToIgnoringWhitespace((CharSequence)actual);
    }

    @Test
    public void testParseSimpleRule() throws Exception {
        XmlPackageReader xmlPackageReader = this.getXmReader();
        xmlPackageReader.read((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_SimpleRule1.xml")));
        PackageDescr packageDescr = xmlPackageReader.getPackageDescr();
        Assert.assertNotNull((Object)packageDescr);
        Assert.assertEquals((Object)"com.sample", (Object)packageDescr.getName());
        List imports = packageDescr.getImports();
        Assert.assertEquals((long)2L, (long)imports.size());
        Assert.assertEquals((Object)"java.util.List", (Object)((ImportDescr)imports.get(0)).getTarget());
        Assert.assertEquals((Object)"org.drools.mvel.compiler.Person", (Object)((ImportDescr)imports.get(1)).getTarget());
        RuleDescr ruleDescr = (RuleDescr)packageDescr.getRules().get(0);
        Assert.assertEquals((Object)"simple_rule1", (Object)ruleDescr.getName());
        AndDescr lhs = ruleDescr.getLhs();
        PatternDescr patternDescr = (PatternDescr)lhs.getDescrs().get(0);
        Assert.assertEquals((Object)"Person", (Object)patternDescr.getObjectType());
        ExprConstraintDescr expr = (ExprConstraintDescr)((AndDescr)patternDescr.getConstraint()).getDescrs().get(0);
        Assert.assertEquals((Object)"name == \"darth\"", (Object)expr.getExpression());
        ruleDescr = (RuleDescr)packageDescr.getRules().get(1);
        Assert.assertEquals((Object)"simple_rule2", (Object)ruleDescr.getName());
        lhs = ruleDescr.getLhs();
        patternDescr = (PatternDescr)lhs.getDescrs().get(0);
        Assert.assertEquals((Object)"Person", (Object)patternDescr.getObjectType());
        expr = (ExprConstraintDescr)((AndDescr)patternDescr.getConstraint()).getDescrs().get(0);
        Assert.assertEquals((Object)"age == 35 || == -3.5", (Object)expr.getExpression());
        ruleDescr = (RuleDescr)packageDescr.getRules().get(2);
        Assert.assertEquals((Object)"simple_rule3", (Object)ruleDescr.getName());
        lhs = ruleDescr.getLhs();
        patternDescr = (PatternDescr)lhs.getDescrs().get(0);
        Assert.assertEquals((Object)"Person", (Object)patternDescr.getObjectType());
        expr = (ExprConstraintDescr)((AndDescr)patternDescr.getConstraint()).getDescrs().get(0);
        Assert.assertEquals((Object)"age == 35 || (!= 7.0 && != -70)", (Object)expr.getExpression());
        ruleDescr = (RuleDescr)packageDescr.getRules().get(3);
        Assert.assertEquals((Object)"simple_rule3", (Object)ruleDescr.getName());
        lhs = ruleDescr.getLhs();
        patternDescr = (PatternDescr)lhs.getDescrs().get(1);
        Assert.assertEquals((Object)"Person", (Object)patternDescr.getObjectType());
        expr = (ExprConstraintDescr)((AndDescr)patternDescr.getConstraint()).getDescrs().get(0);
        Assert.assertEquals((Object)"name == $s", (Object)expr.getExpression());
        ruleDescr = (RuleDescr)packageDescr.getRules().get(4);
        Assert.assertEquals((Object)"simple_rule4", (Object)ruleDescr.getName());
        lhs = ruleDescr.getLhs();
        patternDescr = (PatternDescr)lhs.getDescrs().get(1);
        Assert.assertEquals((Object)"Person", (Object)patternDescr.getObjectType());
        expr = (ExprConstraintDescr)((AndDescr)patternDescr.getConstraint()).getDescrs().get(0);
        Assert.assertEquals((Object)"(name == $s) || (age == 35 || (!= 7.0 && != -70))", (Object)expr.getExpression());
        ruleDescr = (RuleDescr)packageDescr.getRules().get(5);
        Assert.assertEquals((Object)"simple_rule5", (Object)ruleDescr.getName());
        lhs = ruleDescr.getLhs();
        patternDescr = (PatternDescr)lhs.getDescrs().get(1);
        Assert.assertEquals((Object)"Person", (Object)patternDescr.getObjectType());
        expr = (ExprConstraintDescr)((AndDescr)patternDescr.getConstraint()).getDescrs().get(0);
        Assert.assertEquals((Object)"(name == $s) || ((age != 34) && (age != 37) && (name != \"yoda\"))", (Object)expr.getExpression());
    }

    @Test
    public void testParseLhs() throws Exception {
        XmlPackageReader xmlPackageReader = this.getXmReader();
        xmlPackageReader.read((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_ParseLhs.xml")));
        PackageDescr packageDescr = xmlPackageReader.getPackageDescr();
        String expected = StringUtils.readFileAsString((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_ParseLhs.drl")));
        String expectedWithoutHeader = this.removeLicenseHeader(expected);
        String actual = new DrlDumper().dump(packageDescr);
        Assertions.assertThat((String)expectedWithoutHeader).isEqualToIgnoringWhitespace((CharSequence)actual);
    }

    @Test
    public void testParseRhs() throws Exception {
        XmlPackageReader xmlPackageReader = this.getXmReader();
        xmlPackageReader.read((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_ParseRhs.xml")));
        PackageDescr packageDescr = xmlPackageReader.getPackageDescr();
        Assert.assertNotNull((Object)packageDescr);
        Assert.assertEquals((Object)"com.sample", (Object)packageDescr.getName());
        List imports = packageDescr.getImports();
        Assert.assertEquals((long)2L, (long)imports.size());
        Assert.assertEquals((Object)"java.util.HashMap", (Object)((ImportDescr)imports.get(0)).getTarget());
        Assert.assertEquals((Object)"org.drools.mvel.compiler.*", (Object)((ImportDescr)imports.get(1)).getTarget());
        List globals = packageDescr.getGlobals();
        Assert.assertEquals((long)2L, (long)globals.size());
        GlobalDescr x = (GlobalDescr)globals.get(0);
        GlobalDescr yada = (GlobalDescr)globals.get(1);
        Assert.assertEquals((Object)"com.sample.X", (Object)x.getType());
        Assert.assertEquals((Object)"x", (Object)x.getIdentifier());
        Assert.assertEquals((Object)"com.sample.Yada", (Object)yada.getType());
        Assert.assertEquals((Object)"yada", (Object)yada.getIdentifier());
        FunctionDescr functionDescr = (FunctionDescr)packageDescr.getFunctions().get(0);
        List names = functionDescr.getParameterNames();
        Assert.assertEquals((Object)"foo", names.get(0));
        Assert.assertEquals((Object)"bada", names.get(1));
        List types = functionDescr.getParameterTypes();
        Assert.assertEquals((Object)"Bar", types.get(0));
        Assert.assertEquals((Object)"Bing", types.get(1));
        Assert.assertEquals((Object)"System.out.println(\"hello world\");", (Object)functionDescr.getText().trim());
        RuleDescr ruleDescr = (RuleDescr)packageDescr.getRules().get(0);
        Assert.assertEquals((Object)"my rule", (Object)ruleDescr.getName());
        String consequence = (String)ruleDescr.getConsequence();
        Assert.assertNotNull((Object)consequence);
        Assert.assertEquals((Object)"System.out.println( \"hello\" );", (Object)consequence.trim());
    }

    @Test
    public void testParseQuery() throws Exception {
        XmlPackageReader xmlPackageReader = this.getXmReader();
        xmlPackageReader.read((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_ParseQuery.xml")));
        PackageDescr packageDescr = xmlPackageReader.getPackageDescr();
        Assert.assertNotNull((Object)packageDescr);
        Assert.assertEquals((Object)"com.sample", (Object)packageDescr.getName());
        List imports = packageDescr.getImports();
        Assert.assertEquals((long)2L, (long)imports.size());
        Assert.assertEquals((Object)"java.util.HashMap", (Object)((ImportDescr)imports.get(0)).getTarget());
        Assert.assertEquals((Object)"org.drools.mvel.compiler.*", (Object)((ImportDescr)imports.get(1)).getTarget());
        List globals = packageDescr.getGlobals();
        Assert.assertEquals((long)2L, (long)globals.size());
        GlobalDescr x = (GlobalDescr)globals.get(0);
        GlobalDescr yada = (GlobalDescr)globals.get(1);
        Assert.assertEquals((Object)"com.sample.X", (Object)x.getType());
        Assert.assertEquals((Object)"x", (Object)x.getIdentifier());
        Assert.assertEquals((Object)"com.sample.Yada", (Object)yada.getType());
        Assert.assertEquals((Object)"yada", (Object)yada.getIdentifier());
        FunctionDescr functionDescr = (FunctionDescr)packageDescr.getFunctions().get(0);
        List names = functionDescr.getParameterNames();
        Assert.assertEquals((Object)"foo", names.get(0));
        Assert.assertEquals((Object)"bada", names.get(1));
        List types = functionDescr.getParameterTypes();
        Assert.assertEquals((Object)"Bar", types.get(0));
        Assert.assertEquals((Object)"Bing", types.get(1));
        Assert.assertEquals((Object)"System.out.println(\"hello world\");", (Object)functionDescr.getText().trim());
        QueryDescr queryDescr = (QueryDescr)packageDescr.getRules().get(0);
        Assert.assertEquals((Object)"my query", (Object)queryDescr.getName());
        AndDescr lhs = queryDescr.getLhs();
        Assert.assertEquals((long)1L, (long)lhs.getDescrs().size());
        PatternDescr patternDescr = (PatternDescr)lhs.getDescrs().get(0);
        Assert.assertEquals((Object)"Foo", (Object)patternDescr.getObjectType());
    }

    private XmlPackageReader getXmReader() {
        KnowledgeBuilderConfigurationImpl conf = new KnowledgeBuilderConfigurationImpl();
        XmlPackageReader xmlReader = new XmlPackageReader(conf.getSemanticModules());
        xmlReader.getParser().setClassLoader(XmlPackageReaderTest.class.getClassLoader());
        return xmlReader;
    }

    private String removeLicenseHeader(String content) {
        String[] lines = content.trim().split("\n");
        StringBuilder result = new StringBuilder();
        if (lines.length > 1 && lines[0].startsWith("/*")) {
            boolean inHeader = true;
            for (String line : lines) {
                if (line.trim().startsWith("package")) {
                    inHeader = false;
                }
                if (inHeader) continue;
                result.append(line);
                result.append("\n");
            }
            return result.toString();
        }
        return content;
    }
}

