/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.util.ArrayList;
import java.util.Collection;
import org.drools.commands.runtime.rule.FireAllRulesCommand;
import org.drools.mvel.compiler.Cheese;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.command.Command;
import org.kie.api.runtime.ExecutionResults;
import org.kie.api.runtime.StatelessKieSession;
import org.kie.internal.command.CommandFactory;

@RunWith(value=Parameterized.class)
public class FireAllRulesCommandTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public FireAllRulesCommandTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    @Test
    public void oneRuleFiredTest() {
        String str = "";
        str = str + "package org.drools.mvel.integrationtests \n";
        str = str + "import " + Cheese.class.getCanonicalName() + " \n";
        str = str + "rule StringRule \n";
        str = str + " when \n";
        str = str + " $c : Cheese() \n";
        str = str + " then \n";
        str = str + " System.out.println($c); \n";
        str = str + "end \n";
        StatelessKieSession ksession = this.getSession(str);
        ArrayList<Command> commands = new ArrayList<Command>();
        commands.add(CommandFactory.newInsert((Object)new Cheese("stilton")));
        commands.add(CommandFactory.newFireAllRules((String)"num-rules-fired"));
        ExecutionResults results = (ExecutionResults)ksession.execute((Command)CommandFactory.newBatchExecution(commands));
        int fired = Integer.parseInt(results.getValue("num-rules-fired").toString());
        Assert.assertEquals((long)1L, (long)fired);
    }

    @Test
    public void fiveRulesFiredTest() {
        String str = "";
        str = str + "package org.drools.mvel.integrationtests \n";
        str = str + "import " + Cheese.class.getCanonicalName() + " \n";
        str = str + "rule StringRule \n";
        str = str + " when \n";
        str = str + " $c : Cheese() \n";
        str = str + " then \n";
        str = str + " System.out.println($c); \n";
        str = str + "end \n";
        StatelessKieSession ksession = this.getSession(str);
        ArrayList<Command> commands = new ArrayList<Command>();
        commands.add(CommandFactory.newInsert((Object)new Cheese("stilton")));
        commands.add(CommandFactory.newInsert((Object)new Cheese("gruyere")));
        commands.add(CommandFactory.newInsert((Object)new Cheese("cheddar")));
        commands.add(CommandFactory.newInsert((Object)new Cheese("stinky")));
        commands.add(CommandFactory.newInsert((Object)new Cheese("limburger")));
        commands.add(CommandFactory.newFireAllRules((String)"num-rules-fired"));
        ExecutionResults results = (ExecutionResults)ksession.execute((Command)CommandFactory.newBatchExecution(commands));
        int fired = Integer.parseInt(results.getValue("num-rules-fired").toString());
        Assert.assertEquals((long)5L, (long)fired);
    }

    @Test
    public void zeroRulesFiredTest() {
        String str = "";
        str = str + "package org.drools.mvel.integrationtests \n";
        str = str + "import " + Cheese.class.getCanonicalName() + " \n";
        str = str + "rule StringRule \n";
        str = str + " when \n";
        str = str + " $c : Cheese() \n";
        str = str + " then \n";
        str = str + " System.out.println($c); \n";
        str = str + "end \n";
        StatelessKieSession ksession = this.getSession(str);
        ArrayList<Command> commands = new ArrayList<Command>();
        commands.add(CommandFactory.newInsert((Object)"not cheese"));
        commands.add(CommandFactory.newFireAllRules((String)"num-rules-fired"));
        ExecutionResults results = (ExecutionResults)ksession.execute((Command)CommandFactory.newBatchExecution(commands));
        int fired = Integer.parseInt(results.getValue("num-rules-fired").toString());
        Assert.assertEquals((long)0L, (long)fired);
    }

    @Test
    public void oneRuleFiredWithDefinedMaxTest() {
        String str = "";
        str = str + "package org.drools.mvel.integrationtests \n";
        str = str + "import " + Cheese.class.getCanonicalName() + " \n";
        str = str + "rule StringRule \n";
        str = str + " when \n";
        str = str + " $c : Cheese() \n";
        str = str + " then \n";
        str = str + " System.out.println($c); \n";
        str = str + "end \n";
        StatelessKieSession ksession = this.getSession(str);
        ArrayList<Object> commands = new ArrayList<Object>();
        commands.add(CommandFactory.newInsert((Object)new Cheese("stilton")));
        FireAllRulesCommand farc = (FireAllRulesCommand)CommandFactory.newFireAllRules((int)10);
        farc.setOutIdentifier("num-rules-fired");
        commands.add(farc);
        ExecutionResults results = (ExecutionResults)ksession.execute((Command)CommandFactory.newBatchExecution(commands));
        int fired = Integer.parseInt(results.getValue("num-rules-fired").toString());
        Assert.assertEquals((long)1L, (long)fired);
    }

    @Test
    public void infiniteLoopTerminatesAtMaxTest() {
        String str = "";
        str = str + "package org.drools.mvel.integrationtests \n";
        str = str + "import " + Cheese.class.getCanonicalName() + " \n";
        str = str + "rule StringRule \n";
        str = str + " when \n";
        str = str + " $c : Cheese() \n";
        str = str + " then \n";
        str = str + " update($c); \n";
        str = str + "end \n";
        StatelessKieSession ksession = this.getSession(str);
        ArrayList<Object> commands = new ArrayList<Object>();
        commands.add(CommandFactory.newInsert((Object)new Cheese("stilton")));
        FireAllRulesCommand farc = (FireAllRulesCommand)CommandFactory.newFireAllRules((int)10);
        farc.setOutIdentifier("num-rules-fired");
        commands.add(farc);
        ExecutionResults results = (ExecutionResults)ksession.execute((Command)CommandFactory.newBatchExecution(commands));
        int fired = Integer.parseInt(results.getValue("num-rules-fired").toString());
        Assert.assertEquals((long)10L, (long)fired);
    }

    private StatelessKieSession getSession(String drl) {
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        return kbase.newStatelessKieSession();
    }
}

