/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.compiler.kproject.models.KieModuleModelImpl;
import org.drools.mvel.compiler.Message;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.KieModule;
import org.kie.api.builder.Message;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.Results;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.Channel;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.StatelessKieSession;
import org.kie.api.runtime.conf.ClockTypeOption;
import org.kie.internal.builder.InternalKieBuilder;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.io.ResourceFactory;

@RunWith(value=Parameterized.class)
public class KieBuilderTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public KieBuilderTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)false);
    }

    @Test
    public void testResourceInclusion() {
        String drl1 = "package org.drools.mvel.compiler\nrule R1 when\n   $m : Message()\nthen\nend\n";
        String drl2 = "package org.drools.mvel.compiler\nrule R2 when\n   $m : Message( message == \"Hi Universe\" )\nthen\nend\n";
        String drl3 = "package org.drools.mvel.compiler\nrule R3 when\n   $m : Message( message == \"Hello World\" )\nthen\nend\n";
        String drl4 = "package org.drools.mvel.compiler\nrule R4 when\n   $m : Message( message == \"Hello Earth\" )\nthen\nend\n";
        String kmodule = "<kmodule xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" \n         xmlns=\"http://www.drools.org/xsd/kmodule\">\n  <kbase name=\"kbase1\" default=\"true\" eventProcessingMode=\"stream\" equalsBehavior=\"identity\" scope=\"javax.enterprise.context.ApplicationScoped\">\n    <ksession name=\"ksession1\" type=\"stateful\" default=\"true\" clockType=\"realtime\" scope=\"javax.enterprise.context.ApplicationScoped\"/>\n  </kbase>\n</kmodule>";
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId1 = ks.newReleaseId("org.kie", "test-kie-builder", "1.0.0");
        Resource r1 = ResourceFactory.newByteArrayResource((byte[])"package org.drools.mvel.compiler\nrule R1 when\n   $m : Message()\nthen\nend\n".getBytes()).setResourceType(ResourceType.DRL).setSourcePath("kbase1/drl1.drl");
        Resource r2 = ResourceFactory.newByteArrayResource((byte[])"package org.drools.mvel.compiler\nrule R2 when\n   $m : Message( message == \"Hi Universe\" )\nthen\nend\n".getBytes()).setResourceType(ResourceType.GDRL).setSourcePath("kbase1/drl2.gdrl");
        Resource r3 = ResourceFactory.newByteArrayResource((byte[])"package org.drools.mvel.compiler\nrule R3 when\n   $m : Message( message == \"Hello World\" )\nthen\nend\n".getBytes()).setResourceType(ResourceType.RDRL).setSourcePath("kbase1/drl3.rdrl");
        Resource r4 = ResourceFactory.newByteArrayResource((byte[])"package org.drools.mvel.compiler\nrule R4 when\n   $m : Message( message == \"Hello Earth\" )\nthen\nend\n".getBytes()).setResourceType(ResourceType.TDRL).setSourcePath("kbase1/drl4.tdrl");
        KieModule km = KieUtil.buildAndInstallKieModuleIntoRepo((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (ReleaseId)releaseId1, (KieModuleModel)KieModuleModelImpl.fromXML((String)"<kmodule xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" \n         xmlns=\"http://www.drools.org/xsd/kmodule\">\n  <kbase name=\"kbase1\" default=\"true\" eventProcessingMode=\"stream\" equalsBehavior=\"identity\" scope=\"javax.enterprise.context.ApplicationScoped\">\n    <ksession name=\"ksession1\" type=\"stateful\" default=\"true\" clockType=\"realtime\" scope=\"javax.enterprise.context.ApplicationScoped\"/>\n  </kbase>\n</kmodule>"), (Resource[])new Resource[]{r1, r2, r3, r4});
        InternalKieModule ikm = (InternalKieModule)km;
        Assert.assertNotNull((Object)ikm.getResource(r1.getSourcePath()));
        Assert.assertNotNull((Object)ikm.getResource(r2.getSourcePath()));
        Assert.assertNotNull((Object)ikm.getResource(r3.getSourcePath()));
        Assert.assertNotNull((Object)ikm.getResource(r4.getSourcePath()));
        KieContainer kc = ks.newKieContainer(km.getReleaseId());
        KieSession ksession = kc.newKieSession();
        ksession.insert((Object)new Message("Hello World"));
        Assert.assertEquals((long)2L, (long)ksession.fireAllRules());
        ksession.dispose();
    }

    @Test
    public void testValidXsdTargetNamespace() {
        String drl1 = "package org.drools.mvel.compiler\nrule R1 when\n   $m : Message()\nthen\nend\n";
        String kmodule = "<kmodule xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" \n         xmlns=\"http://www.drools.org/xsd/kmodule\">\n  <kbase name=\"kbase1\">\n    <ksession name=\"ksession1\" default=\"true\"/>\n  </kbase>\n</kmodule>";
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId1 = ks.newReleaseId("org.kie", "test-kie-builder", "1.0.0");
        Resource r1 = ResourceFactory.newByteArrayResource((byte[])"package org.drools.mvel.compiler\nrule R1 when\n   $m : Message()\nthen\nend\n".getBytes()).setResourceType(ResourceType.DRL).setSourcePath("kbase1/drl1.drl");
        KieModule km = KieUtil.buildAndInstallKieModuleIntoRepo((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (ReleaseId)releaseId1, (KieModuleModel)KieModuleModelImpl.fromXML((String)"<kmodule xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" \n         xmlns=\"http://www.drools.org/xsd/kmodule\">\n  <kbase name=\"kbase1\">\n    <ksession name=\"ksession1\" default=\"true\"/>\n  </kbase>\n</kmodule>"), (Resource[])new Resource[]{r1});
        ks.newKieContainer(km.getReleaseId());
    }

    @Test
    public void testInvalidXsdTargetNamespace() {
        String drl1 = "package org.drools.compiler\nrule R1 when\n   $m : Message()\nthen\nend\n";
        String kmodule = "<kmodule xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" \n         xmlns=\"http://www.drools.org/xsd/doesNotExist\">\n  <kbase name=\"kbase1\">\n    <ksession name=\"ksession1\" default=\"true\"/>\n  </kbase>\n</kmodule>";
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId1 = ks.newReleaseId("org.kie", "test-kie-builder", "1.0.0");
        Resource r1 = ResourceFactory.newByteArrayResource((byte[])"package org.drools.compiler\nrule R1 when\n   $m : Message()\nthen\nend\n".getBytes()).setResourceType(ResourceType.DRL).setSourcePath("kbase1/drl1.drl");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> KieUtil.buildAndInstallKieModuleIntoRepo((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (ReleaseId)releaseId1, (KieModuleModel)KieModuleModelImpl.fromXML((String)"<kmodule xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" \n         xmlns=\"http://www.drools.org/xsd/doesNotExist\">\n  <kbase name=\"kbase1\">\n    <ksession name=\"ksession1\" default=\"true\"/>\n  </kbase>\n</kmodule>"), (Resource[])new Resource[]{r1})).isInstanceOf(RuntimeException.class)).hasMessageContaining("XSD validation failed");
    }

    @Test
    public void testOldXsdTargetNamespace() {
        String drl1 = "package org.drools.mvel.compiler\nrule R1 when\n   $m : Message()\nthen\nend\n";
        String kmodule = "<kmodule xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" \n         xmlns=\"http://jboss.org/kie/6.0.0/kmodule\">\n  <kbase name=\"kbase1\">\n    <ksession name=\"ksession1\" default=\"true\"/>\n  </kbase>\n</kmodule>";
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId1 = ks.newReleaseId("org.kie", "test-kie-builder", "1.0.0");
        Resource r1 = ResourceFactory.newByteArrayResource((byte[])"package org.drools.mvel.compiler\nrule R1 when\n   $m : Message()\nthen\nend\n".getBytes()).setResourceType(ResourceType.DRL).setSourcePath("kbase1/drl1.drl");
        KieModule km = KieUtil.buildAndInstallKieModuleIntoRepo((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (ReleaseId)releaseId1, (KieModuleModel)KieModuleModelImpl.fromXML((String)"<kmodule xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" \n         xmlns=\"http://jboss.org/kie/6.0.0/kmodule\">\n  <kbase name=\"kbase1\">\n    <ksession name=\"ksession1\" default=\"true\"/>\n  </kbase>\n</kmodule>"), (Resource[])new Resource[]{r1});
        ks.newKieContainer(km.getReleaseId());
    }

    @Test
    public void testGetKieBaseAfterKieSessionCreation() {
        String KBASE_NAME = "kieBase";
        String KSESSION_NAME = "kieSession";
        String drl = "declare TestEvent\n    @role( event )\n    name : String\nend\n\ndeclare window DeclaredTimeWindow\n    TestEvent ( name == \"timeDec\" ) over window:time( 50ms ) from entry-point EventStream\nend";
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem();
        kfs.write("src/main/resources/window.drl", "declare TestEvent\n    @role( event )\n    name : String\nend\n\ndeclare window DeclaredTimeWindow\n    TestEvent ( name == \"timeDec\" ) over window:time( 50ms ) from entry-point EventStream\nend");
        KieModuleModel kmoduleModel = ks.newKieModuleModel();
        kmoduleModel.newKieBaseModel("kieBase").addPackage("*").newKieSessionModel("kieSession").setDefault(true).setClockType(ClockTypeOption.PSEUDO);
        kfs.writeKModuleXML(kmoduleModel.toXML());
        KieBuilder builder = KieUtil.getKieBuilderFromKieFileSystem((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieFileSystem)kfs, (boolean)false);
        Assert.assertEquals((long)0L, (long)builder.getResults().getMessages().size());
        ks.getRepository().addKieModule(builder.getKieModule());
        KieSession kieSession = ks.newKieContainer(ks.getRepository().getDefaultReleaseId()).newKieSession("kieSession");
        Assert.assertNotNull((Object)kieSession);
        KieBase kieBase = ks.newKieContainer(ks.getRepository().getDefaultReleaseId()).getKieBase("kieBase");
        Assert.assertNotNull((Object)kieBase);
    }

    @Test
    public void testReportKBuilderErrorWhenUsingAJavaClassWithNoPkg() {
        String java = "public class JavaClass { }\n";
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem().write("src/main/java/JavaClass.java", "public class JavaClass { }\n");
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromKieFileSystem((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieFileSystem)kfs, (boolean)false);
        Results results = kieBuilder.getResults();
        System.out.println(results.getMessages());
        Assert.assertEquals((long)1L, (long)results.getMessages().size());
    }

    @Test
    public void testJavaSourceFileAndDrlDeploy() {
        String java = "package org.drools.mvel.compiler;\npublic class JavaSourceMessage { }\n";
        String drl = "package org.drools.mvel.compiler;\nimport org.drools.mvel.compiler.JavaSourceMessage;rule R1 when\n   $m : JavaSourceMessage()\nthen\nend\n";
        String kmodule = "<kmodule xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" \n         xmlns=\"http://www.drools.org/xsd/kmodule\">\n  <kbase name=\"kbase1\">\n    <ksession name=\"ksession1\" default=\"true\"/>\n  </kbase>\n</kmodule>";
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId1 = ks.newReleaseId("org.kie", "test-kie-builder", "1.0.0");
        Resource javaResource = ResourceFactory.newByteArrayResource((byte[])"package org.drools.mvel.compiler;\npublic class JavaSourceMessage { }\n".getBytes()).setResourceType(ResourceType.JAVA).setSourcePath("org/drools/mvel/compiler/JavaSourceMessage.java");
        Resource drlResource = ResourceFactory.newByteArrayResource((byte[])"package org.drools.mvel.compiler;\nimport org.drools.mvel.compiler.JavaSourceMessage;rule R1 when\n   $m : JavaSourceMessage()\nthen\nend\n".getBytes()).setResourceType(ResourceType.DRL).setSourcePath("kbase1/drl1.drl");
        KieModule km = KieUtil.buildAndInstallKieModuleIntoRepo((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (ReleaseId)releaseId1, (KieModuleModel)KieModuleModelImpl.fromXML((String)"<kmodule xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" \n         xmlns=\"http://www.drools.org/xsd/kmodule\">\n  <kbase name=\"kbase1\">\n    <ksession name=\"ksession1\" default=\"true\"/>\n  </kbase>\n</kmodule>"), (Resource[])new Resource[]{javaResource, drlResource});
        KieContainer kieContainer = ks.newKieContainer(km.getReleaseId());
        try {
            Class<?> messageClass = kieContainer.getClassLoader().loadClass("org.drools.mvel.compiler.JavaSourceMessage");
            Assert.assertNotNull(messageClass);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Loading the java class failed.", e);
        }
    }

    @Test
    public void testJavaSourceFileAndDrlDeployWithClassFilter() {
        String allowedJava = "package org.drools.mvel.compiler;\npublic class JavaSourceMessage { }\n";
        String filteredJava = "package org.drools.mvel.compiler;\npublic class ClassCausingClassNotFoundException { non.existing.Type foo() { return null; } }\n";
        String drl = "package org.drools.compiler;\nimport org.drools.mvel.compiler.JavaSourceMessage;rule R1 when\n   $m : JavaSourceMessage()\nthen\nend\n";
        String kmodule = "<kmodule xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" \n         xmlns=\"http://www.drools.org/xsd/kmodule\">\n  <kbase name=\"kbase1\">\n    <ksession name=\"ksession1\" default=\"true\"/>\n  </kbase>\n</kmodule>";
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId1 = ks.newReleaseId("org.kie", "test-kie-builder", "1.0.0");
        Resource allowedJavaResource = ResourceFactory.newByteArrayResource((byte[])"package org.drools.mvel.compiler;\npublic class JavaSourceMessage { }\n".getBytes()).setResourceType(ResourceType.JAVA).setSourcePath("org/drools/mvel/compiler/JavaSourceMessage.java");
        Resource filteredJavaResource = ResourceFactory.newByteArrayResource((byte[])"package org.drools.mvel.compiler;\npublic class ClassCausingClassNotFoundException { non.existing.Type foo() { return null; } }\n".getBytes()).setResourceType(ResourceType.JAVA).setSourcePath("org/drools/mvel/compiler/ClassCausingClassNotFoundException.java");
        Resource drlResource = ResourceFactory.newByteArrayResource((byte[])"package org.drools.compiler;\nimport org.drools.mvel.compiler.JavaSourceMessage;rule R1 when\n   $m : JavaSourceMessage()\nthen\nend\n".getBytes()).setResourceType(ResourceType.DRL).setSourcePath("kbase1/drl1.drl");
        Predicate<String> filter = fileName -> !fileName.endsWith("org/drools/mvel/compiler/ClassCausingClassNotFoundException.java");
        KieModule km = null;
        try {
            KieFileSystem kfs = KieUtil.getKieFileSystemWithKieModule((KieModuleModel)KieModuleModelImpl.fromXML((String)"<kmodule xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" \n         xmlns=\"http://www.drools.org/xsd/kmodule\">\n  <kbase name=\"kbase1\">\n    <ksession name=\"ksession1\" default=\"true\"/>\n  </kbase>\n</kmodule>"), (ReleaseId)releaseId1, (Resource[])new Resource[]{allowedJavaResource, filteredJavaResource, drlResource});
            KieBuilder kieBuilder = ks.newKieBuilder(kfs);
            ((InternalKieBuilder)kieBuilder).buildAll(filter);
            km = kieBuilder.getKieModule();
            ks.getRepository().addKieModule(km);
        }
        catch (IllegalStateException ise) {
            if (ise.getMessage().contains("org/drools/mvel/compiler/ClassCausingClassNotFoundException.java")) {
                Assert.fail((String)"Build failed because source file was not filtered out.");
            }
            throw ise;
        }
        KieContainer kieContainer = ks.newKieContainer(km.getReleaseId());
        try {
            Class<?> messageClass = kieContainer.getClassLoader().loadClass("org.drools.mvel.compiler.JavaSourceMessage");
            Assert.assertNotNull(messageClass);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Loading the java class failed.", e);
        }
    }

    @Test
    public void testKieBuilderWithDotFiles() {
        String KBASE_NAME = "kieBase";
        String KSESSION_NAME = "kieSession";
        String drl = "declare TestEvent\n  name : String\nend\n";
        String dotDrl = "Meta-data used by kie-wb";
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem();
        kfs.write("src/main/resources/drlFile.drl", "declare TestEvent\n  name : String\nend\n");
        kfs.write("src/main/resources/.drlFile.drl", "Meta-data used by kie-wb");
        KieModuleModel kmoduleModel = ks.newKieModuleModel();
        kmoduleModel.newKieBaseModel("kieBase").addPackage("*").newKieSessionModel("kieSession").setDefault(true);
        kfs.writeKModuleXML(kmoduleModel.toXML());
        KieBuilder builder = KieUtil.getKieBuilderFromKieFileSystem((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieFileSystem)kfs, (boolean)false);
        for (org.kie.api.builder.Message m : builder.getResults().getMessages()) {
            System.out.println(m);
        }
        Assert.assertEquals((long)0L, (long)builder.getResults().getMessages().size());
        ks.getRepository().addKieModule(builder.getKieModule());
        KieSession kieSession = ks.newKieContainer(ks.getRepository().getDefaultReleaseId()).newKieSession("kieSession");
        Assert.assertNotNull((Object)kieSession);
        KieBase kieBase = ks.newKieContainer(ks.getRepository().getDefaultReleaseId()).getKieBase("kieBase");
        Assert.assertNotNull((Object)kieBase);
    }

    @Test
    public void testMultipleKBaseWithDrlError() {
        String drl = "package org.drools.compiler;\nrule \"test\"\n  when\n    Smurf\n  then\nend";
        KieServices ks = KieServices.Factory.get();
        KieModuleModel kproj = ks.newKieModuleModel();
        kproj.newKieBaseModel("kbase1").newKieSessionModel("ksession1").setDefault(true);
        kproj.newKieBaseModel("kbase2").newKieSessionModel("ksession2");
        ReleaseId releaseId = ks.newReleaseId("org.kie", "test-kie-builder", "1.0.0");
        KieFileSystem kfs = ks.newKieFileSystem().generateAndWritePomXML(releaseId).writeKModuleXML(kproj.toXML());
        Resource drlResource = ResourceFactory.newByteArrayResource((byte[])"package org.drools.compiler;\nrule \"test\"\n  when\n    Smurf\n  then\nend".getBytes()).setResourceType(ResourceType.DRL).setSourcePath("kbase1/drl1.drl");
        kfs.write("src/main/resources/org/drools/compiler/drl1.drl", drlResource);
        KieBuilder kb = KieUtil.getKieBuilderFromKieFileSystem((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieFileSystem)kfs, (boolean)false);
        List messages = kb.getResults().getMessages(new Message.Level[]{Message.Level.ERROR});
        Assert.assertEquals((long)4L, (long)messages.size());
        Assert.assertTrue((boolean)((org.kie.api.builder.Message)messages.get(0)).toString().contains("kbase1"));
        Assert.assertTrue((boolean)((org.kie.api.builder.Message)messages.get(1)).toString().contains("kbase1"));
        Assert.assertTrue((boolean)((org.kie.api.builder.Message)messages.get(2)).toString().contains("kbase2"));
        Assert.assertTrue((boolean)((org.kie.api.builder.Message)messages.get(3)).toString().contains("kbase2"));
    }

    @Test
    public void testBuildWithKBaseAndKSessionWithIdenticalNames() {
        String kmodule = "<kmodule xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" \n         xmlns=\"http://www.drools.org/xsd/kmodule\">\n  <kbase name=\"name\">\n    <ksession name=\"name\" default=\"true\"/>\n  </kbase>\n</kmodule>";
        this.checkKModule("<kmodule xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" \n         xmlns=\"http://www.drools.org/xsd/kmodule\">\n  <kbase name=\"name\">\n    <ksession name=\"name\" default=\"true\"/>\n  </kbase>\n</kmodule>", 0);
    }

    @Test
    public void testBuildWithDuplicatedKSessionNames() {
        String kmodule = "<kmodule xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" \n         xmlns=\"http://www.drools.org/xsd/kmodule\">\n  <kbase name=\"kbase1\">\n    <ksession name=\"ksessionA\" default=\"true\"/>\n  </kbase>\n  <kbase name=\"kbase2\">\n    <ksession name=\"ksessionA\"/>\n  </kbase>\n</kmodule>";
        this.checkKModule("<kmodule xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" \n         xmlns=\"http://www.drools.org/xsd/kmodule\">\n  <kbase name=\"kbase1\">\n    <ksession name=\"ksessionA\" default=\"true\"/>\n  </kbase>\n  <kbase name=\"kbase2\">\n    <ksession name=\"ksessionA\"/>\n  </kbase>\n</kmodule>", 1);
    }

    @Test
    public void testBuildWithDuplicatedKBaseNames() {
        String kmodule = "<kmodule xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" \n         xmlns=\"http://www.drools.org/xsd/kmodule\">\n  <kbase name=\"kbase1\">\n    <ksession name=\"ksessionA\" default=\"true\"/>\n  </kbase>\n  <kbase name=\"kbase1\">\n    <ksession name=\"ksessionB\"/>\n  </kbase>\n</kmodule>";
        this.checkKModule("<kmodule xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" \n         xmlns=\"http://www.drools.org/xsd/kmodule\">\n  <kbase name=\"kbase1\">\n    <ksession name=\"ksessionA\" default=\"true\"/>\n  </kbase>\n  <kbase name=\"kbase1\">\n    <ksession name=\"ksessionB\"/>\n  </kbase>\n</kmodule>", 1);
    }

    private void checkKModule(String kmodule, int expectedErrors) {
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId = ks.newReleaseId("org.kie", "test-kie-builder", "1.0.0");
        KieFileSystem kfs = ks.newKieFileSystem().generateAndWritePomXML(releaseId).writeKModuleXML(kmodule);
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromKieFileSystem((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieFileSystem)kfs, (boolean)false);
        Results results = kieBuilder.getResults();
        Assert.assertEquals((long)expectedErrors, (long)results.getMessages(new Message.Level[]{Message.Level.ERROR}).size());
        Assert.assertNotNull((Object)((InternalKieBuilder)kieBuilder).getKieModuleIgnoringErrors());
    }

    @Test
    public void testAddMissingResourceToPackageBuilder() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        Assertions.assertThatThrownBy(() -> kbuilder.add(ResourceFactory.newClassPathResource((String)"some.rf"), ResourceType.DRL)).isInstanceOf(RuntimeException.class);
        Assertions.assertThatThrownBy(() -> kbuilder.add(ResourceFactory.newClassPathResource((String)"some.bpmn"), ResourceType.BPMN2)).isInstanceOf(RuntimeException.class);
    }

    @Test
    public void testDeclarativeChannelRegistration() {
        String drl1 = "package org.drools.mvel.compiler\nrule R1 when\n   $m : Message()\nthen\nend\n";
        String kmodule = "<kmodule xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" \n         xmlns=\"http://www.drools.org/xsd/kmodule\">\n  <kbase name=\"kbase1\">\n    <ksession name=\"ksession1\" default=\"true\">\n       <channels>\n         <channel name=\"testChannel\" type=\"org.drools.mvel.integrationtests.KieBuilderTest$MockChannel\" />\n       </channels>\n    </ksession>  </kbase>\n</kmodule>";
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId1 = ks.newReleaseId("org.kie", "test-kie-builder", "1.0.0");
        Resource r1 = ResourceFactory.newByteArrayResource((byte[])"package org.drools.mvel.compiler\nrule R1 when\n   $m : Message()\nthen\nend\n".getBytes()).setResourceType(ResourceType.DRL).setSourcePath("kbase1/drl1.drl");
        KieModule km = KieUtil.buildAndInstallKieModuleIntoRepo((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (ReleaseId)releaseId1, (KieModuleModel)KieModuleModelImpl.fromXML((String)"<kmodule xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" \n         xmlns=\"http://www.drools.org/xsd/kmodule\">\n  <kbase name=\"kbase1\">\n    <ksession name=\"ksession1\" default=\"true\">\n       <channels>\n         <channel name=\"testChannel\" type=\"org.drools.mvel.integrationtests.KieBuilderTest$MockChannel\" />\n       </channels>\n    </ksession>  </kbase>\n</kmodule>"), (Resource[])new Resource[]{r1});
        KieContainer kieContainer = ks.newKieContainer(km.getReleaseId());
        KieSession kieSession = kieContainer.newKieSession();
        Assert.assertEquals((long)1L, (long)kieSession.getChannels().size());
        Assert.assertTrue((boolean)kieSession.getChannels().keySet().contains("testChannel"));
    }

    @Test
    public void testStatelessSessionDeclarativeChannelRegistration() {
        String drl1 = "package org.drools.mvel.compiler\nrule R1 when\n   $m : Message()\nthen\nend\n";
        String kmodule = "<kmodule xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" \n         xmlns=\"http://www.drools.org/xsd/kmodule\">\n  <kbase name=\"kbase1\">\n    <ksession name=\"ksession1\" default=\"true\" type=\"stateless\">\n       <channels>\n         <channel name=\"testChannel\" type=\"org.drools.mvel.integrationtests.KieBuilderTest$MockChannel\" />\n       </channels>\n    </ksession>  </kbase>\n</kmodule>";
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId1 = ks.newReleaseId("org.kie", "test-kie-builder", "1.0.0");
        Resource r1 = ResourceFactory.newByteArrayResource((byte[])"package org.drools.mvel.compiler\nrule R1 when\n   $m : Message()\nthen\nend\n".getBytes()).setResourceType(ResourceType.DRL).setSourcePath("kbase1/drl1.drl");
        KieModule km = KieUtil.buildAndInstallKieModuleIntoRepo((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (ReleaseId)releaseId1, (KieModuleModel)KieModuleModelImpl.fromXML((String)"<kmodule xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" \n         xmlns=\"http://www.drools.org/xsd/kmodule\">\n  <kbase name=\"kbase1\">\n    <ksession name=\"ksession1\" default=\"true\" type=\"stateless\">\n       <channels>\n         <channel name=\"testChannel\" type=\"org.drools.mvel.integrationtests.KieBuilderTest$MockChannel\" />\n       </channels>\n    </ksession>  </kbase>\n</kmodule>"), (Resource[])new Resource[]{r1});
        KieContainer kieContainer = ks.newKieContainer(km.getReleaseId());
        StatelessKieSession statelessKieSession = kieContainer.newStatelessKieSession();
        Assert.assertEquals((long)1L, (long)statelessKieSession.getChannels().size());
        Assert.assertTrue((boolean)statelessKieSession.getChannels().keySet().contains("testChannel"));
    }

    public static class MockChannel
    implements Channel {
        public void send(Object object) {
        }
    }
}

