/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests.phreak;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.rule.ContextEntry;
import org.drools.core.rule.Declaration;
import org.drools.core.spi.BetaNodeFieldConstraint;
import org.drools.core.spi.Constraint;
import org.drools.core.spi.Tuple;
import org.drools.drl.parser.impl.Operator;
import org.drools.mvel.integrationtests.phreak.FakeContextEntry;
import org.drools.util.ClassUtils;

public class FakeBetaNodeFieldConstraint
implements BetaNodeFieldConstraint {
    private Class clazz;
    private String fieldName;
    private Declaration declaration;
    private String evaluatorString;
    private Operator operator;
    private Method accessor;

    public FakeBetaNodeFieldConstraint(Class clazz, String fieldName, Declaration declaration, String evaluatorString) {
        this.clazz = clazz;
        this.fieldName = fieldName;
        this.declaration = declaration;
        this.evaluatorString = evaluatorString;
        this.operator = Operator.determineOperator((String)evaluatorString, (boolean)false);
        this.accessor = ClassUtils.getAccessor((Class)clazz, (String)fieldName);
    }

    public Declaration[] getRequiredDeclarations() {
        throw new UnsupportedOperationException();
    }

    public void replaceDeclaration(Declaration oldDecl, Declaration newDecl) {
        throw new UnsupportedOperationException();
    }

    public Constraint clone() {
        throw new UnsupportedOperationException();
    }

    public Constraint.ConstraintType getType() {
        throw new UnsupportedOperationException();
    }

    public boolean isTemporal() {
        throw new UnsupportedOperationException();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        throw new UnsupportedOperationException();
    }

    public boolean isAllowedCachedLeft(ContextEntry context, InternalFactHandle handle) {
        Object fact = handle.getObject();
        Tuple tuple = ((FakeContextEntry)context).getTuple();
        return this.evaluate(fact, tuple, context);
    }

    public boolean isAllowedCachedRight(Tuple tuple, ContextEntry context) {
        Object fact = ((FakeContextEntry)context).getHandle().getObject();
        return this.evaluate(fact, tuple, context);
    }

    private boolean evaluate(Object fact, Tuple tuple, ContextEntry context) {
        try {
            Object value = this.accessor.invoke(fact, new Object[0]);
            Object declObj = tuple.getObject(this.declaration);
            Object declValue = this.declaration.getValue(((FakeContextEntry)context).getReteEvaluator(), declObj);
            if (this.operator == Operator.BuiltInOperator.EQUAL.getOperator()) {
                return value.equals(declValue);
            }
            if (this.operator == Operator.BuiltInOperator.NOT_EQUAL.getOperator()) {
                return !value.equals(declValue);
            }
            if (this.operator == Operator.BuiltInOperator.LESS.getOperator()) {
                return ((Comparable)value).compareTo((Comparable)declValue) < 0;
            }
            if (this.operator == Operator.BuiltInOperator.GREATER.getOperator()) {
                return ((Comparable)value).compareTo((Comparable)declValue) > 0;
            }
            throw new UnsupportedOperationException("This operator " + this.evaluatorString + " is not supported. Feel free to enhance this method");
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    public ContextEntry createContextEntry() {
        return new FakeContextEntry();
    }

    public BetaNodeFieldConstraint cloneIfInUse() {
        throw new UnsupportedOperationException();
    }
}

