/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests.session;

import java.util.ArrayList;
import java.util.Collection;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;

@RunWith(value=Parameterized.class)
public class EntryPointTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public EntryPointTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    @Test
    public void testEntryPointWithVarIN() {
        String str = "package org.drools.mvel.compiler.test;\n\nglobal java.util.List list;\n\nrule \"In\"\nwhen\n   $x : Integer()\n then\n   drools.getEntryPoint(\"inX\").insert( $x );\nend\n\nrule \"Out\"\nwhen\n   $i : Integer() from entry-point \"inX\"\nthen\n   list.add( $i );\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.drools.mvel.compiler.test;\n\nglobal java.util.List list;\n\nrule \"In\"\nwhen\n   $x : Integer()\n then\n   drools.getEntryPoint(\"inX\").insert( $x );\nend\n\nrule \"Out\"\nwhen\n   $i : Integer() from entry-point \"inX\"\nthen\n   list.add( $i );\nend"});
        KieSession ksession = kbase.newKieSession();
        ksession.insert((Object)10);
        ArrayList res = new ArrayList();
        ksession.setGlobal("list", res);
        ksession.fireAllRules();
        ksession.dispose();
        Assert.assertTrue((boolean)res.contains(10));
    }
}

