/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests.session;

import java.util.ArrayList;
import java.util.Collection;
import org.drools.mvel.compiler.Move;
import org.drools.mvel.compiler.Person;
import org.drools.mvel.compiler.PersonFinal;
import org.drools.mvel.compiler.Pet;
import org.drools.mvel.compiler.Win;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;

@RunWith(value=Parameterized.class)
public class InsertTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public InsertTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    @Test
    public void testInsert() throws Exception {
        String drl = "";
        drl = drl + "package test\n";
        drl = drl + "import org.drools.mvel.compiler.Person\n";
        drl = drl + "import org.drools.mvel.compiler.Pet\n";
        drl = drl + "import java.util.ArrayList\n";
        drl = drl + "global java.util.List list\n";
        drl = drl + "rule test\n";
        drl = drl + "when\n";
        drl = drl + "$person:Person()\n";
        drl = drl + "$pets : ArrayList()\n";
        drl = drl + "   from collect( \n";
        drl = drl + "      Pet(\n";
        drl = drl + "         ownerName == $person.name\n";
        drl = drl + "      )\n";
        drl = drl + "   )\n";
        drl = drl + "then\n";
        drl = drl + "  list.add( $person );\n";
        drl = drl + "end\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Person p = new Person("Toni");
        ksession.insert((Object)p);
        ksession.insert((Object)new Pet("Toni"));
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertSame((Object)p, list.get(0));
    }

    @Test
    public void testInsertionOrder() {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_InsertionOrder.drl"});
        KieSession ksession = kbase.newKieSession();
        ArrayList results = new ArrayList();
        ksession.setGlobal("results", results);
        ksession.insert((Object)new Move(1, 2));
        ksession.insert((Object)new Move(2, 3));
        Win win2 = new Win(2);
        Win win3 = new Win(3);
        ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)results.size());
        Assert.assertTrue((boolean)results.contains(win2));
        Assert.assertTrue((boolean)results.contains(win3));
        ksession.dispose();
        ksession = kbase.newKieSession();
        results = new ArrayList();
        ksession.setGlobal("results", results);
        ksession.insert((Object)new Move(2, 3));
        ksession.insert((Object)new Move(1, 2));
        ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)results.size());
        Assert.assertTrue((boolean)results.contains(win2));
        Assert.assertTrue((boolean)results.contains(win3));
    }

    @Test
    public void testInsertFinalClassInstance() throws Exception {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_FinalClass.drl"});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("results", list);
        PersonFinal bob = new PersonFinal();
        bob.setName("bob");
        bob.setStatus(null);
        ksession.insert((Object)bob);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
    }
}

