/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.rule;

import org.drools.core.base.ClassObjectType;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.facttemplates.Fact;
import org.drools.core.facttemplates.FactTemplate;
import org.drools.core.facttemplates.FactTemplateImpl;
import org.drools.core.facttemplates.FactTemplateObjectType;
import org.drools.core.facttemplates.FieldTemplate;
import org.drools.core.facttemplates.FieldTemplateImpl;
import org.drools.core.reteoo.CoreComponentFactory;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.Pattern;
import org.drools.core.spi.InternalReadAccessor;
import org.drools.core.spi.ObjectType;
import org.drools.core.test.model.Cheese;
import org.junit.Assert;
import org.junit.Test;

public class PatternTest {
    @Test
    public void testDeclarationsObjectType() throws Exception {
        ClassObjectType type = new ClassObjectType(Cheese.class);
        Pattern col = new Pattern(0, (ObjectType)type, "foo");
        Declaration dec = col.getDeclaration();
        InternalReadAccessor ext = dec.getExtractor();
        Assert.assertEquals(Cheese.class, (Object)ext.getExtractToClass());
        Cheese stilton = new Cheese("stilton", 42);
        Assert.assertEquals((Object)stilton, (Object)dec.getValue(null, (Object)stilton));
    }

    @Test
    public void testDeclarationsFactTemplate() throws Exception {
        InternalKnowledgePackage pkg = CoreComponentFactory.get().createKnowledgePackage("org.store");
        FieldTemplateImpl cheeseName = new FieldTemplateImpl("name", String.class);
        FieldTemplateImpl cheesePrice = new FieldTemplateImpl("price", Integer.class);
        FieldTemplate[] fields = new FieldTemplate[]{cheeseName, cheesePrice};
        FactTemplateImpl cheese = new FactTemplateImpl(pkg, "Cheese", fields);
        FactTemplateObjectType type = new FactTemplateObjectType((FactTemplate)cheese);
        Pattern col = new Pattern(0, (ObjectType)type, "foo");
        Declaration dec = col.getDeclaration();
        InternalReadAccessor ext = dec.getExtractor();
        Assert.assertEquals(Fact.class, (Object)ext.getExtractToClass());
        Fact stilton = cheese.createFact();
        stilton.set("name", (Object)"stilton");
        stilton.set("price", (Object)new Integer(200));
        Assert.assertEquals((Object)stilton, (Object)dec.getValue(null, (Object)stilton));
    }
}

