/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.drools.compiler.integrationtests.incrementalcompilation.TestUtil;
import org.drools.core.impl.RuleBaseFactory;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.definition.type.FactType;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.conf.ClockTypeOption;
import org.kie.api.runtime.conf.KieSessionOption;
import org.kie.api.time.SessionPseudoClock;

@RunWith(value=Parameterized.class)
public class AccumulateCepTest {
    public static final String TEST_MANY_SLIDING_WINDOWS_DRL = "package com.sample;\n\nglobal java.util.List list; \ndeclare Fakt\n  @role( event ) \n  id : int \nend\n \nrule Init \nwhen \n  $i : Integer() \nthen \n  insert( new Fakt( $i ) ); \nend\nrule \"Test\"\nwhen\n   accumulate ( $d : Fakt( id > 10 ) over window:length(2), $tot1 : count( $d ) ) \n   accumulate ( $d : Fakt( id < 50 ) over window:length(5), $tot2 : count( $d ) ) \nthen\n  list.clear();\n   list.add( $tot1.intValue() ); \n  list.add( $tot2.intValue() ); \nend\n\n";
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public AccumulateCepTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseStreamConfigurations((boolean)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAccumulatesExpireVsCancel() throws Exception {
        String drl = "package com.sample;\n\nglobal java.util.List list; \ndeclare FactTest\n @role( event ) \nend\n \nrule \"A500 test\"\nwhen\n accumulate (\n $d : FactTest() over window:time(1m), $tot : count($d); $tot > 0 )\nthen\n System.out.println( $tot ); \n list.add( $tot.intValue() ); \n end\n\n";
        InternalKnowledgeBase kbase = (InternalKnowledgeBase)KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"accumulate-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[0]);
        kbase.addPackages(TestUtil.createKnowledgeBuilder(null, "package com.sample;\n\nglobal java.util.List list; \ndeclare FactTest\n @role( event ) \nend\n \nrule \"A500 test\"\nwhen\n accumulate (\n $d : FactTest() over window:time(1m), $tot : count($d); $tot > 0 )\nthen\n System.out.println( $tot ); \n list.add( $tot.intValue() ); \n end\n\n").getKnowledgePackages());
        KieSessionConfiguration ksConf = RuleBaseFactory.newKnowledgeSessionConfiguration();
        ksConf.setOption((KieSessionOption)ClockTypeOption.PSEUDO);
        KieSession ksession = kbase.newKieSession(ksConf, null);
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            FactType ft = kbase.getFactType("com.sample", "FactTest");
            ksession.insert(ft.newInstance());
            ksession.fireAllRules();
            ksession.insert(ft.newInstance());
            ksession.fireAllRules();
            ksession.insert(ft.newInstance());
            ksession.fireAllRules();
            SessionPseudoClock clock = (SessionPseudoClock)ksession.getSessionClock();
            clock.advanceTime(1L, TimeUnit.MINUTES);
            ksession.fireAllRules();
            Assert.assertFalse((boolean)list.contains(0));
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testManySlidingWindows() {
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"accumulate-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{TEST_MANY_SLIDING_WINDOWS_DRL});
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            ksession.insert((Object)new Integer(20));
            ksession.fireAllRules();
            Assert.assertEquals(Arrays.asList(1, 1), list);
            ksession.insert((Object)new Integer(20));
            ksession.fireAllRules();
            Assert.assertEquals(Arrays.asList(2, 2), list);
            ksession.insert((Object)new Integer(20));
            ksession.fireAllRules();
            Assert.assertEquals(Arrays.asList(2, 3), list);
            ksession.insert((Object)new Integer(2));
            ksession.fireAllRules();
            Assert.assertEquals(Arrays.asList(2, 4), list);
            ksession.insert((Object)new Integer(2));
            ksession.fireAllRules();
            Assert.assertEquals(Arrays.asList(2, 5), list);
            ksession.insert((Object)new Integer(2));
            ksession.fireAllRules();
            Assert.assertEquals(Arrays.asList(2, 5), list);
        }
        finally {
            ksession.dispose();
        }
    }
}

