/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.drools.testcoverage.common.model.MyFact;
import org.drools.testcoverage.common.model.Person;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.rule.QueryResults;
import org.kie.api.runtime.rule.QueryResultsRow;
import org.kie.api.runtime.rule.Variable;

@RunWith(value=Parameterized.class)
public class AccumulateConsistencyTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;
    private final boolean accumulateNullPropagation;

    public AccumulateConsistencyTest(KieBaseTestConfiguration kieBaseTestConfiguration, boolean accumulateNullPropagation) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
        this.accumulateNullPropagation = accumulateNullPropagation;
    }

    @Parameterized.Parameters(name="KieBase type={0}, accumulateNullPropagation= {1}")
    public static Collection<Object[]> getParameters() {
        ArrayList<Object[]> parameters = new ArrayList<Object[]>();
        parameters.add(new Object[]{KieBaseTestConfiguration.CLOUD_IDENTITY, false});
        parameters.add(new Object[]{KieBaseTestConfiguration.CLOUD_IDENTITY_MODEL_PATTERN, false});
        parameters.add(new Object[]{KieBaseTestConfiguration.CLOUD_IDENTITY, true});
        parameters.add(new Object[]{KieBaseTestConfiguration.CLOUD_IDENTITY_MODEL_PATTERN, true});
        return parameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMinNoMatch() {
        String drl = "package org.drools.compiler.integrationtests;\nimport " + Person.class.getCanonicalName() + ";\nrule R\nwhen\n    accumulate( $p : Person( name == \"John\" ),\n                $min : min( $p.getAge() ) )\nthen\n    System.out.println($min);\nend";
        KieBase kieBase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"accumulate-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSessionConfiguration kieSessionConfiguration = KieServices.get().newKieSessionConfiguration();
        kieSessionConfiguration.setProperty("drools.accumulateNullPropagation", Boolean.toString(this.accumulateNullPropagation));
        KieSession kieSession = kieBase.newKieSession(kieSessionConfiguration, null);
        try {
            kieSession.insert((Object)new Person("Paul", 20));
            if (this.accumulateNullPropagation) {
                Assert.assertEquals((long)1L, (long)kieSession.fireAllRules());
            } else {
                Assert.assertEquals((long)0L, (long)kieSession.fireAllRules());
            }
        }
        finally {
            kieSession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMaxNoMatch() {
        String drl = "package org.drools.compiler.integrationtests;\nimport " + Person.class.getCanonicalName() + ";\nrule R\nwhen\n    accumulate( $p : Person( name == \"John\" ),\n                $max : max( $p.getAge() ) )\nthen\n    System.out.println($max);\nend";
        KieBase kieBase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"accumulate-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSessionConfiguration kieSessionConfiguration = KieServices.get().newKieSessionConfiguration();
        kieSessionConfiguration.setProperty("drools.accumulateNullPropagation", Boolean.toString(this.accumulateNullPropagation));
        KieSession kieSession = kieBase.newKieSession(kieSessionConfiguration, null);
        try {
            kieSession.insert((Object)new Person("Paul", 20));
            if (this.accumulateNullPropagation) {
                Assert.assertEquals((long)1L, (long)kieSession.fireAllRules());
            } else {
                Assert.assertEquals((long)0L, (long)kieSession.fireAllRules());
            }
        }
        finally {
            kieSession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAveNoMatch() {
        String drl = "package org.drools.compiler.integrationtests;\nimport " + Person.class.getCanonicalName() + ";\nrule R\nwhen\n    accumulate( $p : Person( name == \"John\" ),\n                $ave : average( $p.getAge() ) )\nthen\n    System.out.println($ave);\nend";
        KieBase kieBase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"accumulate-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSessionConfiguration kieSessionConfiguration = KieServices.get().newKieSessionConfiguration();
        kieSessionConfiguration.setProperty("drools.accumulateNullPropagation", Boolean.toString(this.accumulateNullPropagation));
        KieSession kieSession = kieBase.newKieSession(kieSessionConfiguration, null);
        try {
            kieSession.insert((Object)new Person("Paul", 20));
            if (this.accumulateNullPropagation) {
                Assert.assertEquals((long)1L, (long)kieSession.fireAllRules());
            } else {
                Assert.assertEquals((long)0L, (long)kieSession.fireAllRules());
            }
        }
        finally {
            kieSession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSumNoMatch() {
        String drl = "package org.drools.compiler.integrationtests;\nimport " + Person.class.getCanonicalName() + ";\nrule R\nwhen\n    accumulate( $p : Person( name == \"John\" ),\n                $sum : sum( $p.getAge() ) )\nthen\n    System.out.println($sum);\nend";
        KieBase kieBase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"accumulate-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSessionConfiguration kieSessionConfiguration = KieServices.get().newKieSessionConfiguration();
        kieSessionConfiguration.setProperty("drools.accumulateNullPropagation", Boolean.toString(this.accumulateNullPropagation));
        KieSession kieSession = kieBase.newKieSession(kieSessionConfiguration, null);
        try {
            kieSession.insert((Object)new Person("Paul", 20));
            Assert.assertEquals((long)1L, (long)kieSession.fireAllRules());
        }
        finally {
            kieSession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCountNoMatch() {
        String drl = "package org.drools.compiler.integrationtests;\nimport " + Person.class.getCanonicalName() + ";\nrule R\nwhen\n    accumulate( $p : Person( name == \"John\" ),\n                $count : count( $p.getAge() ) )\nthen\n    System.out.println($count);\nend";
        KieBase kieBase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"accumulate-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSessionConfiguration kieSessionConfiguration = KieServices.get().newKieSessionConfiguration();
        kieSessionConfiguration.setProperty("drools.accumulateNullPropagation", Boolean.toString(this.accumulateNullPropagation));
        KieSession kieSession = kieBase.newKieSession(kieSessionConfiguration, null);
        try {
            kieSession.insert((Object)new Person("Paul", 20));
            Assert.assertEquals((long)1L, (long)kieSession.fireAllRules());
        }
        finally {
            kieSession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMinMaxNoMatch() {
        String drl = "package org.drools.compiler.integrationtests;\nimport " + Person.class.getCanonicalName() + ";\nrule R\nwhen\n    accumulate( $p : Person( name == \"John\" ),\n                $min : min( $p.getAge() ),\n                $max : max( $p.getAge() ))\nthen\n    System.out.println($min + \", \" + $max);\nend";
        KieBase kieBase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"accumulate-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSessionConfiguration kieSessionConfiguration = KieServices.get().newKieSessionConfiguration();
        kieSessionConfiguration.setProperty("drools.accumulateNullPropagation", Boolean.toString(this.accumulateNullPropagation));
        KieSession kieSession = kieBase.newKieSession(kieSessionConfiguration, null);
        try {
            kieSession.insert((Object)new Person("Paul", 20));
            Assert.assertEquals((long)1L, (long)kieSession.fireAllRules());
        }
        finally {
            kieSession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMinMaxMatch() {
        String drl = "package org.drools.compiler.integrationtests;\nimport " + Person.class.getCanonicalName() + ";\nglobal java.util.Map result;\nrule R\nwhen\n    accumulate( $p : Person( name == \"John\" ),\n                $min : min( $p.getAge() ),\n                $max : max( $p.getAge() ))\nthen\n    result.put(\"min\", $min);\n    result.put(\"max\", $max);\n    System.out.println($min + \", \" + $max);\nend";
        KieBase kieBase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"accumulate-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSessionConfiguration kieSessionConfiguration = KieServices.get().newKieSessionConfiguration();
        kieSessionConfiguration.setProperty("drools.accumulateNullPropagation", Boolean.toString(this.accumulateNullPropagation));
        KieSession kieSession = kieBase.newKieSession(kieSessionConfiguration, null);
        HashMap result = new HashMap();
        kieSession.setGlobal("result", result);
        try {
            kieSession.insert((Object)new Person(0, "John", 20));
            kieSession.insert((Object)new Person(1, "John", 60));
            Assert.assertEquals((long)1L, (long)kieSession.fireAllRules());
            Assert.assertEquals((long)20L, (long)((Integer)result.get("min")).intValue());
            Assert.assertEquals((long)60L, (long)((Integer)result.get("max")).intValue());
        }
        finally {
            kieSession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMinNoMatchAccFrom() {
        String drl = "package org.drools.compiler.integrationtests;\nimport " + Person.class.getCanonicalName() + ";\nrule R\nwhen\n    $min : Number() from accumulate( $p : Person( name == \"John\" ),\n                min( $p.getAge() ) )\nthen\n    System.out.println($min);\nend";
        KieBase kieBase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"accumulate-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSessionConfiguration kieSessionConfiguration = KieServices.get().newKieSessionConfiguration();
        kieSessionConfiguration.setProperty("drools.accumulateNullPropagation", Boolean.toString(this.accumulateNullPropagation));
        KieSession kieSession = kieBase.newKieSession(kieSessionConfiguration, null);
        try {
            kieSession.insert((Object)new Person("Paul", 20));
            if (this.accumulateNullPropagation) {
                Assert.assertEquals((long)1L, (long)kieSession.fireAllRules());
            } else {
                Assert.assertEquals((long)0L, (long)kieSession.fireAllRules());
            }
        }
        finally {
            kieSession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMinMatchUnification() {
        String drl = "package org.drools.compiler.integrationtests;\nimport " + Person.class.getCanonicalName() + ";\nimport " + MyFact.class.getCanonicalName() + ";\nrule R\nwhen\n    MyFact($i : currentValue)\n    accumulate( $p : Person( name == \"John\" ),\n                $i := min( $p.getAge() ) )\nthen\n    System.out.println($i);\nend";
        KieBase kieBase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"accumulate-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSessionConfiguration kieSessionConfiguration = KieServices.get().newKieSessionConfiguration();
        kieSessionConfiguration.setProperty("drools.accumulateNullPropagation", Boolean.toString(this.accumulateNullPropagation));
        KieSession kieSession = kieBase.newKieSession(kieSessionConfiguration, null);
        try {
            kieSession.insert((Object)new Person("John", 20));
            kieSession.insert((Object)new MyFact("A", Integer.valueOf(20)));
            Assert.assertEquals((long)1L, (long)kieSession.fireAllRules());
        }
        finally {
            kieSession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMinNoMatchUnification() {
        String drl = "package org.drools.compiler.integrationtests;\nimport " + Person.class.getCanonicalName() + ";\nimport " + MyFact.class.getCanonicalName() + ";\nrule R\nwhen\n    MyFact($i : currentValue)\n    accumulate( $p : Person( name == \"John\" ),\n                $i := min( $p.getAge() ) )\nthen\n    System.out.println($i);\nend";
        KieBase kieBase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"accumulate-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSessionConfiguration kieSessionConfiguration = KieServices.get().newKieSessionConfiguration();
        kieSessionConfiguration.setProperty("drools.accumulateNullPropagation", Boolean.toString(this.accumulateNullPropagation));
        KieSession kieSession = kieBase.newKieSession(kieSessionConfiguration, null);
        try {
            kieSession.insert((Object)new Person("Paul", 20));
            kieSession.insert((Object)new MyFact("A", null));
            if (this.accumulateNullPropagation) {
                Assert.assertEquals((long)1L, (long)kieSession.fireAllRules());
            } else {
                Assert.assertEquals((long)0L, (long)kieSession.fireAllRules());
            }
        }
        finally {
            kieSession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMinMatchUnificationQuery() {
        String drl = "package org.drools.compiler.integrationtests;\nimport " + Person.class.getCanonicalName() + ";\nimport java.util.List;\nquery getResults( String $name, List $persons )\n  accumulate(  \n    $p : Person( name == $name),\n    $persons := collectList( $p )\n  ) \nend\n";
        KieBase kieBase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"accumulate-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSessionConfiguration kieSessionConfiguration = KieServices.get().newKieSessionConfiguration();
        kieSessionConfiguration.setProperty("drools.accumulateNullPropagation", Boolean.toString(this.accumulateNullPropagation));
        KieSession kieSession = kieBase.newKieSession(kieSessionConfiguration, null);
        try {
            kieSession.insert((Object)new Person(0, "John", 20));
            kieSession.insert((Object)new Person(1, "John", 19));
            QueryResults results = kieSession.getQueryResults("getResults", new Object[]{"John", Variable.v});
            List persons = (List)((QueryResultsRow)results.iterator().next()).get("$persons");
            Assert.assertEquals((long)2L, (long)persons.size());
        }
        finally {
            kieSession.dispose();
        }
    }
}

