/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests;

import java.util.ArrayList;
import java.util.Collection;
import org.drools.modelcompiler.ExecutableModelProject;
import org.drools.util.io.ByteArrayResource;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.ReleaseId;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;

public class BigRuleSetCompilationTest {
    @Test
    public void test() {
        KieServices kieService = KieServices.Factory.get();
        KieFileSystem kfs = kieService.newKieFileSystem();
        ReleaseId rid = kieService.newReleaseId("org.drools.test", "big-rule-set", "1.0.0");
        kfs.generateAndWritePomXML(rid);
        this.generateResourcesToBeCompiled(2, 3).forEach(arg_0 -> ((KieFileSystem)kfs).write(arg_0));
        KieBuilder kbuilder = kieService.newKieBuilder(kfs);
        kbuilder.buildAll(ExecutableModelProject.class);
        Assert.assertTrue((boolean)kbuilder.getResults().getMessages().isEmpty());
    }

    private Collection<Resource> generateResourcesToBeCompiled(int numberOfResources, int rulesPerResource) {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        for (int i = 0; i < numberOfResources; ++i) {
            ByteArrayResource resource = new ByteArrayResource(this.generateRules("org.kie.kogito.codegen.test" + i, rulesPerResource).getBytes());
            resource.setResourceType(ResourceType.DRL);
            resource.setSourcePath("org/kie/kogito/codegen/test" + i + "/rules.drl");
            resources.add((Resource)resource);
        }
        return resources;
    }

    private String generateRules(String packageName, int n) {
        StringBuilder sb = new StringBuilder("package " + packageName + "\n");
        for (int i = 0; i < n; ++i) {
            sb.append(this.generateRule(i));
        }
        return sb.toString();
    }

    private String generateRule(int seed) {
        return "rule R" + seed + " when\n  $i: Integer( this == " + seed + " )\n  $s: String( this == $i.toString() )\nthen\n  System.out.println($s);\nend\n";
    }
}

