/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import org.assertj.core.api.Assertions;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieUtil;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.model.KieBaseModel;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderConfiguration;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.io.ResourceFactory;

public class ClassLoaderTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClassLoaderGetResourcesFromWithin() {
        KieServices kieServices = KieServices.Factory.get();
        String drl1 = "package org.drools.testdrl;\nglobal java.util.List list;\nrule R when\nthen\n   java.net.URL url = drools.getProjectClassLoader().getResource(\"META-INF/foo.xml\");\n   if (url != null) list.add(url);\nend\n";
        Resource resource1 = kieServices.getResources().newReaderResource((Reader)new StringReader("package org.drools.testdrl;\nglobal java.util.List list;\nrule R when\nthen\n   java.net.URL url = drools.getProjectClassLoader().getResource(\"META-INF/foo.xml\");\n   if (url != null) list.add(url);\nend\n"), "UTF-8");
        resource1.setTargetPath("org/drools/testdrl/rules1.drl");
        String foo = "<xyz/>\n";
        Resource resource2 = kieServices.getResources().newReaderResource((Reader)new StringReader("<xyz/>\n"), "UTF-8");
        resource2.setTargetPath("META-INF/foo.xml");
        String kmodule = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<kmodule xmlns=\"http://www.drools.org/xsd/kmodule\">\n  <kbase name=\"testKbase\" packages=\"org.drools.testdrl\">\n    <ksession name=\"testKsession\"/>\n  </kbase>\n</kmodule>";
        ReleaseId releaseId = kieServices.newReleaseId("org.kie", "test-cl", "1.0.0");
        KieUtil.getKieModuleFromResources((ReleaseId)releaseId, (KieBaseTestConfiguration)KieBaseTestConfiguration.CLOUD_IDENTITY, (Resource[])new Resource[]{resource1, resource2});
        KieContainer kieContainer = kieServices.newKieContainer(releaseId);
        ClassLoader classLoader = kieContainer.getClassLoader();
        URL url = classLoader.getResource("META-INF/foo.xml");
        Assertions.assertThat((URL)url).isNotNull();
        KieSession ksession = kieContainer.newKieSession("KieSessionModelName");
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            ksession.fireAllRules();
            Assert.assertEquals((long)1L, (long)list.size());
            Assert.assertEquals((Object)url.getPath(), (Object)((URL)list.get(0)).getPath());
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClassLoaderFromPojo() {
        String source = "package org.drools.testdrl;\npublic class MyPojo {\n    public String getUrlPath() {        return getClass().getClassLoader().getResource(\"META-INF/foo.xml\").getPath();\n    }\n}\n";
        String drl1 = "package org.drools.testdrl;\nimport org.drools.testdrl.MyPojo;\nglobal java.util.List list;\nrule R1 when\nthen\n   insert(new MyPojo());\nend\nrule R2 when\n    $m : MyPojo()\nthen\n   list.add($m.getUrlPath());\nend\n";
        String foo = "<xyz/>\n";
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId = ks.newReleaseId("org.kie", "test-cl", "1.0.0");
        KieFileSystem kfs = ks.newKieFileSystem();
        KieModuleModel kproj = ks.newKieModuleModel();
        KieBaseModel kieBaseModel1 = kproj.newKieBaseModel("testKbase").setDefault(true).addPackage("org.drools.testdrl");
        kieBaseModel1.newKieSessionModel("testKsession").setDefault(true);
        kfs.writeKModuleXML(kproj.toXML());
        kfs.write("src/main/resources/org/drools/testdrl/rules1.drl", "package org.drools.testdrl;\nimport org.drools.testdrl.MyPojo;\nglobal java.util.List list;\nrule R1 when\nthen\n   insert(new MyPojo());\nend\nrule R2 when\n    $m : MyPojo()\nthen\n   list.add($m.getUrlPath());\nend\n");
        kfs.write("src/main/java/org/drools/testdrl/MyPojo.java", "package org.drools.testdrl;\npublic class MyPojo {\n    public String getUrlPath() {        return getClass().getClassLoader().getResource(\"META-INF/foo.xml\").getPath();\n    }\n}\n");
        kfs.write("src/main/resources/META-INF/foo.xml", "<xyz/>\n");
        kfs.generateAndWritePomXML(releaseId);
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromKieFileSystem((KieBaseTestConfiguration)KieBaseTestConfiguration.CLOUD_IDENTITY, (KieFileSystem)kfs, (boolean)true);
        Assert.assertTrue((boolean)kieBuilder.buildAll().getResults().getMessages().isEmpty());
        KieContainer kieContainer = ks.newKieContainer(releaseId);
        ClassLoader classLoader = kieContainer.getClassLoader();
        URL url = classLoader.getResource("META-INF/foo.xml");
        Assertions.assertThat((URL)url).isNotNull();
        KieSession ksession = kieContainer.newKieSession("testKsession");
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            ksession.fireAllRules();
            Assert.assertEquals((long)1L, (long)list.size());
            Assert.assertEquals((Object)url.getPath(), list.get(0));
        }
        finally {
            ksession.dispose();
        }
    }

    @Test
    public void testClassLoaderHits() {
        KnowledgeBuilderConfiguration conf = KnowledgeBuilderFactory.newKnowledgeBuilderConfiguration();
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder((KnowledgeBuilderConfiguration)conf);
        kbuilder.add(ResourceFactory.newInputStreamResource((InputStream)this.getClass().getResourceAsStream("test_GeneratedBeansMVEL.drl")), ResourceType.DRL);
        kbuilder.add(ResourceFactory.newInputStreamResource((InputStream)this.getClass().getResourceAsStream("test_GeneratedBeans.drl")), ResourceType.DRL);
        kbuilder.add(ResourceFactory.newInputStreamResource((InputStream)this.getClass().getResourceAsStream("test_NullFieldOnCompositeSink.drl")), ResourceType.DRL);
        Assert.assertFalse((String)kbuilder.getErrors().toString(), (boolean)kbuilder.hasErrors());
    }
}

