/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests.incrementalcompilation;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.assertj.core.api.Assertions;
import org.drools.compiler.integrationtests.incrementalcompilation.AddRemoveTestCases;
import org.drools.compiler.integrationtests.incrementalcompilation.TestUtil;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.reteoo.SubnetworkTuple;
import org.drools.core.util.DroolsTestUtil;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.kiesession.rulebase.KnowledgeBaseFactory;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.api.definition.KiePackage;
import org.kie.api.definition.rule.Rule;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.StatelessKieSession;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.io.ResourceFactory;

@RunWith(value=Parameterized.class)
public class AddRemoveRulesTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;
    private InternalKnowledgeBase base = KnowledgeBaseFactory.newKnowledgeBase();

    public AddRemoveRulesTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    private String getPrefix() {
        return "package com.rules \nimport java.util.Map;\nimport java.util.HashMap;\nimport org.slf4j.Logger;\nimport java.util.Date;\ndeclare Counter \n@role(event)\n id : int \n\nend\n\n";
    }

    @Before
    public void createEmptyKnowledgeBase() {
        KieServices kieServices = KieServices.get();
        ReleaseId releaseId = kieServices.newReleaseId("org.kie", "test-add-remove-rules", "1.0");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[0]);
        KieContainer kieContainer = kieServices.newKieContainer(releaseId);
        this.base = (InternalKnowledgeBase)kieContainer.getKieBase();
    }

    private void loadRule(String rule) {
        String prefix = this.getPrefix();
        prefix = prefix + rule;
        KnowledgeBuilder builder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        builder.add(ResourceFactory.newReaderResource((Reader)new StringReader(prefix)), ResourceType.DRL);
        Collection<KiePackage> pkgs = this.buildKnowledge(builder);
        this.addKnowledgeToBase(pkgs);
    }

    private void addRuleToEngine(String rule) {
        this.loadRule(rule);
    }

    private void deleteRule(String name) {
        this.base.removeRule("com.rules", name);
    }

    private Collection<KiePackage> buildKnowledge(KnowledgeBuilder builder) {
        if (builder.hasErrors()) {
            Assert.fail((String)builder.getErrors().toString());
        }
        return builder.getKnowledgePackages();
    }

    private void addKnowledgeToBase(Collection<KiePackage> pkgs) {
        this.base.addPackages(pkgs);
    }

    @Test
    public void test() {
        KieSession knowledgeSession = this.base.newKieSession();
        knowledgeSession.fireAllRules();
        String ruleNormal1 = "rule 'rn1' when $c : Counter(id==1)then System.out.println('RN1 fired!!!'); \n end ";
        this.addRuleToEngine("rule 'rn1' when $c : Counter(id==1)then System.out.println('RN1 fired!!!'); \n end ");
        String ruleNormal2 = "rule 'rn2' when $c : Counter(id==1)then System.out.println('RN2 fired!!!'); \n end ";
        this.addRuleToEngine("rule 'rn2' when $c : Counter(id==1)then System.out.println('RN2 fired!!!'); \n end ");
        String ruleNormal3 = "rule 'rn3' when $c : Counter(id==1)then System.out.println('RN3 + fired!!!'); \n end ";
        this.addRuleToEngine("rule 'rn3' when $c : Counter(id==1)then System.out.println('RN3 + fired!!!'); \n end ");
        String rule = "rule 'test' when $c : Counter(id==1)eval(Integer.parseInt(\"5\")==$c.getId()) \neval(Integer.parseInt(\"10\")>5) then System.out.println('TEST 1 fired!!!');end ";
        this.addRuleToEngine("rule 'test' when $c : Counter(id==1)eval(Integer.parseInt(\"5\")==$c.getId()) \neval(Integer.parseInt(\"10\")>5) then System.out.println('TEST 1 fired!!!');end ");
        String rule2 = "rule 'test2' when $c : Counter(id==2)eval(Integer.parseInt(\"10\")==$c.getId()) \neval(Integer.parseInt(\"20\")>10) then System.out.println('TEST 2 fired!!!'); \n end ";
        this.addRuleToEngine("rule 'test2' when $c : Counter(id==2)eval(Integer.parseInt(\"10\")==$c.getId()) \neval(Integer.parseInt(\"20\")>10) then System.out.println('TEST 2 fired!!!'); \n end ");
        String rule3 = "rule 'test3' when $c : Counter(id==3)eval(Integer.parseInt(\"15\")==$c.getId()) \neval(Integer.parseInt(\"30\")>20) then System.out.println('TEST 2 fired!!!'); \n end ";
        this.addRuleToEngine("rule 'test3' when $c : Counter(id==3)eval(Integer.parseInt(\"15\")==$c.getId()) \neval(Integer.parseInt(\"30\")>20) then System.out.println('TEST 2 fired!!!'); \n end ");
        String rule4 = "rule 'test4' when $c : Counter(id==4)eval(Integer.parseInt(\"20\")==$c.getId()) \neval(Integer.parseInt(\"40\")>30) then System.out.println('TEST 2 fired!!!'); \n end ";
        this.addRuleToEngine("rule 'test4' when $c : Counter(id==4)eval(Integer.parseInt(\"20\")==$c.getId()) \neval(Integer.parseInt(\"40\")>30) then System.out.println('TEST 2 fired!!!'); \n end ");
        String rule5 = "rule 'test5' when $c : Counter(id==5)eval(Integer.parseInt(\"25\")==$c.getId()) \neval(Integer.parseInt(\"50\")>40) then System.out.println('TEST 2 fired!!!'); \n end ";
        this.addRuleToEngine("rule 'test5' when $c : Counter(id==5)eval(Integer.parseInt(\"25\")==$c.getId()) \neval(Integer.parseInt(\"50\")>40) then System.out.println('TEST 2 fired!!!'); \n end ");
        String rule6 = "rule 'test6' when $c : Counter(id==6)eval(Integer.parseInt(\"30\")==$c.getId()) \neval(Integer.parseInt(\"60\")>50) then System.out.println('TEST 2 fired!!!'); \n end ";
        this.addRuleToEngine("rule 'test6' when $c : Counter(id==6)eval(Integer.parseInt(\"30\")==$c.getId()) \neval(Integer.parseInt(\"60\")>50) then System.out.println('TEST 2 fired!!!'); \n end ");
        Assert.assertEquals((long)9L, (long)TestUtil.getRulesCount((KieBase)this.base));
        this.deleteRule("test6");
        Assert.assertEquals((long)8L, (long)TestUtil.getRulesCount((KieBase)this.base));
        this.addRuleToEngine("rule 'test6' when $c : Counter(id==6)eval(Integer.parseInt(\"30\")==$c.getId()) \neval(Integer.parseInt(\"60\")>50) then System.out.println('TEST 2 fired!!!'); \n end ");
        Assert.assertEquals((long)9L, (long)TestUtil.getRulesCount((KieBase)this.base));
        this.deleteRule("test6");
        Assert.assertEquals((long)8L, (long)TestUtil.getRulesCount((KieBase)this.base));
    }

    @Test
    public void testAddRemoveFromKB() {
        String drl = "\nrule A\n  when\n    Double() from entry-point \"AAA\"\n  then\n  end\n\nrule B\n  when\n    Boolean()\n    Float()\n  then\n  end\n\n\nrule C\n  when\n  then\n    insertLogical( new Float( 0.0f ) );\n  end\n\n\nrule D\n  when\n    Byte( )\n    String( )\n  then\n  end\n\n\nrule E\n  when\n    Float()\n  then\n    insertLogical( \"foo\" );\n  end\n";
        KnowledgeBuilder kbuilder = TestUtil.createKnowledgeBuilder(null, "\nrule A\n  when\n    Double() from entry-point \"AAA\"\n  then\n  end\n\nrule B\n  when\n    Boolean()\n    Float()\n  then\n  end\n\n\nrule C\n  when\n  then\n    insertLogical( new Float( 0.0f ) );\n  end\n\n\nrule D\n  when\n    Byte( )\n    String( )\n  then\n  end\n\n\nrule E\n  when\n    Float()\n  then\n    insertLogical( \"foo\" );\n  end\n");
        this.base.addPackages(kbuilder.getKnowledgePackages());
        KieSession kSession = this.base.newKieSession();
        kSession.fireAllRules();
        ((InternalKnowledgeBase)kSession.getKieBase()).addPackages(kbuilder.getKnowledgePackages());
    }

    @Test
    public void testAddRemoveDeletingFact() {
        String drl = "\nrule B\n  when\n    Boolean()\n    Float()\n  then\n  end\n\n";
        KnowledgeBuilder kbuilder = TestUtil.createKnowledgeBuilder(null, "\nrule B\n  when\n    Boolean()\n    Float()\n  then\n  end\n\n");
        this.base.addPackages(kbuilder.getKnowledgePackages());
        KieSession kSession = this.base.newKieSession();
        FactHandle fh = kSession.insert((Object)Float.valueOf(0.0f));
        kSession.fireAllRules();
        ((InternalKnowledgeBase)kSession.getKieBase()).addPackages(kbuilder.getKnowledgePackages());
        kSession.delete(fh);
    }

    @Test
    public void testAddRemoveWithPartialSharing() {
        String drl = "package org.drools.test; \n\ndeclare A end \ndeclare B end \ndeclare C end \ndeclare D end \nrule Init \n  when\n  then\n    insert( new A() ); \n    insert( new B() ); \n  end\nrule One\n  when\n    A()\n    B()\n    C()\n  then\n  end\n\nrule Two\n  when\n    A()\n    B()\n    D()\n  then\n  end\n\n";
        KnowledgeBuilder kbuilder = TestUtil.createKnowledgeBuilder(null, "package org.drools.test; \n\ndeclare A end \ndeclare B end \ndeclare C end \ndeclare D end \nrule Init \n  when\n  then\n    insert( new A() ); \n    insert( new B() ); \n  end\nrule One\n  when\n    A()\n    B()\n    C()\n  then\n  end\n\nrule Two\n  when\n    A()\n    B()\n    D()\n  then\n  end\n\n");
        this.base.addPackages(kbuilder.getKnowledgePackages());
        KieSession kSession = this.base.newKieSession();
        kSession.fireAllRules();
        kSession.getKieBase().removeRule("org.drools.test", "Two");
        kSession.fireAllRules();
    }

    @Test
    public void testAddRemoveWithReloadInSamePackage_4Rules() {
        String drl = "package org.drools.test;\ndeclare Fakt enabled : boolean end \nrule Build1\nwhen\n    Fakt( enabled == true )\nthen\nend\nrule Build2\nwhen\n    Fakt( enabled == true )\nthen\nend\nrule Mark \nsalience 9999\nwhen\nthen\n    insertLogical( new Fakt( true ) );\nend\nrule Build3 \nwhen\n    Fakt( enabled == true ) \nthen\nend\nrule Build4 \nwhen\n    Fakt( enabled == true )\nthen\nend\n";
        this.testAddRemoveWithReloadInSamePackage("package org.drools.test;\ndeclare Fakt enabled : boolean end \nrule Build1\nwhen\n    Fakt( enabled == true )\nthen\nend\nrule Build2\nwhen\n    Fakt( enabled == true )\nthen\nend\nrule Mark \nsalience 9999\nwhen\nthen\n    insertLogical( new Fakt( true ) );\nend\nrule Build3 \nwhen\n    Fakt( enabled == true ) \nthen\nend\nrule Build4 \nwhen\n    Fakt( enabled == true )\nthen\nend\n");
    }

    @Test
    public void testAddRemoveWithReloadInSamePackage_3Rules() {
        String drl = "package org.drools.test;\ndeclare Fakt enabled : boolean end \nrule Build1\nwhen\n    Fakt( enabled == true )\nthen\nend\nrule Build2\nwhen\n    Fakt( enabled == true )\nthen\nend\nrule Mark \nsalience 9999\nwhen\nthen\n    insertLogical( new Fakt( true ) );\nend\nrule Build3 \nwhen\n    Fakt( enabled == true ) \nthen\nend\n";
        this.testAddRemoveWithReloadInSamePackage("package org.drools.test;\ndeclare Fakt enabled : boolean end \nrule Build1\nwhen\n    Fakt( enabled == true )\nthen\nend\nrule Build2\nwhen\n    Fakt( enabled == true )\nthen\nend\nrule Mark \nsalience 9999\nwhen\nthen\n    insertLogical( new Fakt( true ) );\nend\nrule Build3 \nwhen\n    Fakt( enabled == true ) \nthen\nend\n");
    }

    @Test
    public void testAddRemoveWithReloadInSamePackage_EntryPoints() {
        String drl = "package org.drools.test; \nrule \"Input_X\"\nwhen\n    Double() from entry-point \"A\"\n    not String( )\nthen\nend\nrule \"Input_Y\"\nwhen\n    Double() from entry-point \"A\"\n    not Float( )\nthen\nend\nrule \"OverrideInput_Temp\"\nwhen\n    Double() from entry-point \"A\"\n    Float( )\nthen\nend\nrule \"Zero\"\nwhen\nthen\nend\n";
        this.testAddRemoveWithReloadInSamePackage("package org.drools.test; \nrule \"Input_X\"\nwhen\n    Double() from entry-point \"A\"\n    not String( )\nthen\nend\nrule \"Input_Y\"\nwhen\n    Double() from entry-point \"A\"\n    not Float( )\nthen\nend\nrule \"OverrideInput_Temp\"\nwhen\n    Double() from entry-point \"A\"\n    Float( )\nthen\nend\nrule \"Zero\"\nwhen\nthen\nend\n");
    }

    @Test
    public void testAddRemoveWithReloadInSamePackage_EntryPointsVariety() {
        String drl = "package org.drools.test; \nrule \"Input_X\"\nwhen\n    Double() \n    not String( )\nthen\nend\nrule \"Input_Y\"\nwhen\n    Double() from entry-point \"A\"\n    not Float( )\nthen\nend\nrule \"OverrideInput_Temp\"\nwhen\n    Double() from entry-point \"A\"\n    Float( )\nthen\nend\nrule \"Zero\"\nwhen\nthen\nend\n";
        this.testAddRemoveWithReloadInSamePackage("package org.drools.test; \nrule \"Input_X\"\nwhen\n    Double() \n    not String( )\nthen\nend\nrule \"Input_Y\"\nwhen\n    Double() from entry-point \"A\"\n    not Float( )\nthen\nend\nrule \"OverrideInput_Temp\"\nwhen\n    Double() from entry-point \"A\"\n    Float( )\nthen\nend\nrule \"Zero\"\nwhen\nthen\nend\n");
    }

    private void testAddRemoveWithReloadInSamePackage(String drl) {
        String simpleRuleInTestPackage = "package org.drools.test; \nglobal java.util.List list; \nrule \"Later\" when    $s : String( ) then    System.out.println( \"ok\" );    list.add( \"ok\" ); \nend ";
        KieSession knowledgeSession = TestUtil.buildSessionInSteps(this.base, drl, "package org.drools.test; \nglobal java.util.List list; \nrule \"Later\" when    $s : String( ) then    System.out.println( \"ok\" );    list.add( \"ok\" ); \nend ");
        ArrayList list = new ArrayList();
        knowledgeSession.setGlobal("list", list);
        knowledgeSession.insert((Object)"go");
        knowledgeSession.fireAllRules();
        Assert.assertEquals(Collections.singletonList("ok"), list);
    }

    @Test
    public void testRemoveWithDuplicatedCondition() {
        String packageName = "test_same_condition_pk";
        String rule = "package test_same_condition_pk;rule 'test_same_condition' \nwhen \n String(this == \"1\") \n String(this == \"1\") \nthen \nSystem.out.println('test same condition rule'); \nend";
        KnowledgeBuilder kbuilder = TestUtil.createKnowledgeBuilder(null, "package test_same_condition_pk;rule 'test_same_condition' \nwhen \n String(this == \"1\") \n String(this == \"1\") \nthen \nSystem.out.println('test same condition rule'); \nend");
        this.base.addPackages(kbuilder.getKnowledgePackages());
        this.base.removeKiePackage("test_same_condition_pk");
    }

    @Test
    public void testFireAfterRemoveDuplicatedConditionInDifferentPackages() {
        String packageName = "test_same_condition_pk";
        String packageName2 = "test_same_condition_pk_2";
        String rule1 = "package test_same_condition_pk;import java.util.Map; \nrule 'test_same_condition' \nwhen \n Map(this['name'] == 'Michael') \nthen \nSystem.out.println('test same condition rule'); \nend";
        String rule2 = "package test_same_condition_pk_2;import java.util.Map; \nrule 'test_same_condition_2' \nwhen \n Map(this['name'] == 'Michael') \n Map(this['test'] == '1') \nthen \nSystem.out.println('test same condition rule 2'); \nend";
        KieSession session = TestUtil.buildSessionInSteps(this.base, "package test_same_condition_pk;import java.util.Map; \nrule 'test_same_condition' \nwhen \n Map(this['name'] == 'Michael') \nthen \nSystem.out.println('test same condition rule'); \nend", "package test_same_condition_pk_2;import java.util.Map; \nrule 'test_same_condition_2' \nwhen \n Map(this['name'] == 'Michael') \n Map(this['test'] == '1') \nthen \nSystem.out.println('test same condition rule 2'); \nend");
        session.getKieBase().removeKiePackage("test_same_condition_pk");
        session.fireAllRules();
        HashMap<String, String> fact = new HashMap<String, String>();
        fact.put("name", "Michael");
        session.insert(fact);
        session.fireAllRules();
    }

    @Test
    public void testAddRemoveWithExtends() {
        String packageName = "test_same_condition_pk";
        String rule1 = "package test_same_condition_pk;import java.util.Map; \nrule \"parentRule\" \nwhen \n Map(this['name'] == 'Michael') \nthen \nSystem.out.println('Parent rule!'); \nend";
        String rule2 = "package test_same_condition_pk;import java.util.Map; \nrule \"childRule\" \n     extends \"parentRule\"\nwhen \n Map(this['test'] == '1') \nthen \nSystem.out.println('Child rule!'); \nend";
        KieSession session = TestUtil.buildSessionInSteps(this.base, true, "package test_same_condition_pk;import java.util.Map; \nrule \"parentRule\" \nwhen \n Map(this['name'] == 'Michael') \nthen \nSystem.out.println('Parent rule!'); \nend", "package test_same_condition_pk;import java.util.Map; \nrule \"childRule\" \n     extends \"parentRule\"\nwhen \n Map(this['test'] == '1') \nthen \nSystem.out.println('Child rule!'); \nend");
        session.fireAllRules();
        HashMap<String, Object> fact = new HashMap<String, Object>();
        fact.put("name", "Michael");
        fact.put("test", 1);
        session.insert(fact);
        try {
            session.getKieBase().removeRule("test_same_condition_pk", "parentRule");
            Assert.fail((String)"A parent rule cannot be removed if one of its children is still there");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testRemoveHasSameConElement() {
        String packageName = "test";
        String rule1 = "package test;import java.util.Map; \nrule 'rule1' \nwhen \n Map(this['type'] == 'Goods' && this['brand'] == 'a') \n Map(this['type'] == 'Goods' && this['category'] == 'b') \nthen \nSystem.out.println('test rule 1'); \nend";
        KnowledgeBuilder kbuilder = TestUtil.createKnowledgeBuilder(null, "package test;import java.util.Map; \nrule 'rule1' \nwhen \n Map(this['type'] == 'Goods' && this['brand'] == 'a') \n Map(this['type'] == 'Goods' && this['category'] == 'b') \nthen \nSystem.out.println('test rule 1'); \nend");
        this.base.addPackages(kbuilder.getKnowledgePackages());
        this.base.removeKiePackage("test");
        StatelessKieSession session = this.base.newStatelessKieSession();
        session.execute(new HashMap());
    }

    @Test
    public void testFireAfterRemoveWithSameCondition() {
        String packageName = "pk1";
        String packageName2 = "pk2";
        String rule1 = "package pk1;import java.util.Map; \nrule 'rule1' \nwhen \n Map(this['type'] == 'Goods' ) \n Map(this['x'] == 'y'  ) \n Map(this['type'] == 'Juice'  ) \n Map(this['kind'] == 'Stuff'  ) \nthen \nend";
        String rule2 = "package pk2;import java.util.Map; \nrule 'rule2' \nwhen \n Map(this['type'] == 'Goods' ) \n Map(this['x'] == 'y'  ) \n Map(this['type'] == 'Juice'  ) \nthen \nend";
        KieServices kieServices = KieServices.get();
        ReleaseId releaseId = kieServices.newReleaseId("org.kie", "test-fire-after-remove-with-same-condition", "1.0");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package pk1;import java.util.Map; \nrule 'rule1' \nwhen \n Map(this['type'] == 'Goods' ) \n Map(this['x'] == 'y'  ) \n Map(this['type'] == 'Juice'  ) \n Map(this['kind'] == 'Stuff'  ) \nthen \nend", "package pk2;import java.util.Map; \nrule 'rule2' \nwhen \n Map(this['type'] == 'Goods' ) \n Map(this['x'] == 'y'  ) \n Map(this['type'] == 'Juice'  ) \nthen \nend"});
        KieContainer kieContainer = kieServices.newKieContainer(releaseId);
        KieBase kbase = kieContainer.getKieBase();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("type", "Goods");
        map.put("kind", "Stuff");
        map.put("x", "y");
        KieSession ksession = kbase.newKieSession();
        ksession.insert(map);
        ksession.fireAllRules();
        kbase.removeKiePackage("pk2");
        ksession = kbase.newKieSession();
        ksession.insert(map);
        ksession.fireAllRules();
    }

    @Test
    public void testSameEval() {
        String rule1Name = "rule1";
        String rule2Name = "rule2";
        String rule1 = "rule rule1 \n when \n eval(true) \nthen \nSystem.out.println('test rule 1'); \nend";
        String rule2 = "rule rule2 \n when \n  eval(true) \nthen \nSystem.out.println('test rule 2'); \nend";
        StatelessKieSession statelessSession = this.base.newStatelessKieSession();
        this.addRuleToEngine("rule rule1 \n when \n eval(true) \nthen \nSystem.out.println('test rule 1'); \nend");
        statelessSession.execute(new Object());
        this.addRuleToEngine("rule rule2 \n when \n  eval(true) \nthen \nSystem.out.println('test rule 2'); \nend");
        statelessSession.execute(new Object());
    }

    @Test
    public void testFireAfterRemoveRule() {
        String rule1Name = "rule1";
        String rule2Name = "rule2";
        String rule1 = "rule rule1 \nwhen \n Map(  this['type'] == 'Goods'  ) and  Map(  this['type'] == 'Cinema'  )then \n System.out.println('test in rule1'); \nend";
        String rule2 = "rule rule2 \nwhen \n Map(  this['type'] == 'Goods'  ) and  Map(  this['type'] == 'Cinema'  )then \n System.out.println('test in rule2'); \nend";
        HashMap<String, String> fact = new HashMap<String, String>();
        fact.put("type", "Cinema");
        StatelessKieSession session = this.base.newStatelessKieSession();
        this.addRuleToEngine("rule rule1 \nwhen \n Map(  this['type'] == 'Goods'  ) and  Map(  this['type'] == 'Cinema'  )then \n System.out.println('test in rule1'); \nend");
        session.execute(fact);
        this.addRuleToEngine("rule rule2 \nwhen \n Map(  this['type'] == 'Goods'  ) and  Map(  this['type'] == 'Cinema'  )then \n System.out.println('test in rule2'); \nend");
        session.execute(fact);
        this.deleteRule("rule1");
        session.execute(fact);
    }

    @Test
    public void testRemoveWithSameRuleNameInDiffPackage() {
        String packageName = "pk1";
        String packageName2 = "pk2";
        String rule1Name = "rule1";
        String rule1 = "package pk1;rule rule1 \nwhen \n String( ) \nthen \n System.out.println('test in rule1'); \nend";
        String rule2 = "package pk2;rule rule1 \nwhen \n Long( ) \nthen \n System.out.println('test in rule2'); \nend";
        KieSession session = TestUtil.buildSessionInSteps(this.base, "package pk1;rule rule1 \nwhen \n String( ) \nthen \n System.out.println('test in rule1'); \nend", "package pk2;rule rule1 \nwhen \n Long( ) \nthen \n System.out.println('test in rule2'); \nend");
        session.getKieBase().removeKiePackage("pk1");
        session.getKieBase().removeKiePackage("pk2");
        session.insert((Object)"");
        session.fireAllRules();
    }

    @Test
    public void testRemoveWithSplitStartAtLianAndFollowedBySubNetworkNoSharing() {
        String packageName = "pk1";
        String rule1 = "package pk1;global java.util.concurrent.atomic.AtomicInteger globalInt\nrule R1 when\n    $s : String()\n    Integer()\n    exists Integer() from globalInt.get()\nthen\nend\n";
        KieSession session = TestUtil.buildSessionInSteps(this.base, "package pk1;global java.util.concurrent.atomic.AtomicInteger globalInt\nrule R1 when\n    $s : String()\n    Integer()\n    exists Integer() from globalInt.get()\nthen\nend\n");
        session.setGlobal("globalInt", (Object)new AtomicInteger(0));
        session.insert((Object)1);
        session.insert((Object)"1");
        session.fireAllRules();
        session.getKieBase().removeKiePackage("pk1");
    }

    @Test
    public void testRemoveExistsPopulatedByInitialFact() {
        String rule1 = "package com.rules;global java.util.List list\nrule R1 when\n    exists( Integer() and Integer() )\nthen\n list.add('R1'); \nend\n";
        String rule2 = "package com.rules;global java.util.List list\nrule R2 \nwhen \n    exists( Integer() and Integer() )\n    String()then \n list.add('R2'); \nend";
        AddRemoveTestCases.insertFactsRemoveFire(this.base, "package com.rules;global java.util.List list\nrule R1 when\n    exists( Integer() and Integer() )\nthen\n list.add('R1'); \nend\n", "package com.rules;global java.util.List list\nrule R2 \nwhen \n    exists( Integer() and Integer() )\n    String()then \n list.add('R2'); \nend", null, TestUtil.getDefaultFacts());
    }

    @Test
    public void testAddSplitInSubnetwork() {
        String rule1 = "package com.rules;global java.util.List list\nrule R1 when\n    exists( Integer() and Integer() )\nthen\n list.add('R1'); \nend\n";
        String rule2 = "package com.rules;global java.util.List list\nrule R2 \nwhen \n    exists( Integer() and String() )\n    String()then \n list.add('R2'); \nend";
        AddRemoveTestCases.insertFactsRemoveFire(this.base, "package com.rules;global java.util.List list\nrule R1 when\n    exists( Integer() and Integer() )\nthen\n list.add('R1'); \nend\n", "package com.rules;global java.util.List list\nrule R2 \nwhen \n    exists( Integer() and String() )\n    String()then \n list.add('R2'); \nend", null, TestUtil.getDefaultFacts());
    }

    @Test
    public void testRemoveWithSplitStartAtLianAndFollowedBySubNetworkWithSharing() {
        String rule1 = "package com.rules;global java.util.concurrent.atomic.AtomicInteger globalInt\nglobal java.util.List list\nrule R1 \nwhen\n    $s : String()\n    Integer()\n    exists Integer() from globalInt.get()\nthen\n list.add('R1'); \nend\n";
        String rule2 = "package com.rules;global java.util.List list\nrule R2 \nwhen \n    $s1 : String()\n    $s2 : String()\nthen \n list.add('R2'); \nend";
        this.testRemoveWithSplitStartBasicTestSet("package com.rules;global java.util.concurrent.atomic.AtomicInteger globalInt\nglobal java.util.List list\nrule R1 \nwhen\n    $s : String()\n    Integer()\n    exists Integer() from globalInt.get()\nthen\n list.add('R1'); \nend\n", "package com.rules;global java.util.List list\nrule R2 \nwhen \n    $s1 : String()\n    $s2 : String()\nthen \n list.add('R2'); \nend", "R1", "R2");
    }

    @Test
    public void testRemoveWithSplitStartBeforeJoinAndFollowedBySubNetworkWithSharing() {
        String rule1 = "package com.rules;global java.util.concurrent.atomic.AtomicInteger globalInt\nglobal java.util.List list\nrule R1 \nwhen\n    $s : String()\n    Integer()\n    exists Integer() from globalInt.get()\nthen\n list.add('R1'); \nend\n";
        String rule2 = "package com.rules;global java.util.concurrent.atomic.AtomicInteger globalInt\nglobal java.util.List list\nrule R2 \nwhen \n    $s : String()\n    exists Integer() from globalInt.get()\n    Integer()\n    String()\nthen \n list.add('R2'); \nend";
        this.testRemoveWithSplitStartBasicTestSet("package com.rules;global java.util.concurrent.atomic.AtomicInteger globalInt\nglobal java.util.List list\nrule R1 \nwhen\n    $s : String()\n    Integer()\n    exists Integer() from globalInt.get()\nthen\n list.add('R1'); \nend\n", "package com.rules;global java.util.concurrent.atomic.AtomicInteger globalInt\nglobal java.util.List list\nrule R2 \nwhen \n    $s : String()\n    exists Integer() from globalInt.get()\n    Integer()\n    String()\nthen \n list.add('R2'); \nend", "R1", "R2");
    }

    @Test
    public void testRemoveWithSplitStartAtJoinAndFollowedBySubNetworkWithSharing() {
        String rule1 = "package com.rules;global java.util.concurrent.atomic.AtomicInteger globalInt\nglobal java.util.List list\nrule R1 \nwhen\n    $s : String()\n    Integer()\n    exists Integer() from globalInt.get()\nthen\n list.add('R1'); \nend\n";
        String rule2 = "package com.rules;global java.util.concurrent.atomic.AtomicInteger globalInt\nglobal java.util.List list\nrule R2 \nwhen \n    $s : String()\n    Integer()\n    String()\nthen \n list.add('R2'); \nend";
        this.testRemoveWithSplitStartBasicTestSet("package com.rules;global java.util.concurrent.atomic.AtomicInteger globalInt\nglobal java.util.List list\nrule R1 \nwhen\n    $s : String()\n    Integer()\n    exists Integer() from globalInt.get()\nthen\n list.add('R1'); \nend\n", "package com.rules;global java.util.concurrent.atomic.AtomicInteger globalInt\nglobal java.util.List list\nrule R2 \nwhen \n    $s : String()\n    Integer()\n    String()\nthen \n list.add('R2'); \nend", "R1", "R2");
    }

    @Test
    public void testRemoveWithSplitStartSameRules() {
        String rule1 = "package com.rules;global java.util.concurrent.atomic.AtomicInteger globalInt\nglobal java.util.List list\nrule R1 \nwhen\n    $s : String()\n    Integer()\n    exists( Integer() and Integer() )\nthen\n list.add('R1'); \nend\n";
        String rule2 = "package com.rules;global java.util.concurrent.atomic.AtomicInteger globalInt\nglobal java.util.List list\nrule R2 \nwhen \n    $s : String()\n    Integer()\n    exists( Integer() and Integer() )\nthen \n list.add('R2'); \nend";
        this.testRemoveWithSplitStartBasicTestSet("package com.rules;global java.util.concurrent.atomic.AtomicInteger globalInt\nglobal java.util.List list\nrule R1 \nwhen\n    $s : String()\n    Integer()\n    exists( Integer() and Integer() )\nthen\n list.add('R1'); \nend\n", "package com.rules;global java.util.concurrent.atomic.AtomicInteger globalInt\nglobal java.util.List list\nrule R2 \nwhen \n    $s : String()\n    Integer()\n    exists( Integer() and Integer() )\nthen \n list.add('R2'); \nend", "R1", "R2");
    }

    @Test
    public void testRemoveWithSplitStartDoubledExistsConstraint() {
        String rule1 = "package com.rules;global java.util.concurrent.atomic.AtomicInteger globalInt\nglobal java.util.List list\nrule R1 \nwhen\n    $s : String()\n    Integer()\n    exists( Integer() and Integer() )\n    exists( Integer() and Integer() )\nthen\n list.add('R1'); \nend\n";
        String rule2 = "package com.rules;global java.util.concurrent.atomic.AtomicInteger globalInt\nglobal java.util.List list\nrule R2 \nwhen \n    $s : String()\n    Integer()\n    exists( Integer() and Integer() )\nthen \n list.add('R2'); \nend";
        this.testRemoveWithSplitStartBasicTestSet("package com.rules;global java.util.concurrent.atomic.AtomicInteger globalInt\nglobal java.util.List list\nrule R1 \nwhen\n    $s : String()\n    Integer()\n    exists( Integer() and Integer() )\n    exists( Integer() and Integer() )\nthen\n list.add('R1'); \nend\n", "package com.rules;global java.util.concurrent.atomic.AtomicInteger globalInt\nglobal java.util.List list\nrule R2 \nwhen \n    $s : String()\n    Integer()\n    exists( Integer() and Integer() )\nthen \n list.add('R2'); \nend", "R1", "R2");
    }

    @Test
    public void testRemoveWithSplitStartDoubledIntegerConstraint() {
        String rule1 = "package com.rules;global java.util.concurrent.atomic.AtomicInteger globalInt\nglobal java.util.List list\nrule R1 \nwhen\n    $s : String()\n    Integer()\n    exists( Integer() and Integer() )\nthen\n list.add('R1'); \nend\n";
        String rule2 = "package com.rules;global java.util.concurrent.atomic.AtomicInteger globalInt\nglobal java.util.List list\nrule R2 \nwhen \n    $s : String()\n    Integer()\n    Integer()\n    exists( Integer() and Integer() )\nthen \n list.add('R2'); \nend";
        this.testRemoveWithSplitStartBasicTestSet("package com.rules;global java.util.concurrent.atomic.AtomicInteger globalInt\nglobal java.util.List list\nrule R1 \nwhen\n    $s : String()\n    Integer()\n    exists( Integer() and Integer() )\nthen\n list.add('R1'); \nend\n", "package com.rules;global java.util.concurrent.atomic.AtomicInteger globalInt\nglobal java.util.List list\nrule R2 \nwhen \n    $s : String()\n    Integer()\n    Integer()\n    exists( Integer() and Integer() )\nthen \n list.add('R2'); \nend", "R1", "R2");
    }

    @Test
    public void testRemoveWithSplitStartAfterSubnetwork() {
        String rule1 = "package com.rules;global java.util.concurrent.atomic.AtomicInteger globalInt\nglobal java.util.List list\nrule R1 \nwhen\n    $s : String()\n    Integer()\n    exists( Integer() and Integer() )\nthen\n list.add('R1'); \nend\n";
        String rule2 = "package com.rules;global java.util.concurrent.atomic.AtomicInteger globalInt\nglobal java.util.List list\nrule R2 \nwhen \n    $s : String()\n    Integer()\n    exists( Integer() and Integer() )\n    String()\nthen \n list.add('R2'); \nend";
        this.testRemoveWithSplitStartBasicTestSet("package com.rules;global java.util.concurrent.atomic.AtomicInteger globalInt\nglobal java.util.List list\nrule R1 \nwhen\n    $s : String()\n    Integer()\n    exists( Integer() and Integer() )\nthen\n list.add('R1'); \nend\n", "package com.rules;global java.util.concurrent.atomic.AtomicInteger globalInt\nglobal java.util.List list\nrule R2 \nwhen \n    $s : String()\n    Integer()\n    exists( Integer() and Integer() )\n    String()\nthen \n list.add('R2'); \nend", "R1", "R2");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRemoveWithSplitStartAfterSubnetwork3Rules() {
        String rule1 = "package com.rules;global java.util.concurrent.atomic.AtomicInteger globalInt\nglobal java.util.List list\nrule R1 \nwhen\n    $s : String()\n    Integer()\n    exists( Integer() and Integer() )\nthen\n list.add('R1'); \nend\n";
        String rule2 = "package com.rules;global java.util.concurrent.atomic.AtomicInteger globalInt\nglobal java.util.List list\nrule R2 \nwhen \n    $s : String()\n    Integer()\n    exists( Integer() and Integer() )\n    String()\nthen \n list.add('R2'); \nend";
        String rule3 = "package com.rules;global java.util.concurrent.atomic.AtomicInteger globalInt\nglobal java.util.List list\nrule R3 \nwhen \n    $s : String()\n    Integer()\n    exists( Integer() and exists(Integer() and Integer()))\n    String()\nthen \n list.add('R3'); \nend";
        KieSession kieSession = TestUtil.buildSessionInSteps(this.base, "package com.rules;global java.util.concurrent.atomic.AtomicInteger globalInt\nglobal java.util.List list\nrule R1 \nwhen\n    $s : String()\n    Integer()\n    exists( Integer() and Integer() )\nthen\n list.add('R1'); \nend\n", "package com.rules;global java.util.concurrent.atomic.AtomicInteger globalInt\nglobal java.util.List list\nrule R2 \nwhen \n    $s : String()\n    Integer()\n    exists( Integer() and Integer() )\n    String()\nthen \n list.add('R2'); \nend", "package com.rules;global java.util.concurrent.atomic.AtomicInteger globalInt\nglobal java.util.List list\nrule R3 \nwhen \n    $s : String()\n    Integer()\n    exists( Integer() and exists(Integer() and Integer()))\n    String()\nthen \n list.add('R3'); \nend");
        try {
            ArrayList resultsList = new ArrayList();
            kieSession.setGlobal("list", resultsList);
            kieSession.setGlobal("globalInt", (Object)new AtomicInteger(0));
            TestUtil.insertFacts(kieSession, 1, 2, "1");
            kieSession.fireAllRules();
            Assertions.assertThat(resultsList).containsOnly((Object[])new String[]{"R1", "R2", "R3"});
            resultsList.clear();
            TestUtil.removeRules(kieSession, "com.rules", "R1", "R2", "R3");
            kieSession.fireAllRules();
            Assertions.assertThat(resultsList).isEmpty();
        }
        finally {
            kieSession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRemoveWithSplitStartAfterSubnetwork3RulesAddOneAfterAnother() {
        String rule1 = "package com.rules;global java.util.concurrent.atomic.AtomicInteger globalInt\nglobal java.util.List list\nrule R1 \nwhen\n    $s : String()\n    Integer()\n    exists( Integer() and Integer() )\nthen\n list.add('R1'); \nend\n";
        String rule2 = "package com.rules;global java.util.concurrent.atomic.AtomicInteger globalInt\nglobal java.util.List list\nrule R2 \nwhen \n    $s : String()\n    Integer()\n    exists( Integer() and Integer() )\n    String()\nthen \n list.add('R2'); \nend";
        String rule3 = "package com.rules;global java.util.concurrent.atomic.AtomicInteger globalInt\nglobal java.util.List list\nrule R3 \nwhen \n    $s : String()\n    Integer()\n    exists( Integer() and exists(Integer() and Integer()))\n    String()\nthen \n list.add('R3'); \nend";
        KieSession kieSession = TestUtil.buildSessionInSteps(this.base, "package com.rules;global java.util.concurrent.atomic.AtomicInteger globalInt\nglobal java.util.List list\nrule R1 \nwhen\n    $s : String()\n    Integer()\n    exists( Integer() and Integer() )\nthen\n list.add('R1'); \nend\n");
        try {
            ArrayList resultsList = new ArrayList();
            kieSession.setGlobal("list", resultsList);
            kieSession.setGlobal("globalInt", (Object)new AtomicInteger(0));
            TestUtil.insertFacts(kieSession, 1, 1, "1");
            kieSession.fireAllRules();
            Assertions.assertThat(resultsList).containsOnly((Object[])new String[]{"R1"});
            resultsList.clear();
            TestUtil.addRules(kieSession, "package com.rules;global java.util.concurrent.atomic.AtomicInteger globalInt\nglobal java.util.List list\nrule R2 \nwhen \n    $s : String()\n    Integer()\n    exists( Integer() and Integer() )\n    String()\nthen \n list.add('R2'); \nend");
            kieSession.fireAllRules();
            Assertions.assertThat(resultsList).containsOnly((Object[])new String[]{"R2"});
            resultsList.clear();
            TestUtil.addRules(kieSession, "package com.rules;global java.util.concurrent.atomic.AtomicInteger globalInt\nglobal java.util.List list\nrule R3 \nwhen \n    $s : String()\n    Integer()\n    exists( Integer() and exists(Integer() and Integer()))\n    String()\nthen \n list.add('R3'); \nend");
            kieSession.fireAllRules();
            Assertions.assertThat(resultsList).containsOnly((Object[])new String[]{"R3"});
            resultsList.clear();
            TestUtil.removeRules(kieSession, "com.rules", "R1", "R2", "R3");
            kieSession.fireAllRules();
            Assertions.assertThat(resultsList).isEmpty();
        }
        finally {
            kieSession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRemoveWithSplitStartAfterSubnetwork3RulesReaddRule() {
        String rule1 = "package com.rules;global java.util.List list\nrule R1 \nwhen\n    $s : String()\n    Integer()\n    exists( Integer() and Integer() )\nthen\n list.add('R1'); \nend\n";
        String rule2 = "package com.rules;global java.util.List list\nrule R2 \nwhen \n    $s : String()\n    Integer()\n    exists( Integer() and Integer() )\n    String()\nthen \n list.add('R2'); \nend";
        String rule3 = "package com.rules;global java.util.List list\nrule R3 \nwhen \n    $s : String()\n    Integer()\n    exists( Integer() and exists(Integer() and Integer()))\n    String()\nthen \n list.add('R3'); \nend";
        KieSession kieSession = TestUtil.buildSessionInSteps(this.base, "package com.rules;global java.util.List list\nrule R1 \nwhen\n    $s : String()\n    Integer()\n    exists( Integer() and Integer() )\nthen\n list.add('R1'); \nend\n", "package com.rules;global java.util.List list\nrule R2 \nwhen \n    $s : String()\n    Integer()\n    exists( Integer() and Integer() )\n    String()\nthen \n list.add('R2'); \nend", "package com.rules;global java.util.List list\nrule R3 \nwhen \n    $s : String()\n    Integer()\n    exists( Integer() and exists(Integer() and Integer()))\n    String()\nthen \n list.add('R3'); \nend");
        try {
            ArrayList resultsList = new ArrayList();
            kieSession.setGlobal("list", resultsList);
            TestUtil.insertFacts(kieSession, 1, 2, "1");
            TestUtil.removeRules(kieSession, "com.rules", "R2");
            kieSession.fireAllRules();
            Assertions.assertThat(resultsList).containsOnly((Object[])new String[]{"R1", "R3"});
            resultsList.clear();
            TestUtil.addRules(kieSession, "package com.rules;global java.util.List list\nrule R2 \nwhen \n    $s : String()\n    Integer()\n    exists( Integer() and Integer() )\n    String()\nthen \n list.add('R2'); \nend");
            kieSession.fireAllRules();
            Assertions.assertThat(resultsList).containsOnly((Object[])new String[]{"R2"});
        }
        finally {
            kieSession.dispose();
        }
    }

    private String[] getRules1Pattern() {
        String rule1 = "package com.rules;global java.util.List list\nrule R1 \nwhen\n    $i : Integer(this>1)\nthen\n list.add('R1'); \nend\n";
        String rule2 = "package com.rules;global java.util.List list\nrule R2 \nwhen \n    $i : Integer(this>2)\nthen \n list.add('R2'); \nend";
        return new String[]{"package com.rules;global java.util.List list\nrule R1 \nwhen\n    $i : Integer(this>1)\nthen\n list.add('R1'); \nend\n", "package com.rules;global java.util.List list\nrule R2 \nwhen \n    $i : Integer(this>2)\nthen \n list.add('R2'); \nend"};
    }

    private String[] getRules2Pattern() {
        String rule1 = "package com.rules;global java.util.List list\nrule R1 \nwhen\n    $i1 : Integer(this>1)\n    $i2 : Integer(this>1)\nthen\n list.add('R1'); \nend\n";
        String rule2 = "package com.rules;global java.util.List list\nrule R2 \nwhen \n    $i1 : Integer(this>1)\n    $i2 : Integer(this>2)\nthen \n list.add('R2'); \nend";
        return new String[]{"package com.rules;global java.util.List list\nrule R1 \nwhen\n    $i1 : Integer(this>1)\n    $i2 : Integer(this>1)\nthen\n list.add('R1'); \nend\n", "package com.rules;global java.util.List list\nrule R2 \nwhen \n    $i1 : Integer(this>1)\n    $i2 : Integer(this>2)\nthen \n list.add('R2'); \nend"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRemoveRuleChangeFHFirstLeftTuple() {
        String[] rules = this.getRules1Pattern();
        KieSession kieSession = TestUtil.buildSessionInSteps(this.base, rules);
        try {
            ArrayList resultsList = new ArrayList();
            kieSession.setGlobal("list", resultsList);
            TestUtil.insertFacts(kieSession, 3);
            kieSession.fireAllRules();
            Assertions.assertThat(resultsList).containsOnly((Object[])new String[]{"R1", "R2"});
            resultsList.clear();
            TestUtil.removeRules(kieSession, "com.rules", "R1");
            kieSession.fireAllRules();
            InternalFactHandle fh1 = (InternalFactHandle)kieSession.getFactHandle((Object)3);
            Assertions.assertThat((Object)fh1.getFirstLeftTuple()).isNotNull();
        }
        finally {
            kieSession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRemoveRuleChangeFHLastLeftTuple() {
        String[] rules = this.getRules1Pattern();
        KieSession kieSession = TestUtil.buildSessionInSteps(this.base, rules);
        try {
            ArrayList resultsList = new ArrayList();
            kieSession.setGlobal("list", resultsList);
            TestUtil.insertFacts(kieSession, 3);
            kieSession.fireAllRules();
            Assertions.assertThat(resultsList).containsOnly((Object[])new String[]{"R1", "R2"});
            resultsList.clear();
            TestUtil.removeRules(kieSession, "com.rules", "R2");
            kieSession.fireAllRules();
            InternalFactHandle fh1 = (InternalFactHandle)kieSession.getFactHandle((Object)3);
            Assertions.assertThat((Object)fh1.getFirstLeftTuple()).isNotNull();
        }
        finally {
            kieSession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRemoveRightTupleThatWasFirst() {
        String[] rules = this.getRules2Pattern();
        KieSession kieSession = TestUtil.buildSessionInSteps(this.base, rules);
        try {
            ArrayList resultsList = new ArrayList();
            kieSession.setGlobal("list", resultsList);
            TestUtil.insertFacts(kieSession, 3);
            kieSession.fireAllRules();
            Assertions.assertThat(resultsList).containsOnly((Object[])new String[]{"R1", "R2"});
            resultsList.clear();
            TestUtil.removeRules(kieSession, "com.rules", "R1");
            kieSession.fireAllRules();
            Map rulesMap = DroolsTestUtil.rulestoMap((KieBase)kieSession.getKieBase());
            InternalFactHandle fh1 = (InternalFactHandle)kieSession.getFactHandle((Object)3);
            Assertions.assertThat((Object)fh1.getFirstRightTuple()).isNotNull();
            Assert.assertEquals((long)1L, (long)fh1.getFirstRightTuple().getTupleSink().getAssociatedRuleSize());
            Assert.assertTrue((boolean)fh1.getFirstRightTuple().getTupleSink().isAssociatedWith((Rule)rulesMap.get("R2")));
        }
        finally {
            kieSession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRemoveRightTupleThatWasLast() {
        String[] rules = this.getRules2Pattern();
        KieSession kieSession = TestUtil.buildSessionInSteps(this.base, rules);
        try {
            ArrayList resultsList = new ArrayList();
            kieSession.setGlobal("list", resultsList);
            TestUtil.insertFacts(kieSession, 3);
            kieSession.fireAllRules();
            Assertions.assertThat(resultsList).containsOnly((Object[])new String[]{"R1", "R2"});
            resultsList.clear();
            TestUtil.removeRules(kieSession, "com.rules", "R2");
            kieSession.fireAllRules();
            Map rulesMap = DroolsTestUtil.rulestoMap((KieBase)kieSession.getKieBase());
            InternalFactHandle fh1 = (InternalFactHandle)kieSession.getFactHandle((Object)3);
            Assertions.assertThat((Object)fh1.getFirstRightTuple()).isNotNull();
            Assert.assertEquals((long)1L, (long)fh1.getFirstRightTuple().getTupleSink().getAssociatedRuleSize());
            Assert.assertTrue((boolean)fh1.getFirstRightTuple().getTupleSink().isAssociatedWith((Rule)rulesMap.get("R1")));
        }
        finally {
            kieSession.dispose();
        }
    }

    private String[] getRules3Pattern() {
        String rule1 = "package com.rules;global java.util.List list\nrule R1 \nwhen\n    $i1 : Integer(this>1)\n    $i2 : Integer(this>1)\n    $i3 : Integer(this>0)\nthen\n list.add('R1'); \nend\n";
        String rule2 = "package com.rules;global java.util.List list\nrule R2 \nwhen \n    $i1 : Integer(this>1)\n    $i2 : Integer(this>1)\n    $i3 : Integer(this>1)\nthen \n list.add('R2'); \nend";
        String rule3 = "package com.rules;global java.util.List list\nrule R3 \nwhen \n    $i1 : Integer(this>1)\n    $i2 : Integer(this>1)\n    $i3 : Integer(this>2)\nthen \n list.add('R3'); \nend";
        return new String[]{"package com.rules;global java.util.List list\nrule R1 \nwhen\n    $i1 : Integer(this>1)\n    $i2 : Integer(this>1)\n    $i3 : Integer(this>0)\nthen\n list.add('R1'); \nend\n", "package com.rules;global java.util.List list\nrule R2 \nwhen \n    $i1 : Integer(this>1)\n    $i2 : Integer(this>1)\n    $i3 : Integer(this>1)\nthen \n list.add('R2'); \nend", "package com.rules;global java.util.List list\nrule R3 \nwhen \n    $i1 : Integer(this>1)\n    $i2 : Integer(this>1)\n    $i3 : Integer(this>2)\nthen \n list.add('R3'); \nend"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRemoveChildLeftTupleThatWasFirst() {
        String[] rules = this.getRules3Pattern();
        KieSession kieSession = TestUtil.buildSessionInSteps(this.base, rules[0], rules[1]);
        try {
            ArrayList resultsList = new ArrayList();
            kieSession.setGlobal("list", resultsList);
            TestUtil.insertFacts(kieSession, 3);
            kieSession.fireAllRules();
            Assertions.assertThat(resultsList).containsOnly((Object[])new String[]{"R1", "R2"});
            resultsList.clear();
            TestUtil.removeRules(kieSession, "com.rules", "R1");
            kieSession.fireAllRules();
            Map rulesMap = DroolsTestUtil.rulestoMap((KieBase)kieSession.getKieBase());
            InternalFactHandle fh1 = (InternalFactHandle)kieSession.getFactHandle((Object)3);
            LeftTuple lt = fh1.getFirstLeftTuple().getFirstChild().getFirstChild();
            Assert.assertSame((Object)lt, (Object)fh1.getFirstLeftTuple().getFirstChild().getLastChild());
            Assert.assertNull((Object)lt.getPeer());
            Assert.assertEquals((long)1L, (long)lt.getTupleSink().getAssociatedRuleSize());
            Assert.assertTrue((boolean)lt.getTupleSink().isAssociatedWith((Rule)rulesMap.get("R2")));
        }
        finally {
            kieSession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRemoveChildLeftTupleThatWasLast() {
        String[] rules = this.getRules3Pattern();
        KieSession kieSession = TestUtil.buildSessionInSteps(this.base, rules[0], rules[1]);
        try {
            ArrayList resultsList = new ArrayList();
            kieSession.setGlobal("list", resultsList);
            TestUtil.insertFacts(kieSession, 3);
            kieSession.fireAllRules();
            Assertions.assertThat(resultsList).containsOnly((Object[])new String[]{"R1", "R2"});
            resultsList.clear();
            TestUtil.removeRules(kieSession, "com.rules", "R2");
            kieSession.fireAllRules();
            Map rulesMap = DroolsTestUtil.rulestoMap((KieBase)kieSession.getKieBase());
            InternalFactHandle fh1 = (InternalFactHandle)kieSession.getFactHandle((Object)3);
            LeftTuple lt = fh1.getFirstLeftTuple().getFirstChild().getFirstChild();
            Assert.assertSame((Object)lt, (Object)fh1.getFirstLeftTuple().getFirstChild().getLastChild());
            Assert.assertNull((Object)lt.getPeer());
            Assert.assertEquals((long)1L, (long)lt.getTupleSink().getAssociatedRuleSize());
            Assert.assertTrue((boolean)lt.getTupleSink().isAssociatedWith((Rule)rulesMap.get("R1")));
        }
        finally {
            kieSession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRemoveChildLeftTupleThatWasMiddle() {
        String[] rules = this.getRules3Pattern();
        KieSession kieSession = TestUtil.buildSessionInSteps(this.base, rules);
        try {
            ArrayList resultsList = new ArrayList();
            kieSession.setGlobal("list", resultsList);
            TestUtil.insertFacts(kieSession, 3);
            kieSession.fireAllRules();
            Assertions.assertThat(resultsList).containsOnly((Object[])new String[]{"R1", "R2", "R3"});
            resultsList.clear();
            TestUtil.removeRules(kieSession, "com.rules", "R2");
            kieSession.fireAllRules();
            Map rulesMap = DroolsTestUtil.rulestoMap((KieBase)kieSession.getKieBase());
            InternalFactHandle fh1 = (InternalFactHandle)kieSession.getFactHandle((Object)3);
            LeftTuple lt = fh1.getFirstLeftTuple().getFirstChild();
            Assert.assertSame((Object)lt, (Object)fh1.getFirstLeftTuple().getLastChild());
            Assert.assertEquals((long)1L, (long)lt.getTupleSink().getAssociatedRuleSize());
            Assert.assertTrue((boolean)lt.getTupleSink().isAssociatedWith((Rule)rulesMap.get("R1")));
            LeftTuple peer = lt.getPeer();
            Assert.assertEquals((long)1L, (long)peer.getTupleSink().getAssociatedRuleSize());
            Assert.assertTrue((boolean)peer.getTupleSink().isAssociatedWith((Rule)rulesMap.get("R3")));
        }
        finally {
            kieSession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRemoveChildLeftTupleThatWasFirstWithMultipleData() {
        String[] rules = this.getRules3Pattern();
        KieSession kieSession = TestUtil.buildSessionInSteps(this.base, rules[0], rules[1]);
        try {
            ArrayList resultsList = new ArrayList();
            kieSession.setGlobal("list", resultsList);
            TestUtil.insertFacts(kieSession, 3, 4, 5);
            kieSession.fireAllRules();
            Assertions.assertThat(resultsList).containsOnly((Object[])new String[]{"R1", "R2"});
            resultsList.clear();
            TestUtil.removeRules(kieSession, "com.rules", "R1");
            kieSession.fireAllRules();
            Map rulesMap = DroolsTestUtil.rulestoMap((KieBase)kieSession.getKieBase());
            InternalFactHandle fh1 = (InternalFactHandle)kieSession.getFactHandle((Object)3);
            InternalFactHandle fh3 = (InternalFactHandle)kieSession.getFactHandle((Object)5);
            LeftTuple lt1 = fh1.getFirstLeftTuple();
            LeftTuple lt1_1 = lt1.getFirstChild();
            LeftTuple lt1_2 = (LeftTuple)lt1_1.getHandleNext();
            LeftTuple lt1_3 = (LeftTuple)lt1_2.getHandleNext();
            Assertions.assertThat((Object)lt1_1).isNotNull();
            Assertions.assertThat((Object)lt1_2).isNotNull();
            Assertions.assertThat((Object)lt1_3).isNotNull();
            Assert.assertSame((Object)lt1_3, (Object)lt1.getLastChild());
            Assert.assertSame((Object)lt1_2, (Object)lt1_3.getHandlePrevious());
            Assert.assertSame((Object)lt1_1, (Object)lt1_2.getHandlePrevious());
            Assert.assertEquals((long)1L, (long)lt1_1.getTupleSink().getAssociatedRuleSize());
            Assert.assertTrue((boolean)lt1_1.getTupleSink().isAssociatedWith((Rule)rulesMap.get("R2")));
            Assert.assertNull((Object)lt1_1.getPeer());
            Assert.assertEquals((long)1L, (long)lt1_2.getTupleSink().getAssociatedRuleSize());
            Assert.assertTrue((boolean)lt1_2.getTupleSink().isAssociatedWith((Rule)rulesMap.get("R2")));
            Assert.assertNull((Object)lt1_2.getPeer());
            Assert.assertEquals((long)1L, (long)lt1_3.getTupleSink().getAssociatedRuleSize());
            Assert.assertTrue((boolean)lt1_3.getTupleSink().isAssociatedWith((Rule)rulesMap.get("R2")));
            Assert.assertNull((Object)lt1_3.getPeer());
            RightTuple rt1 = fh3.getFirstRightTuple();
            LeftTuple rt1_1 = rt1.getLastChild();
            Assert.assertSame((Object)lt1_1, (Object)rt1_1);
            LeftTuple rt1_2 = rt1_1.getRightParentPrevious();
            LeftTuple rt1_3 = rt1_2.getRightParentPrevious();
            Assertions.assertThat((Object)rt1_1).isNotNull();
            Assertions.assertThat((Object)rt1_2).isNotNull();
            Assertions.assertThat((Object)rt1_3).isNotNull();
            Assert.assertSame((Object)rt1_2, (Object)rt1_3.getRightParentNext());
            Assert.assertSame((Object)rt1_1, (Object)rt1_2.getRightParentNext());
            Assert.assertEquals((long)1L, (long)rt1_1.getTupleSink().getAssociatedRuleSize());
            Assert.assertTrue((boolean)rt1_1.getTupleSink().isAssociatedWith((Rule)rulesMap.get("R2")));
            Assert.assertNull((Object)rt1_1.getPeer());
            Assert.assertEquals((long)1L, (long)rt1_2.getTupleSink().getAssociatedRuleSize());
            Assert.assertTrue((boolean)rt1_2.getTupleSink().isAssociatedWith((Rule)rulesMap.get("R2")));
            Assert.assertNull((Object)rt1_2.getPeer());
            Assert.assertEquals((long)1L, (long)rt1_3.getTupleSink().getAssociatedRuleSize());
            Assert.assertTrue((boolean)rt1_3.getTupleSink().isAssociatedWith((Rule)rulesMap.get("R2")));
            Assert.assertNull((Object)rt1_3.getPeer());
        }
        finally {
            kieSession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRemoveChildLeftTupleThatWasLastWithMultipleData() {
        String[] rules = this.getRules3Pattern();
        KieSession kieSession = TestUtil.buildSessionInSteps(this.base, rules[0], rules[1]);
        try {
            ArrayList resultsList = new ArrayList();
            kieSession.setGlobal("list", resultsList);
            TestUtil.insertFacts(kieSession, 3, 4, 5);
            kieSession.fireAllRules();
            Assertions.assertThat(resultsList).containsOnly((Object[])new String[]{"R1", "R2"});
            resultsList.clear();
            TestUtil.removeRules(kieSession, "com.rules", "R2");
            kieSession.fireAllRules();
            Map rulesMap = DroolsTestUtil.rulestoMap((KieBase)kieSession.getKieBase());
            InternalFactHandle fh1 = (InternalFactHandle)kieSession.getFactHandle((Object)3);
            InternalFactHandle fh3 = (InternalFactHandle)kieSession.getFactHandle((Object)5);
            LeftTuple lt1 = fh1.getFirstLeftTuple();
            LeftTuple lt1_1 = lt1.getFirstChild();
            LeftTuple lt1_2 = (LeftTuple)lt1_1.getHandleNext();
            LeftTuple lt1_3 = (LeftTuple)lt1_2.getHandleNext();
            Assertions.assertThat((Object)lt1_1).isNotNull();
            Assertions.assertThat((Object)lt1_2).isNotNull();
            Assertions.assertThat((Object)lt1_3).isNotNull();
            Assert.assertSame((Object)lt1_3, (Object)lt1.getLastChild());
            Assert.assertSame((Object)lt1_2, (Object)lt1_3.getHandlePrevious());
            Assert.assertSame((Object)lt1_1, (Object)lt1_2.getHandlePrevious());
            Assert.assertEquals((long)1L, (long)lt1_1.getTupleSink().getAssociatedRuleSize());
            Assert.assertTrue((boolean)lt1_1.getTupleSink().isAssociatedWith((Rule)rulesMap.get("R1")));
            Assert.assertNull((Object)lt1_1.getPeer());
            Assert.assertEquals((long)1L, (long)lt1_2.getTupleSink().getAssociatedRuleSize());
            Assert.assertTrue((boolean)lt1_2.getTupleSink().isAssociatedWith((Rule)rulesMap.get("R1")));
            Assert.assertNull((Object)lt1_2.getPeer());
            Assert.assertEquals((long)1L, (long)lt1_3.getTupleSink().getAssociatedRuleSize());
            Assert.assertTrue((boolean)lt1_3.getTupleSink().isAssociatedWith((Rule)rulesMap.get("R1")));
            Assert.assertNull((Object)lt1_3.getPeer());
            RightTuple rt1 = fh3.getFirstRightTuple();
            LeftTuple rt1_1 = rt1.getLastChild();
            Assert.assertSame((Object)lt1_1, (Object)rt1_1);
            LeftTuple rt1_2 = rt1_1.getRightParentPrevious();
            LeftTuple rt1_3 = rt1_2.getRightParentPrevious();
            Assertions.assertThat((Object)rt1_1).isNotNull();
            Assertions.assertThat((Object)rt1_2).isNotNull();
            Assertions.assertThat((Object)rt1_3).isNotNull();
            Assert.assertSame((Object)rt1_2, (Object)rt1_3.getRightParentNext());
            Assert.assertSame((Object)rt1_1, (Object)rt1_2.getRightParentNext());
            Assert.assertEquals((long)1L, (long)rt1_1.getTupleSink().getAssociatedRuleSize());
            Assert.assertTrue((boolean)rt1_1.getTupleSink().isAssociatedWith((Rule)rulesMap.get("R1")));
            Assert.assertNull((Object)rt1_1.getPeer());
            Assert.assertEquals((long)1L, (long)rt1_2.getTupleSink().getAssociatedRuleSize());
            Assert.assertTrue((boolean)rt1_2.getTupleSink().isAssociatedWith((Rule)rulesMap.get("R1")));
            Assert.assertNull((Object)rt1_2.getPeer());
            Assert.assertEquals((long)1L, (long)rt1_3.getTupleSink().getAssociatedRuleSize());
            Assert.assertTrue((boolean)rt1_3.getTupleSink().isAssociatedWith((Rule)rulesMap.get("R1")));
            Assert.assertNull((Object)rt1_3.getPeer());
        }
        finally {
            kieSession.dispose();
        }
    }

    private void testRemoveWithSplitStartBasicTestSet(String rule1, String rule2, String rule1Name, String rule2Name) {
        HashMap<String, Object> additionalGlobals = new HashMap<String, Object>();
        additionalGlobals.put("globalInt", new AtomicInteger(0));
        AddRemoveTestCases.runAllTestCases(this.base, rule1, rule2, rule1Name, rule2Name, additionalGlobals, 1, 2, "1");
        AddRemoveTestCases.runAllTestCases(this.base, rule2, rule1, rule2Name, rule1Name, additionalGlobals, 1, 2, "1");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMergeRTN() {
        String rule1 = "package com.rules;global java.util.List list\nrule R1 \nwhen\n    Integer()\n    Integer()\n    Integer()\nthen\n list.add('R1'); \nend\n";
        String rule2 = "package com.rules;global java.util.List list\nrule R2 \nwhen \n    Integer()\n    exists( Integer() and Integer() )\n    Integer()\nthen \n list.add('R2'); \nend";
        KieSession kieSession = TestUtil.buildSessionInSteps(this.base, "package com.rules;global java.util.List list\nrule R1 \nwhen\n    Integer()\n    Integer()\n    Integer()\nthen\n list.add('R1'); \nend\n", "package com.rules;global java.util.List list\nrule R2 \nwhen \n    Integer()\n    exists( Integer() and Integer() )\n    Integer()\nthen \n list.add('R2'); \nend");
        try {
            ArrayList resultsList = new ArrayList();
            kieSession.setGlobal("list", resultsList);
            TestUtil.insertFacts(kieSession, 1, 2, 3);
            TestUtil.removeRules(kieSession, "com.rules", "R2");
            kieSession.fireAllRules();
            Assertions.assertThat(resultsList).containsOnly((Object[])new String[]{"R1"});
            resultsList.clear();
            TestUtil.removeRules(kieSession, "com.rules", "R1");
            kieSession.fireAllRules();
            Assertions.assertThat(resultsList).isEmpty();
        }
        finally {
            kieSession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSubSubNetwork() {
        String rule1 = "package com.rules;global java.util.List list\nrule R1 \nwhen\n    Integer()\n    Integer()\n    Integer()\nthen\n list.add('R1'); \nend\n";
        String rule2 = "package com.rules;global java.util.List list\nrule R2 \nwhen \n    Integer()\n    exists( Integer() and Integer() )\n    exists(Integer() and exists(Integer() and Integer()))\nthen \n list.add('R2'); \nend";
        KieSession kieSession = TestUtil.buildSessionInSteps(this.base, "package com.rules;global java.util.List list\nrule R1 \nwhen\n    Integer()\n    Integer()\n    Integer()\nthen\n list.add('R1'); \nend\n", "package com.rules;global java.util.List list\nrule R2 \nwhen \n    Integer()\n    exists( Integer() and Integer() )\n    exists(Integer() and exists(Integer() and Integer()))\nthen \n list.add('R2'); \nend");
        try {
            ArrayList resultsList = new ArrayList();
            kieSession.setGlobal("list", resultsList);
            TestUtil.insertFacts(kieSession, 1);
            TestUtil.removeRules(kieSession, "com.rules", "R2");
            kieSession.fireAllRules();
            Assertions.assertThat(resultsList).containsOnly((Object[])new String[]{"R1"});
            resultsList.clear();
            TestUtil.removeRules(kieSession, "com.rules", "R1");
            kieSession.fireAllRules();
            Assertions.assertThat(resultsList).isEmpty();
        }
        finally {
            kieSession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSubSubNetwork2() {
        String rule1 = "package com.rules;global java.util.List list\nrule R1 \nwhen\n    Integer()\n    Integer()\nthen\n list.add('R1'); \nend\n";
        String rule2 = "package com.rules;global java.util.List list\nrule R2 \nwhen \n    Integer()\n    exists( Integer() and Integer() )\n    exists(Integer() and exists(Integer() and Integer()))\nthen \n list.add('R2'); \nend";
        KieSession kieSession = TestUtil.buildSessionInSteps(this.base, "package com.rules;global java.util.List list\nrule R1 \nwhen\n    Integer()\n    Integer()\nthen\n list.add('R1'); \nend\n", "package com.rules;global java.util.List list\nrule R2 \nwhen \n    Integer()\n    exists( Integer() and Integer() )\n    exists(Integer() and exists(Integer() and Integer()))\nthen \n list.add('R2'); \nend");
        try {
            ArrayList resultsList = new ArrayList();
            kieSession.setGlobal("list", resultsList);
            TestUtil.insertFacts(kieSession, 1);
            TestUtil.removeRules(kieSession, "com.rules", "R1", "R2");
            TestUtil.addRules(kieSession, "package com.rules;global java.util.List list\nrule R1 \nwhen\n    Integer()\n    Integer()\nthen\n list.add('R1'); \nend\n");
            kieSession.fireAllRules();
            Assertions.assertThat(resultsList).containsOnly((Object[])new String[]{"R1"});
        }
        finally {
            kieSession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSubSubNetwork3() {
        String rule1 = "package com.rules;global java.util.List list\nrule R1 \nwhen\n  exists(Integer() and Integer()) \n  exists(Integer() and Integer()) \n  Integer() \n\nthen\n list.add('R1'); \nend\n";
        String rule2 = "package com.rules;global java.util.List list\nrule R2 \nwhen \n  exists(Integer() and Integer()) \n  Integer() \n  exists(Integer() and exists(Integer() and Integer())) \nthen \n list.add('R2'); \nend";
        KieSession kieSession = TestUtil.buildSessionInSteps(this.base, "package com.rules;global java.util.List list\nrule R1 \nwhen\n  exists(Integer() and Integer()) \n  exists(Integer() and Integer()) \n  Integer() \n\nthen\n list.add('R1'); \nend\n", "package com.rules;global java.util.List list\nrule R2 \nwhen \n  exists(Integer() and Integer()) \n  Integer() \n  exists(Integer() and exists(Integer() and Integer())) \nthen \n list.add('R2'); \nend");
        try {
            ArrayList resultsList = new ArrayList();
            kieSession.setGlobal("list", resultsList);
            TestUtil.insertFacts(kieSession, 1);
            kieSession.fireAllRules();
            Assertions.assertThat(resultsList).containsOnly((Object[])new String[]{"R1", "R2"});
            resultsList.clear();
            TestUtil.removeRules(kieSession, "com.rules", "R1", "R2");
            kieSession.fireAllRules();
            Assertions.assertThat(resultsList).isEmpty();
        }
        finally {
            kieSession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSubSubNetwork4() {
        String rule1 = "package com.rules;global java.util.List list\nrule R1 \nwhen\n  exists(Integer() and Integer()) \n  Integer() \n  Integer() \nthen\n list.add('R1'); \nend\n";
        String rule2 = "package com.rules;global java.util.List list\nrule R2 \nwhen \n  exists(Integer() and Integer()) \n  Integer() \n  exists(Integer() and exists(Integer() and Integer())) \nthen \n list.add('R2'); \nend";
        KieSession kieSession = TestUtil.buildSessionInSteps(this.base, "package com.rules;global java.util.List list\nrule R1 \nwhen\n  exists(Integer() and Integer()) \n  Integer() \n  Integer() \nthen\n list.add('R1'); \nend\n", "package com.rules;global java.util.List list\nrule R2 \nwhen \n  exists(Integer() and Integer()) \n  Integer() \n  exists(Integer() and exists(Integer() and Integer())) \nthen \n list.add('R2'); \nend");
        try {
            ArrayList resultsList = new ArrayList();
            kieSession.setGlobal("list", resultsList);
            TestUtil.insertFacts(kieSession, 1);
            TestUtil.removeRules(kieSession, "com.rules", "R1");
            kieSession.fireAllRules();
            Assertions.assertThat(resultsList).containsOnly((Object[])new String[]{"R2"});
        }
        finally {
            kieSession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSubNetworkWithNot() {
        String rule1 = "package com.rules;global java.util.List list\nrule R1 \nwhen\n  exists(Integer() and Integer()) \n  not(Double() and Double()) \n  Integer() \nthen\n list.add('R1'); \nend\n";
        String rule2 = "package com.rules;global java.util.List list\nrule R2 \nwhen \n  exists(Integer() and Integer()) \n  not(Double() and Double()) \nthen \n list.add('R2'); \nend";
        KieSession kieSession = TestUtil.buildSessionInSteps(this.base, "package com.rules;global java.util.List list\nrule R1 \nwhen\n  exists(Integer() and Integer()) \n  not(Double() and Double()) \n  Integer() \nthen\n list.add('R1'); \nend\n", "package com.rules;global java.util.List list\nrule R2 \nwhen \n  exists(Integer() and Integer()) \n  not(Double() and Double()) \nthen \n list.add('R2'); \nend");
        try {
            ArrayList resultsList = new ArrayList();
            kieSession.setGlobal("list", resultsList);
            TestUtil.insertFacts(kieSession, 1);
            TestUtil.removeRules(kieSession, "com.rules", "R2");
            kieSession.fireAllRules();
            Assertions.assertThat(resultsList).containsOnly((Object[])new String[]{"R1"});
        }
        finally {
            kieSession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSubNetworkWithNot2() {
        String rule1 = "package com.rules;global java.util.List list\nrule R1 \nwhen\n  exists(Integer() and Integer()) \n  not(Double() and Double()) \n  Integer() \nthen\n list.add('R1'); \nend\n";
        String rule2 = "package com.rules;global java.util.List list\nrule R2 \nwhen \n  exists(Integer() and Integer()) \n  not(Double() and Double()) \n  exists(Integer() and Integer()) \nthen \n list.add('R2'); \nend";
        KieSession kieSession = TestUtil.buildSessionInSteps(this.base, "package com.rules;global java.util.List list\nrule R1 \nwhen\n  exists(Integer() and Integer()) \n  not(Double() and Double()) \n  Integer() \nthen\n list.add('R1'); \nend\n", "package com.rules;global java.util.List list\nrule R2 \nwhen \n  exists(Integer() and Integer()) \n  not(Double() and Double()) \n  exists(Integer() and Integer()) \nthen \n list.add('R2'); \nend");
        try {
            ArrayList resultsList = new ArrayList();
            kieSession.setGlobal("list", resultsList);
            TestUtil.insertFacts(kieSession, 1);
            TestUtil.removeRules(kieSession, "com.rules", "R2");
            kieSession.fireAllRules();
            Assertions.assertThat(resultsList).containsOnly((Object[])new String[]{"R1"});
        }
        finally {
            kieSession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSubNetworkWithNot3() {
        String rule1 = "package com.rules;global java.util.List list\nrule R1 \nwhen\n  exists(Integer()) \n  not(Double() and Double()) \n  Integer() \nthen\n list.add('R1'); \nend\n";
        String rule2 = "package com.rules;global java.util.List list\nrule R2 \nwhen \n  exists(Integer()) \n  not(Double() and Double()) \nthen \n list.add('R2'); \nend";
        KieSession kieSession = TestUtil.buildSessionInSteps(this.base, "package com.rules;global java.util.List list\nrule R1 \nwhen\n  exists(Integer()) \n  not(Double() and Double()) \n  Integer() \nthen\n list.add('R1'); \nend\n", "package com.rules;global java.util.List list\nrule R2 \nwhen \n  exists(Integer()) \n  not(Double() and Double()) \nthen \n list.add('R2'); \nend");
        try {
            ArrayList resultsList = new ArrayList();
            kieSession.setGlobal("list", resultsList);
            TestUtil.insertFacts(kieSession, 1);
            kieSession.fireAllRules();
            Assertions.assertThat(resultsList).containsOnly((Object[])new String[]{"R1", "R2"});
        }
        finally {
            kieSession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSubNetworkWithNot4() {
        String rule1 = "package com.rules;global java.util.List list\nrule R1 \nwhen\n  exists(Integer() and Integer()) \n  exists(Integer() and exists(Integer() and Integer())) \n  Integer() \n  not(Double() and Double()) \nthen\n list.add('R1'); \nend\n";
        String rule2 = "package com.rules;global java.util.List list\nrule R2 \nwhen \n  exists(Integer() and Integer()) \n  Integer() \n  not(Double() and Double()) \n  exists(Integer() and Integer()) \nthen \n list.add('R2'); \nend";
        KieSession kieSession = TestUtil.buildSessionInSteps(this.base, "package com.rules;global java.util.List list\nrule R1 \nwhen\n  exists(Integer() and Integer()) \n  exists(Integer() and exists(Integer() and Integer())) \n  Integer() \n  not(Double() and Double()) \nthen\n list.add('R1'); \nend\n", "package com.rules;global java.util.List list\nrule R2 \nwhen \n  exists(Integer() and Integer()) \n  Integer() \n  not(Double() and Double()) \n  exists(Integer() and Integer()) \nthen \n list.add('R2'); \nend");
        try {
            ArrayList resultsList = new ArrayList();
            kieSession.setGlobal("list", resultsList);
            TestUtil.insertFacts(kieSession, 1);
            TestUtil.removeRules(kieSession, "com.rules", "R1");
            kieSession.fireAllRules();
            Assertions.assertThat(resultsList).containsOnly((Object[])new String[]{"R2"});
        }
        finally {
            kieSession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInsertFireRemoveWith2Nots() {
        String rule1 = " package com.rules;\n global java.util.List list\n rule R1 \n when \n   Integer() \n   Integer() \n then\n   list.add('R1'); \n end";
        String rule2 = " package com.rules;\n global java.util.List list\n rule R2 \n when \n   Integer() \n   Integer() \n   not(not(Integer() and Integer())) \n then\n   list.add('R2'); \n end";
        KieSession kieSession = TestUtil.buildSessionInSteps(this.base, " package com.rules;\n global java.util.List list\n rule R2 \n when \n   Integer() \n   Integer() \n   not(not(Integer() and Integer())) \n then\n   list.add('R2'); \n end", " package com.rules;\n global java.util.List list\n rule R1 \n when \n   Integer() \n   Integer() \n then\n   list.add('R1'); \n end");
        try {
            ArrayList resultsList = new ArrayList();
            kieSession.setGlobal("list", resultsList);
            TestUtil.insertFacts(kieSession, 1);
            TestUtil.removeRules(kieSession, "com.rules", "R2");
            TestUtil.removeRules(kieSession, "com.rules", "R1");
            kieSession.fireAllRules();
            Assertions.assertThat(resultsList).isEmpty();
        }
        finally {
            kieSession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSubSubNetwork5() {
        String rule1 = "package com.rules;global java.util.List list\nrule R1 \nwhen\n  Integer() \n  Integer() \n  exists(Integer() and Integer()) \nthen\n list.add('R1'); \nend\n";
        String rule2 = "package com.rules;global java.util.List list\nrule R2 \nwhen \n  Integer() \n  exists(Integer() and Integer()) \nthen \n list.add('R2'); \nend";
        KieSession kieSession = TestUtil.buildSessionInSteps(this.base, "package com.rules;global java.util.List list\nrule R1 \nwhen\n  Integer() \n  Integer() \n  exists(Integer() and Integer()) \nthen\n list.add('R1'); \nend\n", "package com.rules;global java.util.List list\nrule R2 \nwhen \n  Integer() \n  exists(Integer() and Integer()) \nthen \n list.add('R2'); \nend");
        try {
            ArrayList resultsList = new ArrayList();
            kieSession.setGlobal("list", resultsList);
            TestUtil.insertFacts(kieSession, 1);
            TestUtil.removeRules(kieSession, "com.rules", "R1");
            kieSession.fireAllRules();
            Assertions.assertThat(resultsList).containsOnly((Object[])new String[]{"R2"});
        }
        finally {
            kieSession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInsertRemoveFireWith2Nots() {
        String rule1 = " package com.rules;\n global java.util.List list\n rule R1 \n when \n   exists(Integer() and Integer()) \n   Integer() \n   not(exists(Integer() and Integer())) \n then\n   list.add('R1'); \n end";
        String rule2 = " package com.rules;\n global java.util.List list\n rule R2 \n when \n   exists(Integer() and Integer()) \n   not(exists(Integer() and Integer())) \n then\n   list.add('R2'); \n end";
        KieSession kieSession = TestUtil.buildSessionInSteps(this.base, " package com.rules;\n global java.util.List list\n rule R1 \n when \n   exists(Integer() and Integer()) \n   Integer() \n   not(exists(Integer() and Integer())) \n then\n   list.add('R1'); \n end", " package com.rules;\n global java.util.List list\n rule R2 \n when \n   exists(Integer() and Integer()) \n   not(exists(Integer() and Integer())) \n then\n   list.add('R2'); \n end");
        try {
            ArrayList resultsList = new ArrayList();
            kieSession.setGlobal("list", resultsList);
            TestUtil.insertFacts(kieSession, 1);
            TestUtil.removeRules(kieSession, "com.rules", "R2");
            kieSession.fireAllRules();
            Assertions.assertThat(resultsList).isEmpty();
        }
        finally {
            kieSession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSharedRian() {
        String rule1 = " package com.rules;\n global java.util.List list\n rule R1 \n when \n   Integer() \n   not(Integer() and Integer()) \n then\n   list.add('R1'); \n end";
        String rule2 = " package com.rules;\n global java.util.List list\n rule R2 \n when \n   Integer() \n   exists(Integer() and Integer()) \n then\n   list.add('R2'); \n end";
        KieSession kieSession = TestUtil.buildSessionInSteps(this.base, " package com.rules;\n global java.util.List list\n rule R1 \n when \n   Integer() \n   not(Integer() and Integer()) \n then\n   list.add('R1'); \n end");
        try {
            ArrayList resultsList = new ArrayList();
            kieSession.setGlobal("list", resultsList);
            TestUtil.insertFacts(kieSession, 1);
            TestUtil.addRules(kieSession, " package com.rules;\n global java.util.List list\n rule R2 \n when \n   Integer() \n   exists(Integer() and Integer()) \n then\n   list.add('R2'); \n end");
            kieSession.fireAllRules();
            Assertions.assertThat(resultsList).containsOnly((Object[])new String[]{"R2"});
        }
        finally {
            kieSession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSharedRianWithFire() {
        String rule1 = " package com.rules;\n global java.util.List list\n rule R1 \n when \n   Integer() \n   not(Integer() and Integer()) \n then\n   list.add('R1'); \n end";
        String rule2 = " package com.rules;\n global java.util.List list\n rule R2 \n when \n   Integer() \n   exists(Integer() and Integer()) \n then\n   list.add('R2'); \n end";
        KieSession kieSession = TestUtil.buildSessionInSteps(this.base, " package com.rules;\n global java.util.List list\n rule R1 \n when \n   Integer() \n   not(Integer() and Integer()) \n then\n   list.add('R1'); \n end");
        try {
            ArrayList resultsList = new ArrayList();
            kieSession.setGlobal("list", resultsList);
            TestUtil.insertFacts(kieSession, 1);
            kieSession.fireAllRules();
            TestUtil.addRules(kieSession, " package com.rules;\n global java.util.List list\n rule R2 \n when \n   Integer() \n   exists(Integer() and Integer()) \n then\n   list.add('R2'); \n end");
            kieSession.fireAllRules();
            Assertions.assertThat(resultsList).containsOnly((Object[])new String[]{"R2"});
        }
        finally {
            kieSession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSharedRian2() {
        String rule1 = " package com.rules;\n global java.util.List list\n rule R1 \n when \n   Integer() \n   Integer() \n   not(not(Integer() and Integer())) \n then\n   list.add('R1'); \n end";
        String rule2 = " package com.rules;\n global java.util.List list\n rule R2 \n when \n   Integer() \n   exists(Integer() and exists(Integer() and Integer())) \n then\n   list.add('R2'); \n end";
        KieSession kieSession = TestUtil.buildSessionInSteps(this.base, " package com.rules;\n global java.util.List list\n rule R1 \n when \n   Integer() \n   Integer() \n   not(not(Integer() and Integer())) \n then\n   list.add('R1'); \n end");
        try {
            ArrayList resultsList = new ArrayList();
            kieSession.setGlobal("list", resultsList);
            TestUtil.insertFacts(kieSession, 1);
            kieSession.fireAllRules();
            Assertions.assertThat(resultsList).containsOnly((Object[])new String[]{"R1"});
            resultsList.clear();
            TestUtil.addRules(kieSession, " package com.rules;\n global java.util.List list\n rule R2 \n when \n   Integer() \n   exists(Integer() and exists(Integer() and Integer())) \n then\n   list.add('R2'); \n end");
            kieSession.fireAllRules();
            Assertions.assertThat(resultsList).containsOnly((Object[])new String[]{"R2"});
        }
        finally {
            kieSession.dispose();
        }
    }

    @Test
    public void testRemoveRuleWithSharedRia() {
        String rule1Name = "rule1";
        String rule2Name = "rule2";
        String rule1 = "rule rule1 \nwhen \n   Integer() \n   not(Integer() and Integer()) \nthen \nSystem.out.println('test rule 1'); \nend";
        String rule2 = "rule rule2 \nwhen \n   Integer() \n   exists(Integer() and Integer()) \nthen \nSystem.out.println('test  rule 2'); \nend";
        KieSession session = this.base.newKieSession();
        this.addRuleToEngine("rule rule1 \nwhen \n   Integer() \n   not(Integer() and Integer()) \nthen \nSystem.out.println('test rule 1'); \nend");
        InternalFactHandle fh = (InternalFactHandle)session.insert((Object)1);
        session.fireAllRules();
        this.addRuleToEngine("rule rule2 \nwhen \n   Integer() \n   exists(Integer() and Integer()) \nthen \nSystem.out.println('test  rule 2'); \nend");
        SubnetworkTuple tuple = (SubnetworkTuple)fh.getFirstLeftTuple().getFirstChild().getFirstChild();
        Assertions.assertThat((Object)tuple.getPeer()).isNotNull();
        this.deleteRule("rule2");
        Assert.assertNull((Object)tuple.getPeer());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAddRemoveFacts() {
        String rule1 = " package com.rules;\n global java.util.List list\n rule R1 \n when \n   Integer() \n   not(not(Integer() and Integer())) \n then\n   list.add('R1'); \n end";
        String rule2 = " package com.rules;\n global java.util.List list\n rule R2 \n when \n   Integer() \n   exists(Integer() and Integer()) \n then\n   list.add('R2'); \n end";
        KieSession kieSession = TestUtil.buildSessionInSteps(this.base, " package com.rules;\n global java.util.List list\n rule R1 \n when \n   Integer() \n   not(not(Integer() and Integer())) \n then\n   list.add('R1'); \n end", " package com.rules;\n global java.util.List list\n rule R2 \n when \n   Integer() \n   exists(Integer() and Integer()) \n then\n   list.add('R2'); \n end");
        try {
            ArrayList resultsList = new ArrayList();
            kieSession.setGlobal("list", resultsList);
            List<FactHandle> sessionFacts = TestUtil.insertFacts(kieSession, 1);
            TestUtil.removeRules(kieSession, "com.rules", "R2", "R1");
            kieSession.fireAllRules();
            Assertions.assertThat(resultsList).isEmpty();
            TestUtil.removeFacts(kieSession, sessionFacts);
            kieSession.fireAllRules();
            Assertions.assertThat(resultsList).isEmpty();
        }
        finally {
            kieSession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReaddRulesSharedRianDoubleNots() {
        String rule1 = " package com.rules;\n global java.util.List list\n rule R1 \n when \n   exists(Integer() and Integer()) \n then\n   list.add('R1'); \n end";
        String rule2 = " package com.rules;\n global java.util.List list\n rule R2 \n when \n   not(not(exists(Integer() and Integer()))) \n then\n   list.add('R2'); \n end";
        KieSession kieSession = TestUtil.buildSessionInSteps(this.base, " package com.rules;\n global java.util.List list\n rule R1 \n when \n   exists(Integer() and Integer()) \n then\n   list.add('R1'); \n end", " package com.rules;\n global java.util.List list\n rule R2 \n when \n   not(not(exists(Integer() and Integer()))) \n then\n   list.add('R2'); \n end");
        try {
            ArrayList resultsList = new ArrayList();
            kieSession.setGlobal("list", resultsList);
            TestUtil.insertFacts(kieSession, 1);
            kieSession.fireAllRules();
            Assertions.assertThat(resultsList).containsOnly((Object[])new String[]{"R1", "R2"});
            resultsList.clear();
            TestUtil.removeRules(kieSession, "com.rules", "R2", "R1");
            kieSession.fireAllRules();
            Assertions.assertThat(resultsList).isEmpty();
            TestUtil.addRules(kieSession, " package com.rules;\n global java.util.List list\n rule R1 \n when \n   exists(Integer() and Integer()) \n then\n   list.add('R1'); \n end", " package com.rules;\n global java.util.List list\n rule R2 \n when \n   not(not(exists(Integer() and Integer()))) \n then\n   list.add('R2'); \n end");
            kieSession.fireAllRules();
            Assertions.assertThat(resultsList).containsOnly((Object[])new String[]{"R1", "R2"});
        }
        finally {
            kieSession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOr() {
        String rule1 = " package com.rules;\n global java.util.List list\n rule R1 \n when \n   $k: Integer()\n   ( Integer(this != 1) or Integer(this == 1) )\n then\n   list.add('R1'); \n end";
        String rule2 = " package com.rules;\n global java.util.List list\n rule R2 \n when \n   Integer()\n then\n   list.add('R2'); \n end";
        KieSession kieSession = TestUtil.buildSessionInSteps(this.base, " package com.rules;\n global java.util.List list\n rule R2 \n when \n   Integer()\n then\n   list.add('R2'); \n end");
        try {
            ArrayList resultsList = new ArrayList();
            kieSession.setGlobal("list", resultsList);
            TestUtil.insertFacts(kieSession, 1);
            kieSession.fireAllRules();
            Assertions.assertThat(resultsList).containsOnly((Object[])new String[]{"R2"});
            resultsList.clear();
            TestUtil.removeRules(kieSession, "com.rules", "R2");
            kieSession.fireAllRules();
            Assertions.assertThat(resultsList).isEmpty();
            TestUtil.addRules(kieSession, " package com.rules;\n global java.util.List list\n rule R1 \n when \n   $k: Integer()\n   ( Integer(this != 1) or Integer(this == 1) )\n then\n   list.add('R1'); \n end", " package com.rules;\n global java.util.List list\n rule R2 \n when \n   Integer()\n then\n   list.add('R2'); \n end");
            kieSession.fireAllRules();
            Assertions.assertThat(resultsList).containsOnly((Object[])new String[]{"R1", "R2"});
        }
        finally {
            kieSession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOr2() {
        String rule1 = " package com.rules;\n global java.util.List list\n rule R1 \n when \n   Integer()\n then\n   list.add('R1'); \n end";
        String rule2 = " package com.rules;\n global java.util.List list\n rule R2 \n when \n   $k: Integer()\n   ( Integer(this != 1) or Integer(this == 1) )\n then\n   list.add('R2'); \n end";
        KieSession kieSession = TestUtil.buildSessionInSteps(this.base, " package com.rules;\n global java.util.List list\n rule R1 \n when \n   Integer()\n then\n   list.add('R1'); \n end", " package com.rules;\n global java.util.List list\n rule R2 \n when \n   $k: Integer()\n   ( Integer(this != 1) or Integer(this == 1) )\n then\n   list.add('R2'); \n end");
        try {
            ArrayList resultsList = new ArrayList();
            kieSession.setGlobal("list", resultsList);
            TestUtil.insertFacts(kieSession, 1);
            kieSession.fireAllRules();
            Assertions.assertThat(resultsList).containsOnly((Object[])new String[]{"R1", "R2"});
            resultsList.clear();
            TestUtil.removeRules(kieSession, "com.rules", "R2");
            kieSession.fireAllRules();
            Assertions.assertThat(resultsList).isEmpty();
            TestUtil.removeRules(kieSession, "com.rules", "R1");
            kieSession.fireAllRules();
            Assertions.assertThat(resultsList).isEmpty();
            TestUtil.addRules(kieSession, " package com.rules;\n global java.util.List list\n rule R1 \n when \n   Integer()\n then\n   list.add('R1'); \n end");
            kieSession.fireAllRules();
            Assertions.assertThat(resultsList).containsOnly((Object[])new String[]{"R1"});
            resultsList.clear();
            TestUtil.removeRules(kieSession, "com.rules", "R1");
            kieSession.fireAllRules();
            Assertions.assertThat(resultsList).isEmpty();
        }
        finally {
            kieSession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEvals() {
        String rule1 = " package com.rules;\n global java.util.List list\n rule R1 \n when \n   Integer()\n then\n   list.add('R1'); \n end";
        String rule2 = " package com.rules;\n global java.util.List list\n rule R2 \n when \n  $j: Integer() \n  eval($j == 1) \n  (eval(true) or eval($j == 1) ) \n then\n   list.add('R2'); \n end";
        KieSession kieSession = TestUtil.buildSessionInSteps(this.base, " package com.rules;\n global java.util.List list\n rule R1 \n when \n   Integer()\n then\n   list.add('R1'); \n end", " package com.rules;\n global java.util.List list\n rule R2 \n when \n  $j: Integer() \n  eval($j == 1) \n  (eval(true) or eval($j == 1) ) \n then\n   list.add('R2'); \n end");
        try {
            ArrayList resultsList = new ArrayList();
            kieSession.setGlobal("list", resultsList);
            TestUtil.insertFacts(kieSession, 1);
            TestUtil.removeRules(kieSession, "com.rules", "R2");
            kieSession.fireAllRules();
            Assertions.assertThat(resultsList).containsOnly((Object[])new String[]{"R1"});
            resultsList.clear();
            TestUtil.removeRules(kieSession, "com.rules", "R1");
            kieSession.fireAllRules();
            Assertions.assertThat(resultsList).isEmpty();
        }
        finally {
            kieSession.dispose();
        }
    }

    @Test
    public void testPathMemoryInitialization() {
        String rule1 = "package com.rules;global java.util.List list\nrule R1 \n when \n  exists(Integer() and Integer()) \n Integer() \n Integer() \n then\n list.add('R1'); \nend\n";
        String rule2 = "package com.rules;global java.util.List list\nrule R2 \n when \n  exists(Integer() and exists(Integer() and Integer())) \n Integer() \n exists(Integer() and Integer()) \n then\n list.add('R2'); \nend";
        ArrayList globalList = new ArrayList();
        KieSession kieSession = TestUtil.buildSessionInSteps(this.base, "package com.rules;global java.util.List list\nrule R1 \n when \n  exists(Integer() and Integer()) \n Integer() \n Integer() \n then\n list.add('R1'); \nend\n", "package com.rules;global java.util.List list\nrule R2 \n when \n  exists(Integer() and exists(Integer() and Integer())) \n Integer() \n exists(Integer() and Integer()) \n then\n list.add('R2'); \nend");
        kieSession.setGlobal("list", globalList);
        kieSession.insert((Object)1);
        kieSession.insert((Object)2);
        kieSession.insert((Object)3);
        kieSession.insert((Object)"1");
        HashMap<Object, String> mapFact = new HashMap<Object, String>(1);
        mapFact.put(new Object(), "1");
        kieSession.insert(mapFact);
        kieSession.getKieBase().removeRule("com.rules", "R2");
        kieSession.fireAllRules();
        Assertions.assertThat(globalList).contains((Object[])new String[]{"R1"});
        globalList.clear();
        kieSession.getKieBase().removeRule("com.rules", "R1");
        kieSession.fireAllRules();
        Assertions.assertThat(globalList).isEmpty();
    }

    @Test
    public void testBuildKieBaseIncrementally() {
        String rule1 = "package com.rules;global java.util.List list\nrule R1 \n when \n  exists(Integer() and Integer()) \n Integer() \n Integer() \n then\n list.add('R1'); \nend\n";
        String rule2 = "package com.rules;global java.util.List list\nrule R2 \n when \n  exists(Integer() and exists(Integer() and Integer())) \n Integer() \n exists(Integer() and Integer()) \n then\n list.add('R2'); \nend";
        ArrayList globalList = new ArrayList();
        KieSession kieSession = TestUtil.buildSessionInSteps(this.base, "package com.rules;global java.util.List list\nrule R1 \n when \n  exists(Integer() and Integer()) \n Integer() \n Integer() \n then\n list.add('R1'); \nend\n", "package com.rules;global java.util.List list\nrule R2 \n when \n  exists(Integer() and exists(Integer() and Integer())) \n Integer() \n exists(Integer() and Integer()) \n then\n list.add('R2'); \nend");
        kieSession.setGlobal("list", globalList);
        kieSession.insert((Object)1);
        kieSession.insert((Object)2);
        kieSession.insert((Object)3);
        kieSession.insert((Object)"1");
        HashMap<Object, String> mapFact = new HashMap<Object, String>(1);
        mapFact.put(new Object(), "1");
        kieSession.insert(mapFact);
        kieSession.fireAllRules();
        Assertions.assertThat(globalList).contains((Object[])new String[]{"R1", "R2"});
    }

    @Test
    public void testBuildKieBaseIncrementally2() {
        String rule1 = "package com.rules;global java.util.List list\nrule R1 \n when \n  exists(Integer() and Integer()) \n Integer() \n Integer() \n then\n list.add('R1'); \nend\n";
        String rule2 = "package com.rules;global java.util.List list\nrule R2 \n when \n  exists(Integer() and exists(Integer() and Integer())) \n Integer() \n exists(Integer() and Integer()) \n then\n list.add('R2'); \nend";
        ArrayList globalList = new ArrayList();
        KieSession kieSession = TestUtil.buildSessionInSteps(this.base, "package com.rules;global java.util.List list\nrule R1 \n when \n  exists(Integer() and Integer()) \n Integer() \n Integer() \n then\n list.add('R1'); \nend\n", "package com.rules;global java.util.List list\nrule R2 \n when \n  exists(Integer() and exists(Integer() and Integer())) \n Integer() \n exists(Integer() and Integer()) \n then\n list.add('R2'); \nend");
        kieSession.setGlobal("list", globalList);
        kieSession.fireAllRules();
        Assertions.assertThat(globalList).isEmpty();
        kieSession.insert((Object)1);
        kieSession.insert((Object)2);
        kieSession.insert((Object)3);
        kieSession.insert((Object)"1");
        HashMap<Object, String> mapFact = new HashMap<Object, String>(1);
        mapFact.put(new Object(), "1");
        kieSession.insert(mapFact);
        kieSession.fireAllRules();
        Assertions.assertThat(globalList).contains((Object[])new String[]{"R1", "R2"});
    }

    @Test
    public void testBuildKieBaseIncrementally3() {
        String rule1 = "package com.rules;global java.util.List list\nrule R1 \n when \n  exists(Integer()) \n Integer() \n then\n list.add('R1'); \nend\n";
        String rule2 = "package com.rules;global java.util.List list\nrule R2 \n when \n  exists(Integer()) \n not(not(Integer() and Integer())) \n then\n list.add('R2'); \nend";
        ArrayList globalList = new ArrayList();
        KieSession kieSession = TestUtil.buildSessionInSteps(this.base, "package com.rules;global java.util.List list\nrule R2 \n when \n  exists(Integer()) \n not(not(Integer() and Integer())) \n then\n list.add('R2'); \nend", "package com.rules;global java.util.List list\nrule R1 \n when \n  exists(Integer()) \n Integer() \n then\n list.add('R1'); \nend\n");
        kieSession.setGlobal("list", globalList);
        Assertions.assertThat(globalList).isEmpty();
        kieSession.insert((Object)1);
        kieSession.insert((Object)"1");
        kieSession.getKieBase().removeRule("com.rules", "R1");
        kieSession.fireAllRules();
        Assertions.assertThat(globalList).contains((Object[])new String[]{"R2"});
        globalList.clear();
        kieSession.getKieBase().removeRule("com.rules", "R2");
        kieSession.fireAllRules();
        Assertions.assertThat(globalList).isEmpty();
    }
}

