/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests.incrementalcompilation;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.drools.core.base.ClassObjectType;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.time.impl.PseudoClockScheduler;
import org.drools.kiesession.entrypoints.NamedEntryPoint;
import org.drools.testcoverage.common.model.ChildEventA;
import org.drools.testcoverage.common.model.ChildEventB;
import org.drools.testcoverage.common.model.Message;
import org.drools.testcoverage.common.model.MyFact;
import org.drools.testcoverage.common.model.ParentEvent;
import org.drools.testcoverage.common.model.Person;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieSessionTestConfiguration;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieServices;
import org.kie.api.builder.Message;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.Results;
import org.kie.api.definition.type.Role;
import org.kie.api.marshalling.KieMarshallers;
import org.kie.api.marshalling.Marshaller;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.conf.ClockTypeOption;
import org.kie.api.runtime.conf.KieSessionOption;
import org.kie.api.runtime.conf.TimedRuleExecutionOption;
import org.kie.api.runtime.conf.TimerJobFactoryOption;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.api.time.SessionPseudoClock;
import org.kie.internal.builder.conf.PropertySpecificOption;

@RunWith(value=Parameterized.class)
public class IncrementalCompilationCepTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public IncrementalCompilationCepTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseStreamConfigurations((boolean)true);
    }

    @Test
    public void testRemoveRuleAndThenFactInStreamMode() {
        String header = "package org.some.test\nimport " + MyFact.class.getCanonicalName() + "\n";
        String declaration = "declare MyFact\n@role(event)end\n";
        String rule2 = "rule R when\n  $FactA : MyFact ($FactA_field2 : currentValue == 105742)\n  not MyFact($FactA_field2 == 105742)\nthen\nend\n";
        String file2 = header + "declare MyFact\n@role(event)end\n" + "rule R when\n  $FactA : MyFact ($FactA_field2 : currentValue == 105742)\n  not MyFact($FactA_field2 == 105742)\nthen\nend\n";
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId1 = ks.newReleaseId("org.kie", "test-upgrade", "1.0.0");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId1, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{file2});
        KieContainer kc = ks.newKieContainer(releaseId1);
        KieSession ksession = kc.newKieSession();
        MyFact myFact = new MyFact("entry:105742", Integer.valueOf(105742));
        FactHandle fh = ksession.insert((Object)myFact);
        ReleaseId releaseId2 = ks.newReleaseId("org.kie", "test-upgrade", "1.1.0");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId2, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[0]);
        kc.updateToVersion(releaseId2);
        ksession.delete(fh);
    }

    @Test
    public void testAlphaNodeSharingIsOK() {
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId1 = ks.newReleaseId("org.kie", "test-upgrade", "1.0.0");
        String drl = "package org.drools.compiler\nglobal java.util.List list;\nglobal java.util.List list2;\nrule R1\n timer (int: 3s)\n when\n   $m : String()\n then\n   list.add( $m );\n   retract( $m );\nend\nrule RS\n timer (int: 3s)\n salience 1\n when\n   $i : Integer()\n   $m : String()\n then\n   System.out.println($i + \" \"+ $m);   list2.add($i + \" \"+ $m);\nend\n";
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId1, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.drools.compiler\nglobal java.util.List list;\nglobal java.util.List list2;\nrule R1\n timer (int: 3s)\n when\n   $m : String()\n then\n   list.add( $m );\n   retract( $m );\nend\nrule RS\n timer (int: 3s)\n salience 1\n when\n   $i : Integer()\n   $m : String()\n then\n   System.out.println($i + \" \"+ $m);   list2.add($i + \" \"+ $m);\nend\n"});
        KieContainer kc = ks.newKieContainer(releaseId1);
        KieSessionConfiguration ksconf = ks.newKieSessionConfiguration();
        ksconf.setOption((KieSessionOption)TimedRuleExecutionOption.YES);
        ksconf.setOption((KieSessionOption)TimerJobFactoryOption.get((String)"trackable"));
        ksconf.setOption((KieSessionOption)ClockTypeOption.PSEUDO);
        KieSession ksession = kc.newKieSession(ksconf);
        SessionPseudoClock timeService = (SessionPseudoClock)ksession.getSessionClock();
        timeService.advanceTime(new Date().getTime(), TimeUnit.MILLISECONDS);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ArrayList list2 = new ArrayList();
        ksession.setGlobal("list2", list2);
        ksession.insert((Object)"A");
        ksession.insert((Object)1);
        ksession.fireAllRules();
        Assert.assertEquals((String)"1. Initial run: no message expected after rule fired immediately after fireAllRules due to duration of 5 sec", (long)0L, (long)list.size());
        Assert.assertEquals((String)"1. Initial run: no message expected after rule fired immediately after fireAllRules due to duration of 5 sec", (long)0L, (long)list2.size());
        ReleaseId releaseId2 = ks.newReleaseId("org.kie", "test-upgrade", "1.0.1");
        String drl2 = "package org.drools.compiler\nglobal java.util.List list;\nglobal java.util.List list2;\nrule R1\n timer (int: 3s)\n when\n   $m : String()\n then\n   list.add( $m );\n   list.add( $m );\n   retract( $m );\nend\nrule RS\n timer (int: 3s)\n salience 1\n when\n   $i : Integer()\n   $m : String()\n then\n   System.out.println($i + \" \"+ $m);   list2.add($i + \" \"+ $m);\nend\n";
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId2, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieSessionTestConfiguration)KieSessionTestConfiguration.STATEFUL_PSEUDO, new HashMap(), (String[])new String[]{"package org.drools.compiler\nglobal java.util.List list;\nglobal java.util.List list2;\nrule R1\n timer (int: 3s)\n when\n   $m : String()\n then\n   list.add( $m );\n   list.add( $m );\n   retract( $m );\nend\nrule RS\n timer (int: 3s)\n salience 1\n when\n   $i : Integer()\n   $m : String()\n then\n   System.out.println($i + \" \"+ $m);   list2.add($i + \" \"+ $m);\nend\n"});
        kc.updateToVersion(releaseId2);
        timeService.advanceTime(3200L, TimeUnit.MILLISECONDS);
        Assert.assertEquals((String)"1. R1 is NOT preserved", (long)0L, (long)list.size());
        Assert.assertEquals((String)"1. RS is preserved", (long)1L, (long)list2.size());
    }

    @Test
    public void testRemoveRuleWithNonInitializedPath() {
        String drl1 = "import " + MyEvent.class.getCanonicalName() + "\ndeclare MyEvent @role( event ) end\nrule \"RG_TEST_1\"\n    when\n       $dummy: MyEvent (id == 1)\n\t\t$other: MyEvent (this != $dummy)\n    then\n        retract($other);\nend\nrule \"RG_TEST_2\"\n    when\n       $dummy: MyEvent (id == 1)\n    then\n        retract($dummy);\nend\n";
        String drl2 = "import " + MyEvent.class.getCanonicalName() + "\ndeclare IMyEvent @role( event ) end\nrule \"RG_TEST_2\"\n    when\n       $dummy: MyEvent (id == 1)\n    then\n        retract($dummy);\nend\n";
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId1 = ks.newReleaseId("org.kie", "test-upgrade", "1.0.0");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId1, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl1});
        KieContainer kc = ks.newKieContainer(releaseId1);
        KieSession ksession = kc.newKieSession();
        ksession.insert((Object)new MyEvent(0));
        ReleaseId releaseId2 = ks.newReleaseId("org.kie", "test-upgrade", "1.1.0");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId2, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl2});
        kc.updateToVersion(releaseId2);
    }

    @Test
    public void testUpdateWithDeclarationPresent() {
        String header = "package org.drools.compiler\nimport " + FooEvent.class.getCanonicalName() + ";\nimport " + Message.class.getCanonicalName() + ";\n";
        String declaration = "declare FooEvent\n @timestamp( mytime )\n @role( event )\nend\n";
        String rule1 = "rule R1 when\n $e : FooEvent( )\nthen\n insert(new Message(\"Hello R1\"));\nend\n";
        String rule2 = "rule R1 when\n $e : FooEvent( )\nthen\n insert(new Message(\"Hello R2\"));\nend\n";
        String file1 = header + "declare FooEvent\n @timestamp( mytime )\n @role( event )\nend\n" + "rule R1 when\n $e : FooEvent( )\nthen\n insert(new Message(\"Hello R1\"));\nend\n";
        String file2 = header + "declare FooEvent\n @timestamp( mytime )\n @role( event )\nend\n" + "rule R1 when\n $e : FooEvent( )\nthen\n insert(new Message(\"Hello R2\"));\nend\n";
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId1 = ks.newReleaseId("org.kie", "test-upgrade", "1.0.0");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId1, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{file1});
        KieContainer kc = ks.newKieContainer(releaseId1);
        KieSession ksession = kc.newKieSession();
        ksession.insert((Object)new FooEvent(0L));
        Assert.assertEquals((long)1L, (long)ksession.fireAllRules());
        ReleaseId releaseId2 = ks.newReleaseId("org.kie", "test-upgrade", "1.1.0");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId2, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{file2});
        Results results = kc.updateToVersion(releaseId2);
        Assert.assertFalse((String)("Errors detected on updateToVersion: " + results.getMessages(new Message.Level[]{Message.Level.ERROR})), (boolean)results.hasMessages(new Message.Level[]{Message.Level.ERROR}));
        ksession.insert((Object)new FooEvent(1L));
        Assert.assertEquals((long)2L, (long)ksession.fireAllRules());
    }

    @Test
    public void testChangeWindowTime() {
        String drl1 = "import " + MyEvent.class.getCanonicalName() + "\nglobal java.util.concurrent.atomic.AtomicInteger result\ndeclare MyEvent @expires(5m) @role( event ) end\nrule A when\n    accumulate( $e : MyEvent() over window:time(10s), $result : count($e) )\nthen    System.out.println(\"Result-1: \" + $result);\n    result.set( $result.intValue() );\nend";
        String drl2 = "import " + MyEvent.class.getCanonicalName() + "\nglobal java.util.concurrent.atomic.AtomicInteger result\ndeclare MyEvent @expires(5m) @role( event ) end\nrule A when\n    accumulate( $e : MyEvent() over window:time(5s), $result : count($e) )\nthen    System.out.println(\"Result-2: \" + $result);\n    result.set( $result.intValue() );\nend";
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId1 = ks.newReleaseId("org.kie", "test-upgrade", "1.0.0");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId1, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieSessionTestConfiguration)KieSessionTestConfiguration.STATEFUL_PSEUDO, new HashMap(), (String[])new String[]{drl1});
        KieContainer kc = ks.newKieContainer(releaseId1);
        KieSession ksession = kc.newKieSession();
        PseudoClockScheduler clock = (PseudoClockScheduler)ksession.getSessionClock();
        AtomicInteger result = new AtomicInteger(0);
        ksession.setGlobal("result", (Object)result);
        ksession.insert((Object)new MyEvent(1));
        clock.advanceTime(4L, TimeUnit.SECONDS);
        ksession.insert((Object)new MyEvent(2));
        clock.advanceTime(4L, TimeUnit.SECONDS);
        ksession.insert((Object)new MyEvent(3));
        ksession.fireAllRules();
        Assert.assertEquals((long)3L, (long)result.get());
        clock.advanceTime(3L, TimeUnit.SECONDS);
        ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)result.get());
        ReleaseId releaseId2 = ks.newReleaseId("org.kie", "test-upgrade", "1.1.0");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId2, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieSessionTestConfiguration)KieSessionTestConfiguration.STATEFUL_PSEUDO, new HashMap(), (String[])new String[]{drl2});
        kc.updateToVersion(releaseId2);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)result.get());
        ksession.insert((Object)new MyEvent(4));
        ksession.insert((Object)new MyEvent(5));
        ksession.fireAllRules();
        Assert.assertEquals((long)3L, (long)result.get());
        clock.advanceTime(3L, TimeUnit.SECONDS);
        ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)result.get());
        clock.advanceTime(3L, TimeUnit.SECONDS);
        ksession.fireAllRules();
        Assert.assertEquals((long)0L, (long)result.get());
    }

    @Test
    public void testIncrementalCompilationWithSlidingWindow() {
        String drl1 = "import " + MyEvent.class.getCanonicalName() + "\ndeclare MyEvent @role( event ) end\nrule A when\n    Number($number : intValue)\n              from accumulate( MyEvent($id : id) over window:time(10s), sum($id) )\nthen\n    System.out.println(\"1. SUM : \" + $number);\nend\n\nrule B when\n    Number($number : intValue)\n              from accumulate( MyEvent($id : id) over window:time(10s), count($id) )\nthen\n    System.out.println(\"1. CNT : \" + $number);\nend";
        String drl2 = "import " + MyEvent.class.getCanonicalName() + "\ndeclare MyEvent @role( event ) end\nrule A when\n    Number($number : intValue)\n              from accumulate( MyEvent($id : id) over window:time(10s), sum($id) )\nthen\n    System.out.println(\"2. SUM : \" + $number);\nend\n\nrule B when\n    Number($number : intValue)\n              from accumulate( MyEvent($id : id) over window:time(10s), count($id) )\nthen\n    System.out.println(\"2. CNT : \" + $number);\nend";
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId1 = ks.newReleaseId("org.kie", "test-upgrade", "1.0.0");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId1, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieSessionTestConfiguration)KieSessionTestConfiguration.STATEFUL_PSEUDO, new HashMap(), (String[])new String[]{drl1});
        ReleaseId releaseId2 = ks.newReleaseId("org.kie", "test-upgrade", "1.1.0");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId2, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieSessionTestConfiguration)KieSessionTestConfiguration.STATEFUL_PSEUDO, new HashMap(), (String[])new String[]{drl2});
        KieContainer kc = ks.newKieContainer(releaseId1);
        KieSession ksession = kc.newKieSession();
        PseudoClockScheduler clock = (PseudoClockScheduler)ksession.getSessionClock();
        ksession.insert((Object)new MyEvent(1));
        ksession.fireAllRules();
        clock.advanceTime(7L, TimeUnit.SECONDS);
        kc.updateToVersion(releaseId2);
        ksession.fireAllRules();
        clock.advanceTime(7L, TimeUnit.SECONDS);
        kc.updateToVersion(releaseId1);
        ksession.fireAllRules();
    }

    @Test
    public void testDrlRenamingWithEvents() {
        String drl1 = "import " + SimpleEvent.class.getCanonicalName() + ";\n\nglobal java.util.concurrent.atomic.AtomicInteger counter1;\nglobal java.util.concurrent.atomic.AtomicInteger counter2;\n\ndeclare SimpleEvent\n    @role( event )\n    @timestamp( timestamp )\n    @expires( 2d )\nend\n\nrule R1 when\n    $s:SimpleEvent(code==\"MY_CODE\")\nthen\n    counter1.incrementAndGet();\nend\n\nrule R2 when\n    $s:SimpleEvent(code==\"MY_CODE\")\n    not SimpleEvent(this != $s, this after [0,10s] $s)\nthen\n    counter2.incrementAndGet();\nend\n";
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId1 = ks.newReleaseId("org.kie", "test-upgrade", "1.1.1");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId1, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieSessionTestConfiguration)KieSessionTestConfiguration.STATEFUL_PSEUDO, new HashMap(), (String[])new String[]{drl1});
        KieContainer kc = ks.newKieContainer(releaseId1);
        KieSession ksession = kc.newKieSession();
        PseudoClockScheduler clock = (PseudoClockScheduler)ksession.getSessionClock();
        AtomicInteger counter1 = new AtomicInteger(0);
        AtomicInteger counter2 = new AtomicInteger(0);
        ksession.setGlobal("counter1", (Object)counter1);
        ksession.setGlobal("counter2", (Object)counter2);
        ksession.insert((Object)new SimpleEvent("1", "MY_CODE", 0L));
        ksession.fireAllRules();
        clock.advanceTime(5L, TimeUnit.SECONDS);
        ksession.insert((Object)new SimpleEvent("2", "MY_CODE", 5L));
        ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)counter1.get());
        Assert.assertEquals((long)0L, (long)counter2.get());
        ReleaseId releaseId2 = ks.newReleaseId("org.kie", "test-upgrade", "1.1.2");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId2, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieSessionTestConfiguration)KieSessionTestConfiguration.STATEFUL_PSEUDO, new HashMap(), (String[])new String[]{null, drl1});
        kc.updateToVersion(releaseId2);
        clock = (PseudoClockScheduler)ksession.getSessionClock();
        clock.advanceTime(16L, TimeUnit.SECONDS);
        ksession.insert((Object)new SimpleEvent("3", "MY_CODE", 21L));
        ksession.fireAllRules();
        if (this.kieBaseTestConfiguration.getExecutableModelProjectClass().isPresent()) {
            Assert.assertEquals((long)3L, (long)counter1.get());
        } else {
            Assert.assertEquals((long)5L, (long)counter1.get());
        }
        Assert.assertEquals((long)1L, (long)counter2.get());
    }

    @Test
    public void testIncrementalCompilationWithTimerNode() {
        String drl1 = "package org.drools.test\nimport " + DummyEvent.class.getCanonicalName() + "\ndeclare DummyEvent\n    @role( event )\n    @timestamp( eventTimestamp )\nend\nrule \"RG_TEST_TIMER\"\ntimer (int: 0 1; start=$expirationTimestamp , repeat-limit=0 )\n    when\n       $dummy: DummyEvent (id == 'timer', $expirationTimestamp : systemTimestamp )\n    then\n System.out.println(\"1\");\nend\n";
        String drl2 = "package org.drools.test\nimport " + DummyEvent.class.getCanonicalName() + "\ndeclare DummyEvent\n    @role( event )\n    @timestamp( eventTimestamp )\nend\nrule \"RG_TEST_TIMER_NEW\"\ntimer (int: 0 1; start=$expirationTimestamp , repeat-limit=0 )\n    when\n       $dummy: DummyEvent (id == 'timer', $expirationTimestamp : systemTimestamp )\n\t\tDummyEvent (id == 'timer_match')\n    then\n System.out.println(\"1\");\nend\nrule \"RG_OTHER_RULE\"\n    when\n       $dummy: DummyEvent ( id == 'timer' )\n    then\n System.out.println(\"2\");\nend\n";
        long now = System.currentTimeMillis();
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId1 = ks.newReleaseId("org.kie", "test-upgrade", "1.0.0");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId1, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieSessionTestConfiguration)KieSessionTestConfiguration.STATEFUL_PSEUDO, new HashMap(), (String[])new String[]{drl1});
        KieContainer kc = ks.newKieContainer(releaseId1);
        KieSession kieSession = kc.newKieSession();
        DummyEvent dummyEvent = new DummyEvent();
        dummyEvent.setId("timer");
        dummyEvent.setEventTimestamp(now);
        dummyEvent.setSystemTimestamp(now + TimeUnit.HOURS.toMillis(1L));
        DummyEvent other = new DummyEvent();
        other.setId("timer_match");
        other.setEventTimestamp(now);
        kieSession.insert((Object)dummyEvent);
        kieSession.insert((Object)other);
        ReleaseId releaseId2 = ks.newReleaseId("org.kie", "test-upgrade", "2.0.0");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId2, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieSessionTestConfiguration)KieSessionTestConfiguration.STATEFUL_PSEUDO, new HashMap(), (String[])new String[]{drl2});
        kc.updateToVersion(releaseId2);
        PseudoClockScheduler scheduler = (PseudoClockScheduler)kieSession.getSessionClock();
        scheduler.setStartupTime(now);
        scheduler.advanceTime(1L, TimeUnit.DAYS);
        Assert.assertEquals((long)2L, (long)kieSession.fireAllRules());
    }

    @Test
    public void testEventDeclarationInSeparatedDRL() {
        String drl1 = "import " + SimpleEvent.class.getCanonicalName() + ";\ndeclare SimpleEvent\n    @role( event )\n    @timestamp( timestamp )\n    @expires( 2d )\nend\n";
        String drl2 = "import " + SimpleEvent.class.getCanonicalName() + ";\nglobal java.util.List list;\nrule R1 when\n    $s:SimpleEvent(code==\"MY_CODE\") over window:time( 1s )\nthen\n    list.add(\"MY_CODE\");\nend\n";
        String drl3 = "import " + SimpleEvent.class.getCanonicalName() + ";\nglobal java.util.List list;\nrule R2 when\n    $s:SimpleEvent(code==\"YOUR_CODE\") over window:time( 1s )\nthen\n    list.add(\"YOUR_CODE\");\nend\n";
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId1 = ks.newReleaseId("org.kie", "test-cep-upgrade", "1.1.1");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId1, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieSessionTestConfiguration)KieSessionTestConfiguration.STATEFUL_PSEUDO, new HashMap(), (String[])new String[]{drl1, drl2});
        KieContainer kc = ks.newKieContainer(releaseId1);
        KieSession ksession = kc.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)new SimpleEvent("1", "MY_CODE", 0L));
        ksession.insert((Object)new SimpleEvent("2", "YOUR_CODE", 0L));
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)"MY_CODE", list.get(0));
        list.clear();
        ReleaseId releaseId2 = ks.newReleaseId("org.kie", "test-cep-upgrade", "1.1.2");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId2, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieSessionTestConfiguration)KieSessionTestConfiguration.STATEFUL_PSEUDO, new HashMap(), (String[])new String[]{drl1, drl2, drl3});
        Results results = kc.updateToVersion(releaseId2);
        Assert.assertEquals((long)0L, (long)results.getMessages().size());
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)"YOUR_CODE", list.get(0));
    }

    @Test
    public void testKeepBuilderConfAfterIncrementalUpdate() {
        String drl1 = "import " + DummyEvent.class.getCanonicalName() + "\nrule R1 when\n  DummyEvent() @watch(id)\nthen end\n";
        String drl2 = "import " + DummyEvent.class.getCanonicalName() + "\nrule R1 when\n  DummyEvent() @watch(*)\nthen end\n";
        KieServices ks = KieServices.Factory.get();
        HashMap<String, String> kieModuleConfigurationProperties = new HashMap<String, String>();
        kieModuleConfigurationProperties.put("drools.propertySpecific", PropertySpecificOption.ALWAYS.toString());
        ReleaseId releaseId1 = ks.newReleaseId("org.kie", "test-property-reactive-upgrade", "1");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId1, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieSessionTestConfiguration)KieSessionTestConfiguration.STATEFUL_REALTIME, kieModuleConfigurationProperties, (String[])new String[]{drl1});
        KieContainer container = ks.newKieContainer(releaseId1);
        container.newKieSession();
        ReleaseId releaseId2 = ks.newReleaseId("org.kie", "test-property-reactive-upgrade", "2");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId2, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieSessionTestConfiguration)KieSessionTestConfiguration.STATEFUL_REALTIME, kieModuleConfigurationProperties, (String[])new String[]{drl2});
        Results results = container.updateToVersion(releaseId2);
        Assert.assertEquals((long)0L, (long)results.getMessages().size());
    }

    @Test
    public void testIncrementalCompilationWithNewEvent() {
        String drl1 = "package org.drools.test\nimport " + DummyEvent.class.getCanonicalName() + "\ndeclare DummyEvent\n    @role( event )\n    @timestamp( eventTimestamp )\nend\nrule \"RG_TEST_1\"\n    when\n       $event: DummyEvent ()\n    then\n        System.out.println(\"RG_TEST_1 fired\");\n        retract($event);\nend";
        String drl2 = "package org.drools.test\nimport " + DummyEvent.class.getCanonicalName() + "\nimport " + OtherDummyEvent.class.getCanonicalName() + "\ndeclare DummyEvent\n    @role( event )\n    @timestamp( eventTimestamp )\nend\ndeclare OtherDummyEvent\n    @role( event )\n    @timestamp( eventTimestamp )\nend\nrule \"RG_TEST_2\"\n    when\n       $event: DummyEvent ()\n       $other : OtherDummyEvent(id == $event.id, this after $event)\n    then\n        System.out.println(\"RG_TEST_2 fired\");\n        retract($other);\nend\n\nrule \"RG_TEST_1\"\n    when\n       $event: DummyEvent ()\n    then\n        System.out.println(\"RG_TEST_1 fired\");\n        retract($event);\nend\n";
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId1 = ks.newReleaseId("org.kie", "test-upgrade", "1.0.0");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId1, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieSessionTestConfiguration)KieSessionTestConfiguration.STATEFUL_PSEUDO, new HashMap(), (String[])new String[]{drl1});
        KieContainer kc = ks.newKieContainer(releaseId1);
        KieSession kieSession = kc.newKieSession();
        DummyEvent evt = new DummyEvent("evt");
        kieSession.insert((Object)evt);
        Assert.assertEquals((long)1L, (long)kieSession.fireAllRules());
        ReleaseId releaseId2 = ks.newReleaseId("org.kie", "test-upgrade", "2.0.0");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId2, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieSessionTestConfiguration)KieSessionTestConfiguration.STATEFUL_PSEUDO, new HashMap(), (String[])new String[]{drl2});
        kc.updateToVersion(releaseId2);
        evt = new DummyEvent("evt");
        kieSession.insert((Object)evt);
        OtherDummyEvent other = new OtherDummyEvent("evt");
        kieSession.insert((Object)other);
        Assert.assertEquals((long)1L, (long)kieSession.fireAllRules());
    }

    @Test
    public void testAddRuleWithSlidingWindows() throws Exception {
        String drl1 = "package org.drools.compiler\nimport " + List.class.getCanonicalName() + "\nimport " + BooleanEvent.class.getCanonicalName() + "\nrule R1 when\n    $e : BooleanEvent(!enabled)\n    List(size >= 1) from collect ( BooleanEvent(!enabled) over window:time(1) )\n    $toEdit : List() from collect( BooleanEvent(!enabled) over window:time(2) )\nthen\n    modify( (BooleanEvent)$toEdit.get(0) ){ setEnabled( true ) }\nend\n";
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId1 = ks.newReleaseId("org.kie", "test-upgrade", "1.0.0");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId1, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieSessionTestConfiguration)KieSessionTestConfiguration.STATEFUL_PSEUDO, new HashMap(), (String[])new String[0]);
        ReleaseId releaseId2 = ks.newReleaseId("org.kie", "test-upgrade", "2.0.0");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId2, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieSessionTestConfiguration)KieSessionTestConfiguration.STATEFUL_PSEUDO, new HashMap(), (String[])new String[]{drl1});
        KieContainer kc = ks.newKieContainer(releaseId1);
        KieSession kieSession = kc.newKieSession();
        kieSession.insert((Object)new BooleanEvent());
        kieSession.fireAllRules();
        kc.updateToVersion(releaseId2);
        kieSession.fireAllRules();
        KieMarshallers marshallers = ks.getMarshallers();
        Marshaller marshaller = marshallers.newMarshaller(kieSession.getKieBase());
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        marshaller.marshall((OutputStream)outputStream, kieSession);
    }

    @Test
    public void testObjectTypeNodeExpirationOffset() {
        String drl1 = "package org.drools.test;\nimport " + ParentEvent.class.getCanonicalName() + "\nimport " + ChildEventA.class.getCanonicalName() + "\nimport " + ChildEventB.class.getCanonicalName() + "\n\ndeclare ChildEventA\n   @role( event )\n   @timestamp( eventTimestamp )\n   @expires(3d)\nend;\ndeclare ChildEventB\n   @role( event )\n   @timestamp( eventTimestamp )\n   @expires(30d)\nend;\nrule \"detect ChildEventA\"\nwhen $e: ChildEventA()\nthen\n    System.out.println(\"detect ChildEventA\");\nend\n\nrule \"detect ParentEvent\"\nwhen $e: ParentEvent()\nthen\n   System.out.println(\"detect ParentEvent\");\nend\nrule \"detect ChildEventB\"\nwhen $e: ChildEventB()\nthen\n   System.out.println(\"detect ChildEventB\");\nend";
        String drl2 = "package org.drools.test;\nimport " + ParentEvent.class.getCanonicalName() + "\nimport " + ChildEventA.class.getCanonicalName() + "\nimport " + ChildEventB.class.getCanonicalName() + "\nimport " + Person.class.getCanonicalName() + "\n\ndeclare ChildEventA\n   @role( event )\n   @timestamp( eventTimestamp )\n   @expires(3d)\nend;\ndeclare ChildEventB\n   @role( event )\n   @timestamp( eventTimestamp )\n   @expires(30d)\nend;\nrule \"detect ChildEventA\"\nwhen $e: ChildEventA()\nthen\n    System.out.println(\"detect ChildEventA\");\nend\n\nrule \"detect ParentEvent\"\nwhen $e: ParentEvent()\nthen\n   System.out.println(\"detect ParentEvent\");\nend\nrule \"detect ChildEventB\"\nwhen $e: ChildEventB()\nthen\n   System.out.println(\"detect ChildEventB\");\nend\nrule \"detect a Person\"\nwhen $p: Person()\nthen\n  System.out.println(\"detect a Person\");\nend";
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId1 = ks.newReleaseId("org.kie", "test-upgrade", "1.0.0");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId1, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieSessionTestConfiguration)KieSessionTestConfiguration.STATEFUL_PSEUDO, new HashMap(), (String[])new String[]{drl1});
        KieContainer kc = ks.newKieContainer(releaseId1);
        KieSession kieSession = kc.newKieSession();
        NamedEntryPoint entryPoint = (NamedEntryPoint)kieSession.getEntryPoints().stream().findFirst().get();
        Map objectTypeNodes = entryPoint.getEntryPointNode().getObjectTypeNodes();
        ObjectTypeNode parentEventOTN = (ObjectTypeNode)objectTypeNodes.get(new ClassObjectType(ParentEvent.class));
        Assert.assertEquals((long)-1L, (long)parentEventOTN.getExpirationOffset());
        ObjectTypeNode childEventAOTN = (ObjectTypeNode)objectTypeNodes.get(new ClassObjectType(ChildEventA.class));
        Assert.assertEquals((long)(Duration.of(3L, ChronoUnit.DAYS).toMillis() + 1L), (long)childEventAOTN.getExpirationOffset());
        ObjectTypeNode childEventBOTN = (ObjectTypeNode)objectTypeNodes.get(new ClassObjectType(ChildEventB.class));
        Assert.assertEquals((long)(Duration.of(30L, ChronoUnit.DAYS).toMillis() + 1L), (long)childEventBOTN.getExpirationOffset());
        long now = System.currentTimeMillis();
        SessionPseudoClock sessionClock = (SessionPseudoClock)kieSession.getSessionClock();
        sessionClock.advanceTime(now, TimeUnit.MILLISECONDS);
        ChildEventA childEventA = new ChildEventA(new Date(now), "A");
        kieSession.insert((Object)childEventA);
        kieSession.fireAllRules();
        sessionClock.advanceTime(Duration.of(4L, ChronoUnit.DAYS).toMillis(), TimeUnit.MILLISECONDS);
        kieSession.fireAllRules();
        Assert.assertEquals((long)0L, (long)kieSession.getFactCount());
        kieSession.dispose();
        ReleaseId releaseId2 = ks.newReleaseId("org.kie", "test-upgrade", "2.0.0");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId2, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieSessionTestConfiguration)KieSessionTestConfiguration.STATEFUL_PSEUDO, new HashMap(), (String[])new String[]{drl2});
        kc.updateToVersion(releaseId2);
        KieSession kieSession2 = kc.newKieSession();
        NamedEntryPoint entryPoint2 = (NamedEntryPoint)kieSession2.getEntryPoints().stream().findFirst().get();
        Map objectTypeNodes2 = entryPoint2.getEntryPointNode().getObjectTypeNodes();
        ObjectTypeNode parentEventOTN2 = (ObjectTypeNode)objectTypeNodes2.get(new ClassObjectType(ParentEvent.class));
        Assert.assertEquals((long)-1L, (long)parentEventOTN2.getExpirationOffset());
        ObjectTypeNode childEventAOTN2 = (ObjectTypeNode)objectTypeNodes2.get(new ClassObjectType(ChildEventA.class));
        Assert.assertEquals((long)(Duration.of(3L, ChronoUnit.DAYS).toMillis() + 1L), (long)childEventAOTN2.getExpirationOffset());
        ObjectTypeNode childEventBOTN2 = (ObjectTypeNode)objectTypeNodes2.get(new ClassObjectType(ChildEventB.class));
        Assert.assertEquals((long)(Duration.of(30L, ChronoUnit.DAYS).toMillis() + 1L), (long)childEventBOTN2.getExpirationOffset());
        now = System.currentTimeMillis();
        SessionPseudoClock sessionClock2 = (SessionPseudoClock)kieSession2.getSessionClock();
        sessionClock2.advanceTime(now, TimeUnit.MILLISECONDS);
        ChildEventA childEventA2 = new ChildEventA(new Date(now), "A");
        kieSession2.insert((Object)childEventA2);
        kieSession2.fireAllRules();
        sessionClock2.advanceTime(Duration.of(4L, ChronoUnit.DAYS).toMillis(), TimeUnit.MILLISECONDS);
        kieSession2.fireAllRules();
        Assert.assertEquals((long)0L, (long)kieSession2.getFactCount());
        kieSession2.dispose();
    }

    public static class MyEvent {
        private final int id;

        public MyEvent(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public String toString() {
            return "MyEvent: " + this.id;
        }
    }

    @Role(value=Role.Type.EVENT)
    public static class BooleanEvent
    implements Serializable {
        private boolean enabled = false;

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }
    }

    public static class OtherDummyEvent {
        private String id;
        private long eventTimestamp;
        private long systemTimestamp;

        public OtherDummyEvent() {
        }

        public OtherDummyEvent(String id) {
            this.id = id;
        }

        public long getEventTimestamp() {
            return this.eventTimestamp;
        }

        public void setEventTimestamp(long eventTimestamp) {
            this.eventTimestamp = eventTimestamp;
        }

        public long getSystemTimestamp() {
            return this.systemTimestamp;
        }

        public void setSystemTimestamp(long systemTimestamp) {
            this.systemTimestamp = systemTimestamp;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }
    }

    public static class DummyEvent {
        private String id;
        private long eventTimestamp;
        private long systemTimestamp;

        public DummyEvent() {
        }

        public DummyEvent(String id) {
            this.id = id;
        }

        public long getEventTimestamp() {
            return this.eventTimestamp;
        }

        public void setEventTimestamp(long eventTimestamp) {
            this.eventTimestamp = eventTimestamp;
        }

        public long getSystemTimestamp() {
            return this.systemTimestamp;
        }

        public void setSystemTimestamp(long systemTimestamp) {
            this.systemTimestamp = systemTimestamp;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }
    }

    public static class SimpleEvent {
        private final String id;
        private final String code;
        private final long timestamp;

        public SimpleEvent(String eventId, String code, long timestamp) {
            this.id = eventId;
            this.code = code;
            this.timestamp = timestamp * 1000L;
        }

        public String getId() {
            return this.id;
        }

        public String getCode() {
            return this.code;
        }

        public Date getTimestamp() {
            return new Date(this.timestamp);
        }

        public String toString() {
            return "SimpleEvent(" + this.id + ")";
        }
    }

    public static class FooEvent {
        private final long mytime;

        public FooEvent(long mytime) {
            this.mytime = mytime;
        }

        public long getMytime() {
            return this.mytime;
        }
    }
}

