/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests.incrementalcompilation;

import java.util.ArrayList;
import java.util.List;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.kiesession.rulebase.KnowledgeBaseFactory;
import org.kie.api.KieBase;
import org.kie.api.definition.KiePackage;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.io.ResourceFactory;

public final class TestUtil {
    public static final String RULES_PACKAGE_NAME = "com.rules";
    public static final String RULE1_NAME = "R1";
    public static final String RULE2_NAME = "R2";
    public static final String RULE3_NAME = "R3";

    public static void addRules(KieSession session, String ... drls) {
        TestUtil.addRules(session, false, drls);
    }

    public static void addRules(KieSession session, boolean reuseKieBaseWhenAddingRules, String ... drls) {
        for (String drl : drls) {
            KnowledgeBuilder kBuilder = reuseKieBaseWhenAddingRules ? TestUtil.createKnowledgeBuilder(session.getKieBase(), drl) : TestUtil.createKnowledgeBuilder(null, drl);
            ((InternalKnowledgeBase)session.getKieBase()).addPackages(kBuilder.getKnowledgePackages());
        }
    }

    public static void removeRules(KieSession session, String rulesPackageName, String ... ruleNames) {
        KieBase kieBase = session.getKieBase();
        for (String ruleName : ruleNames) {
            kieBase.removeRule(rulesPackageName, ruleName);
        }
    }

    public static List<FactHandle> insertFacts(KieSession session, Object ... facts) {
        ArrayList<FactHandle> factHandles = new ArrayList<FactHandle>();
        for (Object fact : facts) {
            factHandles.add(session.insert(fact));
        }
        return factHandles;
    }

    public static void removeFacts(KieSession session, List<FactHandle> factHandles) {
        for (FactHandle factHandle : factHandles) {
            session.delete(factHandle);
        }
    }

    public static KieSession buildSessionInSteps(String ... drls) {
        return TestUtil.buildSessionInSteps(false, drls);
    }

    public static KieSession buildSessionInSteps(InternalKnowledgeBase originalKnowledgeBase, String ... drls) {
        return TestUtil.buildSessionInSteps(originalKnowledgeBase, false, drls);
    }

    public static KieSession buildSessionInSteps(InternalKnowledgeBase originalKnowledgeBase, boolean reuseKieBaseWhenAddingRules, String ... drls) {
        if (drls == null || drls.length == 0) {
            if (originalKnowledgeBase == null) {
                return KnowledgeBaseFactory.newKnowledgeBase().newKieSession();
            }
            return originalKnowledgeBase.newKieSession();
        }
        String drl = drls[0];
        KnowledgeBuilder kbuilder = TestUtil.createKnowledgeBuilder(null, drl);
        InternalKnowledgeBase kbase = originalKnowledgeBase == null ? KnowledgeBaseFactory.newKnowledgeBase() : originalKnowledgeBase;
        kbase.addPackages(kbuilder.getKnowledgePackages());
        KieSession kSession = kbase.newKieSession();
        for (int i = 1; i < drls.length; ++i) {
            drl = drls[i];
            KnowledgeBuilder kbuilder2 = reuseKieBaseWhenAddingRules ? TestUtil.createKnowledgeBuilder(kSession.getKieBase(), drl) : TestUtil.createKnowledgeBuilder(null, drl);
            ((InternalKnowledgeBase)kSession.getKieBase()).addPackages(kbuilder2.getKnowledgePackages());
        }
        return kSession;
    }

    public static KieSession buildSessionInSteps(boolean reuseKieBaseWhenAddingRules, String ... drls) {
        return TestUtil.buildSessionInSteps(null, reuseKieBaseWhenAddingRules, drls);
    }

    public static KnowledgeBuilder createKnowledgeBuilder(KieBase kbase, String ... drls) {
        KnowledgeBuilder kbuilder = kbase == null ? KnowledgeBuilderFactory.newKnowledgeBuilder() : KnowledgeBuilderFactory.newKnowledgeBuilder((KieBase)kbase);
        for (String drl : drls) {
            kbuilder.add(ResourceFactory.newByteArrayResource((byte[])drl.getBytes()), ResourceType.DRL);
        }
        if (kbuilder.hasErrors()) {
            throw new RuntimeException("Knowledge contains errors: " + kbuilder.getErrors().toString());
        }
        return kbuilder;
    }

    public static int getRulesCount(KieBase kBase) {
        int result = 0;
        for (KiePackage kiePackage : kBase.getKiePackages()) {
            result += kiePackage.getRules().size();
        }
        return result;
    }

    public static Object[] getDefaultFacts() {
        return new Object[]{1, 2, "1"};
    }

    private TestUtil() {
    }
}

