/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests.phases;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.drools.compiler.builder.PackageRegistryManager;
import org.drools.compiler.builder.impl.BuildResultCollector;
import org.drools.compiler.builder.impl.BuildResultCollectorImpl;
import org.drools.compiler.builder.impl.GlobalVariableContext;
import org.drools.compiler.builder.impl.GlobalVariableContextImpl;
import org.drools.compiler.builder.impl.InternalKnowledgeBaseProvider;
import org.drools.compiler.builder.impl.KnowledgeBuilderConfigurationImpl;
import org.drools.compiler.builder.impl.PackageRegistryManagerImpl;
import org.drools.compiler.builder.impl.RootClassLoaderProvider;
import org.drools.compiler.builder.impl.TypeDeclarationBuilder;
import org.drools.compiler.builder.impl.TypeDeclarationContext;
import org.drools.compiler.builder.impl.TypeDeclarationContextImpl;
import org.drools.compiler.builder.impl.TypeDeclarationManagerImpl;
import org.drools.compiler.builder.impl.resources.DrlResourceHandler;
import org.drools.compiler.integrationtests.phases.ExplicitCanonicalModelCompiler;
import org.drools.compiler.lang.descr.CompositePackageDescr;
import org.drools.drl.ast.descr.PackageDescr;
import org.drools.drl.parser.DroolsParserException;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.modelcompiler.builder.CanonicalModelBuildContext;
import org.drools.modelcompiler.builder.PackageModelManager;
import org.drools.modelcompiler.builder.PackageSourceManager;
import org.drools.modelcompiler.builder.PackageSources;
import org.drools.modelcompiler.builder.generator.DRLIdGenerator;
import org.drools.util.io.ClassPathResource;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.builder.ReleaseId;
import org.kie.api.io.Resource;
import org.kie.util.maven.support.ReleaseIdImpl;

public class ExplicitCanonicalModelCompilerTest {
    @Test
    public void testCompile() throws DroolsParserException, IOException {
        ClassPathResource resource = new ClassPathResource("org/drools/compiler/integrationtests/phases/ExplicitCompilerTest.drl");
        InternalKnowledgeBase kBase = null;
        KnowledgeBuilderConfigurationImpl configuration = new KnowledgeBuilderConfigurationImpl();
        ClassLoader rootClassLoader = configuration.getClassLoader();
        BuildResultCollectorImpl results = new BuildResultCollectorImpl();
        RootClassLoaderProvider rootClassLoaderProvider = () -> rootClassLoader;
        InternalKnowledgeBaseProvider internalKnowledgeBaseProvider = () -> kBase;
        PackageRegistryManagerImpl packageRegistryManager = new PackageRegistryManagerImpl(configuration, rootClassLoaderProvider, internalKnowledgeBaseProvider);
        GlobalVariableContextImpl globalVariableContext = new GlobalVariableContextImpl();
        TypeDeclarationContextImpl typeDeclarationContext = new TypeDeclarationContextImpl(configuration, (PackageRegistryManager)packageRegistryManager, (GlobalVariableContext)globalVariableContext);
        TypeDeclarationBuilder typeBuilder = new TypeDeclarationBuilder((TypeDeclarationContext)typeDeclarationContext);
        typeDeclarationContext.setTypeDeclarationManager(new TypeDeclarationManagerImpl(typeBuilder, kBase));
        DrlResourceHandler handler = new DrlResourceHandler(configuration);
        PackageDescr packageDescr = handler.process((Resource)resource);
        handler.getResults().forEach(arg_0 -> ((BuildResultCollectorImpl)results).addBuilderResult(arg_0));
        CompositePackageDescr compositePackageDescr = new CompositePackageDescr((Resource)resource, packageDescr);
        List<CompositePackageDescr> compositePackageDescrs = Arrays.asList(compositePackageDescr);
        PackageModelManager packageModelManager = new PackageModelManager(configuration, (ReleaseId)new ReleaseIdImpl("org.drools:dummy:1.0-SNAPSHOT"), new DRLIdGenerator());
        CanonicalModelBuildContext buildContext = new CanonicalModelBuildContext();
        PackageSourceManager packageSourceManager = new PackageSourceManager();
        ExplicitCanonicalModelCompiler compiler = new ExplicitCanonicalModelCompiler(compositePackageDescrs, (PackageRegistryManager)packageRegistryManager, packageModelManager, buildContext, configuration, (BuildResultCollector)results, (TypeDeclarationContext)typeDeclarationContext, (GlobalVariableContext)globalVariableContext, (PackageSourceManager<PackageSources>)packageSourceManager);
        compiler.process();
        ArrayList generatedSources = new ArrayList();
        for (PackageSources src : packageSourceManager.getPackageSources()) {
            src.collectGeneratedFiles(generatedSources);
        }
        Assert.assertEquals((long)4L, (long)generatedSources.size());
    }
}

