/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel;

import java.util.ArrayList;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.SingleBetaConstraints;
import org.drools.core.reteoo.BetaMemory;
import org.drools.core.reteoo.LeftTupleImpl;
import org.drools.core.reteoo.Tuple;
import org.drools.core.rule.constraint.BetaNodeFieldConstraint;
import org.drools.core.util.AbstractHashTable;
import org.drools.core.util.Entry;
import org.drools.core.util.Iterator;
import org.drools.core.util.index.TupleIndexHashTable;
import org.drools.core.util.index.TupleList;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.kiesession.rulebase.KnowledgeBaseFactory;
import org.drools.mvel.BaseTupleIndexHashTableIteratorTest;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.runtime.KieSession;
import org.mockito.Mockito;

public class LeftTupleIndexHashTableIteratorTest
extends BaseTupleIndexHashTableIteratorTest {
    public LeftTupleIndexHashTableIteratorTest(boolean useLambdaConstraint) {
        this.useLambdaConstraint = useLambdaConstraint;
    }

    @Test
    public void test1() {
        BetaNodeFieldConstraint constraint0 = LeftTupleIndexHashTableIteratorTest.createFooThisEqualsDBetaConstraint(this.useLambdaConstraint);
        BetaNodeFieldConstraint[] constraints = new BetaNodeFieldConstraint[]{constraint0};
        RuleBaseConfiguration config = new RuleBaseConfiguration();
        SingleBetaConstraints betaConstraints = null;
        betaConstraints = new SingleBetaConstraints(constraints, config);
        BetaMemory betaMemory = betaConstraints.createBetaMemory(config, (short)181);
        InternalKnowledgeBase kBase = KnowledgeBaseFactory.newKnowledgeBase();
        KieSession ss = kBase.newKieSession();
        InternalFactHandle fh1 = (InternalFactHandle)ss.insert((Object)new BaseTupleIndexHashTableIteratorTest.Foo("brie", 1));
        InternalFactHandle fh2 = (InternalFactHandle)ss.insert((Object)new BaseTupleIndexHashTableIteratorTest.Foo("brie", 1));
        InternalFactHandle fh3 = (InternalFactHandle)ss.insert((Object)new BaseTupleIndexHashTableIteratorTest.Foo("soda", 1));
        InternalFactHandle fh4 = (InternalFactHandle)ss.insert((Object)new BaseTupleIndexHashTableIteratorTest.Foo("soda", 1));
        InternalFactHandle fh5 = (InternalFactHandle)ss.insert((Object)new BaseTupleIndexHashTableIteratorTest.Foo("bread", 3));
        InternalFactHandle fh6 = (InternalFactHandle)ss.insert((Object)new BaseTupleIndexHashTableIteratorTest.Foo("bread", 3));
        InternalFactHandle fh7 = (InternalFactHandle)ss.insert((Object)new BaseTupleIndexHashTableIteratorTest.Foo("cream", 3));
        InternalFactHandle fh8 = (InternalFactHandle)ss.insert((Object)new BaseTupleIndexHashTableIteratorTest.Foo("gorda", 15));
        InternalFactHandle fh9 = (InternalFactHandle)ss.insert((Object)new BaseTupleIndexHashTableIteratorTest.Foo("beer", 16));
        InternalFactHandle fh10 = (InternalFactHandle)ss.insert((Object)new BaseTupleIndexHashTableIteratorTest.Foo("mars", 0));
        InternalFactHandle fh11 = (InternalFactHandle)ss.insert((Object)new BaseTupleIndexHashTableIteratorTest.Foo("snicker", 0));
        InternalFactHandle fh12 = (InternalFactHandle)ss.insert((Object)new BaseTupleIndexHashTableIteratorTest.Foo("snicker", 0));
        InternalFactHandle fh13 = (InternalFactHandle)ss.insert((Object)new BaseTupleIndexHashTableIteratorTest.Foo("snicker", 0));
        betaMemory.getLeftTupleMemory().add((Tuple)new LeftTupleImpl(fh1, null, true));
        betaMemory.getLeftTupleMemory().add((Tuple)new LeftTupleImpl(fh2, null, true));
        betaMemory.getLeftTupleMemory().add((Tuple)new LeftTupleImpl(fh3, null, true));
        betaMemory.getLeftTupleMemory().add((Tuple)new LeftTupleImpl(fh4, null, true));
        betaMemory.getLeftTupleMemory().add((Tuple)new LeftTupleImpl(fh5, null, true));
        betaMemory.getLeftTupleMemory().add((Tuple)new LeftTupleImpl(fh6, null, true));
        betaMemory.getLeftTupleMemory().add((Tuple)new LeftTupleImpl(fh7, null, true));
        betaMemory.getLeftTupleMemory().add((Tuple)new LeftTupleImpl(fh8, null, true));
        betaMemory.getLeftTupleMemory().add((Tuple)new LeftTupleImpl(fh9, null, true));
        TupleIndexHashTable hashTable = (TupleIndexHashTable)betaMemory.getLeftTupleMemory();
        TupleList leftTupleList = new TupleList();
        leftTupleList.add((Tuple)new LeftTupleImpl(fh10, null, true));
        hashTable.getTable()[0] = leftTupleList;
        leftTupleList = new TupleList();
        leftTupleList.add((Tuple)new LeftTupleImpl(fh11, null, true));
        leftTupleList.add((Tuple)new LeftTupleImpl(fh12, null, true));
        leftTupleList.add((Tuple)new LeftTupleImpl(fh13, null, true));
        ((TupleList)hashTable.getTable()[0]).setNext(leftTupleList);
        List tableIndexList = this.createTableIndexListForAssertion(hashTable);
        Assert.assertEquals((long)5L, (long)tableIndexList.size());
        if (this.useLambdaConstraint) {
            this.assertTableIndex(tableIndexList, 0, 0, 3);
            this.assertTableIndex(tableIndexList, 1, 49, 3);
            this.assertTableIndex(tableIndexList, 2, 51, 3);
            this.assertTableIndex(tableIndexList, 3, 60, 2);
            this.assertTableIndex(tableIndexList, 4, 61, 2);
        } else {
            this.assertTableIndex(tableIndexList, 0, 0, 3);
            this.assertTableIndex(tableIndexList, 1, 102, 2);
            this.assertTableIndex(tableIndexList, 2, 103, 2);
            this.assertTableIndex(tableIndexList, 3, 115, 3);
            this.assertTableIndex(tableIndexList, 4, 117, 3);
        }
        ArrayList<LeftTupleImpl> resultList = new ArrayList<LeftTupleImpl>();
        Iterator it = betaMemory.getLeftTupleMemory().iterator();
        LeftTupleImpl leftTuple = (LeftTupleImpl)it.next();
        while (leftTuple != null) {
            resultList.add(leftTuple);
            leftTuple = (LeftTupleImpl)it.next();
        }
        Assert.assertEquals((long)13L, (long)resultList.size());
    }

    @Test
    public void testLastBucketInTheTable() {
        Entry[] entries = new Entry[10];
        entries[0] = (Entry)Mockito.mock(TupleList.class);
        entries[5] = (Entry)Mockito.mock(TupleList.class);
        entries[9] = (Entry)Mockito.mock(TupleList.class);
        LeftTupleImpl[] tuples = new LeftTupleImpl[]{(LeftTupleImpl)Mockito.mock(LeftTupleImpl.class), (LeftTupleImpl)Mockito.mock(LeftTupleImpl.class), (LeftTupleImpl)Mockito.mock(LeftTupleImpl.class)};
        Mockito.when((Object)entries[0].getNext()).thenReturn(null);
        Mockito.when((Object)((TupleList)entries[0]).getFirst()).thenReturn((Object)tuples[0]);
        Mockito.when((Object)entries[5].getNext()).thenReturn(null);
        Mockito.when((Object)((TupleList)entries[5]).getFirst()).thenReturn((Object)tuples[1]);
        Mockito.when((Object)entries[9].getNext()).thenReturn(null);
        Mockito.when((Object)((TupleList)entries[9]).getFirst()).thenReturn((Object)tuples[2]);
        AbstractHashTable table = (AbstractHashTable)Mockito.mock(AbstractHashTable.class);
        Mockito.when((Object)table.getTable()).thenReturn((Object)entries);
        TupleIndexHashTable.FieldIndexHashTableFullIterator iterator = new TupleIndexHashTable.FieldIndexHashTableFullIterator(table);
        Assertions.assertThat((Object)iterator.next()).isSameAs((Object)tuples[0]);
        Assertions.assertThat((Object)iterator.next()).isSameAs((Object)tuples[1]);
        Assertions.assertThat((Object)iterator.next()).isSameAs((Object)tuples[2]);
        Assertions.assertThat((Object)iterator.next()).isNull();
    }
}

