/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.compiler.compiler;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import org.assertj.core.api.Assertions;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.drl.parser.DroolsParserException;
import org.junit.Assert;
import org.junit.Test;

public class CompilerPerfProfileTest {
    @Test
    public void testProfileRuns() throws Exception {
        this.build("JDT", "largeRuleNumber.drl", false);
        this.build("MVEL", "largeRuleNumberMVEL.drl", false);
        System.gc();
        Thread.sleep(100L);
        this.build("MVEL", "largeRuleNumberMVEL.drl", true);
        System.gc();
        Thread.sleep(100L);
        this.build("JDT", "largeRuleNumber.drl", true);
    }

    private void build(String msg, String resource, boolean showResults) throws DroolsParserException, IOException {
        KnowledgeBuilderImpl builder = new KnowledgeBuilderImpl();
        long start = System.currentTimeMillis();
        builder.addPackageFromDrl((Reader)new InputStreamReader(this.getClass().getResourceAsStream(resource)));
        InternalKnowledgePackage pkg = builder.getPackage("org.drools.mvel.compiler.test");
        Assert.assertFalse((boolean)builder.hasErrors());
        Assertions.assertThat((Object)pkg).isNotNull();
        if (showResults) {
            System.out.print("Time taken for " + msg + " : " + (System.currentTimeMillis() - start));
        }
    }
}

