/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.compiler.lang;

import java.util.LinkedList;
import org.antlr.runtime.RecognitionException;
import org.assertj.core.api.Assertions;
import org.drools.compiler.builder.impl.EvaluatorRegistry;
import org.drools.drl.ast.descr.ImportDescr;
import org.drools.drl.ast.descr.PackageDescr;
import org.drools.drl.ast.descr.RuleDescr;
import org.drools.drl.parser.DrlParser;
import org.drools.drl.parser.DroolsParserException;
import org.drools.drl.parser.lang.DroolsSentence;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.kie.internal.builder.conf.LanguageLevelOption;

public class DRLIncompleteCodeTest {
    @Before
    public void setup() {
        new EvaluatorRegistry();
    }

    @Test
    @Ignore
    public void testIncompleteCode1() throws DroolsParserException, RecognitionException {
        String input = "package a.b.c import a.b.c.* rule MyRule when Class ( property memberOf collexction ";
        DrlParser parser = new DrlParser(LanguageLevelOption.DRL5);
        PackageDescr descr = parser.parse(true, input);
        System.out.println(parser.getErrors());
        Assertions.assertThat((Object)descr).isNotNull();
        Assert.assertEquals((Object)"a.b.c", (Object)descr.getNamespace());
        Assert.assertEquals((Object)"a.b.c.*", (Object)((ImportDescr)descr.getImports().get(0)).getTarget());
        Assert.assertEquals((long)103L, (long)this.getLastIntegerValue(((DroolsSentence)parser.getEditorSentences().get(2)).getContent()));
    }

    @Test
    public void testIncompleteCode2() throws DroolsParserException, RecognitionException {
        String input = "rule MyRule when Class ( property memberOf collection ";
        DrlParser parser = new DrlParser(LanguageLevelOption.DRL5);
        PackageDescr descr = parser.parse(true, input);
        Assertions.assertThat((Object)descr).isNotNull();
        Assert.assertEquals((long)103L, (long)this.getLastIntegerValue(((DroolsSentence)parser.getEditorSentences().get(0)).getContent()));
    }

    @Test
    public void testIncompleteCode3() throws DroolsParserException, RecognitionException {
        String input = "rule MyRule when Class ( property > somevalue ) then end query MyQuery Class ( property == collection ) end ";
        DrlParser parser = new DrlParser(LanguageLevelOption.DRL5);
        PackageDescr descr = parser.parse(true, input);
        Assertions.assertThat((Object)descr).isNotNull();
        Assert.assertEquals((Object)"MyRule", (Object)((RuleDescr)descr.getRules().get(0)).getName());
        Assertions.assertThat((Object)descr).isNotNull();
        Assert.assertEquals((Object)"MyQuery", (Object)((RuleDescr)descr.getRules().get(1)).getName());
        Assert.assertEquals((long)1000L, (long)this.getLastIntegerValue(((DroolsSentence)parser.getEditorSentences().get(0)).getContent()));
    }

    @Test
    public void testIncompleteCode4() throws DroolsParserException, RecognitionException {
        String input = "package a.b.c import a.b.c.* rule MyRule when Class ( property == collection ) then end  query MyQuery Class ( property == collection ) end ";
        DrlParser parser = new DrlParser(LanguageLevelOption.DRL5);
        PackageDescr descr = parser.parse(true, input);
        Assert.assertEquals((Object)"a.b.c", (Object)descr.getNamespace());
        Assert.assertEquals((Object)"a.b.c.*", (Object)((ImportDescr)descr.getImports().get(0)).getTarget());
        Assertions.assertThat((Object)descr).isNotNull();
        Assert.assertEquals((Object)"MyRule", (Object)((RuleDescr)descr.getRules().get(0)).getName());
        Assertions.assertThat((Object)descr).isNotNull();
        Assert.assertEquals((Object)"MyQuery", (Object)((RuleDescr)descr.getRules().get(1)).getName());
    }

    @Test
    public void testIncompleteCode5() throws DroolsParserException, RecognitionException {
        String input = "package a.b.c import a.b.c.* rule MyRule when Class ( property memberOf collection ) then end  query MyQuery Class ( property memberOf collection ) end ";
        DrlParser parser = new DrlParser(LanguageLevelOption.DRL5);
        PackageDescr descr = parser.parse(true, input);
        Assertions.assertThat((Object)descr).isNotNull();
    }

    @Test
    public void testIncompleteCode6() throws DroolsParserException, RecognitionException {
        String input = "packe 1111.111 import a.b.c.* rule MyRule when Class ( property memberOf collection ) then end  query MyQuery Class ( property memberOf collection ) end ";
        DrlParser parser = new DrlParser(LanguageLevelOption.DRL5);
        PackageDescr descr = parser.parse(true, input);
        Assertions.assertThat((Object)descr).isNotNull();
    }

    @Test
    public void testIncompleteCode7() throws DroolsParserException, RecognitionException {
        String input = "package a.b.c imrt a.b.c.* rule MyRule when Class ( property memberOf collection ) then end  query MyQuery Class ( property memberOf collection ) end ";
        DrlParser parser = new DrlParser(LanguageLevelOption.DRL5);
        PackageDescr descr = parser.parse(true, input);
        Assertions.assertThat((Object)descr).isNotNull();
    }

    @Test
    public void testIncompleteCode8() throws DroolsParserException, RecognitionException {
        String input = "package a.b.c import a.1111.c.* rule MyRule when Class ( property memberOf collection ) then end  query MyQuery Class ( property memberOf collection ) end ";
        DrlParser parser = new DrlParser(LanguageLevelOption.DRL5);
        PackageDescr descr = parser.parse(true, input);
        System.out.println(parser.getErrors());
        Assert.assertEquals((Object)"a.b.c", (Object)descr.getNamespace());
        Assert.assertEquals((Object)true, (Object)parser.hasErrors());
    }

    @Test
    @Ignore
    public void testIncompleteCode9() throws DroolsParserException, RecognitionException {
        String input = "package a.b.c import a.b.c.* rule MyRule xxxxx Class ( property memberOf collection ) then end  query MyQuery Class ( property memberOf collection ) end ";
        DrlParser parser = new DrlParser(LanguageLevelOption.DRL5);
        PackageDescr descr = parser.parse(true, input);
        Assert.assertEquals((Object)"a.b.c", (Object)descr.getNamespace());
        Assert.assertEquals((Object)"a.b.c.*", (Object)((ImportDescr)descr.getImports().get(0)).getTarget());
        Assert.assertEquals((long)1L, (long)descr.getRules().size());
        Assert.assertEquals((Object)"MyQuery", (Object)((RuleDescr)descr.getRules().get(0)).getName());
    }

    @Test
    @Ignore
    public void testIncompleteCode10() throws DroolsParserException, RecognitionException {
        String input = "package a.b.c import a.b.c.* rule MyRule xxxxx Class ( property memberOf  query MyQuery Class ( property memberOf collection ) end ";
        DrlParser parser = new DrlParser(LanguageLevelOption.DRL5);
        PackageDescr descr = parser.parse(true, input);
        Assert.assertEquals((Object)"a.b.c", (Object)descr.getNamespace());
        Assert.assertEquals((Object)"a.b.c.*", (Object)((ImportDescr)descr.getImports().get(0)).getTarget());
        Assert.assertEquals((long)0L, (long)descr.getRules().size());
    }

    @Test
    public void testIncompleteCode11() throws DroolsParserException, RecognitionException {
        String input = "package a.b.c import a.b.c.* rule MyRule when Class ( property memberOf collection ) then end  qzzzzuery MyQuery Class ( property ";
        DrlParser parser = new DrlParser(LanguageLevelOption.DRL5);
        PackageDescr descr = parser.parse(true, input);
        Assert.assertEquals((Object)"a.b.c", (Object)descr.getNamespace());
        Assert.assertEquals((Object)"a.b.c.*", (Object)((ImportDescr)descr.getImports().get(0)).getTarget());
        Assertions.assertThat((Object)descr).isNotNull();
        Assert.assertEquals((Object)"MyRule", (Object)((RuleDescr)descr.getRules().get(0)).getName());
    }

    @Test
    public void testIncompleteCode12() throws DroolsParserException, RecognitionException {
        String input = "package a.b.c import a.b.c.* rule MyRule  when     m: Message(  )       thenend ";
        DrlParser parser = new DrlParser(LanguageLevelOption.DRL5);
        PackageDescr descr = parser.parse(true, input);
        Assertions.assertThat((Object)descr).isNotNull();
        Assert.assertEquals((Object)"a.b.c", (Object)descr.getNamespace());
        Assert.assertEquals((Object)"a.b.c.*", (Object)((ImportDescr)descr.getImports().get(0)).getTarget());
    }

    @Test
    public void testIncompleteCode13() throws DroolsParserException, RecognitionException {
        String input = "package com.sample import com.sample.DroolsTest.Message; rule \"Hello World\"  when   then     \\\" end ";
        DrlParser parser = new DrlParser(LanguageLevelOption.DRL5);
        PackageDescr descr = parser.parse(true, input);
        Assertions.assertThat((Object)descr).isNotNull();
    }

    private int getLastIntegerValue(LinkedList list) {
        int lastIntergerValue = -1;
        for (Object object : list) {
            if (!(object instanceof Integer)) continue;
            lastIntergerValue = (Integer)object;
        }
        return lastIntergerValue;
    }
}

