/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.compiler.rule.builder.dialect.java;

import java.util.ArrayList;
import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.rule.EvalCondition;
import org.drools.core.rule.Pattern;
import org.drools.core.rule.PredicateConstraint;
import org.drools.core.rule.accessor.EvalExpression;
import org.drools.core.rule.accessor.PredicateExpression;
import org.drools.core.rule.constraint.Constraint;
import org.drools.mvel.compiler.Person;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.definition.KiePackage;
import org.kie.api.runtime.KieSession;

@RunWith(value=Parameterized.class)
public class JavaDialectBinaryEqualityTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public JavaDialectBinaryEqualityTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)false);
    }

    @Test
    public void test1() {
        KiePackage pkg1 = this.getKnowledgePackage1();
        KiePackage pkg2 = this.getKnowledgePackage1();
        KiePackage pkg3 = this.getKnowledgePackage2();
        RuleImpl rule1 = ((InternalKnowledgePackage)pkg1).getRule("rule1");
        RuleImpl rule2 = ((InternalKnowledgePackage)pkg2).getRule("rule1");
        RuleImpl rule3 = ((InternalKnowledgePackage)pkg3).getRule("rule1");
        Pattern p1 = (Pattern)rule1.getLhs().getChildren().get(0);
        Constraint rvc1 = (Constraint)p1.getConstraints().get(0);
        Pattern p2 = (Pattern)rule2.getLhs().getChildren().get(0);
        Constraint rvc2 = (Constraint)p2.getConstraints().get(0);
        Assert.assertNotSame((Object)rvc1, (Object)rvc2);
        Assert.assertEquals((Object)rvc1, (Object)rvc2);
        Pattern p3 = (Pattern)rule3.getLhs().getChildren().get(0);
        Constraint rvc3 = (Constraint)p3.getConstraints().get(0);
        Assert.assertNotSame((Object)rvc1, (Object)rvc3);
        Assertions.assertThat((Object)rvc1).isNotEqualTo((Object)rvc3);
        PredicateConstraint pc1 = this.getPredicateConstraint(p1);
        PredicateExpression pe1 = pc1.getPredicateExpression();
        PredicateConstraint pc2 = this.getPredicateConstraint(p2);
        PredicateExpression pe2 = pc2.getPredicateExpression();
        Assert.assertNotSame((Object)pe1, (Object)pe2);
        Assert.assertEquals((Object)pe1, (Object)pe2);
        PredicateConstraint pc3 = this.getPredicateConstraint(p3);
        PredicateExpression pe3 = pc3.getPredicateExpression();
        Assert.assertNotSame((Object)pe1, (Object)pe3);
        Assertions.assertThat((Object)pe1).isNotEqualTo((Object)pe3);
        EvalCondition ec1 = (EvalCondition)rule1.getLhs().getChildren().get(1);
        EvalExpression ee1 = ec1.getEvalExpression();
        EvalCondition ec2 = (EvalCondition)rule2.getLhs().getChildren().get(1);
        EvalExpression ee2 = ec2.getEvalExpression();
        Assert.assertNotSame((Object)ee1, (Object)ee2);
        Assert.assertEquals((Object)ee1, (Object)ee2);
        EvalCondition ec3 = (EvalCondition)rule3.getLhs().getChildren().get(1);
        EvalExpression ee3 = ec3.getEvalExpression();
        Assert.assertNotSame((Object)ee1, (Object)ee3);
        Assertions.assertThat((Object)ee1).isNotEqualTo((Object)ee3);
        Assert.assertNotSame((Object)rule1.getConsequence(), (Object)rule2.getConsequence());
        Assert.assertEquals((Object)rule1.getConsequence(), (Object)rule2.getConsequence());
        Assert.assertNotSame((Object)rule1.getConsequence(), (Object)rule3.getConsequence());
        Assertions.assertThat((Object)rule1.getConsequence()).isNotEqualTo((Object)rule3.getConsequence());
        Assert.assertNotSame((Object)rule1.getLhs(), (Object)rule2.getLhs());
        Assert.assertEquals((Object)rule1.getLhs(), (Object)rule2.getLhs());
        Assert.assertNotSame((Object)rule1.getLhs(), (Object)rule3.getLhs());
        Assertions.assertThat((Object)rule1.getLhs()).isNotEqualTo((Object)rule3.getLhs());
    }

    private PredicateConstraint getPredicateConstraint(Pattern pattern) {
        for (Constraint constraint : pattern.getConstraints()) {
            if (!(constraint instanceof PredicateConstraint)) continue;
            return (PredicateConstraint)constraint;
        }
        return null;
    }

    public KiePackage getKnowledgePackage1() {
        String str = "";
        str = str + "package org.drools.mvel.compiler.test\n";
        str = str + "import " + Person.class.getName() + ";\n";
        str = str + "global java.util.List list\n";
        str = str + "rule rule1 dialect\"java\" \n";
        str = str + "when\n";
        str = str + "   $p : Person( age : age == ( 17 + 17 ), eval( age == 34 ))\n";
        str = str + "   eval( $p.getAge() == 34 )\n";
        str = str + "then\n";
        str = str + "   list.add( $p );\n";
        str = str + "end\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        ArrayList list = new ArrayList();
        KieSession ksession = kbase.newKieSession();
        ksession.setGlobal("list", list);
        ksession.insert((Object)new Person("darth", 34));
        ksession.fireAllRules();
        Assert.assertEquals((Object)new Person("darth", 34), list.get(0));
        return kbase.getKiePackage("org.drools.mvel.compiler.test");
    }

    public KiePackage getKnowledgePackage2() {
        String str = "";
        str = str + "package org.drools.mvel.compiler.test\n";
        str = str + "import " + Person.class.getName() + ";\n";
        str = str + "global java.util.List list\n";
        str = str + "rule rule1 dialect\"java\" \n";
        str = str + "when\n";
        str = str + "   $p : Person( age : age == ( 18 + 18 ), eval( age == 36 ))\n";
        str = str + "   eval( $p.getAge() == 36 )\n";
        str = str + "then\n";
        str = str + "   System.out.println( $p );\n";
        str = str + "   list.add( $p );\n";
        str = str + "end\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        ArrayList list = new ArrayList();
        KieSession ksession = kbase.newKieSession();
        ksession.setGlobal("list", list);
        ksession.insert((Object)new Person("darth", 36));
        ksession.fireAllRules();
        Assert.assertEquals((Object)new Person("darth", 36), list.get(0));
        return kbase.getKiePackage("org.drools.mvel.compiler.test");
    }
}

