/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.drools.core.base.ClassObjectType;
import org.drools.core.common.AgendaItem;
import org.drools.core.common.InternalAgenda;
import org.drools.core.common.InternalAgendaGroup;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.MemoryFactory;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.impl.RuleBase;
import org.drools.core.phreak.RuleAgendaItem;
import org.drools.core.phreak.RuleExecutor;
import org.drools.core.phreak.SegmentUtilities;
import org.drools.core.reteoo.BetaMemory;
import org.drools.core.reteoo.EvalConditionNode;
import org.drools.core.reteoo.ExistsNode;
import org.drools.core.reteoo.JoinNode;
import org.drools.core.reteoo.LeftInputAdapterNode;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.NotNode;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.PathMemory;
import org.drools.core.reteoo.RightInputAdapterNode;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.reteoo.RuleTerminalNode;
import org.drools.core.reteoo.SegmentMemory;
import org.drools.kiesession.session.StatefulKnowledgeSessionImpl;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.FactHandle;

@RunWith(value=Parameterized.class)
public class LinkingTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public LinkingTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    @Test
    public void testSubNetworkSharing() throws Exception {
        String str = "";
        str = str + "package org.kie \n";
        str = str + "import " + A.class.getCanonicalName() + "\n";
        str = str + "import " + B.class.getCanonicalName() + "\n";
        str = str + "import " + C.class.getCanonicalName() + "\n";
        str = str + "import " + X.class.getCanonicalName() + "\n";
        str = str + "import " + E.class.getCanonicalName() + "\n";
        str = str + "global java.util.List list \n";
        str = str + "rule rule1 when \n";
        str = str + "   A() \n";
        str = str + "   B() \n";
        str = str + "   C() \n";
        str = str + "   X() \n";
        str = str + "then \n";
        str = str + "end \n";
        str = str + "rule rule2 when \n";
        str = str + "   A() \n";
        str = str + "   exists( B() and C() ) \n";
        str = str + "   X() \n";
        str = str + "then \n";
        str = str + "end \n";
        str = str + "rule rule3 when \n";
        str = str + "   A() \n";
        str = str + "   exists( B() and C() and X() ) \n";
        str = str + "   E() \n";
        str = str + "then \n";
        str = str + "end \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        ObjectTypeNode node = LinkingTest.getObjectTypeNode(kbase, A.class);
        StatefulKnowledgeSessionImpl wm = (StatefulKnowledgeSessionImpl)kbase.newKieSession();
        LeftInputAdapterNode liaNode = (LeftInputAdapterNode)node.getObjectSinkPropagator().getSinks()[0];
        Assert.assertEquals((long)3L, (long)liaNode.getSinkPropagator().size());
        ExistsNode existsNode2 = (ExistsNode)liaNode.getSinkPropagator().getSinks()[1];
        ExistsNode existsNode3 = (ExistsNode)liaNode.getSinkPropagator().getSinks()[2];
        JoinNode joinNodeB = (JoinNode)liaNode.getSinkPropagator().getSinks()[0];
        Assert.assertSame((Object)joinNodeB.getRightInput(), (Object)LinkingTest.getObjectTypeNode(kbase, B.class));
        JoinNode joinNodeC = (JoinNode)joinNodeB.getSinkPropagator().getSinks()[0];
        Assert.assertSame((Object)joinNodeC.getRightInput(), (Object)LinkingTest.getObjectTypeNode(kbase, C.class));
        Assert.assertEquals((long)2L, (long)joinNodeC.getSinkPropagator().size());
        JoinNode joinNodeD = (JoinNode)joinNodeC.getSinkPropagator().getSinks()[0];
        Assert.assertSame((Object)joinNodeD.getRightInput(), (Object)LinkingTest.getObjectTypeNode(kbase, X.class));
        Assert.assertEquals((long)2L, (long)joinNodeD.getSinkPropagator().size());
        Assert.assertSame((Object)existsNode2, (Object)((RightInputAdapterNode)joinNodeC.getSinkPropagator().getSinks()[1]).getObjectSinkPropagator().getSinks()[0]);
        Assert.assertSame((Object)existsNode3, (Object)((RightInputAdapterNode)joinNodeD.getSinkPropagator().getSinks()[1]).getObjectSinkPropagator().getSinks()[0]);
    }

    @Test
    public void testSubNetworkSharingMemories() throws Exception {
        String str = "";
        str = str + "package org.kie \n";
        str = str + "import " + A.class.getCanonicalName() + "\n";
        str = str + "import " + B.class.getCanonicalName() + "\n";
        str = str + "import " + C.class.getCanonicalName() + "\n";
        str = str + "import " + X.class.getCanonicalName() + "\n";
        str = str + "import " + E.class.getCanonicalName() + "\n";
        str = str + "global java.util.List list \n";
        str = str + "rule rule1 when \n";
        str = str + "   A() \n";
        str = str + "   B() \n";
        str = str + "   C() \n";
        str = str + "   X() \n";
        str = str + "then \n";
        str = str + "end \n";
        str = str + "rule rule2 when \n";
        str = str + "   A() \n";
        str = str + "   exists( B() and C() ) \n";
        str = str + "   X() \n";
        str = str + "then \n";
        str = str + "end \n";
        str = str + "rule rule3 when \n";
        str = str + "   A() \n";
        str = str + "   exists( B() and C() and X() ) \n";
        str = str + "   E() \n";
        str = str + "then \n";
        str = str + "end \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        ObjectTypeNode node = LinkingTest.getObjectTypeNode(kbase, A.class);
        StatefulKnowledgeSessionImpl wm = (StatefulKnowledgeSessionImpl)kbase.newKieSession();
        LeftInputAdapterNode liaNodeA = (LeftInputAdapterNode)node.getObjectSinkPropagator().getSinks()[0];
        ExistsNode existsNode2 = (ExistsNode)liaNodeA.getSinkPropagator().getSinks()[1];
        ExistsNode existsNode3 = (ExistsNode)liaNodeA.getSinkPropagator().getSinks()[2];
        JoinNode joinNodeB = (JoinNode)liaNodeA.getSinkPropagator().getSinks()[0];
        JoinNode joinNodeC = (JoinNode)joinNodeB.getSinkPropagator().getSinks()[0];
        JoinNode joinNodeD1 = (JoinNode)joinNodeC.getSinkPropagator().getSinks()[0];
        JoinNode joinNodeD2 = (JoinNode)existsNode2.getSinkPropagator().getSinks()[0];
        JoinNode joinNodeE = (JoinNode)existsNode3.getSinkPropagator().getSinks()[0];
        RuleTerminalNode rtn1 = (RuleTerminalNode)joinNodeD1.getSinkPropagator().getSinks()[0];
        RuleTerminalNode rtn2 = (RuleTerminalNode)joinNodeD2.getSinkPropagator().getSinks()[0];
        RuleTerminalNode rtn3 = (RuleTerminalNode)joinNodeE.getSinkPropagator().getSinks()[0];
        FactHandle fha = wm.insert((Object)new A());
        wm.insert((Object)new B());
        wm.insert((Object)new C());
        wm.insert((Object)new X());
        wm.flushPropagations();
        Object bm = null;
        LeftInputAdapterNode.LiaNodeMemory liam = (LeftInputAdapterNode.LiaNodeMemory)wm.getNodeMemory((MemoryFactory)liaNodeA);
        BetaMemory bm1 = (BetaMemory)wm.getNodeMemory((MemoryFactory)joinNodeB);
        BetaMemory bm2 = (BetaMemory)wm.getNodeMemory((MemoryFactory)joinNodeC);
        BetaMemory bm3 = (BetaMemory)wm.getNodeMemory((MemoryFactory)joinNodeD1);
        Assert.assertEquals((long)1L, (long)liam.getNodePosMaskBit());
        Assert.assertEquals((long)1L, (long)bm1.getNodePosMaskBit());
        Assert.assertEquals((long)2L, (long)bm2.getNodePosMaskBit());
        Assert.assertEquals((long)1L, (long)bm3.getNodePosMaskBit());
        Assert.assertNotSame((Object)liam.getSegmentMemory(), (Object)bm1.getSegmentMemory());
        Assert.assertSame((Object)bm1.getSegmentMemory(), (Object)bm2.getSegmentMemory());
        Assert.assertNotSame((Object)bm2.getSegmentMemory(), (Object)bm3.getSegmentMemory());
        BetaMemory bm4 = (BetaMemory)wm.getNodeMemory((MemoryFactory)existsNode2);
        BetaMemory bm5 = (BetaMemory)wm.getNodeMemory((MemoryFactory)joinNodeD2);
        Assert.assertEquals((long)1L, (long)bm4.getNodePosMaskBit());
        Assert.assertEquals((long)2L, (long)bm5.getNodePosMaskBit());
        Assert.assertSame((Object)bm4.getSegmentMemory(), (Object)bm5.getSegmentMemory());
        PathMemory rs1 = (PathMemory)wm.getNodeMemory((MemoryFactory)rtn1);
        PathMemory rs2 = (PathMemory)wm.getNodeMemory((MemoryFactory)rtn2);
        PathMemory rs3 = (PathMemory)wm.getNodeMemory((MemoryFactory)rtn3);
        Assert.assertTrue((boolean)rs1.isRuleLinked());
        Assert.assertTrue((boolean)rs2.isRuleLinked());
        Assert.assertFalse((boolean)rs3.isRuleLinked());
        wm.insert((Object)new E());
        wm.flushPropagations();
        BetaMemory bm6 = (BetaMemory)wm.getNodeMemory((MemoryFactory)existsNode3);
        BetaMemory bm7 = (BetaMemory)wm.getNodeMemory((MemoryFactory)joinNodeE);
        Assert.assertEquals((long)1L, (long)bm6.getNodePosMaskBit());
        Assert.assertEquals((long)2L, (long)bm7.getNodePosMaskBit());
        Assert.assertSame((Object)bm6.getSegmentMemory(), (Object)bm7.getSegmentMemory());
        Assert.assertTrue((boolean)rs1.isRuleLinked());
        Assert.assertTrue((boolean)rs2.isRuleLinked());
        Assert.assertTrue((boolean)rs3.isRuleLinked());
        wm.retract(fha);
        wm.fireAllRules();
        Assert.assertFalse((boolean)rs1.isRuleLinked());
        Assert.assertFalse((boolean)rs2.isRuleLinked());
        Assert.assertFalse((boolean)rs3.isRuleLinked());
    }

    @Test
    public void testSubNetworkRiaLinking() throws Exception {
        String str = "";
        str = str + "package org.kie \n";
        str = str + "import " + A.class.getCanonicalName() + "\n";
        str = str + "import " + B.class.getCanonicalName() + "\n";
        str = str + "import " + C.class.getCanonicalName() + "\n";
        str = str + "import " + X.class.getCanonicalName() + "\n";
        str = str + "import " + E.class.getCanonicalName() + "\n";
        str = str + "global java.util.List list \n";
        str = str + "rule rule1 when \n";
        str = str + "   A() \n";
        str = str + "   B() \n";
        str = str + "   exists( C() and X() ) \n";
        str = str + "   E() \n";
        str = str + "then \n";
        str = str + "end \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        ObjectTypeNode node = LinkingTest.getObjectTypeNode(kbase, A.class);
        StatefulKnowledgeSessionImpl wm = (StatefulKnowledgeSessionImpl)kbase.newKieSession();
        LeftInputAdapterNode liaNode = (LeftInputAdapterNode)node.getObjectSinkPropagator().getSinks()[0];
        Assert.assertEquals((long)1L, (long)liaNode.getSinkPropagator().size());
        JoinNode bNode = (JoinNode)liaNode.getSinkPropagator().getSinks()[0];
        Assert.assertEquals((long)2L, (long)bNode.getSinkPropagator().size());
        ExistsNode exists1n = (ExistsNode)bNode.getSinkPropagator().getSinks()[1];
        JoinNode cNode = (JoinNode)bNode.getSinkPropagator().getSinks()[0];
        JoinNode dNode = (JoinNode)cNode.getSinkPropagator().getSinks()[0];
        Assert.assertEquals((long)1L, (long)dNode.getSinkPropagator().size());
        RightInputAdapterNode riaNode1 = (RightInputAdapterNode)dNode.getSinkPropagator().getSinks()[0];
        JoinNode eNode = (JoinNode)exists1n.getSinkPropagator().getSinks()[0];
        RuleTerminalNode rtn = (RuleTerminalNode)eNode.getSinkPropagator().getSinks()[0];
        SegmentUtilities.getOrCreateSegmentMemory((LeftTupleSource)exists1n, (ReteEvaluator)wm);
        BetaMemory existsBm = (BetaMemory)wm.getNodeMemory((MemoryFactory)exists1n);
        Assert.assertEquals((long)0L, (long)existsBm.getSegmentMemory().getLinkedNodeMask());
        FactHandle fhc = wm.insert((Object)new C());
        FactHandle fhd = wm.insert((Object)new X());
        wm.flushPropagations();
        Assert.assertEquals((long)1L, (long)existsBm.getSegmentMemory().getLinkedNodeMask());
        wm.retract(fhd);
        wm.flushPropagations();
        Assert.assertEquals((long)0L, (long)existsBm.getSegmentMemory().getLinkedNodeMask());
        PathMemory rs = (PathMemory)wm.getNodeMemory((MemoryFactory)rtn);
        Assert.assertFalse((boolean)rs.isRuleLinked());
        wm.insert((Object)new A());
        wm.flushPropagations();
        Assert.assertFalse((boolean)rs.isRuleLinked());
        wm.insert((Object)new B());
        wm.flushPropagations();
        Assert.assertFalse((boolean)rs.isRuleLinked());
        wm.insert((Object)new E());
        wm.flushPropagations();
        Assert.assertFalse((boolean)rs.isRuleLinked());
        wm.insert((Object)new X());
        wm.flushPropagations();
        Assert.assertTrue((boolean)rs.isRuleLinked());
        wm.retract(fhc);
        wm.flushPropagations();
        Assert.assertFalse((boolean)rs.isRuleLinked());
        wm.insert((Object)new C());
        wm.flushPropagations();
        Assert.assertTrue((boolean)rs.isRuleLinked());
    }

    @Test
    public void testNonReactiveSubNetworkInShareMasks() throws Exception {
        String str = "";
        str = str + "package org.kie \n";
        str = str + "import " + A.class.getCanonicalName() + "\n";
        str = str + "import " + B.class.getCanonicalName() + "\n";
        str = str + "import " + C.class.getCanonicalName() + "\n";
        str = str + "import " + X.class.getCanonicalName() + "\n";
        str = str + "import " + E.class.getCanonicalName() + "\n";
        str = str + "import " + F.class.getCanonicalName() + "\n";
        str = str + "import " + G.class.getCanonicalName() + "\n";
        str = str + "global java.util.List list \n";
        str = str + "rule rule1 when \n";
        str = str + "   A() \n";
        str = str + "   exists( B() and C() ) \n";
        str = str + "   exists( eval(1==1) ) \n";
        str = str + "   X() \n";
        str = str + "then \n";
        str = str + "end \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        ObjectTypeNode node = LinkingTest.getObjectTypeNode(kbase, A.class);
        StatefulKnowledgeSessionImpl wm = (StatefulKnowledgeSessionImpl)kbase.newKieSession();
        LeftInputAdapterNode liaNode = (LeftInputAdapterNode)node.getObjectSinkPropagator().getSinks()[0];
        Assert.assertEquals((long)2L, (long)liaNode.getSinkPropagator().size());
        JoinNode bNode = (JoinNode)liaNode.getSinkPropagator().getSinks()[0];
        JoinNode cNode = (JoinNode)bNode.getSinkPropagator().getSinks()[0];
        ExistsNode exists1n = (ExistsNode)liaNode.getSinkPropagator().getSinks()[1];
        EvalConditionNode evalNode = (EvalConditionNode)exists1n.getSinkPropagator().getSinks()[0];
        ExistsNode exists2n = (ExistsNode)exists1n.getSinkPropagator().getSinks()[1];
        JoinNode dNode = (JoinNode)exists2n.getSinkPropagator().getSinks()[0];
        RuleTerminalNode rtn = (RuleTerminalNode)dNode.getSinkPropagator().getSinks()[0];
        wm.insert((Object)new A());
        PathMemory pmem = (PathMemory)wm.getNodeMemory((MemoryFactory)rtn);
        Assert.assertEquals((long)3L, (long)pmem.getSegmentMemories().length);
        Assert.assertEquals((long)7L, (long)pmem.getAllLinkedMaskTest());
        BetaMemory bm = (BetaMemory)wm.getNodeMemory((MemoryFactory)dNode);
        Assert.assertNull((Object)bm.getSegmentMemory());
        wm.insert((Object)new X());
        wm.flushPropagations();
        Assert.assertEquals((long)2L, (long)bm.getSegmentMemory().getAllLinkedMaskTest());
    }

    @Test
    public void testNonReactiveSubNetworkOwnSegmentMasks() throws Exception {
        String str = "";
        str = str + "package org.kie \n";
        str = str + "import " + A.class.getCanonicalName() + "\n";
        str = str + "import " + B.class.getCanonicalName() + "\n";
        str = str + "import " + C.class.getCanonicalName() + "\n";
        str = str + "import " + X.class.getCanonicalName() + "\n";
        str = str + "import " + E.class.getCanonicalName() + "\n";
        str = str + "import " + F.class.getCanonicalName() + "\n";
        str = str + "import " + G.class.getCanonicalName() + "\n";
        str = str + "global java.util.List list \n";
        str = str + "rule rule1 when \n";
        str = str + "   A() \n";
        str = str + "   exists( B() and C() ) \n";
        str = str + "   exists( eval(1==1) ) \n";
        str = str + "   X() \n";
        str = str + "then \n";
        str = str + "end \n";
        str = str + "rule rule2 when \n";
        str = str + "   A() \n";
        str = str + "   exists( B() and C() ) \n";
        str = str + "   exists( eval(1==1) ) \n";
        str = str + "   E() \n";
        str = str + "then \n";
        str = str + "end \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        ObjectTypeNode node = LinkingTest.getObjectTypeNode(kbase, A.class);
        StatefulKnowledgeSessionImpl wm = (StatefulKnowledgeSessionImpl)kbase.newKieSession();
        LeftInputAdapterNode liaNode = (LeftInputAdapterNode)node.getObjectSinkPropagator().getSinks()[0];
        Assert.assertEquals((long)2L, (long)liaNode.getSinkPropagator().size());
        JoinNode bNode = (JoinNode)liaNode.getSinkPropagator().getSinks()[0];
        JoinNode cNode = (JoinNode)bNode.getSinkPropagator().getSinks()[0];
        ExistsNode exists1n = (ExistsNode)liaNode.getSinkPropagator().getSinks()[1];
        EvalConditionNode evalNode = (EvalConditionNode)exists1n.getSinkPropagator().getSinks()[0];
        ExistsNode exists2n = (ExistsNode)exists1n.getSinkPropagator().getSinks()[1];
        JoinNode dNode = (JoinNode)exists2n.getSinkPropagator().getSinks()[0];
        RuleTerminalNode rtn = (RuleTerminalNode)dNode.getSinkPropagator().getSinks()[0];
        wm.insert((Object)new A());
        PathMemory pmem = (PathMemory)wm.getNodeMemory((MemoryFactory)rtn);
        Assert.assertEquals((long)4L, (long)pmem.getSegmentMemories().length);
        Assert.assertEquals((long)11L, (long)pmem.getAllLinkedMaskTest());
        RightInputAdapterNode.RiaNodeMemory riaMem = (RightInputAdapterNode.RiaNodeMemory)wm.getNodeMemory((MemoryFactory)exists1n.getRightInput());
        Assert.assertEquals((long)2L, (long)riaMem.getRiaPathMemory().getAllLinkedMaskTest());
        wm.insert((Object)new B());
        wm.insert((Object)new C());
        Assert.assertEquals((long)2L, (long)riaMem.getRiaPathMemory().getSegmentMemories().length);
        riaMem = (RightInputAdapterNode.RiaNodeMemory)wm.getNodeMemory((MemoryFactory)exists2n.getRightInput());
        Assert.assertEquals((long)0L, (long)riaMem.getRiaPathMemory().getAllLinkedMaskTest());
    }

    @Test
    public void testNestedSubNetwork() throws Exception {
        String str = "";
        str = str + "package org.kie \n";
        str = str + "import " + A.class.getCanonicalName() + "\n";
        str = str + "import " + B.class.getCanonicalName() + "\n";
        str = str + "import " + C.class.getCanonicalName() + "\n";
        str = str + "import " + X.class.getCanonicalName() + "\n";
        str = str + "import " + E.class.getCanonicalName() + "\n";
        str = str + "import " + F.class.getCanonicalName() + "\n";
        str = str + "import " + G.class.getCanonicalName() + "\n";
        str = str + "global java.util.List list \n";
        str = str + "rule rule1 when \n";
        str = str + "   A() \n";
        str = str + "   B() \n";
        str = str + "   exists( C() and X() and exists( E() and F() ) ) \n";
        str = str + "   G() \n";
        str = str + "then \n";
        str = str + "end \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        ObjectTypeNode node = LinkingTest.getObjectTypeNode(kbase, A.class);
        StatefulKnowledgeSessionImpl wm = (StatefulKnowledgeSessionImpl)kbase.newKieSession();
        LeftInputAdapterNode liaNode = (LeftInputAdapterNode)node.getObjectSinkPropagator().getSinks()[0];
        Assert.assertEquals((long)1L, (long)liaNode.getSinkPropagator().size());
        JoinNode bNode = (JoinNode)liaNode.getSinkPropagator().getSinks()[0];
        Assert.assertEquals((long)2L, (long)bNode.getSinkPropagator().size());
        ExistsNode exists1n = (ExistsNode)bNode.getSinkPropagator().getSinks()[1];
        JoinNode cNode = (JoinNode)bNode.getSinkPropagator().getSinks()[0];
        JoinNode dNode = (JoinNode)cNode.getSinkPropagator().getSinks()[0];
        Assert.assertEquals((long)2L, (long)dNode.getSinkPropagator().size());
        ExistsNode exists2n = (ExistsNode)dNode.getSinkPropagator().getSinks()[1];
        JoinNode eNode = (JoinNode)dNode.getSinkPropagator().getSinks()[0];
        JoinNode fNode = (JoinNode)eNode.getSinkPropagator().getSinks()[0];
        RightInputAdapterNode riaNode2 = (RightInputAdapterNode)fNode.getSinkPropagator().getSinks()[0];
        Assert.assertEquals((Object)exists2n, (Object)riaNode2.getObjectSinkPropagator().getSinks()[0]);
        RightInputAdapterNode riaNode1 = (RightInputAdapterNode)exists2n.getSinkPropagator().getSinks()[0];
        Assert.assertEquals((Object)exists1n, (Object)riaNode1.getObjectSinkPropagator().getSinks()[0]);
        JoinNode gNode = (JoinNode)exists1n.getSinkPropagator().getSinks()[0];
        RuleTerminalNode rtn = (RuleTerminalNode)gNode.getSinkPropagator().getSinks()[0];
        wm.insert((Object)new A());
        wm.insert((Object)new B());
        wm.insert((Object)new C());
        wm.insert((Object)new X());
        wm.insert((Object)new F());
        wm.insert((Object)new G());
        PathMemory rs = (PathMemory)wm.getNodeMemory((MemoryFactory)rtn);
        Assert.assertFalse((boolean)rs.isRuleLinked());
        FactHandle fhE1 = wm.insert((Object)new E());
        FactHandle fhE2 = wm.insert((Object)new E());
        wm.flushPropagations();
        Assert.assertTrue((boolean)rs.isRuleLinked());
        wm.retract(fhE1);
        wm.flushPropagations();
        Assert.assertTrue((boolean)rs.isRuleLinked());
        wm.retract(fhE2);
        wm.flushPropagations();
        Assert.assertFalse((boolean)rs.isRuleLinked());
    }

    @Test
    public void testNestedSubNetworkMasks() throws Exception {
        String str = "";
        str = str + "package org.kie \n";
        str = str + "import " + A.class.getCanonicalName() + "\n";
        str = str + "import " + B.class.getCanonicalName() + "\n";
        str = str + "import " + C.class.getCanonicalName() + "\n";
        str = str + "import " + X.class.getCanonicalName() + "\n";
        str = str + "import " + E.class.getCanonicalName() + "\n";
        str = str + "import " + F.class.getCanonicalName() + "\n";
        str = str + "import " + G.class.getCanonicalName() + "\n";
        str = str + "global java.util.List list \n";
        str = str + "rule rule1 when \n";
        str = str + "   A() \n";
        str = str + "   B() \n";
        str = str + "   exists( C() and X() and exists( E() and F() ) ) \n";
        str = str + "   G() \n";
        str = str + "then \n";
        str = str + "end \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        ObjectTypeNode node = LinkingTest.getObjectTypeNode(kbase, A.class);
        StatefulKnowledgeSessionImpl wm = (StatefulKnowledgeSessionImpl)kbase.newKieSession();
        LeftInputAdapterNode liaNode = (LeftInputAdapterNode)node.getObjectSinkPropagator().getSinks()[0];
        JoinNode bNode = (JoinNode)liaNode.getSinkPropagator().getSinks()[0];
        ExistsNode exists1n = (ExistsNode)bNode.getSinkPropagator().getSinks()[1];
        JoinNode cNode = (JoinNode)bNode.getSinkPropagator().getSinks()[0];
        JoinNode dNode = (JoinNode)cNode.getSinkPropagator().getSinks()[0];
        ExistsNode exists2n = (ExistsNode)dNode.getSinkPropagator().getSinks()[1];
        JoinNode eNode = (JoinNode)dNode.getSinkPropagator().getSinks()[0];
        JoinNode fNode = (JoinNode)eNode.getSinkPropagator().getSinks()[0];
        RightInputAdapterNode riaNode2 = (RightInputAdapterNode)fNode.getSinkPropagator().getSinks()[0];
        RightInputAdapterNode riaNode1 = (RightInputAdapterNode)exists2n.getSinkPropagator().getSinks()[0];
        JoinNode gNode = (JoinNode)exists1n.getSinkPropagator().getSinks()[0];
        RuleTerminalNode rtn = (RuleTerminalNode)gNode.getSinkPropagator().getSinks()[0];
        wm.insert((Object)new A());
        wm.insert((Object)new B());
        wm.insert((Object)new C());
        wm.insert((Object)new X());
        wm.insert((Object)new G());
        wm.flushPropagations();
        LeftInputAdapterNode.LiaNodeMemory liaMem = (LeftInputAdapterNode.LiaNodeMemory)wm.getNodeMemory((MemoryFactory)liaNode);
        BetaMemory bMem = (BetaMemory)wm.getNodeMemory((MemoryFactory)bNode);
        BetaMemory exists1Mem = (BetaMemory)wm.getNodeMemory((MemoryFactory)exists1n);
        BetaMemory cMem = (BetaMemory)wm.getNodeMemory((MemoryFactory)cNode);
        BetaMemory dMem = (BetaMemory)wm.getNodeMemory((MemoryFactory)dNode);
        BetaMemory exists2Mem = (BetaMemory)wm.getNodeMemory((MemoryFactory)exists2n);
        BetaMemory eMem = (BetaMemory)wm.getNodeMemory((MemoryFactory)eNode);
        BetaMemory fMem = (BetaMemory)wm.getNodeMemory((MemoryFactory)fNode);
        BetaMemory gMem = (BetaMemory)wm.getNodeMemory((MemoryFactory)gNode);
        RightInputAdapterNode.RiaNodeMemory riaMem1 = (RightInputAdapterNode.RiaNodeMemory)wm.getNodeMemory((MemoryFactory)riaNode1);
        RightInputAdapterNode.RiaNodeMemory riaMem2 = (RightInputAdapterNode.RiaNodeMemory)wm.getNodeMemory((MemoryFactory)riaNode2);
        PathMemory rs = (PathMemory)wm.getNodeMemory((MemoryFactory)rtn);
        Assert.assertFalse((boolean)rs.isRuleLinked());
        Assert.assertSame((Object)liaMem.getSegmentMemory(), (Object)bMem.getSegmentMemory());
        Assert.assertNotSame((Object)bMem.getSegmentMemory(), (Object)exists1Mem.getSegmentMemory());
        Assert.assertSame((Object)exists1Mem.getSegmentMemory(), (Object)gMem.getSegmentMemory());
        Assert.assertEquals((long)2L, (long)rs.getSegmentMemories().length);
        Assert.assertEquals((long)3L, (long)rs.getAllLinkedMaskTest());
        Assert.assertEquals((long)1L, (long)rs.getLinkedSegmentMask());
        Assert.assertEquals((long)3L, (long)liaMem.getSegmentMemory().getAllLinkedMaskTest());
        Assert.assertEquals((long)1L, (long)liaMem.getNodePosMaskBit());
        Assert.assertEquals((long)2L, (long)bMem.getNodePosMaskBit());
        Assert.assertEquals((long)3L, (long)exists1Mem.getSegmentMemory().getAllLinkedMaskTest());
        Assert.assertEquals((long)1L, (long)exists1Mem.getNodePosMaskBit());
        Assert.assertEquals((long)2L, (long)gMem.getNodePosMaskBit());
        Assert.assertSame((Object)dMem.getSegmentMemory(), (Object)cMem.getSegmentMemory());
        Assert.assertNotSame((Object)exists2Mem.getSegmentMemory(), (Object)dMem.getSegmentMemory());
        Assert.assertEquals((long)3L, (long)riaMem1.getRiaPathMemory().getSegmentMemories().length);
        Assert.assertEquals(null, (Object)riaMem1.getRiaPathMemory().getSegmentMemories()[0]);
        Assert.assertEquals((Object)dMem.getSegmentMemory(), (Object)riaMem1.getRiaPathMemory().getSegmentMemories()[1]);
        Assert.assertEquals((long)1L, (long)dMem.getSegmentMemory().getPathMemories().size());
        Assert.assertSame((Object)riaMem1.getRiaPathMemory(), cMem.getSegmentMemory().getPathMemories().get(0));
        Assert.assertEquals((long)3L, (long)cMem.getSegmentMemory().getAllLinkedMaskTest());
        Assert.assertEquals((long)3L, (long)cMem.getSegmentMemory().getLinkedNodeMask());
        Assert.assertEquals((long)1L, (long)cMem.getNodePosMaskBit());
        Assert.assertEquals((long)2L, (long)dMem.getNodePosMaskBit());
        Assert.assertEquals((long)0L, (long)exists2Mem.getNodePosMaskBit());
        FactHandle fhE1 = wm.insert((Object)new E());
        FactHandle fhF1 = wm.insert((Object)new F());
        wm.flushPropagations();
        Assert.assertEquals((long)1L, (long)exists2Mem.getNodePosMaskBit());
        Assert.assertEquals((long)6L, (long)riaMem1.getRiaPathMemory().getAllLinkedMaskTest());
        Assert.assertEquals((long)6L, (long)riaMem1.getRiaPathMemory().getLinkedSegmentMask());
        wm.delete(fhE1);
        wm.delete(fhF1);
        wm.flushPropagations();
        Assert.assertEquals((long)2L, (long)riaMem1.getRiaPathMemory().getLinkedSegmentMask());
        Assertions.assertThat((Object)eMem.getSegmentMemory()).isNotNull();
        Assert.assertSame((Object)fMem.getSegmentMemory(), (Object)eMem.getSegmentMemory());
        Assert.assertEquals((long)3L, (long)riaMem2.getRiaPathMemory().getSegmentMemories().length);
        Assert.assertEquals(null, (Object)riaMem2.getRiaPathMemory().getSegmentMemories()[0]);
        Assert.assertEquals(null, (Object)riaMem2.getRiaPathMemory().getSegmentMemories()[1]);
        Assert.assertEquals((Object)fMem.getSegmentMemory(), (Object)riaMem2.getRiaPathMemory().getSegmentMemories()[2]);
        Assert.assertSame((Object)riaMem2.getRiaPathMemory(), eMem.getSegmentMemory().getPathMemories().get(0));
        Assert.assertEquals((long)3L, (long)eMem.getSegmentMemory().getAllLinkedMaskTest());
        Assert.assertEquals((long)0L, (long)eMem.getSegmentMemory().getLinkedNodeMask());
        Assert.assertEquals((long)4L, (long)riaMem2.getRiaPathMemory().getAllLinkedMaskTest());
        Assert.assertEquals((long)0L, (long)riaMem2.getRiaPathMemory().getLinkedSegmentMask());
        fhE1 = wm.insert((Object)new E());
        wm.insert((Object)new F());
        wm.flushPropagations();
        Assert.assertTrue((boolean)rs.isRuleLinked());
        Assert.assertEquals((long)3L, (long)rs.getAllLinkedMaskTest());
        Assert.assertEquals((long)3L, (long)rs.getLinkedSegmentMask());
        Assert.assertEquals((long)3L, (long)cMem.getSegmentMemory().getAllLinkedMaskTest());
        Assert.assertEquals((long)3L, (long)cMem.getSegmentMemory().getLinkedNodeMask());
        Assert.assertEquals((long)6L, (long)riaMem1.getRiaPathMemory().getAllLinkedMaskTest());
        Assert.assertEquals((long)6L, (long)riaMem1.getRiaPathMemory().getLinkedSegmentMask());
        Assert.assertEquals((long)3L, (long)eMem.getSegmentMemory().getAllLinkedMaskTest());
        Assert.assertEquals((long)3L, (long)eMem.getSegmentMemory().getLinkedNodeMask());
        Assert.assertEquals((long)4L, (long)riaMem2.getRiaPathMemory().getAllLinkedMaskTest());
        Assert.assertEquals((long)4L, (long)riaMem2.getRiaPathMemory().getLinkedSegmentMask());
        wm.delete(fhE1);
        wm.flushPropagations();
        Assert.assertFalse((boolean)rs.isRuleLinked());
        Assert.assertEquals((long)3L, (long)cMem.getSegmentMemory().getLinkedNodeMask());
        Assert.assertEquals((long)2L, (long)riaMem1.getRiaPathMemory().getLinkedSegmentMask());
        Assert.assertEquals((long)2L, (long)eMem.getSegmentMemory().getLinkedNodeMask());
        Assert.assertEquals((long)0L, (long)riaMem2.getRiaPathMemory().getLinkedSegmentMask());
    }

    @Test
    public void testJoinNodes() throws Exception {
        int i;
        String str = "";
        str = str + "package org.kie \n";
        str = str + "import " + A.class.getCanonicalName() + "\n";
        str = str + "import " + B.class.getCanonicalName() + "\n";
        str = str + "import " + C.class.getCanonicalName() + "\n";
        str = str + "import " + X.class.getCanonicalName() + "\n";
        str = str + "import " + E.class.getCanonicalName() + "\n";
        str = str + "import " + F.class.getCanonicalName() + "\n";
        str = str + "import " + G.class.getCanonicalName() + "\n";
        str = str + "global java.util.List list \n";
        str = str + "rule rule1 when \n";
        str = str + "   $a : A() \n";
        str = str + "   $b : B() \n";
        str = str + "   $c : C() \n";
        str = str + "then \n";
        str = str + "  list.add( $a.getValue() + \":\"+ $b.getValue() + \":\" + $c.getValue() ); \n";
        str = str + "end \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        ObjectTypeNode aotn = LinkingTest.getObjectTypeNode(kbase, A.class);
        ObjectTypeNode botn = LinkingTest.getObjectTypeNode(kbase, B.class);
        ObjectTypeNode cotn = LinkingTest.getObjectTypeNode(kbase, C.class);
        InternalWorkingMemory wm = (InternalWorkingMemory)kbase.newKieSession();
        ArrayList list = new ArrayList();
        wm.setGlobal("list", list);
        for (i = 0; i < 3; ++i) {
            wm.insert((Object)new A(i));
        }
        for (i = 0; i < 3; ++i) {
            wm.insert((Object)new B(i));
        }
        for (i = 0; i < 29; ++i) {
            wm.insert((Object)new C(i));
        }
        wm.flushPropagations();
        LeftInputAdapterNode aNode = (LeftInputAdapterNode)aotn.getObjectSinkPropagator().getSinks()[0];
        JoinNode bNode = (JoinNode)aNode.getSinkPropagator().getSinks()[0];
        JoinNode cNode = (JoinNode)bNode.getSinkPropagator().getSinks()[0];
        LeftInputAdapterNode.LiaNodeMemory amem = (LeftInputAdapterNode.LiaNodeMemory)wm.getNodeMemory((MemoryFactory)aNode);
        BetaMemory bmem = (BetaMemory)wm.getNodeMemory((MemoryFactory)bNode);
        BetaMemory cmem = (BetaMemory)wm.getNodeMemory((MemoryFactory)cNode);
        Assertions.assertThat((Object)((LeftTuple)amem.getSegmentMemory().getStagedLeftTuples().getInsertFirst())).isNotNull();
        Assertions.assertThat((Object)((LeftTuple)amem.getSegmentMemory().getStagedLeftTuples().getInsertFirst()).getStagedNext()).isNotNull();
        Assertions.assertThat((Object)((LeftTuple)amem.getSegmentMemory().getStagedLeftTuples().getInsertFirst()).getStagedNext().getStagedNext()).isNotNull();
        Assert.assertNull((Object)((LeftTuple)amem.getSegmentMemory().getStagedLeftTuples().getInsertFirst()).getStagedNext().getStagedNext().getStagedNext());
        Assertions.assertThat((Object)((RightTuple)bmem.getStagedRightTuples().getInsertFirst())).isNotNull();
        Assertions.assertThat((Object)((RightTuple)bmem.getStagedRightTuples().getInsertFirst()).getStagedNext()).isNotNull();
        Assertions.assertThat((Object)((RightTuple)bmem.getStagedRightTuples().getInsertFirst()).getStagedNext().getStagedNext()).isNotNull();
        Assert.assertNull((Object)((RightTuple)bmem.getStagedRightTuples().getInsertFirst()).getStagedNext().getStagedNext().getStagedNext());
        wm.fireAllRules();
        Assert.assertNull((Object)amem.getSegmentMemory().getStagedLeftTuples().getInsertFirst());
        Assert.assertNull((Object)bmem.getStagedRightTuples().getInsertFirst());
        Assert.assertNull((Object)cmem.getStagedRightTuples().getInsertFirst());
        Assert.assertEquals((long)261L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("2:2:14"));
        Assert.assertTrue((boolean)list.contains("1:0:6"));
        Assert.assertTrue((boolean)list.contains("0:1:1"));
        Assert.assertTrue((boolean)list.contains("2:2:14"));
        Assert.assertTrue((boolean)list.contains("0:0:25"));
    }

    @Test
    public void testExistsNodes1() throws Exception {
        String str = "";
        str = str + "package org.kie \n";
        str = str + "import " + A.class.getCanonicalName() + "\n";
        str = str + "import " + B.class.getCanonicalName() + "\n";
        str = str + "import " + C.class.getCanonicalName() + "\n";
        str = str + "import " + X.class.getCanonicalName() + "\n";
        str = str + "import " + E.class.getCanonicalName() + "\n";
        str = str + "import " + F.class.getCanonicalName() + "\n";
        str = str + "import " + G.class.getCanonicalName() + "\n";
        str = str + "global java.util.List list \n";
        str = str + "rule rule1 when \n";
        str = str + "   exists A() \n";
        str = str + "then \n";
        str = str + "  list.add( 'x' ); \n";
        str = str + "end \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession wm = kbase.newKieSession();
        ArrayList list = new ArrayList();
        wm.setGlobal("list", list);
        wm.fireAllRules();
        Assert.assertEquals((long)0L, (long)list.size());
        wm = (StatefulKnowledgeSessionImpl)kbase.newKieSession();
        list = new ArrayList();
        wm.setGlobal("list", list);
        FactHandle fh = wm.insert((Object)new A(1));
        wm.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        wm.retract(fh);
        wm.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
    }

    @Test
    public void testExistsNodes2() throws Exception {
        int i;
        String str = "";
        str = str + "package org.kie \n";
        str = str + "import " + A.class.getCanonicalName() + "\n";
        str = str + "import " + B.class.getCanonicalName() + "\n";
        str = str + "import " + C.class.getCanonicalName() + "\n";
        str = str + "import " + X.class.getCanonicalName() + "\n";
        str = str + "import " + E.class.getCanonicalName() + "\n";
        str = str + "import " + F.class.getCanonicalName() + "\n";
        str = str + "import " + G.class.getCanonicalName() + "\n";
        str = str + "global java.util.List list \n";
        str = str + "rule rule1 when \n";
        str = str + "   $a : A() \n";
        str = str + "   exists B() \n";
        str = str + "   $c : C() \n";
        str = str + "then \n";
        str = str + "  list.add( 'x' ); \n";
        str = str + "end \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession wm = kbase.newKieSession();
        ArrayList list = new ArrayList();
        wm.setGlobal("list", list);
        for (i = 0; i < 3; ++i) {
            wm.insert((Object)new A(i));
        }
        for (i = 0; i < 3; ++i) {
            wm.insert((Object)new C(i));
        }
        wm.fireAllRules();
        Assert.assertEquals((long)0L, (long)list.size());
        wm = (StatefulKnowledgeSessionImpl)kbase.newKieSession();
        list = new ArrayList();
        wm.setGlobal("list", list);
        for (i = 0; i < 3; ++i) {
            wm.insert((Object)new A(i));
        }
        FactHandle fh = wm.insert((Object)new B(1));
        for (int i2 = 0; i2 < 3; ++i2) {
            wm.insert((Object)new C(i2));
        }
        wm.fireAllRules();
        Assert.assertEquals((long)9L, (long)list.size());
        wm.retract(fh);
        wm.fireAllRules();
        Assert.assertEquals((long)9L, (long)list.size());
    }

    @Test
    public void testNotNodeUnlinksWithNoConstriants() {
        String str = "";
        str = str + "package org.kie \n";
        str = str + "import " + A.class.getCanonicalName() + "\n";
        str = str + "import " + B.class.getCanonicalName() + "\n";
        str = str + "import " + C.class.getCanonicalName() + "\n";
        str = str + "import " + X.class.getCanonicalName() + "\n";
        str = str + "import " + E.class.getCanonicalName() + "\n";
        str = str + "import " + F.class.getCanonicalName() + "\n";
        str = str + "import " + G.class.getCanonicalName() + "\n";
        str = str + "global java.util.List list \n";
        str = str + "rule rule1 when \n";
        str = str + "   $a : A() \n";
        str = str + "   not B() \n";
        str = str + "   $c : C() \n";
        str = str + "then \n";
        str = str + "  list.add( 'x' ); \n";
        str = str + "end \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        ObjectTypeNode aotn = LinkingTest.getObjectTypeNode(kbase, A.class);
        StatefulKnowledgeSessionImpl wm = (StatefulKnowledgeSessionImpl)kbase.newKieSession();
        ArrayList list = new ArrayList();
        wm.setGlobal("list", list);
        LeftInputAdapterNode aNode = (LeftInputAdapterNode)aotn.getObjectSinkPropagator().getSinks()[0];
        NotNode bNode = (NotNode)aNode.getSinkPropagator().getSinks()[0];
        JoinNode cNode = (JoinNode)bNode.getSinkPropagator().getSinks()[0];
        SegmentUtilities.getOrCreateSegmentMemory((LeftTupleSource)cNode, (ReteEvaluator)wm);
        LeftInputAdapterNode.LiaNodeMemory amem = (LeftInputAdapterNode.LiaNodeMemory)wm.getNodeMemory((MemoryFactory)aNode);
        Assert.assertEquals((long)2L, (long)amem.getSegmentMemory().getLinkedNodeMask());
        FactHandle fha = wm.insert((Object)new A());
        FactHandle fhb = wm.insert((Object)new B());
        FactHandle fhc = wm.insert((Object)new C());
        wm.fireAllRules();
        Assert.assertEquals((long)0L, (long)list.size());
        Assert.assertEquals((long)5L, (long)amem.getSegmentMemory().getLinkedNodeMask());
        wm.retract(fhb);
        wm.flushPropagations();
        Assert.assertEquals((long)7L, (long)amem.getSegmentMemory().getLinkedNodeMask());
        wm.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        list.clear();
        ArrayList<FactHandle> handles = new ArrayList<FactHandle>();
        for (int i = 0; i < 5; ++i) {
            handles.add(wm.insert((Object)new B()));
        }
        wm.fireAllRules();
        Assert.assertEquals((long)0L, (long)list.size());
        Assert.assertEquals((long)5L, (long)amem.getSegmentMemory().getLinkedNodeMask());
        for (FactHandle fh : handles) {
            wm.retract(fh);
        }
        wm.flushPropagations();
        Assert.assertEquals((long)7L, (long)amem.getSegmentMemory().getLinkedNodeMask());
        wm.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
    }

    @Test
    public void testNotNodeDoesNotUnlinksWithConstriants() {
        String str = "";
        str = str + "package org.kie \n";
        str = str + "import " + A.class.getCanonicalName() + "\n";
        str = str + "import " + B.class.getCanonicalName() + "\n";
        str = str + "import " + C.class.getCanonicalName() + "\n";
        str = str + "import " + X.class.getCanonicalName() + "\n";
        str = str + "import " + E.class.getCanonicalName() + "\n";
        str = str + "import " + F.class.getCanonicalName() + "\n";
        str = str + "import " + G.class.getCanonicalName() + "\n";
        str = str + "global java.util.List list \n";
        str = str + "rule rule1 when \n";
        str = str + "   $a : A() \n";
        str = str + "   not B( value == $a.value ) \n";
        str = str + "   $c : C() \n";
        str = str + "then \n";
        str = str + "  list.add( 'x' ); \n";
        str = str + "end \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        ObjectTypeNode aotn = LinkingTest.getObjectTypeNode(kbase, A.class);
        StatefulKnowledgeSessionImpl wm = (StatefulKnowledgeSessionImpl)kbase.newKieSession();
        ArrayList list = new ArrayList();
        wm.setGlobal("list", list);
        LeftInputAdapterNode aNode = (LeftInputAdapterNode)aotn.getObjectSinkPropagator().getSinks()[0];
        NotNode bNode = (NotNode)aNode.getSinkPropagator().getSinks()[0];
        JoinNode cNode = (JoinNode)bNode.getSinkPropagator().getSinks()[0];
        SegmentUtilities.getOrCreateSegmentMemory((LeftTupleSource)cNode, (ReteEvaluator)wm);
        LeftInputAdapterNode.LiaNodeMemory amem = (LeftInputAdapterNode.LiaNodeMemory)wm.getNodeMemory((MemoryFactory)aNode);
        Assert.assertEquals((long)2L, (long)amem.getSegmentMemory().getLinkedNodeMask());
        FactHandle fha = wm.insert((Object)new A());
        FactHandle fhb = wm.insert((Object)new B(1));
        FactHandle fhc = wm.insert((Object)new C());
        wm.flushPropagations();
        Assert.assertEquals((long)7L, (long)amem.getSegmentMemory().getLinkedNodeMask());
        wm.retract(fhb);
        wm.flushPropagations();
        Assert.assertEquals((long)7L, (long)amem.getSegmentMemory().getLinkedNodeMask());
    }

    @Test
    public void testNotNodes1() throws Exception {
        String str = "";
        str = str + "package org.kie \n";
        str = str + "import " + A.class.getCanonicalName() + "\n";
        str = str + "import " + B.class.getCanonicalName() + "\n";
        str = str + "import " + C.class.getCanonicalName() + "\n";
        str = str + "import " + X.class.getCanonicalName() + "\n";
        str = str + "import " + E.class.getCanonicalName() + "\n";
        str = str + "import " + F.class.getCanonicalName() + "\n";
        str = str + "import " + G.class.getCanonicalName() + "\n";
        str = str + "global java.util.List list \n";
        str = str + "rule rule1 when \n";
        str = str + "   not A() \n";
        str = str + "then \n";
        str = str + "  list.add( 'x' ); \n";
        str = str + "end \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        StatefulKnowledgeSessionImpl wm = (StatefulKnowledgeSessionImpl)kbase.newKieSession();
        ArrayList list = new ArrayList();
        wm.setGlobal("list", list);
        wm.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        wm = (StatefulKnowledgeSessionImpl)kbase.newKieSession();
        list = new ArrayList();
        wm.setGlobal("list", list);
        FactHandle fh = wm.insert((Object)new A(1));
        wm.fireAllRules();
        Assert.assertEquals((long)0L, (long)list.size());
        wm.retract(fh);
        wm.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
    }

    @Test
    public void testNotNodes2() throws Exception {
        int i;
        String str = "";
        str = str + "package org.kie \n";
        str = str + "import " + A.class.getCanonicalName() + "\n";
        str = str + "import " + B.class.getCanonicalName() + "\n";
        str = str + "import " + C.class.getCanonicalName() + "\n";
        str = str + "import " + X.class.getCanonicalName() + "\n";
        str = str + "import " + E.class.getCanonicalName() + "\n";
        str = str + "import " + F.class.getCanonicalName() + "\n";
        str = str + "import " + G.class.getCanonicalName() + "\n";
        str = str + "global java.util.List list \n";
        str = str + "rule rule1 when \n";
        str = str + "   $a : A() \n";
        str = str + "   not B() \n";
        str = str + "   $c : C() \n";
        str = str + "then \n";
        str = str + "  list.add( 'x' ); \n";
        str = str + "end \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        ObjectTypeNode aotn = LinkingTest.getObjectTypeNode(kbase, A.class);
        ObjectTypeNode botn = LinkingTest.getObjectTypeNode(kbase, A.class);
        ObjectTypeNode cotn = LinkingTest.getObjectTypeNode(kbase, A.class);
        StatefulKnowledgeSessionImpl wm = (StatefulKnowledgeSessionImpl)kbase.newKieSession();
        ArrayList list = new ArrayList();
        wm.setGlobal("list", list);
        for (i = 0; i < 3; ++i) {
            wm.insert((Object)new A(i));
        }
        for (i = 0; i < 3; ++i) {
            wm.insert((Object)new C(i));
        }
        wm.fireAllRules();
        Assert.assertEquals((long)9L, (long)list.size());
        wm = (StatefulKnowledgeSessionImpl)kbase.newKieSession();
        list = new ArrayList();
        wm.setGlobal("list", list);
        for (i = 0; i < 3; ++i) {
            wm.insert((Object)new A(i));
        }
        FactHandle fh = wm.insert((Object)new B(1));
        for (int i2 = 0; i2 < 3; ++i2) {
            wm.insert((Object)new C(i2));
        }
        wm.fireAllRules();
        Assert.assertEquals((long)0L, (long)list.size());
        wm.retract(fh);
        wm.fireAllRules();
        Assert.assertEquals((long)9L, (long)list.size());
    }

    @Test
    public void testNotNodeMasksWithConstraints() throws Exception {
        String str = "";
        str = str + "package org.kie \n";
        str = str + "import " + A.class.getCanonicalName() + "\n";
        str = str + "import " + B.class.getCanonicalName() + "\n";
        str = str + "import " + C.class.getCanonicalName() + "\n";
        str = str + "import " + X.class.getCanonicalName() + "\n";
        str = str + "import " + E.class.getCanonicalName() + "\n";
        str = str + "import " + F.class.getCanonicalName() + "\n";
        str = str + "import " + G.class.getCanonicalName() + "\n";
        str = str + "global java.util.List list \n";
        str = str + "rule rule1 when \n";
        str = str + "   $a : A() \n";
        str = str + "   not( B( value == $a.value ) ) \n";
        str = str + "   C() \n";
        str = str + "then \n";
        str = str + "end \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        ObjectTypeNode node = LinkingTest.getObjectTypeNode(kbase, A.class);
        StatefulKnowledgeSessionImpl wm = (StatefulKnowledgeSessionImpl)kbase.newKieSession();
        LeftInputAdapterNode liaNode = (LeftInputAdapterNode)node.getObjectSinkPropagator().getSinks()[0];
        Assert.assertEquals((long)1L, (long)liaNode.getSinkPropagator().size());
        wm.insert((Object)new A());
        wm.flushPropagations();
        NotNode notNode = (NotNode)liaNode.getSinkPropagator().getSinks()[0];
        JoinNode cNode = (JoinNode)notNode.getSinkPropagator().getSinks()[0];
        RuleTerminalNode rtn = (RuleTerminalNode)cNode.getSinkPropagator().getSinks()[0];
        PathMemory pmem = (PathMemory)wm.getNodeMemory((MemoryFactory)rtn);
        Assert.assertEquals((long)1L, (long)pmem.getSegmentMemories().length);
        Assert.assertEquals((long)1L, (long)pmem.getAllLinkedMaskTest());
        SegmentMemory sm = pmem.getSegmentMemories()[0];
        Assert.assertEquals((long)5L, (long)sm.getAllLinkedMaskTest());
        Assert.assertEquals((long)3L, (long)sm.getLinkedNodeMask());
        Assert.assertFalse((boolean)sm.isSegmentLinked());
        Assert.assertFalse((boolean)pmem.isRuleLinked());
        wm.insert((Object)new C());
        wm.flushPropagations();
        Assert.assertEquals((long)7L, (long)sm.getLinkedNodeMask());
        Assert.assertTrue((boolean)sm.isSegmentLinked());
        Assert.assertTrue((boolean)pmem.isRuleLinked());
    }

    @Test
    public void testNotNodeMasksWithoutConstraints() throws Exception {
        String str = "";
        str = str + "package org.kie \n";
        str = str + "import " + A.class.getCanonicalName() + "\n";
        str = str + "import " + B.class.getCanonicalName() + "\n";
        str = str + "import " + C.class.getCanonicalName() + "\n";
        str = str + "import " + X.class.getCanonicalName() + "\n";
        str = str + "import " + E.class.getCanonicalName() + "\n";
        str = str + "import " + F.class.getCanonicalName() + "\n";
        str = str + "import " + G.class.getCanonicalName() + "\n";
        str = str + "global java.util.List list \n";
        str = str + "rule rule1 when \n";
        str = str + "   A() \n";
        str = str + "   not( B( ) ) \n";
        str = str + "   C() \n";
        str = str + "then \n";
        str = str + "end \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        ObjectTypeNode node = LinkingTest.getObjectTypeNode(kbase, A.class);
        StatefulKnowledgeSessionImpl wm = (StatefulKnowledgeSessionImpl)kbase.newKieSession();
        LeftInputAdapterNode liaNode = (LeftInputAdapterNode)node.getObjectSinkPropagator().getSinks()[0];
        Assert.assertEquals((long)1L, (long)liaNode.getSinkPropagator().size());
        wm.insert((Object)new A());
        wm.flushPropagations();
        NotNode notNode = (NotNode)liaNode.getSinkPropagator().getSinks()[0];
        JoinNode cNode = (JoinNode)notNode.getSinkPropagator().getSinks()[0];
        RuleTerminalNode rtn = (RuleTerminalNode)cNode.getSinkPropagator().getSinks()[0];
        PathMemory pmem = (PathMemory)wm.getNodeMemory((MemoryFactory)rtn);
        Assert.assertEquals((long)1L, (long)pmem.getSegmentMemories().length);
        Assert.assertEquals((long)1L, (long)pmem.getAllLinkedMaskTest());
        SegmentMemory sm = pmem.getSegmentMemories()[0];
        Assert.assertEquals((long)7L, (long)sm.getAllLinkedMaskTest());
        Assert.assertEquals((long)3L, (long)sm.getLinkedNodeMask());
        Assert.assertFalse((boolean)sm.isSegmentLinked());
        Assert.assertFalse((boolean)pmem.isRuleLinked());
        wm.insert((Object)new C());
        wm.flushPropagations();
        Assert.assertEquals((long)7L, (long)sm.getLinkedNodeMask());
        Assert.assertTrue((boolean)sm.isSegmentLinked());
        Assert.assertTrue((boolean)pmem.isRuleLinked());
    }

    @Test
    public void testForallNodes() throws Exception {
        int i;
        String str = "";
        str = str + "package org.kie \n";
        str = str + "import " + A.class.getCanonicalName() + "\n";
        str = str + "import " + B.class.getCanonicalName() + "\n";
        str = str + "import " + C.class.getCanonicalName() + "\n";
        str = str + "import " + X.class.getCanonicalName() + "\n";
        str = str + "import " + E.class.getCanonicalName() + "\n";
        str = str + "import " + F.class.getCanonicalName() + "\n";
        str = str + "import " + G.class.getCanonicalName() + "\n";
        str = str + "global java.util.List list \n";
        str = str + "rule rule1 when \n";
        str = str + "   $a : A() \n";
        str = str + "   forall( B() )\n";
        str = str + "   $c : C() \n";
        str = str + "then \n";
        str = str + "  list.add( 'x' ); \n";
        str = str + "end \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        ObjectTypeNode aotn = LinkingTest.getObjectTypeNode(kbase, A.class);
        ObjectTypeNode botn = LinkingTest.getObjectTypeNode(kbase, A.class);
        ObjectTypeNode cotn = LinkingTest.getObjectTypeNode(kbase, A.class);
        KieSession wm = kbase.newKieSession();
        ArrayList list = new ArrayList();
        wm = (StatefulKnowledgeSessionImpl)kbase.newKieSession();
        list = new ArrayList();
        wm.setGlobal("list", list);
        for (i = 0; i < 2; ++i) {
            wm.insert((Object)new A(i));
        }
        for (i = 0; i < 27; ++i) {
            wm.insert((Object)new B(1));
        }
        for (i = 0; i < 2; ++i) {
            wm.insert((Object)new C(i));
        }
        wm.fireAllRules();
        Assert.assertEquals((long)4L, (long)list.size());
    }

    @Test
    public void testAccumulateNodes1() throws Exception {
        String str = "";
        str = str + "package org.kie \n";
        str = str + "import " + A.class.getCanonicalName() + "\n";
        str = str + "import " + B.class.getCanonicalName() + "\n";
        str = str + "import " + C.class.getCanonicalName() + "\n";
        str = str + "import " + X.class.getCanonicalName() + "\n";
        str = str + "import " + E.class.getCanonicalName() + "\n";
        str = str + "import " + F.class.getCanonicalName() + "\n";
        str = str + "import " + G.class.getCanonicalName() + "\n";
        str = str + "global java.util.List list \n";
        str = str + "rule rule1 when \n";
        str = str + "   accumulate( $a : A(); $l : collectList( $a ) ) \n";
        str = str + "then \n";
        str = str + "  list.add( $l.size() ); \n";
        str = str + "end \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession wm = kbase.newKieSession();
        ArrayList list = new ArrayList();
        wm.setGlobal("list", list);
        wm.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        wm = kbase.newKieSession();
        list = new ArrayList();
        wm.setGlobal("list", list);
        FactHandle fh1 = wm.insert((Object)new A(1));
        FactHandle fh2 = wm.insert((Object)new A(2));
        FactHandle fh3 = wm.insert((Object)new A(3));
        FactHandle fh4 = wm.insert((Object)new A(4));
        wm.fireAllRules();
        Assert.assertEquals((Object)4, list.get(0));
    }

    @Test
    public void testAccumulateNodes2() throws Exception {
        String str = "";
        str = str + "package org.kie \n";
        str = str + "import " + A.class.getCanonicalName() + "\n";
        str = str + "import " + B.class.getCanonicalName() + "\n";
        str = str + "import " + C.class.getCanonicalName() + "\n";
        str = str + "import " + X.class.getCanonicalName() + "\n";
        str = str + "import " + E.class.getCanonicalName() + "\n";
        str = str + "import " + F.class.getCanonicalName() + "\n";
        str = str + "import " + G.class.getCanonicalName() + "\n";
        str = str + "global java.util.List list \n";
        str = str + "rule rule1 when \n";
        str = str + "   A() \n";
        str = str + "   accumulate( $a : B(); $l : collectList( $a ) ) \n";
        str = str + "   C() \n";
        str = str + "then \n";
        str = str + "  list.add( $l.size() ); \n";
        str = str + "end \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession wm = kbase.newKieSession();
        ArrayList list = new ArrayList();
        wm.setGlobal("list", list);
        wm.fireAllRules();
        Assert.assertEquals((long)0L, (long)list.size());
        wm = (StatefulKnowledgeSessionImpl)kbase.newKieSession();
        list = new ArrayList();
        wm.setGlobal("list", list);
        FactHandle fh1 = wm.insert((Object)new B(1));
        FactHandle fh2 = wm.insert((Object)new B(2));
        FactHandle fh3 = wm.insert((Object)new B(3));
        FactHandle fh4 = wm.insert((Object)new B(4));
        FactHandle fha = wm.insert((Object)new A(1));
        FactHandle fhc = wm.insert((Object)new C(1));
        wm.fireAllRules();
        Assert.assertEquals((Object)4, list.get(0));
    }

    @Test
    public void testSubnetwork() throws Exception {
        String str = "";
        str = str + "package org.kie \n";
        str = str + "import " + A.class.getCanonicalName() + "\n";
        str = str + "import " + B.class.getCanonicalName() + "\n";
        str = str + "import " + C.class.getCanonicalName() + "\n";
        str = str + "import " + X.class.getCanonicalName() + "\n";
        str = str + "import " + E.class.getCanonicalName() + "\n";
        str = str + "import " + F.class.getCanonicalName() + "\n";
        str = str + "import " + G.class.getCanonicalName() + "\n";
        str = str + "global java.util.List list \n";
        str = str + "rule rule1 when \n";
        str = str + "   $a : A() \n";
        str = str + "   exists ( B() and C() ) \n";
        str = str + "   $e : X() \n";
        str = str + "then \n";
        str = str + "  list.add( 'x' ); \n";
        str = str + "end \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        ObjectTypeNode aotn = LinkingTest.getObjectTypeNode(kbase, A.class);
        ObjectTypeNode botn = LinkingTest.getObjectTypeNode(kbase, A.class);
        ObjectTypeNode cotn = LinkingTest.getObjectTypeNode(kbase, A.class);
        StatefulKnowledgeSessionImpl wm = (StatefulKnowledgeSessionImpl)kbase.newKieSession();
        ArrayList list = new ArrayList();
        wm.setGlobal("list", list);
        wm.insert((Object)new A());
        wm.insert((Object)new B());
        for (int i = 0; i < 28; ++i) {
            wm.insert((Object)new C());
        }
        wm.insert((Object)new X());
        wm.flushPropagations();
        InternalAgenda agenda = wm.getAgenda();
        InternalAgendaGroup group = agenda.getAgendaGroupsManager().getNextFocus();
        AgendaItem item = (AgendaItem)group.remove();
        RuleExecutor ruleExecutor = ((RuleAgendaItem)item).getRuleExecutor();
        int count = ruleExecutor.evaluateNetworkAndFire((ReteEvaluator)wm, null, 0, -1);
        wm.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        wm.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
    }

    @Test
    public void testNestedSubnetwork() throws Exception {
        int i;
        String str = "";
        str = str + "package org.kie \n";
        str = str + "import " + A.class.getCanonicalName() + "\n";
        str = str + "import " + B.class.getCanonicalName() + "\n";
        str = str + "import " + C.class.getCanonicalName() + "\n";
        str = str + "import " + X.class.getCanonicalName() + "\n";
        str = str + "import " + E.class.getCanonicalName() + "\n";
        str = str + "import " + F.class.getCanonicalName() + "\n";
        str = str + "import " + G.class.getCanonicalName() + "\n";
        str = str + "global java.util.List list \n";
        str = str + "rule rule1 when \n";
        str = str + "   $a : A() \n";
        str = str + "   exists ( B() and exists( C() and X() ) and E() ) \n";
        str = str + "   $f : F() \n";
        str = str + "then \n";
        str = str + "  list.add( 'x' ); \n";
        str = str + "end \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        ObjectTypeNode aotn = LinkingTest.getObjectTypeNode(kbase, A.class);
        ObjectTypeNode botn = LinkingTest.getObjectTypeNode(kbase, A.class);
        ObjectTypeNode cotn = LinkingTest.getObjectTypeNode(kbase, A.class);
        StatefulKnowledgeSessionImpl wm = (StatefulKnowledgeSessionImpl)kbase.newKieSession();
        ArrayList list = new ArrayList();
        wm.setGlobal("list", list);
        wm.insert((Object)new A());
        wm.insert((Object)new B());
        for (i = 0; i < 28; ++i) {
            wm.insert((Object)new C());
        }
        for (i = 0; i < 29; ++i) {
            wm.insert((Object)new X());
        }
        wm.insert((Object)new E());
        wm.insert((Object)new F());
        wm.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        wm.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
    }

    public static ObjectTypeNode getObjectTypeNode(KieBase kbase, Class<?> nodeClass) {
        List nodes = ((RuleBase)kbase).getRete().getObjectTypeNodes();
        for (ObjectTypeNode n : nodes) {
            if (((ClassObjectType)n.getObjectType()).getClassType() != nodeClass) continue;
            return n;
        }
        return null;
    }

    public static class G {
        private int value;

        public G() {
        }

        public G(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public void setValue(int value) {
            this.value = value;
        }
    }

    public static class F {
        private int value;

        public F() {
        }

        public F(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public void setValue(int value) {
            this.value = value;
        }
    }

    public static class E {
        private int value;

        public E() {
        }

        public E(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public void setValue(int value) {
            this.value = value;
        }
    }

    public static class X {
        private int value;

        public X() {
        }

        public X(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public void setValue(int value) {
            this.value = value;
        }
    }

    public static class C {
        private int value;

        public C() {
        }

        public C(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public void setValue(int value) {
            this.value = value;
        }
    }

    public static class B {
        private int value;

        public B() {
        }

        public B(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public void setValue(int value) {
            this.value = value;
        }
    }

    public static class A {
        private int value;

        public A() {
        }

        public A(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public void setValue(int value) {
            this.value = value;
        }
    }
}

