/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.io.InputStreamReader;
import java.io.Reader;
import org.assertj.core.api.Assertions;
import org.drools.compiler.builder.impl.KnowledgeBuilderConfigurationImpl;
import org.drools.compiler.compiler.DescrBuildError;
import org.drools.drl.parser.DrlParser;
import org.drools.drl.parser.ParserError;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.io.ResourceType;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderError;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.builder.conf.LanguageLevelOption;
import org.kie.internal.io.ResourceFactory;
import org.kie.memorycompiler.JavaConfiguration;

public class ParserTest {
    @Test
    public void testErrorLineNumbers() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"errors_in_rule.drl", this.getClass()), ResourceType.DRL);
        KnowledgeBuilderError[] errors = (KnowledgeBuilderError[])kbuilder.getErrors().toArray((Object[])new KnowledgeBuilderError[0]);
        Assert.assertEquals((long)3L, (long)errors.length);
        DescrBuildError stiltonError = (DescrBuildError)errors[0];
        Assert.assertTrue((boolean)stiltonError.getMessage().contains("Stilton"));
        Assertions.assertThat((Object)stiltonError.getDescr()).isNotNull();
        Assert.assertTrue((stiltonError.getLine() != -1 ? 1 : 0) != 0);
        Assert.assertEquals((long)stiltonError.getLine(), (long)stiltonError.getDescr().getLine());
        Assert.assertEquals((long)26L, (long)stiltonError.getLine());
        DescrBuildError poisonError = (DescrBuildError)errors[1];
        Assert.assertTrue((boolean)poisonError.getMessage().contains("Poison"));
        Assert.assertEquals((long)28L, (long)poisonError.getLine());
        KnowledgeBuilderConfigurationImpl cfg = new KnowledgeBuilderConfigurationImpl();
        JavaConfiguration javaConf = (JavaConfiguration)cfg.getDialectConfiguration("java");
        switch (javaConf.getCompiler()) {
            case NATIVE: {
                Assert.assertTrue((boolean)errors[2].getMessage().contains("illegal"));
                break;
            }
            case ECLIPSE: {
                Assert.assertTrue((boolean)errors[2].getMessage().contains("add"));
                break;
            }
            default: {
                Assert.fail((String)"Unknown compiler used");
            }
        }
        DescrBuildError rhsError = (DescrBuildError)errors[2];
        Assert.assertTrue((rhsError.getLine() >= 23 && rhsError.getLine() <= 32 ? 1 : 0) != 0);
    }

    @Test
    public void testErrorsParser() throws Exception {
        DrlParser parser = new DrlParser(LanguageLevelOption.DRL5);
        Assert.assertEquals((long)0L, (long)parser.getErrors().size());
        parser.parse((Reader)new InputStreamReader(this.getClass().getResourceAsStream("errors_parser_multiple.drl")));
        Assert.assertTrue((boolean)parser.hasErrors());
        Assert.assertTrue((parser.getErrors().size() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)(parser.getErrors().get(0) instanceof ParserError));
        ParserError first = (ParserError)parser.getErrors().get(0);
        Assert.assertTrue((first.getMessage() != null ? 1 : 0) != 0);
        Assert.assertFalse((boolean)first.getMessage().equals(""));
    }
}

