/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests.session;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.assertj.core.api.Assertions;
import org.drools.core.ClassObjectFilter;
import org.drools.core.common.DefaultFactHandle;
import org.drools.mvel.compiler.Cheese;
import org.drools.mvel.compiler.CheeseEqual;
import org.drools.mvel.compiler.Message;
import org.drools.mvel.compiler.PersonInterface;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.ObjectFilter;
import org.kie.api.runtime.rule.FactHandle;

@RunWith(value=Parameterized.class)
public class StatefulSessionTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public StatefulSessionTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    @Test
    public void testDispose() throws Exception {
        StringBuilder rule = new StringBuilder();
        rule.append("package org.drools.mvel.compiler\n");
        rule.append("rule X\n");
        rule.append("when\n");
        rule.append("    Message()\n");
        rule.append("then\n");
        rule.append("end\n");
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{rule.toString()});
        KieSession ksession = kbase.newKieSession();
        ksession.insert((Object)new Message("test"));
        int rules = ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)rules);
        ksession.dispose();
        try {
            ksession.fireAllRules();
            Assert.fail((String)"An IllegallStateException should have been raised as the session was disposed before the method call.");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testGetStatefulKnowledgeSessions() throws Exception {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"../empty.drl"});
        KieSession ksession_1 = kbase.newKieSession();
        String expected_1 = "expected_1";
        String expected_2 = "expected_2";
        FactHandle handle_1 = ksession_1.insert((Object)"expected_1");
        FactHandle handle_2 = ksession_1.insert((Object)"expected_2");
        ksession_1.fireAllRules();
        Collection coll_1 = kbase.getKieSessions();
        Assert.assertTrue((coll_1.size() == 1 ? 1 : 0) != 0);
        KieSession ksession_2 = (KieSession)coll_1.iterator().next();
        Object actual_1 = ksession_2.getObject(handle_1);
        Object actual_2 = ksession_2.getObject(handle_2);
        Assert.assertEquals((Object)"expected_1", (Object)actual_1);
        Assert.assertEquals((Object)"expected_2", (Object)actual_2);
        ksession_1.dispose();
        Collection coll_2 = kbase.getKieSessions();
        Assert.assertTrue((coll_2.size() == 0 ? 1 : 0) != 0);
        ksession_1.dispose();
        Collection coll_3 = kbase.getKieSessions();
        Assert.assertTrue((coll_3.size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testGetFactHandle() throws Exception {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"../empty.drl"});
        KieSession ksession = kbase.newKieSession();
        for (int i = 0; i < 20; ++i) {
            Object object = new Object();
            ksession.insert(object);
            FactHandle factHandle = ksession.getFactHandle(object);
            Assertions.assertThat((Object)factHandle).isNotNull();
            Assert.assertEquals((Object)object, (Object)ksession.getObject(factHandle));
        }
        ksession.dispose();
    }

    @Test
    public void testGetFactHandleEqualityBehavior() throws Exception {
        KieBaseTestConfiguration equalityConfig = TestParametersUtil.getEqualityInstanceOf((KieBaseTestConfiguration)this.kieBaseTestConfiguration);
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)equalityConfig, (String[])new String[0]);
        KieSession ksession = kbase.newKieSession();
        CheeseEqual cheese = new CheeseEqual("stilton", 10);
        ksession.insert((Object)cheese);
        FactHandle fh = ksession.getFactHandle((Object)new CheeseEqual("stilton", 10));
        Assertions.assertThat((Object)fh).isNotNull();
    }

    @Test
    public void testGetFactHandleIdentityBehavior() throws Exception {
        KieBaseTestConfiguration identityConfig = TestParametersUtil.getIdentityInstanceOf((KieBaseTestConfiguration)this.kieBaseTestConfiguration);
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)identityConfig, (String[])new String[0]);
        KieSession ksession = kbase.newKieSession();
        CheeseEqual cheese = new CheeseEqual("stilton", 10);
        ksession.insert((Object)cheese);
        FactHandle fh1 = ksession.getFactHandle((Object)new Cheese("stilton", 10));
        Assert.assertNull((Object)fh1);
        FactHandle fh2 = ksession.getFactHandle((Object)cheese);
        Assertions.assertThat((Object)fh2).isNotNull();
    }

    @Test
    public void testDisconnectedFactHandle() {
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[0]);
        KieSession ksession = kbase.newKieSession();
        DefaultFactHandle helloHandle = (DefaultFactHandle)ksession.insert((Object)"hello");
        DefaultFactHandle goodbyeHandle = (DefaultFactHandle)ksession.insert((Object)"goodbye");
        DefaultFactHandle key = DefaultFactHandle.createFromExternalFormat((String)helloHandle.toExternalForm());
        Assert.assertEquals((Object)"hello", (Object)ksession.getObject((FactHandle)key));
        key = DefaultFactHandle.createFromExternalFormat((String)goodbyeHandle.toExternalForm());
        Assert.assertEquals((Object)"goodbye", (Object)ksession.getObject((FactHandle)key));
    }

    @Test
    public void testIterateObjects() throws Exception {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_IterateObjects.drl"});
        KieSession ksession = kbase.newKieSession();
        ArrayList results = new ArrayList();
        ksession.setGlobal("results", results);
        ksession.insert((Object)new Cheese("stilton", 10));
        ksession.fireAllRules();
        Iterator events = ksession.getObjects((ObjectFilter)new ClassObjectFilter(PersonInterface.class)).iterator();
        Assert.assertTrue((boolean)events.hasNext());
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals(results.get(0), events.next());
    }
}

