/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.rule;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import org.drools.core.base.ClassFieldAccessorCache;
import org.drools.core.base.ClassObjectType;
import org.drools.core.base.ObjectType;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.Pattern;
import org.drools.core.rule.accessor.ReadAccessor;
import org.drools.core.test.model.Cheese;
import org.drools.mvel.accessors.ClassFieldAccessorStore;
import org.drools.mvel.accessors.ClassFieldReader;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DeclarationTest {
    ClassFieldAccessorStore store = new ClassFieldAccessorStore();

    @Before
    public void setUp() throws Exception {
        this.store.setClassFieldAccessorCache(new ClassFieldAccessorCache(Thread.currentThread().getContextClassLoader()));
        this.store.setEagerWire(true);
    }

    @Test
    public void testDeclaration() {
        ClassFieldReader extractor = this.store.getReader(Cheese.class, "type");
        Pattern pattern = new Pattern(5, (ObjectType)new ClassObjectType(Cheese.class));
        Declaration declaration = new Declaration("typeOfCheese", (ReadAccessor)extractor, pattern);
        Assert.assertEquals((Object)"typeOfCheese", (Object)declaration.getIdentifier());
        Assert.assertSame(String.class, (Object)declaration.getDeclarationClass());
        Assert.assertSame((Object)extractor, (Object)declaration.getExtractor());
        Assert.assertEquals((long)5L, (long)declaration.getPattern().getPatternId());
    }

    @Test
    public void testGetFieldValue() {
        ClassFieldReader extractor = this.store.getReader(Cheese.class, "type");
        Pattern pattern = new Pattern(5, (ObjectType)new ClassObjectType(Cheese.class));
        Declaration declaration = new Declaration("typeOfCheese", (ReadAccessor)extractor, pattern);
        Cheese cheddar = new Cheese("cheddar", 5);
        Assert.assertEquals((Object)"cheddar", (Object)declaration.getValue(null, (Object)cheddar));
    }

    public static int getIndex(Class clazz, String name) throws IntrospectionException {
        PropertyDescriptor[] descriptors = Introspector.getBeanInfo(clazz).getPropertyDescriptors();
        for (int i = 0; i < descriptors.length; ++i) {
            if (!descriptors[i].getName().equals(name)) continue;
            return i;
        }
        return -1;
    }
}

