/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests.phases;

import java.util.ArrayList;
import java.util.Collection;
import org.drools.compiler.builder.PackageRegistryManager;
import org.drools.compiler.builder.impl.BuildResultCollector;
import org.drools.compiler.builder.impl.GlobalVariableContext;
import org.drools.compiler.builder.impl.KnowledgeBuilderConfigurationImpl;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.compiler.builder.impl.TypeDeclarationContext;
import org.drools.compiler.builder.impl.processors.AccumulateFunctionCompilationPhase;
import org.drools.compiler.builder.impl.processors.CompilationPhase;
import org.drools.compiler.builder.impl.processors.FunctionCompilationPhase;
import org.drools.compiler.builder.impl.processors.GlobalCompilationPhase;
import org.drools.compiler.builder.impl.processors.IteratingPhase;
import org.drools.compiler.builder.impl.processors.RuleValidator;
import org.drools.compiler.builder.impl.processors.SinglePackagePhaseFactory;
import org.drools.compiler.builder.impl.processors.WindowDeclarationCompilationPhase;
import org.drools.compiler.compiler.PackageRegistry;
import org.drools.compiler.lang.descr.CompositePackageDescr;
import org.drools.drl.ast.descr.PackageDescr;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.modelcompiler.builder.CanonicalModelBuildContext;
import org.drools.modelcompiler.builder.PackageModelManager;
import org.drools.modelcompiler.builder.PackageSourceManager;
import org.drools.modelcompiler.builder.PackageSources;
import org.drools.modelcompiler.builder.generator.declaredtype.POJOGenerator;
import org.drools.modelcompiler.builder.processors.DeclaredTypeDeregistrationPhase;
import org.drools.modelcompiler.builder.processors.DeclaredTypeRegistrationPhase;
import org.drools.modelcompiler.builder.processors.GeneratedPojoCompilationPhase;
import org.drools.modelcompiler.builder.processors.ModelGeneratorPhase;
import org.drools.modelcompiler.builder.processors.PojoStoragePhase;
import org.drools.modelcompiler.builder.processors.SourceCodeGenerationPhase;
import org.kie.internal.builder.KnowledgeBuilderConfiguration;

class ExplicitCanonicalModelCompiler {
    private final Collection<CompositePackageDescr> packages;
    private final PackageRegistryManager pkgRegistryManager;
    private final PackageModelManager packageModelManager;
    private final CanonicalModelBuildContext buildContext;
    private final KnowledgeBuilderConfigurationImpl configuration;
    private final BuildResultCollector results;
    private final TypeDeclarationContext typeDeclarationContext;
    private final InternalKnowledgeBase kBase = null;
    private final GlobalVariableContext globalVariableContext;
    private final PackageSourceManager<PackageSources> packageSourceManager;
    final boolean hasMvel = false;
    final boolean oneClassPerRule = true;

    ExplicitCanonicalModelCompiler(Collection<CompositePackageDescr> packages, PackageRegistryManager pkgRegistryManager, PackageModelManager packageModelManager, CanonicalModelBuildContext buildContext, KnowledgeBuilderConfigurationImpl configuration, BuildResultCollector results, TypeDeclarationContext typeDeclarationContext, GlobalVariableContext globalVariableContext, PackageSourceManager<PackageSources> packageSourceManager) {
        this.packages = packages;
        this.pkgRegistryManager = pkgRegistryManager;
        this.packageModelManager = packageModelManager;
        this.buildContext = buildContext;
        this.configuration = configuration;
        this.results = results;
        this.typeDeclarationContext = typeDeclarationContext;
        this.globalVariableContext = globalVariableContext;
        this.packageSourceManager = packageSourceManager;
    }

    public void process() {
        ArrayList<Object> phases = new ArrayList<Object>();
        phases.add(this.iteratingPhase((reg, acc) -> new DeclaredTypeRegistrationPhase(reg, (PackageDescr)acc, this.pkgRegistryManager)));
        phases.add(this.iteratingPhase((reg, acc) -> new POJOGenerator(reg.getPackage(), (PackageDescr)acc, this.packageModelManager.getPackageModel((PackageDescr)acc, reg, reg.getPackage().getName()))));
        phases.add(new GeneratedPojoCompilationPhase(this.packageModelManager, this.buildContext, this.configuration.getClassLoader()));
        phases.add(new PojoStoragePhase(this.buildContext, this.pkgRegistryManager, this.packages));
        phases.add(this.iteratingPhase(AccumulateFunctionCompilationPhase::new));
        phases.add(this.iteratingPhase((reg, acc) -> new FunctionCompilationPhase(reg, (PackageDescr)acc, (KnowledgeBuilderConfiguration)this.configuration)));
        phases.add(this.iteratingPhase((reg, acc) -> new GlobalCompilationPhase(reg, (PackageDescr)acc, this.kBase, this.globalVariableContext, (KnowledgeBuilderImpl.AssetFilter)acc.getFilter())));
        phases.add(new DeclaredTypeDeregistrationPhase(this.packages, this.pkgRegistryManager));
        phases.add(this.iteratingPhase((reg, acc) -> new RuleValidator(reg, (PackageDescr)acc, (KnowledgeBuilderConfiguration)this.configuration)));
        phases.add(this.iteratingPhase((reg, acc) -> new ModelGeneratorPhase(reg, (PackageDescr)acc, this.packageModelManager.getPackageModel((PackageDescr)acc, reg, acc.getName()), this.typeDeclarationContext)));
        phases.add(this.iteratingPhase((reg, acc) -> new SourceCodeGenerationPhase(this.packageModelManager.getPackageModel((PackageDescr)acc, reg, acc.getName()), this.packageSourceManager, PackageSources::dumpSources, true)));
        for (CompilationPhase compilationPhase : phases) {
            compilationPhase.process();
            this.results.addAll(compilationPhase.getResults());
            if (!this.results.hasErrors()) continue;
            break;
        }
    }

    private IteratingPhase iteratingPhase(SinglePackagePhaseFactory phaseFactory) {
        return new IteratingPhase(this.packages, this.pkgRegistryManager, phaseFactory);
    }

    private /* synthetic */ CompilationPhase lambda$process$2(PackageRegistry reg, CompositePackageDescr acc) {
        return new WindowDeclarationCompilationPhase(reg, (PackageDescr)acc, this.typeDeclarationContext);
    }
}

