/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.compiler.builder;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import org.assertj.core.api.Assertions;
import org.drools.compiler.compiler.io.memory.MemoryFileSystem;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.compiler.kie.builder.impl.KieBuilderImpl;
import org.drools.compiler.kie.builder.impl.KieFileSystemImpl;
import org.drools.compiler.kproject.models.KieBaseModelImpl;
import org.drools.core.util.FileManager;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.KieModule;
import org.kie.api.builder.KieRepository;
import org.kie.api.builder.Message;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.model.KieBaseModel;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.conf.EqualityBehaviorOption;
import org.kie.api.conf.EventProcessingOption;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;
import org.kie.util.maven.support.PomModel;
import org.kie.util.maven.support.ReleaseIdImpl;

public class KieBuilderTest {
    protected FileManager fileManager;

    @Before
    public void setUp() throws Exception {
        this.fileManager = new FileManager();
        this.fileManager.setUp();
    }

    @After
    public void tearDown() throws Exception {
        this.fileManager.tearDown();
    }

    @Test
    public void testInMemory() throws ClassNotFoundException, InterruptedException, IOException {
        String namespace = "org.kie.test";
        ReleaseId releaseId = KieServices.Factory.get().newReleaseId(namespace, "memory", "1.0");
        KieModuleModel kProj = this.createKieProject(namespace);
        KieFileSystem kfs = KieServices.Factory.get().newKieFileSystem();
        this.generateAll(kfs, namespace, releaseId, kProj);
        this.createAndTestKieContainer(releaseId, this.createKieBuilder(kfs), namespace);
    }

    @Test
    public void testOnDisc() throws ClassNotFoundException, InterruptedException, IOException {
        String namespace = "org.kie.test";
        KieModuleModel kProj = this.createKieProject(namespace);
        ReleaseId releaseId = KieServices.Factory.get().newReleaseId(namespace, "memory", "1.0");
        KieFileSystem kfs = KieServices.Factory.get().newKieFileSystem();
        this.generateAll(kfs, namespace, releaseId, kProj);
        MemoryFileSystem mfs = ((KieFileSystemImpl)kfs).asMemoryFileSystem();
        File file = this.fileManager.getRootDirectory();
        mfs.writeAsFs(file);
        this.createAndTestKieContainer(releaseId, this.createKieBuilder(kfs), namespace);
    }

    @Test
    public void testKieModuleDependencies() throws ClassNotFoundException, InterruptedException, IOException {
        KieServices ks = KieServices.Factory.get();
        String namespace1 = "org.kie.test1";
        ReleaseId releaseId1 = KieServices.Factory.get().newReleaseId(namespace1, "memory", "1.0");
        KieModuleModel kProj1 = this.createKieProject(namespace1);
        KieFileSystem kfs1 = KieServices.Factory.get().newKieFileSystem();
        this.generateAll(kfs1, namespace1, releaseId1, kProj1);
        KieBuilder kb1 = this.createKieBuilder(kfs1);
        kb1.buildAll();
        if (kb1.getResults().hasMessages(new Message.Level[]{Message.Level.ERROR})) {
            Assert.fail((String)("Unable to build KieJar\n" + kb1.getResults().toString()));
        }
        KieRepository kr = ks.getRepository();
        KieModule kModule1 = kr.getKieModule(releaseId1);
        Assertions.assertThat((Object)kModule1).isNotNull();
        String namespace2 = "org.kie.test2";
        ReleaseId releaseId2 = KieServices.Factory.get().newReleaseId(namespace2, "memory", "1.0");
        KieModuleModel kProj2 = this.createKieProject(namespace2);
        KieBaseModelImpl kieBase2 = (KieBaseModelImpl)kProj2.getKieBaseModels().get(namespace2);
        kieBase2.addInclude(namespace1);
        KieFileSystem kfs2 = KieServices.Factory.get().newKieFileSystem();
        this.generateAll(kfs2, namespace2, releaseId2, kProj2);
        KieBuilder kb2 = this.createKieBuilder(kfs2);
        kb2.setDependencies(new KieModule[]{kModule1});
        kb2.buildAll();
        if (kb2.getResults().hasMessages(new Message.Level[]{Message.Level.ERROR})) {
            Assert.fail((String)("Unable to build KieJar\n" + kb2.getResults().toString()));
        }
        KieModule kModule2 = kr.getKieModule(releaseId2);
        Assertions.assertThat((Object)kModule2).isNotNull();
        KieContainer kContainer = ks.newKieContainer(releaseId2);
        KieBase kBase = kContainer.getKieBase(namespace2);
        KieSession kSession = kBase.newKieSession();
        ArrayList list = new ArrayList();
        kSession.setGlobal("list", list);
        kSession.fireAllRules();
        Assert.assertEquals((long)2L, (long)list.size());
        if ("org.kie.test1.Message".equals(list.get(0).getClass().getName())) {
            Assert.assertEquals((Object)"org.kie.test2.Message", (Object)list.get(1).getClass().getName());
        } else {
            Assert.assertEquals((Object)"org.kie.test2.Message", (Object)list.get(0).getClass().getName());
            Assert.assertEquals((Object)"org.kie.test1.Message", (Object)list.get(1).getClass().getName());
        }
    }

    @Test
    public void testNotExistingInclude() throws Exception {
        String drl = "package org.drools.mvel.compiler.integrationtests\ndeclare CancelFact\n cancel : boolean = true\nend\nrule R1 when\n $m : CancelFact( cancel == true )\nthen\nend\n";
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem().write("src/main/resources/r1.drl", drl);
        KieModuleModel module = ks.newKieModuleModel();
        String defaultBaseName = "defaultKBase";
        KieBaseModel defaultBase = module.newKieBaseModel("defaultKBase").addInclude("notExistingKB1").addInclude("notExistingKB2");
        defaultBase.setDefault(true);
        defaultBase.addPackage("*");
        defaultBase.newKieSessionModel("defaultKSession").setDefault(true);
        kfs.writeKModuleXML(module.toXML());
        KieBuilder kb = ks.newKieBuilder(kfs).buildAll();
        Assert.assertEquals((long)2L, (long)kb.getResults().getMessages().size());
    }

    @Test
    public void testNoPomXml() throws ClassNotFoundException, InterruptedException, IOException {
        String namespace = "org.kie.test";
        KieModuleModel kProj = this.createKieProject(namespace);
        ReleaseId releaseId = KieServices.Factory.get().getRepository().getDefaultReleaseId();
        KieFileSystem kfs = KieServices.Factory.get().newKieFileSystem();
        this.generateKProjectXML(kfs, namespace, kProj);
        this.generateMessageClass(kfs, namespace);
        this.generateRule(kfs, namespace);
        MemoryFileSystem mfs = ((KieFileSystemImpl)kfs).asMemoryFileSystem();
        this.createAndTestKieContainer(releaseId, this.createKieBuilder(kfs), namespace);
    }

    @Test
    public void testNoProjectXml() throws ClassNotFoundException, InterruptedException, IOException {
        String namespace = "org.kie.test";
        ReleaseId releaseId = KieServices.Factory.get().newReleaseId(namespace, "memory", "1.0");
        KieFileSystem kfs = KieServices.Factory.get().newKieFileSystem();
        this.generatePomXML(kfs, releaseId);
        this.generateMessageClass(kfs, namespace);
        this.generateRule(kfs, namespace);
        MemoryFileSystem mfs = ((KieFileSystemImpl)kfs).asMemoryFileSystem();
        this.createAndTestKieContainer(releaseId, this.createKieBuilder(kfs), null);
    }

    @Test
    public void testEmptyProjectXml() throws ClassNotFoundException, InterruptedException, IOException {
        String namespace = "org.kie.test";
        KieServices ks = KieServices.Factory.get();
        KieModuleModel kProj = ks.newKieModuleModel();
        ReleaseId releaseId = KieServices.Factory.get().newReleaseId(namespace, "memory", "1.0");
        KieFileSystem kfs = KieServices.Factory.get().newKieFileSystem();
        this.generateKProjectXML(kfs, namespace, kProj);
        this.generatePomXML(kfs, releaseId);
        this.generateMessageClass(kfs, namespace);
        this.generateRule(kfs, namespace);
        MemoryFileSystem mfs = ((KieFileSystemImpl)kfs).asMemoryFileSystem();
        this.createAndTestKieContainer(releaseId, this.createKieBuilder(kfs), null);
    }

    @Test
    public void testNoPomAndProjectXml() throws ClassNotFoundException, InterruptedException, IOException {
        String namespace = "org.kie.test";
        ReleaseId releaseId = KieServices.Factory.get().getRepository().getDefaultReleaseId();
        KieFileSystem kfs = KieServices.Factory.get().newKieFileSystem();
        this.generateMessageClass(kfs, namespace);
        this.generateRule(kfs, namespace);
        MemoryFileSystem mfs = ((KieFileSystemImpl)kfs).asMemoryFileSystem();
        this.createAndTestKieContainer(releaseId, this.createKieBuilder(kfs), null);
    }

    @Test
    public void testInvalidPomXmlGAV() throws ClassNotFoundException, InterruptedException, IOException {
        String namespace = "org.kie.test";
        KieModuleModel kProj = this.createKieProject(namespace);
        ReleaseIdImpl releaseId = new ReleaseIdImpl("", "", "");
        KieFileSystem kfs = KieServices.Factory.get().newKieFileSystem();
        this.generatePomXML(kfs, (ReleaseId)releaseId);
        this.generateMessageClass(kfs, namespace);
        this.generateRule(kfs, namespace);
        MemoryFileSystem mfs = ((KieFileSystemImpl)kfs).asMemoryFileSystem();
        KieBuilder kieBuilder = this.createKieBuilder(kfs);
        kieBuilder.buildAll();
        Assert.assertTrue((boolean)kieBuilder.getResults().hasMessages(new Message.Level[]{Message.Level.ERROR}));
    }

    @Test
    public void testInvalidPomXmlContent() throws ClassNotFoundException, InterruptedException, IOException {
        String namespace = "org.kie.test";
        KieModuleModel kProj = this.createKieProject(namespace);
        ReleaseId releaseId = KieServices.Factory.get().newReleaseId(namespace, "memory", "1.0");
        KieFileSystem kfs = KieServices.Factory.get().newKieFileSystem();
        kfs.write("pom.xml", "xxxx");
        this.generateKProjectXML(kfs, namespace, kProj);
        this.generateMessageClass(kfs, namespace);
        this.generateRule(kfs, namespace);
        KieBuilder kieBuilder = this.createKieBuilder(kfs);
        kieBuilder.buildAll();
        Assert.assertTrue((boolean)kieBuilder.getResults().hasMessages(new Message.Level[]{Message.Level.ERROR}));
    }

    @Test
    public void testInvalidProjectXml() throws ClassNotFoundException, InterruptedException, IOException {
        String namespace = "org.kie.test";
        KieModuleModel kProj = this.createKieProject(namespace);
        ReleaseId releaseId = KieServices.Factory.get().newReleaseId(namespace, "memory", "1.0");
        KieFileSystem kfs = KieServices.Factory.get().newKieFileSystem();
        this.generatePomXML(kfs, releaseId);
        kfs.writeKModuleXML("xxxx");
        this.generateMessageClass(kfs, namespace);
        this.generateRule(kfs, namespace);
        KieBuilder kieBuilder = this.createKieBuilder(kfs);
        kieBuilder.buildAll();
        Assert.assertTrue((boolean)kieBuilder.getResults().hasMessages(new Message.Level[]{Message.Level.ERROR}));
    }

    @Test
    public void testSetPomModelReuse() throws IOException {
        int charCode;
        String namespace = "org.kie.test";
        ReleaseId releaseId = KieServices.Factory.get().newReleaseId(namespace, "pomModelReuse", "1.0");
        String pom = KieBuilderImpl.generatePomXml((ReleaseId)releaseId);
        KieFileSystem kfs = KieServices.Factory.get().newKieFileSystem();
        kfs.writePomXML(pom);
        KieBuilder kieBuilder1 = this.createKieBuilder(kfs);
        kieBuilder1.buildAll();
        PomModel pomModel = ((KieBuilderImpl)kieBuilder1).getPomModel();
        kfs.writePomXML(pom);
        KieBuilder kieBuilder2 = this.createKieBuilder(kfs);
        ((KieBuilderImpl)kieBuilder2).setPomModel(pomModel);
        kieBuilder2.buildAll();
        InternalKieModule kieModule1 = (InternalKieModule)((KieBuilderImpl)kieBuilder1).getKieModuleIgnoringErrors();
        Reader reader1 = kieModule1.getResource("META-INF/maven/org.kie.test/pomModelReuse/pom.xml").getReader();
        String readPom1 = "";
        while ((charCode = reader1.read()) != -1) {
            readPom1 = readPom1 + (char)charCode;
        }
        reader1.close();
        Assert.assertEquals((Object)pom, (Object)readPom1);
        InternalKieModule kieModule2 = (InternalKieModule)((KieBuilderImpl)kieBuilder2).getKieModuleIgnoringErrors();
        Reader reader2 = kieModule2.getResource("META-INF/maven/org.kie.test/pomModelReuse/pom.xml").getReader();
        String readPom2 = "";
        while ((charCode = reader2.read()) != -1) {
            readPom2 = readPom2 + (char)charCode;
        }
        reader1.close();
        Assert.assertEquals((Object)pom, (Object)readPom2);
    }

    public KieModuleModel createKieProject(String namespace) {
        KieServices ks = KieServices.Factory.get();
        KieModuleModel kProj = ks.newKieModuleModel();
        KieBaseModel kBase1 = kProj.newKieBaseModel(namespace).setEqualsBehavior(EqualityBehaviorOption.EQUALITY).setEventProcessingMode(EventProcessingOption.STREAM);
        return kProj;
    }

    public void generateAll(KieFileSystem kfs, String namespace, ReleaseId releaseId, KieModuleModel kProj) {
        this.generatePomXML(kfs, releaseId);
        this.generateKProjectXML(kfs, namespace, kProj);
        this.generateMessageClass(kfs, namespace);
        this.generateRule(kfs, namespace);
    }

    public void generatePomXML(KieFileSystem kfs, ReleaseId releaseId) {
        kfs.writePomXML(KieBuilderImpl.generatePomXml((ReleaseId)releaseId));
    }

    public void generateKProjectXML(KieFileSystem kfs, String namespace, KieModuleModel kProj) {
        kfs.writeKModuleXML(kProj.toXML());
    }

    public void generateMessageClass(KieFileSystem kfs, String namespace) {
        kfs.write("src/main/java/" + namespace.replace('.', '/') + "/Message.java", this.getMessageClass(namespace));
    }

    public void generateRule(KieFileSystem kfs, String namespace) {
        kfs.write("src/main/resources/" + namespace.replace('.', '/') + "/rule1.drl", this.getRule(namespace, namespace, "r1"));
    }

    public KieBuilder createKieBuilder(KieFileSystem kfs) {
        KieServices ks = KieServices.Factory.get();
        return ks.newKieBuilder(kfs);
    }

    public KieBuilder createKieBuilder(File file) {
        KieServices ks = KieServices.Factory.get();
        return ks.newKieBuilder(file);
    }

    public void createAndTestKieContainer(ReleaseId releaseId, KieBuilder kb, String kBaseName) throws IOException, ClassNotFoundException, InterruptedException {
        KieServices ks = KieServices.Factory.get();
        kb.buildAll();
        if (kb.getResults().hasMessages(new Message.Level[]{Message.Level.ERROR})) {
            Assert.fail((String)("Unable to build KieModule\n" + kb.getResults().toString()));
        }
        KieRepository kr = ks.getRepository();
        KieModule kJar = kr.getKieModule(releaseId);
        Assertions.assertThat((Object)kJar).isNotNull();
        KieContainer kContainer = ks.newKieContainer(releaseId);
        KieBase kBase = kBaseName != null ? kContainer.getKieBase(kBaseName) : kContainer.getKieBase();
        KieSession kSession = kBase.newKieSession();
        ArrayList list = new ArrayList();
        kSession.setGlobal("list", list);
        kSession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)"org.kie.test.Message", (Object)list.get(0).getClass().getName());
    }

    public String getRule(String namespace, String messageNS, String ruleName) {
        String s = "package " + namespace + "\nimport " + messageNS + ".Message;\nglobal java.util.List list;\nrule " + ruleName + " when \nthen \n  Message msg = new Message('hello');  list.add(msg); end \n";
        return s;
    }

    public String getMessageClass(String namespace) {
        String s = "package " + namespace + ";\nimport java.lang.*;\npublic class Message  {\n    private String text; \n     public Message(String text) { \n        this.text = text; \n    } \n    \n    public String getText() { \n        return this.text;\n    }\n}\n";
        return s;
    }
}

