/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.compiler.builder;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.HashSet;
import org.assertj.core.api.Assertions;
import org.drools.core.base.accumulators.AverageAccumulateFunction;
import org.drools.core.base.accumulators.MaxAccumulateFunction;
import org.drools.mvel.evaluators.AfterEvaluatorDefinition;
import org.drools.mvel.evaluators.BeforeEvaluatorDefinition;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.runtime.rule.AccumulateFunction;
import org.kie.api.runtime.rule.EvaluatorDefinition;
import org.kie.internal.builder.KnowledgeBuilderConfiguration;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.builder.conf.AccumulateFunctionOption;
import org.kie.internal.builder.conf.DefaultDialectOption;
import org.kie.internal.builder.conf.DefaultPackageNameOption;
import org.kie.internal.builder.conf.DumpDirOption;
import org.kie.internal.builder.conf.EvaluatorOption;
import org.kie.internal.builder.conf.KnowledgeBuilderOption;
import org.kie.internal.builder.conf.LanguageLevelOption;
import org.kie.internal.builder.conf.ProcessStringEscapesOption;

public class KnowledgeBuilderConfigurationTest {
    private KnowledgeBuilderConfiguration config;

    @Before
    public void setUp() throws Exception {
        this.config = KnowledgeBuilderFactory.newKnowledgeBuilderConfiguration();
    }

    @Test
    public void testDefaultDialectConfiguration() {
        this.config.setOption((KnowledgeBuilderOption)DefaultDialectOption.get((String)"mvel"));
        Assert.assertEquals((Object)DefaultDialectOption.get((String)"mvel"), (Object)this.config.getOption(DefaultDialectOption.class));
        Assert.assertEquals((Object)"mvel", (Object)((DefaultDialectOption)this.config.getOption(DefaultDialectOption.class)).getName());
        Assert.assertEquals((Object)"mvel", (Object)this.config.getProperty("drools.dialect.default"));
        this.config.setProperty("drools.dialect.default", "java");
        Assert.assertEquals((Object)DefaultDialectOption.get((String)"java"), (Object)this.config.getOption(DefaultDialectOption.class));
        Assert.assertEquals((Object)"DefaultDialectOption( name=java )", (Object)((DefaultDialectOption)this.config.getOption(DefaultDialectOption.class)).toString());
        Assert.assertEquals((Object)"java", (Object)((DefaultDialectOption)this.config.getOption(DefaultDialectOption.class)).getName());
        Assert.assertEquals((Object)"java", (Object)this.config.getProperty("drools.dialect.default"));
    }

    @Test
    public void testLanguageLevelConfiguration() {
        this.config.setOption((KnowledgeBuilderOption)LanguageLevelOption.DRL5);
        Assert.assertEquals((Object)LanguageLevelOption.DRL5, (Object)this.config.getOption(LanguageLevelOption.class));
        Assert.assertEquals((Object)LanguageLevelOption.DRL5, (Object)this.config.getOption(LanguageLevelOption.class));
        Assert.assertEquals((Object)"DRL5", (Object)this.config.getProperty("drools.lang.level"));
        this.config.setProperty("drools.lang.level", "DRL6");
        Assert.assertEquals((Object)LanguageLevelOption.DRL6, (Object)this.config.getOption(LanguageLevelOption.class));
        Assert.assertEquals((Object)"DRL6", (Object)((LanguageLevelOption)this.config.getOption(LanguageLevelOption.class)).toString());
        Assert.assertEquals((Object)LanguageLevelOption.DRL6, (Object)this.config.getOption(LanguageLevelOption.class));
        Assert.assertEquals((Object)"DRL6", (Object)this.config.getProperty("drools.lang.level"));
    }

    @Test
    public void testAccumulateFunctionConfiguration() {
        HashSet<String> keySet = new HashSet<String>();
        AverageAccumulateFunction function = new AverageAccumulateFunction();
        AccumulateFunctionOption option = AccumulateFunctionOption.get((String)"avg", (AccumulateFunction)function);
        this.config.setOption((KnowledgeBuilderOption)option);
        Assert.assertEquals((Object)option, (Object)this.config.getOption(AccumulateFunctionOption.class, "avg"));
        Assert.assertEquals((Object)"avg", (Object)((AccumulateFunctionOption)this.config.getOption(AccumulateFunctionOption.class, "avg")).getName());
        Assert.assertEquals((Object)function, (Object)((AccumulateFunctionOption)this.config.getOption(AccumulateFunctionOption.class, "avg")).getFunction());
        Assert.assertEquals((Object)AverageAccumulateFunction.class.getName(), (Object)this.config.getProperty("drools.accumulate.function.avg"));
        keySet.add("avg");
        Assert.assertTrue((boolean)this.config.getOptionKeys(AccumulateFunctionOption.class).contains("avg"));
        this.config.setProperty("drools.accumulate.function.maximum", MaxAccumulateFunction.class.getName());
        MaxAccumulateFunction max = new MaxAccumulateFunction();
        Assert.assertEquals((Object)AccumulateFunctionOption.get((String)"maximum", (AccumulateFunction)max), (Object)this.config.getOption(AccumulateFunctionOption.class, "maximum"));
        Assert.assertEquals((Object)"maximum", (Object)((AccumulateFunctionOption)this.config.getOption(AccumulateFunctionOption.class, "maximum")).getName());
        Assert.assertEquals((Object)max.getClass().getName(), (Object)((AccumulateFunctionOption)this.config.getOption(AccumulateFunctionOption.class, "maximum")).getFunction().getClass().getName());
        Assert.assertEquals((Object)MaxAccumulateFunction.class.getName(), (Object)this.config.getProperty("drools.accumulate.function.maximum"));
        keySet.add("avg");
        this.config.setProperty("drools.accumulate.function.inner", InnerAccumulateFuncion.class.getName());
        InnerAccumulateFuncion inner = new InnerAccumulateFuncion();
        Assert.assertEquals((Object)AccumulateFunctionOption.get((String)"inner", (AccumulateFunction)inner), (Object)this.config.getOption(AccumulateFunctionOption.class, "inner"));
        Assert.assertEquals((Object)"inner", (Object)((AccumulateFunctionOption)this.config.getOption(AccumulateFunctionOption.class, "inner")).getName());
        Assert.assertEquals((Object)inner.getClass().getName(), (Object)((AccumulateFunctionOption)this.config.getOption(AccumulateFunctionOption.class, "inner")).getFunction().getClass().getName());
        Assert.assertEquals((Object)InnerAccumulateFuncion.class.getName(), (Object)this.config.getProperty("drools.accumulate.function.inner"));
        keySet.add("avg");
        Assert.assertTrue((boolean)this.config.getOptionKeys(AccumulateFunctionOption.class).containsAll(keySet));
    }

    @Test
    public void testDumpDirectoryConfiguration() {
        File dumpDir = new File("target");
        this.config.setOption((KnowledgeBuilderOption)DumpDirOption.get((File)dumpDir));
        Assert.assertEquals((Object)DumpDirOption.get((File)dumpDir), (Object)this.config.getOption(DumpDirOption.class));
        Assert.assertEquals((Object)dumpDir, (Object)((DumpDirOption)this.config.getOption(DumpDirOption.class)).getDirectory());
        Assert.assertEquals((Object)dumpDir.toString(), (Object)this.config.getProperty("drools.dump.dir"));
        dumpDir = new File(System.getProperty("java.io.tmpdir"));
        this.config.setProperty("drools.dump.dir", System.getProperty("java.io.tmpdir"));
        Assert.assertEquals((Object)DumpDirOption.get((File)dumpDir), (Object)this.config.getOption(DumpDirOption.class));
        Assert.assertEquals((Object)dumpDir, (Object)((DumpDirOption)this.config.getOption(DumpDirOption.class)).getDirectory());
        Assert.assertEquals((Object)dumpDir.toString(), (Object)this.config.getProperty("drools.dump.dir"));
    }

    @Test
    public void testEvaluatorConfiguration() {
        AfterEvaluatorDefinition afterDef = new AfterEvaluatorDefinition();
        Assertions.assertThat((Object)afterDef).isNotNull();
        EvaluatorOption option = EvaluatorOption.get((String)"after", (EvaluatorDefinition)afterDef);
        this.config.setOption((KnowledgeBuilderOption)option);
        Assert.assertEquals((Object)option, (Object)this.config.getOption(EvaluatorOption.class, "after"));
        Assert.assertEquals((Object)"after", (Object)((EvaluatorOption)this.config.getOption(EvaluatorOption.class, "after")).getName());
        Assert.assertEquals((Object)afterDef, (Object)((EvaluatorOption)this.config.getOption(EvaluatorOption.class, "after")).getEvaluatorDefinition());
        Assert.assertEquals((Object)AfterEvaluatorDefinition.class.getName(), (Object)this.config.getProperty("drools.evaluator.after"));
        this.config.setProperty("drools.evaluator.before", BeforeEvaluatorDefinition.class.getName());
        BeforeEvaluatorDefinition beforeDef = new BeforeEvaluatorDefinition();
        Assert.assertEquals((Object)EvaluatorOption.get((String)"before", (EvaluatorDefinition)beforeDef), (Object)this.config.getOption(EvaluatorOption.class, "before"));
        Assert.assertEquals((Object)"before", (Object)((EvaluatorOption)this.config.getOption(EvaluatorOption.class, "before")).getName());
        Assert.assertEquals((Object)beforeDef.getClass().getName(), (Object)((EvaluatorOption)this.config.getOption(EvaluatorOption.class, "before")).getEvaluatorDefinition().getClass().getName());
        Assert.assertEquals((Object)beforeDef.getClass().getName(), (Object)this.config.getProperty("drools.evaluator.before"));
    }

    @Test
    public void testProcessStringEscapesConfiguration() {
        this.config.setOption((KnowledgeBuilderOption)ProcessStringEscapesOption.YES);
        Assert.assertEquals((Object)ProcessStringEscapesOption.YES, (Object)this.config.getOption(ProcessStringEscapesOption.class));
        Assert.assertEquals((Object)"true", (Object)this.config.getProperty("drools.parser.processStringEscapes"));
        this.config.setProperty("drools.parser.processStringEscapes", "false");
        Assert.assertEquals((Object)ProcessStringEscapesOption.NO, (Object)this.config.getOption(ProcessStringEscapesOption.class));
        Assert.assertEquals((Object)"false", (Object)this.config.getProperty("drools.parser.processStringEscapes"));
    }

    @Test
    public void testDefaultPackageNameConfiguration() {
        this.config.setOption((KnowledgeBuilderOption)DefaultPackageNameOption.get((String)"org.drools.mvel.compiler.test"));
        Assert.assertEquals((Object)DefaultPackageNameOption.get((String)"org.drools.mvel.compiler.test"), (Object)this.config.getOption(DefaultPackageNameOption.class));
        Assert.assertEquals((Object)"org.drools.mvel.compiler.test", (Object)((DefaultPackageNameOption)this.config.getOption(DefaultPackageNameOption.class)).getPackageName());
        Assert.assertEquals((Object)"org.drools.mvel.compiler.test", (Object)this.config.getProperty("drools.defaultPackageName"));
        this.config.setProperty("drools.defaultPackageName", "org.drools");
        Assert.assertEquals((Object)DefaultPackageNameOption.get((String)"org.drools"), (Object)this.config.getOption(DefaultPackageNameOption.class));
        Assert.assertEquals((Object)"org.drools", (Object)((DefaultPackageNameOption)this.config.getOption(DefaultPackageNameOption.class)).getPackageName());
        Assert.assertEquals((Object)"org.drools", (Object)this.config.getProperty("drools.defaultPackageName"));
    }

    public static class InnerAccumulateFuncion
    implements AccumulateFunction {
        public void accumulate(Serializable context, Object value) {
        }

        public Serializable createContext() {
            return null;
        }

        public Object getResult(Serializable context) throws Exception {
            return null;
        }

        public void init(Serializable context) throws Exception {
        }

        public void reverse(Serializable context, Object value) throws Exception {
        }

        public boolean supportsReverse() {
            return false;
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        }

        public void writeExternal(ObjectOutput out) throws IOException {
        }

        public Class<?> getResultType() {
            return Object.class;
        }
    }
}

