/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.core.base.ClassObjectType;
import org.drools.core.reteoo.AlphaNode;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.rule.constraint.AlphaNodeFieldConstraint;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.mvel.MVELConstraint;
import org.drools.mvel.accessors.ClassFieldReader;
import org.drools.mvel.compiler.Address;
import org.drools.mvel.compiler.Cheese;
import org.drools.mvel.compiler.Cheesery;
import org.drools.mvel.compiler.FactA;
import org.drools.mvel.compiler.Person;
import org.drools.mvel.compiler.TestEnum;
import org.drools.mvel.expr.MVELDebugHandler;
import org.drools.mvel.extractors.MVELObjectClassFieldReader;
import org.drools.mvel.integrationtests.SerializationHelper;
import org.drools.mvel.integrationtests.TestObject;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.drools.util.DateUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.Message;
import org.kie.api.definition.type.FactType;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.StatelessKieSession;
import org.mvel2.MVEL;
import org.mvel2.ParserContext;

@RunWith(value=Parameterized.class)
public class MVELTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public MVELTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)false);
    }

    @Test
    public void testHelloWorld() {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_mvel.drl"});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ArrayList list2 = new ArrayList();
        ksession.setGlobal("list2", list2);
        Cheese c = new Cheese("stilton", 10);
        ksession.insert((Object)c);
        ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((Object)BigInteger.valueOf(30L), list.get(0));
        Assert.assertEquals((Object)22, list.get(1));
        Assert.assertEquals((Object)"hello world", list2.get(0));
        Date dt = DateUtils.parseDate((String)"10-Jul-1974");
        Assert.assertEquals((Object)dt, (Object)c.getUsedBy());
    }

    @Test
    public void testIncrementOperator() {
        String str = "";
        str = str + "package org.kie \n";
        str = str + "global java.util.List list \n";
        str = str + "rule rule1 \n";
        str = str + "    dialect \"mvel\" \n";
        str = str + "when \n";
        str = str + "    $I : Integer() \n";
        str = str + "then \n";
        str = str + "    i = $I.intValue(); \n";
        str = str + "    i += 5; \n";
        str = str + "    list.add( i ); \n";
        str = str + "end \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)5);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)10, list.get(0));
    }

    @Test
    public void testEvalWithBigDecimal() {
        String str = "";
        str = str + "package org.kie \n";
        str = str + "import java.math.BigDecimal; \n";
        str = str + "global java.util.List list \n";
        str = str + "rule rule1 \n";
        str = str + "    dialect \"mvel\" \n";
        str = str + "when \n";
        str = str + "    $bd : BigDecimal() \n";
        str = str + "    eval( $bd.compareTo( BigDecimal.ZERO ) > 0 ) \n";
        str = str + "then \n";
        str = str + "    list.add( $bd ); \n";
        str = str + "end \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)new BigDecimal(1.5));
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)new BigDecimal(1.5), list.get(0));
    }

    @Test
    public void testLocalVariableMVELConsequence() {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_LocalVariableMVELConsequence.drl"});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("results", list);
        ksession.insert((Object)new Person("bob", "stilton"));
        ksession.insert((Object)new Person("mark", "brie"));
        try {
            ksession.fireAllRules();
            Assert.assertEquals((String)"should have fired twice", (long)2L, (long)list.size());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"Should not raise any exception");
        }
    }

    @Test
    public void testMVELUsingGlobalsInDebugMode() {
        MVELDebugHandler.setDebugMode((boolean)true);
        try {
            KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_MVELGlobalDebug.drl"});
            KieSession ksession = kbase.newKieSession();
            ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, false);
            ksession.dispose();
            MVELDebugHandler.setDebugMode((boolean)false);
        }
        catch (Exception e) {
            MVELDebugHandler.setDebugMode((boolean)false);
            e.printStackTrace();
            Assert.fail((String)"Should not raise exceptions");
        }
    }

    @Test
    public void testDuplicateLocalVariableMVELConsequence() {
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromClasspathResources((KieBaseTestConfiguration)this.kieBaseTestConfiguration, this.getClass(), (boolean)false, (String[])new String[]{"test_DuplicateLocalVariableMVELConsequence.drl"});
        List errors = kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR});
        Assert.assertFalse((String)"Should have an error", (boolean)errors.isEmpty());
    }

    @Test
    public void testArrays() {
        String text = "package test_mvel;\n";
        text = text + "import " + TestObject.class.getCanonicalName() + ";\n";
        text = text + "import function " + TestObject.class.getCanonicalName() + ".array;\n";
        text = text + "no-loop true\n";
        text = text + "dialect \"mvel\"\n";
        text = text + "rule \"1\"\n";
        text = text + "salience 1\n";
        text = text + "when\n";
        text = text + "    $fact: TestObject()\n";
        text = text + "    eval($fact.checkHighestPriority(\"mvel\", 2))\n";
        text = text + "    eval($fact.stayHasDaysOfWeek(\"mvel\", false, new String[][]{{\"2008-04-01\", \"2008-04-10\"}}))\n";
        text = text + "then\n";
        text = text + "    $fact.applyValueAddPromo(1,2,3,4,\"mvel\");\n";
        text = text + "end";
        KieBase kieBase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{text.replaceAll("_mvel", "_java").replaceAll("\"mvel\"", "\"java\""), text});
        StatelessKieSession statelessKieSession = kieBase.newStatelessKieSession();
        ArrayList list = new ArrayList();
        statelessKieSession.execute((Object)new TestObject(list));
        Assert.assertEquals((long)6L, (long)list.size());
        Assert.assertTrue((boolean)list.containsAll(Arrays.asList("TestObject.checkHighestPriority: java|2", "TestObject.stayHasDaysOfWeek: java|false|[2008-04-01, 2008-04-10]", "TestObject.checkHighestPriority: mvel|2", "TestObject.stayHasDaysOfWeek: mvel|false|[2008-04-01, 2008-04-10]", "TestObject.applyValueAddPromo: 1|2|3|4|mvel", "TestObject.applyValueAddPromo: 1|2|3|4|java")));
    }

    @Test
    public void testPackageImports() {
        String str = "";
        str = str + "package org.kie \n";
        str = str + "dialect \"mvel\"\n";
        str = str + "import org.acme.healthcare.* \n";
        str = str + "import org.acme.insurance.* \n";
        str = str + "import org.acme.sensors.SensorReading \n";
        str = str + "rule rule1 \n";
        str = str + "  when \n";
        str = str + "    eval(true)\n";
        str = str + "  then \n";
        str = str + "    insert(new Claim());         // from org.acme.healthcare.* \n";
        str = str + "    insert(new Policy());        // from org.acme.insurance.* \n";
        str = str + "    insert(new SensorReading()); // from org.acme.sensor.SensorReading \n";
        str = str + "end\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        int result = ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)result);
        Collection insertedObjects = ksession.getObjects();
        Assert.assertEquals((long)3L, (long)insertedObjects.size());
    }

    @Test
    public void testSizeCheckInObject() {
        String str = "package org.drools.mvel.compiler.test \nimport " + Triangle.class.getCanonicalName() + "\nglobal java.util.List list \nrule \"show\" \nwhen  \n    $m : Triangle( deliveries.size == 0) \nthen \n    list.add('r1'); \nend \n";
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{str});
        List errors = kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR});
        Assert.assertTrue((String)errors.toString(), (boolean)errors.isEmpty());
    }

    @Test
    public void testNestedEnum() {
        String str = "package org.drools.mvel.compiler.test \nimport " + Triangle.class.getCanonicalName() + "\nglobal java.util.List list \nrule \"show\" \nwhen  \n    $t: Triangle(t == Triangle.Type.ACUTE) \nthen \n    list.add($t.getT()); \nend \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Triangle t = new Triangle(Triangle.Type.ACUTE);
        ksession.insert((Object)t);
        ksession.fireAllRules();
        Assert.assertEquals((Object)((Object)Triangle.Type.ACUTE), list.get(0));
    }

    @Test
    public void testNestedEnumWithMap() {
        String str = "package org.drools.mvel.compiler.test \nimport " + DMap.class.getCanonicalName() + " \nimport " + Triangle.class.getCanonicalName() + "\nglobal java.util.List list \nrule \"show\" \nwhen  \n    $m : DMap( this[Triangle.Type.ACUTE] == 'xxx') \nthen \n    list.add('r1'); \nend \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        DMap m = new DMap();
        m.put(Triangle.Type.ACUTE, "xxx");
        ksession.insert((Object)m);
        ksession.fireAllRules();
        Assert.assertEquals((Object)"r1", list.get(0));
    }

    @Test
    public void testNewConstructor() {
        AlphaNode alphanode;
        AlphaNodeFieldConstraint constraint;
        String str = "package org.drools.mvel.compiler.test \nimport " + Person.class.getCanonicalName() + "\nimport " + Address.class.getCanonicalName() + "\nglobal java.util.List list \nrule \"show\" \nwhen  \n    $m : Person( address == new Address('s1')) \nthen \n    list.add('r1'); \nend \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Person p = new Person("yoda");
        p.setAddress(new Address("s1"));
        ksession.insert((Object)p);
        ksession.fireAllRules();
        Assert.assertEquals((Object)"r1", list.get(0));
        List nodes = ((InternalKnowledgeBase)kbase).getRete().getObjectTypeNodes();
        ObjectTypeNode node = null;
        for (ObjectTypeNode n : nodes) {
            if (((ClassObjectType)n.getObjectType()).getClassType() != Person.class) continue;
            node = n;
            break;
        }
        if ((constraint = (alphanode = (AlphaNode)node.getObjectSinkPropagator().getSinks()[0]).getConstraint()) instanceof MVELConstraint) {
            Assert.assertTrue((boolean)(((MVELConstraint)constraint).getFieldExtractor() instanceof ClassFieldReader));
        }
    }

    @Test
    public void testArrayAccessorWithGenerics() {
        AlphaNode alphanode;
        AlphaNodeFieldConstraint constraint;
        String str = "package org.drools.mvel.compiler.test \nimport " + Person.class.getCanonicalName() + "\nimport " + Address.class.getCanonicalName() + "\nglobal java.util.List list \nrule \"show\" \nwhen  \n    $m : Person( addresses[0] == new Address('s1'), addresses[0].street == new Address('s1').street ) \nthen \n    list.add('r1'); \nend \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Person p = new Person("yoda");
        p.addAddress(new Address("s1"));
        ksession.insert((Object)p);
        ksession.fireAllRules();
        Assert.assertEquals((Object)"r1", list.get(0));
        List nodes = ((InternalKnowledgeBase)kbase).getRete().getObjectTypeNodes();
        ObjectTypeNode node = null;
        for (ObjectTypeNode n : nodes) {
            if (((ClassObjectType)n.getObjectType()).getClassType() != Person.class) continue;
            node = n;
            break;
        }
        if ((constraint = (alphanode = (AlphaNode)node.getObjectSinkPropagator().getSinks()[0]).getConstraint()) instanceof MVELConstraint) {
            Assert.assertTrue((boolean)(((MVELConstraint)constraint).getFieldExtractor() instanceof MVELObjectClassFieldReader));
        }
        if ((constraint = (alphanode = (AlphaNode)alphanode.getObjectSinkPropagator().getSinks()[0]).getConstraint()) instanceof MVELConstraint) {
            Assert.assertTrue((boolean)(((MVELConstraint)constraint).getFieldExtractor() instanceof MVELObjectClassFieldReader));
        }
    }

    @Test
    public void testArrayAccessorWithStaticFieldAccess() {
        AlphaNode alphanode;
        AlphaNodeFieldConstraint constraint;
        String str = "package org.drools.mvel.compiler.test \nimport " + Person.class.getCanonicalName() + "\nimport " + Address.class.getCanonicalName() + "\nimport " + Triangle.class.getCanonicalName() + "\nglobal java.util.List list \nrule \"show\" \nwhen  \n    $m : Person( addresses[Triangle.ZERO] == new Address('s1'), addresses[Triangle.ZERO].street == new Address('s1').street ) \nthen \n    list.add('r1'); \nend \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Person p = new Person("yoda");
        p.addAddress(new Address("s1"));
        ksession.insert((Object)p);
        ksession.fireAllRules();
        Assert.assertEquals((Object)"r1", list.get(0));
        List nodes = ((InternalKnowledgeBase)kbase).getRete().getObjectTypeNodes();
        ObjectTypeNode node = null;
        for (ObjectTypeNode n : nodes) {
            if (((ClassObjectType)n.getObjectType()).getClassType() != Person.class) continue;
            node = n;
            break;
        }
        if ((constraint = (alphanode = (AlphaNode)node.getObjectSinkPropagator().getSinks()[0]).getConstraint()) instanceof MVELConstraint) {
            Assert.assertTrue((boolean)(((MVELConstraint)alphanode.getConstraint()).getFieldExtractor() instanceof MVELObjectClassFieldReader));
        }
        if ((constraint = (alphanode = (AlphaNode)alphanode.getObjectSinkPropagator().getSinks()[0]).getConstraint()) instanceof MVELConstraint) {
            Assert.assertTrue((boolean)(((MVELConstraint)alphanode.getConstraint()).getFieldExtractor() instanceof MVELObjectClassFieldReader));
        }
    }

    @Test
    public void testMapAccessorWithStaticFieldAccess() {
        AlphaNode alphanode;
        AlphaNodeFieldConstraint constraint;
        String str = "package org.drools.mvel.compiler.test \nimport " + Person.class.getCanonicalName() + "\nimport " + Address.class.getCanonicalName() + "\nimport " + TestEnum.class.getCanonicalName() + "\nglobal java.util.List list \nrule \"show\" \nwhen  \n    $m : Person( namedAddresses[TestEnum.ONE] == new Address('s1'), namedAddresses[TestEnum.ONE].street == new Address('s1').street ) \nthen \n    list.add('r1'); \nend \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Person p = new Person("yoda");
        p.getNamedAddresses().put((Object)TestEnum.ONE, new Address("s1"));
        ksession.insert((Object)p);
        ksession.fireAllRules();
        Assert.assertEquals((Object)"r1", list.get(0));
        List nodes = ((InternalKnowledgeBase)kbase).getRete().getObjectTypeNodes();
        ObjectTypeNode node = null;
        for (ObjectTypeNode n : nodes) {
            if (((ClassObjectType)n.getObjectType()).getClassType() != Person.class) continue;
            node = n;
            break;
        }
        if ((constraint = (alphanode = (AlphaNode)node.getObjectSinkPropagator().getSinks()[0]).getConstraint()) instanceof MVELConstraint) {
            Assert.assertTrue((boolean)(((MVELConstraint)alphanode.getConstraint()).getFieldExtractor() instanceof MVELObjectClassFieldReader));
        }
        if ((constraint = (alphanode = (AlphaNode)alphanode.getObjectSinkPropagator().getSinks()[0]).getConstraint()) instanceof MVELConstraint) {
            Assert.assertTrue((boolean)(((MVELConstraint)alphanode.getConstraint()).getFieldExtractor() instanceof MVELObjectClassFieldReader));
        }
    }

    @Test
    public void testArrayAccessorWithoutGenerics() {
        String str = "package org.drools.mvel.compiler.test \nimport " + Person.class.getCanonicalName() + "\nimport " + Address.class.getCanonicalName() + "\nglobal java.util.List list \nrule \"show\" \nwhen  \n    $m : Person( addressesNoGenerics[0].street == new Address('s1').street) \nthen \n    list.add('r1'); \nend \n";
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{str});
        List errors = kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR});
        Assert.assertFalse((String)"Should have an error", (boolean)errors.isEmpty());
    }

    public Object compiledExecute(String ex) {
        Serializable compiled = MVEL.compileExpression((String)ex);
        return MVEL.executeExpression((Object)compiled, (Object)new Object(), new HashMap());
    }

    @Test
    public void test1() {
        ParserContext pc = new ParserContext();
        pc.addInput("x", String.class);
        pc.setStrongTyping(true);
        Serializable o = MVEL.compileExpression((String)"x.startsWith('d')", (ParserContext)pc);
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("x", "d");
        MVEL.executeExpression((Object)o, vars);
        System.out.println(o);
    }

    @Test
    public void testTokensInString() {
        String[] operators = new String[]{",", "=", "|=", "*"};
        String strBegin = "package org.kie \nimport org.drools.mvel.compiler.Cheese \ndialect \"mvel\"\nrule rule1 \nwhen \n$c:Cheese(type==\"swiss\") \nthen \nmodify($c){ type = \"swiss";
        String strEnd = "good\"};\nend\n";
        for (String oper : operators) {
            String rule = "package org.kie \nimport org.drools.mvel.compiler.Cheese \ndialect \"mvel\"\nrule rule1 \nwhen \n$c:Cheese(type==\"swiss\") \nthen \nmodify($c){ type = \"swiss" + oper + "good\"};\nend\n";
            System.out.print(rule);
            KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{rule});
            List errors = kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR});
            Assert.assertTrue((String)errors.toString(), (boolean)errors.isEmpty());
        }
    }

    @Test
    public void testGeneratedBeansMVEL() throws IllegalAccessException, InstantiationException {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_GeneratedBeansMVEL.drl"});
        FactType pf = kbase.getFactType("mortgages", "Applicant");
        FactType af = kbase.getFactType("mortgages", "LoanApplication");
        Object person = pf.newInstance();
        pf.set(person, "creditRating", (Object)"OK");
        Object application = af.newInstance();
        KieSession ksession = kbase.newKieSession();
        ksession.insert(person);
        ksession.insert(application);
        ksession.fireAllRules();
    }

    @Test
    public void testMVELClassReferences() throws InstantiationException, IllegalAccessException {
        String str = "package org.drools.compiler\ndeclare Assignment\n    source : Class\n    target : Class\nend\nrule ObjectIsAssignable1\nwhen\n    Assignment( $t: target == java.lang.Object.class || target == source )\nthen\nend\nrule ObjectIsAssignable2\nwhen\n    Assignment( $t: target == source || target == java.lang.Object.class )\nthen\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.drools.compiler\ndeclare Assignment\n    source : Class\n    target : Class\nend\nrule ObjectIsAssignable1\nwhen\n    Assignment( $t: target == java.lang.Object.class || target == source )\nthen\nend\nrule ObjectIsAssignable2\nwhen\n    Assignment( $t: target == source || target == java.lang.Object.class )\nthen\nend"});
        KieSession ksession = kbase.newKieSession();
        FactType asgType = kbase.getFactType("org.drools.compiler", "Assignment");
        Object asg = asgType.newInstance();
        asgType.set(asg, "source", Object.class);
        asgType.set(asg, "target", Object.class);
        ksession.insert(asg);
        int rules = ksession.fireAllRules();
        ksession.dispose();
        Assert.assertEquals((long)2L, (long)rules);
    }

    @Test
    public void testMVELConstraintsWithFloatingPointNumbersInScientificNotation() {
        String rule = "package test; \ndialect \"mvel\"\nglobal java.util.List list;\ndeclare Bean \n field : double \nend \n\nrule \"Init\" \nwhen \nthen \n\t insert( new Bean( 1.0E-2 ) ); \nend \n\nrule \"Check\" \nwhen \n\t Bean( field < 1.0E-1 ) \nthen \n\t list.add( \"OK\" ); \nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package test; \ndialect \"mvel\"\nglobal java.util.List list;\ndeclare Bean \n field : double \nend \n\nrule \"Init\" \nwhen \nthen \n\t insert( new Bean( 1.0E-2 ) ); \nend \n\nrule \"Check\" \nwhen \n\t Bean( field < 1.0E-1 ) \nthen \n\t list.add( \"OK\" ); \nend"});
        KieSession kSession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        kSession.setGlobal("list", list);
        kSession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
    }

    @Test
    public void testMvelDoubleInvocation() {
        String rule = "package org.drools.compiler\nimport " + TestUtility.class.getCanonicalName() + ";\nimport " + TestFact.class.getCanonicalName() + ";\nrule \"First Rule\"\n    when\n    $tf : TestFact(TestUtility.utilMethod(s, \"Value1\") == true\n             && i > 0\n    )\n    then\n        System.out.println(\"First Rule Fires\");\nend\n\nrule \"Second Rule\"\n    when\n    $tf : TestFact(TestUtility.utilMethod(s, \"Value2\") == true\n             && i > 0\n    )\n    then\n        System.out.println(\"Second Rule Fires\");\nend\n\nrule \"Third Rule\"\n    when\n    $tf : TestFact(TestUtility.utilMethod(s, \"Value3\") == true\n             && i > 0\n    )\n    then\n        System.out.println(\"Third Rule Fires\");\nend ";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{rule});
        KieSession ksession = kbase.newKieSession();
        TestFact fact = new TestFact();
        fact.setS("asdf");
        fact.setI(10);
        ksession.insert((Object)fact);
        ksession.fireAllRules();
        ksession.dispose();
    }

    @Test
    public void testMVELSoundex() throws Exception {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"MVEL_soundex.drl"});
        KieSession ksession = kbase.newKieSession();
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        Cheese c = new Cheese("fubar", 2);
        ksession.insert((Object)c);
        ksession.fireAllRules();
        Assert.assertEquals((long)42L, (long)c.getPrice());
    }

    @Test
    public void testMVELSoundexNoCharParam() throws Exception {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"MVEL_soundexNPE2500.drl"});
        KieSession ksession = kbase.newKieSession();
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        Cheese foobarCheese = new Cheese("foobar", 2);
        Cheese nullCheese = new Cheese(null, 2);
        Cheese starCheese = new Cheese("*", 2);
        ksession.insert((Object)foobarCheese);
        ksession.insert((Object)nullCheese);
        ksession.insert((Object)starCheese);
        ksession.fireAllRules();
        Assert.assertEquals((long)42L, (long)foobarCheese.getPrice());
        Assert.assertEquals((long)2L, (long)nullCheese.getPrice());
        Assert.assertEquals((long)2L, (long)starCheese.getPrice());
    }

    @Test
    public void testMVELRewrite() throws Exception {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_MVELrewrite.drl"});
        KieSession ksession = kbase.newKieSession();
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ArrayList results = new ArrayList();
        ksession.setGlobal("results", results);
        Cheese brie = new Cheese("brie", 2);
        Cheese stilton = new Cheese("stilton", 2);
        Cheesery cheesery = new Cheesery();
        cheesery.addCheese(brie);
        cheesery.addCheese(stilton);
        ksession.insert((Object)cheesery);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((Object)cheesery, results.get(0));
    }

    @Test
    public void testMVELTypeCoercion() {
        String str = "package org.drools.mvel.compiler.test; \n\nglobal java.util.List list;\ndeclare Bean\n  field : java.util.ArrayList\nend\n\n\nrule \"Init\"\nwhen  \nthen\n  insert( new Bean( new java.util.ArrayList( java.util.Arrays.asList( \"x\" ) ) ) );\nend\n\nrule \"Check\"\nwhen\n  $b : Bean( $fld : field == [\"x\"] )\nthen\n  System.out.println( $fld );\n  list.add( \"OK\" ); \nend";
        KieBaseTestConfiguration equalityConfig = TestParametersUtil.getEqualityInstanceOf((KieBaseTestConfiguration)this.kieBaseTestConfiguration);
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)equalityConfig, (String[])new String[]{"package org.drools.mvel.compiler.test; \n\nglobal java.util.List list;\ndeclare Bean\n  field : java.util.ArrayList\nend\n\n\nrule \"Init\"\nwhen  \nthen\n  insert( new Bean( new java.util.ArrayList( java.util.Arrays.asList( \"x\" ) ) ) );\nend\n\nrule \"Check\"\nwhen\n  $b : Bean( $fld : field == [\"x\"] )\nthen\n  System.out.println( $fld );\n  list.add( \"OK\" ); \nend"});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        Assert.assertTrue((boolean)list.contains("OK"));
        ksession.dispose();
    }

    @Test
    public void testNoMvelSyntaxInFunctions() {
        String str = "import java.util.*;\ndialect \"mvel\"\nfunction Integer englishToInt(String englishNumber) { \n   Map m = [\"one\":1, \"two\":2, \"three\":3, \"four\":4, \"five\":5]; \n   Object obj = m.get(englishNumber.toLowerCase()); \n   return Integer.parseInt(obj.toString()); \n}\n";
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{"import java.util.*;\ndialect \"mvel\"\nfunction Integer englishToInt(String englishNumber) { \n   Map m = [\"one\":1, \"two\":2, \"three\":3, \"four\":4, \"five\":5]; \n   Object obj = m.get(englishNumber.toLowerCase()); \n   return Integer.parseInt(obj.toString()); \n}\n"});
        List errors = kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR});
        Assert.assertFalse((String)"Should have an error", (boolean)errors.isEmpty());
    }

    @Test
    public void testModifyObjectWithMutableHashCodeInEqualityMode() {
        String str = "package com.sample\nimport " + Human.class.getCanonicalName() + ";\nrule \"Step A\"\ndialect \"mvel\"\n    no-loop true\nwhen\n    e : Human()\nthen\t\n    modify( e ) {\n        setAge( 10 );\n    }\nend";
        KieBaseTestConfiguration equalityConfig = TestParametersUtil.getEqualityInstanceOf((KieBaseTestConfiguration)this.kieBaseTestConfiguration);
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)equalityConfig, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        Human h = new Human(2);
        ksession.insert((Object)h);
        ksession.fireAllRules();
        Assert.assertEquals((long)10L, (long)h.getAge());
    }

    @Test
    public void testModifyObjectWithMutableHashCodeInEqualityMode2() {
        String str = "package com.sample\nimport " + Human.class.getCanonicalName() + ";\nrule \"Step A\"\ndialect \"mvel\"\nwhen\n    e : Human()\n    not String()\nthen\t\n    insert(\"test\");\n    modify( e ) {\n        setAge( 10 );\n    }\nend";
        KieBaseTestConfiguration equalityConfig = TestParametersUtil.getEqualityInstanceOf((KieBaseTestConfiguration)this.kieBaseTestConfiguration);
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)equalityConfig, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        Human h = new Human(2);
        ksession.insert((Object)h);
        ksession.fireAllRules();
        Assert.assertEquals((long)10L, (long)h.getAge());
    }

    @Test
    public void test2ndDashInMvelConsequnence() {
        String str = "package com.sample\nimport " + Fact.class.getCanonicalName() + ";\ndialect \"mvel\"\nrule \"testRule\"\n    when\n        $fact : Fact();\n    then\n        $fact.name = \"A#\";\n        $fact.value = \"B#\";\n        System.out.println( $fact );\nend";
        KieBaseTestConfiguration equalityConfig = TestParametersUtil.getEqualityInstanceOf((KieBaseTestConfiguration)this.kieBaseTestConfiguration);
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)equalityConfig, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        Fact f = new Fact();
        ksession.insert((Object)f);
        ksession.fireAllRules();
        Assert.assertEquals((Object)"A#", (Object)f.getName());
        Assert.assertEquals((Object)"B#", (Object)f.getValue());
    }

    @Test
    public void testTypeCoercionLongDivByInt() {
        String str = "package com.sample\nimport " + Person.class.getCanonicalName() + ";\nrule R1\nno-loop true\ndialect \"mvel\"\nwhen\n  $p : Person()\nthen\n  modify ($p) { setBigDecimal(15 * Math.round( new java.math.BigDecimal(\"49.4\") ) / 100 ) }\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        Person p = new Person("Toshiya");
        ksession.insert((Object)p);
        ksession.fireAllRules();
        Assert.assertEquals((Object)new BigDecimal(7.35, MathContext.DECIMAL32), (Object)p.getBigDecimal().round(MathContext.DECIMAL32));
    }

    @Test
    public void testTypeCoercionIntCompareToDouble() {
        String str = "package com.sample\nimport " + IntFact.class.getCanonicalName() + ";\nrule R1\ndialect \"mvel\"\nwhen\n  $f : IntFact(a == 1, b == 2, a / b < 0.99)\nthen\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        IntFact f = new IntFact();
        f.setA(1);
        f.setB(2);
        ksession.insert((Object)f);
        Assert.assertEquals((long)1L, (long)ksession.fireAllRules());
    }

    @Test
    public void testTypeCoercionFloatCompareToDouble() {
        String str = "package com.sample\nimport " + FactA.class.getCanonicalName() + ";\nrule R1\ndialect \"mvel\"\nwhen\n  $f : FactA(field3 == 15.1)\nthen\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        FactA f = new FactA();
        f.setField3(new Float(15.1f));
        ksession.insert((Object)f);
        Assert.assertEquals((long)1L, (long)ksession.fireAllRules());
    }

    public static class IntFact {
        private int a;
        private int b;

        public int getA() {
            return this.a;
        }

        public void setA(int a) {
            this.a = a;
        }

        public int getB() {
            return this.b;
        }

        public void setB(int b) {
            this.b = b;
        }
    }

    public static class Fact {
        private String name;
        private String value;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    public static class Human {
        private int age;

        public Human(int age) {
            this.age = age;
        }

        public int getAge() {
            return this.age;
        }

        public void setAge(int age) {
            this.age = age;
        }

        public int hashCode() {
            return this.age;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            return this.age == ((Human)obj).age;
        }
    }

    public static class TestFact {
        private int i;
        private String s;

        public int getI() {
            return this.i;
        }

        public void setI(int i) {
            this.i = i;
        }

        public String getS() {
            return this.s;
        }

        public void setS(String s) {
            this.s = s;
        }
    }

    public static class TestUtility {
        public static Boolean utilMethod(String s1, String s2) {
            Boolean result = null;
            if (s1 != null) {
                result = s1.equals(s2);
            }
            return result;
        }
    }

    public static class Triangle {
        public static final int ZERO = 0;
        private List<Map<String, Object>> deliveries;
        private Type t;

        public Triangle(Type t) {
            this.t = t;
        }

        public Type getT() {
            return this.t;
        }

        public void setT(Type t) {
            this.t = t;
        }

        public List<Map<String, Object>> getDeliveries() {
            return this.deliveries;
        }

        public void setDeliveries(List<Map<String, Object>> deliveries) {
            this.deliveries = deliveries;
        }

        public static enum Type {
            ACUTE,
            OBTUSE;

        }
    }

    public static class DMap
    extends HashMap {
    }
}

