/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests.eventgenerator;

import java.io.IOException;
import java.util.Collection;
import org.drools.drl.parser.DroolsParserException;
import org.drools.mvel.integrationtests.eventgenerator.Event;
import org.drools.mvel.integrationtests.eventgenerator.PseudoSessionClock;
import org.drools.mvel.integrationtests.eventgenerator.SimpleEventGenerator;
import org.drools.mvel.integrationtests.eventgenerator.SimpleEventListener;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;

@RunWith(value=Parameterized.class)
public class SimpleEventGeneratorTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;
    private static final String TEST_RULE_FILE = "test_eventGenerator.drl";

    public SimpleEventGeneratorTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    @Test
    public void testEventGenerationMaxItems() throws DroolsParserException, IOException, Exception {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{TEST_RULE_FILE});
        KieSession ksession = kbase.newKieSession();
        SimpleEventGenerator myGenerator = new SimpleEventGenerator(ksession, new SimpleEventListener(ksession));
        myGenerator.addEventSource("Conveyor1", new Event(Event.EventType.CUSTOM, null), PseudoSessionClock.timeInSeconds(4L), PseudoSessionClock.timeInSeconds(6L), 0L, 10);
        myGenerator.generate();
        Assert.assertEquals((long)ksession.getQueryResults("all inserted events", new Object[0]).size(), (long)10L);
    }

    @Test
    public void testEventGenerationMaxTime() throws DroolsParserException, IOException, Exception {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{TEST_RULE_FILE});
        KieSession ksession = kbase.newKieSession();
        SimpleEventGenerator myGenerator = new SimpleEventGenerator(ksession, new SimpleEventListener(ksession));
        myGenerator.addEventSource("Conveyor1", new Event(Event.EventType.CUSTOM, null), PseudoSessionClock.timeInSeconds(4L), PseudoSessionClock.timeInSeconds(6L), PseudoSessionClock.timeInMinutes(1L), 0);
        myGenerator.generate();
        Assert.assertEquals((long)ksession.getQueryResults("all inserted events", new Object[0]).size(), (long)ksession.getQueryResults("all inserted events with generation time < 1 min", new Object[0]).size());
    }

    @Test
    public void testEventGenerationMaxTimeAndMaxItems() throws DroolsParserException, IOException, Exception {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{TEST_RULE_FILE});
        KieSession ksession = kbase.newKieSession();
        SimpleEventGenerator myGenerator = new SimpleEventGenerator(ksession, new SimpleEventListener(ksession));
        myGenerator.addEventSource("Conveyor1", new Event(Event.EventType.CUSTOM, null), PseudoSessionClock.timeInSeconds(4L), PseudoSessionClock.timeInSeconds(6L), PseudoSessionClock.timeInMinutes(1L), 10);
        myGenerator.generate();
        Assert.assertEquals((long)ksession.getQueryResults("all inserted events", new Object[0]).size(), (long)ksession.getQueryResults("all inserted events with generation time < 1 min", new Object[0]).size());
        Assert.assertTrue((ksession.getQueryResults("all inserted events with generation time < 1 min", new Object[0]).size() <= 10 ? 1 : 0) != 0);
    }

    @Test
    public void testEventGenerationDelayedMaxItems() throws DroolsParserException, IOException, Exception {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{TEST_RULE_FILE});
        KieSession ksession = kbase.newKieSession();
        SimpleEventGenerator myGenerator = new SimpleEventGenerator(ksession, new SimpleEventListener(ksession));
        myGenerator.addDelayedEventSource("Conveyor1", new Event(Event.EventType.CUSTOM, null), PseudoSessionClock.timeInSeconds(4L), PseudoSessionClock.timeInSeconds(6L), PseudoSessionClock.timeInMinutes(2L), 0L, 10);
        myGenerator.generate();
        Assert.assertEquals((long)ksession.getQueryResults("all inserted events", new Object[0]).size(), (long)10L);
    }

    @Test
    public void testEventGenerationDelayedMaxTime() throws DroolsParserException, IOException, Exception {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{TEST_RULE_FILE});
        KieSession ksession = kbase.newKieSession();
        SimpleEventGenerator myGenerator = new SimpleEventGenerator(ksession, new SimpleEventListener(ksession));
        myGenerator.addDelayedEventSource("Conveyor1", new Event(Event.EventType.CUSTOM, null), PseudoSessionClock.timeInSeconds(4L), PseudoSessionClock.timeInSeconds(6L), PseudoSessionClock.timeInMinutes(2L), PseudoSessionClock.timeInMinutes(1L), 0);
        myGenerator.generate();
        Assert.assertEquals((long)ksession.getQueryResults("all inserted events", new Object[0]).size(), (long)ksession.getQueryResults("all inserted events with 2 min < generation time < 3 min", new Object[0]).size());
    }

    @Test
    public void testEventGenerationDelayedMaxTimeAndMaxItems() throws DroolsParserException, IOException, Exception {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{TEST_RULE_FILE});
        KieSession ksession = kbase.newKieSession();
        SimpleEventGenerator myGenerator = new SimpleEventGenerator(ksession, new SimpleEventListener(ksession));
        myGenerator.addDelayedEventSource("Conveyor1", new Event(Event.EventType.CUSTOM, null), PseudoSessionClock.timeInSeconds(4L), PseudoSessionClock.timeInSeconds(6L), PseudoSessionClock.timeInMinutes(2L), PseudoSessionClock.timeInMinutes(1L), 10);
        myGenerator.generate();
        Assert.assertEquals((long)ksession.getQueryResults("all inserted events", new Object[0]).size(), (long)ksession.getQueryResults("all inserted events with 2 min < generation time < 3 min", new Object[0]).size());
        Assert.assertTrue((ksession.getQueryResults("all inserted events with 2 min < generation time < 3 min", new Object[0]).size() <= 10 ? 1 : 0) != 0);
    }

    @Test
    public void testEventGenerationGlobalMaxTime() throws DroolsParserException, IOException, Exception {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{TEST_RULE_FILE});
        KieSession ksession = kbase.newKieSession();
        SimpleEventGenerator myGenerator = new SimpleEventGenerator(ksession, new SimpleEventListener(ksession), PseudoSessionClock.timeInMinutes(1L));
        myGenerator.addEventSource("Conveyor1", new Event(Event.EventType.CUSTOM, null), PseudoSessionClock.timeInSeconds(4L), PseudoSessionClock.timeInSeconds(6L), PseudoSessionClock.timeInMinutes(3L), 0);
        myGenerator.generate();
        Assert.assertEquals((long)ksession.getQueryResults("all inserted events", new Object[0]).size(), (long)ksession.getQueryResults("all inserted events with generation time < 1 min", new Object[0]).size());
    }

    @Test
    public void testEventGenerationMultipleSources() throws DroolsParserException, IOException, Exception {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{TEST_RULE_FILE});
        KieSession ksession = kbase.newKieSession();
        SimpleEventGenerator myGenerator = new SimpleEventGenerator(ksession, new SimpleEventListener(ksession));
        myGenerator.addEventSource("Conveyor1", new Event(Event.EventType.CUSTOM, "resA"), PseudoSessionClock.timeInSeconds(4L), PseudoSessionClock.timeInSeconds(6L), 0L, 15);
        myGenerator.addEventSource("Conveyor2", new Event(Event.EventType.CUSTOM, "resB"), PseudoSessionClock.timeInSeconds(3L), PseudoSessionClock.timeInSeconds(5L), 0L, 20);
        myGenerator.generate();
        Assert.assertEquals((long)ksession.getQueryResults("all inserted events with parent resource A", new Object[0]).size(), (long)15L);
        Assert.assertEquals((long)ksession.getQueryResults("all inserted events with parent resource B", new Object[0]).size(), (long)20L);
    }
}

