/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.rule;

import org.assertj.core.api.Assertions;
import org.drools.core.base.ClassObjectType;
import org.drools.core.base.ObjectType;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.GroupElement;
import org.drools.core.rule.GroupElementFactory;
import org.drools.core.rule.Pattern;
import org.drools.core.rule.RuleConditionElement;
import org.drools.core.test.model.Person;
import org.junit.Assert;
import org.junit.Test;

public class GroupElementTest {
    @Test
    public void testPackNestedAnd() {
        GroupElement and1 = GroupElementFactory.newAndInstance();
        Pattern pattern1 = new Pattern(0, null);
        and1.addChild((RuleConditionElement)pattern1);
        Pattern pattern2 = new Pattern(0, null);
        and1.addChild((RuleConditionElement)pattern2);
        Assert.assertEquals((long)2L, (long)and1.getChildren().size());
        Assert.assertSame((Object)pattern1, and1.getChildren().get(0));
        Assert.assertSame((Object)pattern2, and1.getChildren().get(1));
        GroupElement and2 = GroupElementFactory.newAndInstance();
        and2.addChild((RuleConditionElement)and1);
        and2.pack();
        Assert.assertEquals((long)2L, (long)and2.getChildren().size());
        Assert.assertSame((Object)pattern1, and2.getChildren().get(0));
        Assert.assertSame((Object)pattern2, and2.getChildren().get(1));
    }

    @Test
    public void testDeclarationOrdering() {
        GroupElement and1 = GroupElementFactory.newAndInstance();
        Pattern pattern1 = new Pattern(0, (ObjectType)new ClassObjectType(Person.class), "x");
        and1.addChild((RuleConditionElement)pattern1);
        Pattern pattern2 = new Pattern(2, (ObjectType)new ClassObjectType(Person.class), "y");
        and1.addChild((RuleConditionElement)pattern2);
        Declaration x1 = (Declaration)and1.getInnerDeclarations().get("x");
        Declaration y1 = (Declaration)and1.getInnerDeclarations().get("y");
        Declaration z1 = (Declaration)and1.getInnerDeclarations().get("z");
        Assertions.assertThat((Object)x1).isNotNull();
        Assertions.assertThat((Object)y1).isNotNull();
        Assert.assertNull((Object)z1);
        Assert.assertEquals((long)2L, (long)and1.getChildren().size());
        Assert.assertSame((Object)pattern1, and1.getChildren().get(0));
        Assert.assertSame((Object)pattern2, and1.getChildren().get(1));
        GroupElement and2 = GroupElementFactory.newAndInstance();
        and2.addChild((RuleConditionElement)and1);
        Pattern pattern3 = new Pattern(3, (ObjectType)new ClassObjectType(Person.class), "x");
        and2.addChild((RuleConditionElement)pattern3);
        and2.pack();
        Assert.assertEquals((long)3L, (long)and2.getChildren().size());
        Assert.assertSame((Object)pattern1, and2.getChildren().get(0));
        Assert.assertSame((Object)pattern2, and2.getChildren().get(1));
        Assert.assertSame((Object)pattern3, and2.getChildren().get(2));
        Declaration x2 = (Declaration)and2.getInnerDeclarations().get("x");
        Declaration y2 = (Declaration)and2.getInnerDeclarations().get("y");
        Declaration z2 = (Declaration)and2.getInnerDeclarations().get("z");
        Assertions.assertThat((Object)x2).isNotNull();
        Assertions.assertThat((Object)y2).isNotNull();
        Assert.assertNull((Object)z2);
        Assert.assertNotSame((Object)x1, (Object)x2);
        Assert.assertSame((Object)x2, (Object)pattern3.getDeclaration());
        Assert.assertSame((Object)y1, (Object)y2);
        Assert.assertSame((Object)z1, (Object)z2);
    }

    @Test
    public void testPackNestedOr() {
        GroupElement or1 = GroupElementFactory.newOrInstance();
        Pattern pattern1 = new Pattern(0, null);
        or1.addChild((RuleConditionElement)pattern1);
        Pattern pattern2 = new Pattern(0, null);
        or1.addChild((RuleConditionElement)pattern2);
        Assert.assertEquals((long)2L, (long)or1.getChildren().size());
        Assert.assertSame((Object)pattern1, or1.getChildren().get(0));
        Assert.assertSame((Object)pattern2, or1.getChildren().get(1));
        GroupElement or2 = GroupElementFactory.newOrInstance();
        or2.addChild((RuleConditionElement)or1);
        or2.pack();
        Assert.assertEquals((long)2L, (long)or2.getChildren().size());
        Assert.assertSame((Object)pattern1, or2.getChildren().get(0));
        Assert.assertSame((Object)pattern2, or2.getChildren().get(1));
    }

    @Test
    public void testPackNestedExists() {
        GroupElement exists1 = GroupElementFactory.newExistsInstance();
        Pattern pattern1 = new Pattern(0, null);
        exists1.addChild((RuleConditionElement)pattern1);
        Assert.assertEquals((long)1L, (long)exists1.getChildren().size());
        Assert.assertSame((Object)pattern1, exists1.getChildren().get(0));
        GroupElement exists2 = GroupElementFactory.newExistsInstance();
        exists2.addChild((RuleConditionElement)exists1);
        exists2.pack();
        Assert.assertEquals((long)1L, (long)exists2.getChildren().size());
        Assert.assertSame((Object)pattern1, exists2.getChildren().get(0));
    }

    @Test
    public void testAddMultipleChildsIntoNot() {
        GroupElement not = GroupElementFactory.newNotInstance();
        Pattern pattern1 = new Pattern(0, null);
        try {
            not.addChild((RuleConditionElement)pattern1);
        }
        catch (RuntimeException rde) {
            Assert.fail((String)("Adding a single child is not supposed to throw Exception for NOT GE: " + rde.getMessage()));
        }
        Pattern pattern2 = new Pattern(0, null);
        try {
            not.addChild((RuleConditionElement)pattern2);
            Assert.fail((String)"Adding a second child into a NOT GE should throw Exception");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Test
    public void testAddSingleBranchAnd() {
        GroupElement and1 = GroupElementFactory.newAndInstance();
        Pattern pattern = new Pattern(0, null);
        and1.addChild((RuleConditionElement)pattern);
        Assert.assertEquals((long)1L, (long)and1.getChildren().size());
        Assert.assertSame((Object)pattern, and1.getChildren().get(0));
        GroupElement or1 = GroupElementFactory.newOrInstance();
        or1.addChild((RuleConditionElement)and1);
        or1.pack();
        Assert.assertEquals((long)1L, (long)or1.getChildren().size());
        Assert.assertSame((Object)pattern, or1.getChildren().get(0));
    }

    @Test
    public void testAddSingleBranchOr() {
        GroupElement or1 = GroupElementFactory.newOrInstance();
        Pattern pattern = new Pattern(0, null);
        or1.addChild((RuleConditionElement)pattern);
        Assert.assertEquals((long)1L, (long)or1.getChildren().size());
        Assert.assertSame((Object)pattern, or1.getChildren().get(0));
        GroupElement and1 = GroupElementFactory.newAndInstance();
        and1.addChild((RuleConditionElement)or1);
        and1.pack();
        Assert.assertEquals((long)1L, (long)and1.getChildren().size());
        Assert.assertSame((Object)pattern, and1.getChildren().get(0));
    }

    @Test
    public void testDeepNestedStructure() {
        GroupElement or1 = GroupElementFactory.newOrInstance();
        Pattern pattern1 = new Pattern(0, null);
        or1.addChild((RuleConditionElement)pattern1);
        Pattern pattern2 = new Pattern(0, null);
        or1.addChild((RuleConditionElement)pattern2);
        GroupElement and1 = GroupElementFactory.newAndInstance();
        and1.addChild((RuleConditionElement)or1);
        Assert.assertEquals((long)1L, (long)and1.getChildren().size());
        Assert.assertSame((Object)or1, and1.getChildren().get(0));
        Assert.assertSame((Object)pattern1, or1.getChildren().get(0));
        Assert.assertSame((Object)pattern2, or1.getChildren().get(1));
        GroupElement or2 = GroupElementFactory.newOrInstance();
        or2.addChild((RuleConditionElement)and1);
        Assert.assertEquals((long)1L, (long)or2.getChildren().size());
        Assert.assertSame((Object)and1, or2.getChildren().get(0));
        GroupElement or3 = GroupElementFactory.newOrInstance();
        or3.addChild((RuleConditionElement)or2);
        Assert.assertEquals((long)1L, (long)or2.getChildren().size());
        Assert.assertSame((Object)or2, or3.getChildren().get(0));
        GroupElement and2 = GroupElementFactory.newAndInstance();
        and2.addChild((RuleConditionElement)or3);
        Assert.assertEquals((long)1L, (long)and2.getChildren().size());
        Assert.assertSame((Object)or3, and2.getChildren().get(0));
        and2.pack();
        Assert.assertEquals((Object)GroupElement.Type.OR, (Object)and2.getType());
        Assert.assertEquals((long)2L, (long)and2.getChildren().size());
        Assert.assertSame((Object)pattern1, and2.getChildren().get(0));
        Assert.assertSame((Object)pattern2, and2.getChildren().get(1));
    }

    @Test
    public void testDeepNestedStructureWithMultipleElementsInRoot() {
        GroupElement or1 = GroupElementFactory.newOrInstance();
        Pattern pattern1 = new Pattern(0, null);
        or1.addChild((RuleConditionElement)pattern1);
        Pattern pattern2 = new Pattern(0, null);
        or1.addChild((RuleConditionElement)pattern2);
        GroupElement and1 = GroupElementFactory.newAndInstance();
        and1.addChild((RuleConditionElement)or1);
        Assert.assertEquals((long)1L, (long)and1.getChildren().size());
        Assert.assertSame((Object)or1, and1.getChildren().get(0));
        Assert.assertSame((Object)pattern1, or1.getChildren().get(0));
        Assert.assertSame((Object)pattern2, or1.getChildren().get(1));
        GroupElement or2 = GroupElementFactory.newOrInstance();
        or2.addChild((RuleConditionElement)and1);
        Assert.assertEquals((long)1L, (long)or2.getChildren().size());
        Assert.assertSame((Object)and1, or2.getChildren().get(0));
        GroupElement or3 = GroupElementFactory.newOrInstance();
        or3.addChild((RuleConditionElement)or2);
        Assert.assertEquals((long)1L, (long)or2.getChildren().size());
        Assert.assertSame((Object)or2, or3.getChildren().get(0));
        GroupElement and2 = GroupElementFactory.newAndInstance();
        and2.addChild((RuleConditionElement)or3);
        Pattern pattern3 = new Pattern(0, null);
        and2.addChild((RuleConditionElement)pattern3);
        Assert.assertEquals((long)2L, (long)and2.getChildren().size());
        Assert.assertSame((Object)or3, and2.getChildren().get(0));
        Assert.assertSame((Object)pattern3, and2.getChildren().get(1));
        and2.pack();
        Assert.assertTrue((boolean)and2.isAnd());
        Assert.assertEquals((long)2L, (long)and2.getChildren().size());
        Assert.assertSame((Object)or1, and2.getChildren().get(0));
        Assert.assertSame((Object)pattern3, and2.getChildren().get(1));
        Assert.assertEquals((long)2L, (long)or1.getChildren().size());
        Assert.assertSame((Object)pattern1, or1.getChildren().get(0));
        Assert.assertSame((Object)pattern2, or1.getChildren().get(1));
    }
}

