/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.assertj.core.api.Assertions;
import org.drools.core.base.UndefinedCalendarExcption;
import org.drools.core.time.impl.PseudoClockScheduler;
import org.drools.testcoverage.common.model.Alarm;
import org.drools.testcoverage.common.model.FactA;
import org.drools.testcoverage.common.model.FactB;
import org.drools.testcoverage.common.model.Pet;
import org.drools.testcoverage.common.model.StockTick;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.KieSessionTestConfiguration;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.drools.util.DateUtils;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.builder.KieBuilder;
import org.kie.api.event.rule.AfterMatchFiredEvent;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.event.rule.DefaultAgendaEventListener;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.conf.KieSessionOption;
import org.kie.api.runtime.conf.TimedRuleExecutionOption;
import org.kie.api.runtime.rule.EntryPoint;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.api.time.Calendar;
import org.kie.api.time.SessionClock;
import org.kie.api.time.SessionPseudoClock;

@RunWith(value=Parameterized.class)
public class TimerAndCalendarWithPseudoTimeTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public TimerAndCalendarWithPseudoTimeTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseStreamConfigurations((boolean)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testDurationMemoryLeakonRepeatedUpdate() {
        String drl = "package org.drools.compiler.test\nimport " + Alarm.class.getCanonicalName() + "\nglobal java.util.List list;rule \"COMPTEUR\"\n  timer (int: 50s)\n  when\n    $alarm : Alarm( number < 5 )\n  then\n    $alarm.incrementNumber();\n    list.add( $alarm );\n    update($alarm);\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"timer-and-calendar-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession(KieSessionTestConfiguration.STATEFUL_PSEUDO.getKieSessionConfiguration(), null);
        try {
            PseudoClockScheduler timeService = (PseudoClockScheduler)ksession.getSessionClock();
            timeService.advanceTime(new Date().getTime(), TimeUnit.MILLISECONDS);
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            ksession.insert((Object)new Alarm());
            ksession.fireAllRules();
            for (int i = 0; i < 6; ++i) {
                timeService.advanceTime(55L, TimeUnit.SECONDS);
                ksession.fireAllRules();
            }
            Assertions.assertThat((int)list.size()).isEqualTo(5);
        }
        finally {
            ksession.dispose();
        }
    }

    @Test(timeout=10000L)
    public void testNoProtocolIntervalTimer() {
        this.testIntervalTimer(true);
    }

    @Test(timeout=10000L)
    public void testIntervalTimer() {
        this.testIntervalTimer(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testIntervalTimer(boolean noProtocol) {
        String drl = "package org.simple \nglobal java.util.List list \nrule xxx \n" + (noProtocol ? "  duration (30s 10s) " : "  timer (int:30s 10s) ") + "when \nthen \n  list.add(\"fired\"); \nend  \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"timer-and-calendar-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession(KieSessionTestConfiguration.STATEFUL_PSEUDO.getKieSessionConfiguration(), null);
        try {
            ArrayList list = new ArrayList();
            PseudoClockScheduler timeService = (PseudoClockScheduler)ksession.getSessionClock();
            timeService.advanceTime(new Date().getTime(), TimeUnit.MILLISECONDS);
            ksession.setGlobal("list", list);
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(0);
            timeService.advanceTime(20L, TimeUnit.SECONDS);
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(0);
            timeService.advanceTime(15L, TimeUnit.SECONDS);
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(1);
            timeService.advanceTime(3L, TimeUnit.SECONDS);
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(1);
            timeService.advanceTime(2L, TimeUnit.SECONDS);
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(2);
            timeService.advanceTime(10L, TimeUnit.SECONDS);
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(3);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testIntervalTimerWithoutFire() {
        String drl = "package org.simple \nglobal java.util.List list \nrule xxx \n  timer (int:30s 10s) when \nthen \n  list.add(\"fired\"); \nend  \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"timer-and-calendar-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.simple \nglobal java.util.List list \nrule xxx \n  timer (int:30s 10s) when \nthen \n  list.add(\"fired\"); \nend  \n"});
        KieSessionConfiguration kieSessionConfiguration = KieSessionTestConfiguration.STATEFUL_PSEUDO.getKieSessionConfiguration();
        kieSessionConfiguration.setOption((KieSessionOption)TimedRuleExecutionOption.YES);
        KieSession ksession = kbase.newKieSession(kieSessionConfiguration, null);
        try {
            ArrayList list = new ArrayList();
            PseudoClockScheduler timeService = (PseudoClockScheduler)ksession.getSessionClock();
            timeService.advanceTime(new Date().getTime(), TimeUnit.MILLISECONDS);
            ksession.setGlobal("list", list);
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(0);
            timeService.advanceTime(35L, TimeUnit.SECONDS);
            Assertions.assertThat((int)list.size()).isEqualTo(1);
            timeService.advanceTime(10L, TimeUnit.SECONDS);
            Assertions.assertThat((int)list.size()).isEqualTo(2);
            timeService.advanceTime(10L, TimeUnit.SECONDS);
            Assertions.assertThat((int)list.size()).isEqualTo(3);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testExprIntervalTimerRaceCondition() {
        String drl = "package org.simple \nglobal java.util.List list \nrule xxx \n  timer (expr: $i, $i) \nwhen \n   $i : Long() \nthen \n  list.add(\"fired\"); \nend  \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"timer-and-calendar-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.simple \nglobal java.util.List list \nrule xxx \n  timer (expr: $i, $i) \nwhen \n   $i : Long() \nthen \n  list.add(\"fired\"); \nend  \n"});
        KieSession ksession = kbase.newKieSession(KieSessionTestConfiguration.STATEFUL_PSEUDO.getKieSessionConfiguration(), null);
        try {
            ArrayList list = new ArrayList();
            PseudoClockScheduler timeService = (PseudoClockScheduler)ksession.getSessionClock();
            timeService.advanceTime(new Date().getTime(), TimeUnit.MILLISECONDS);
            ksession.setGlobal("list", list);
            FactHandle fh = ksession.insert((Object)10000L);
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(0);
            timeService.advanceTime(10L, TimeUnit.SECONDS);
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(1);
            timeService.advanceTime(17L, TimeUnit.SECONDS);
            ksession.update(fh, (Object)5000L);
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(2);
        }
        finally {
            ksession.dispose();
        }
    }

    @Test(timeout=10000L)
    public void testUnknownProtocol() {
        this.wrongTimerExpression("xyz:30");
    }

    @Test(timeout=10000L)
    public void testMissingColon() {
        this.wrongTimerExpression("int 30");
    }

    @Test(timeout=10000L)
    public void testMalformedExpression() {
        this.wrongTimerExpression("30s s30");
    }

    @Test(timeout=10000L)
    public void testMalformedIntExpression() {
        this.wrongTimerExpression("int 30s");
    }

    @Test(timeout=10000L)
    public void testMalformedCronExpression() {
        this.wrongTimerExpression("cron: 0/30 * * * * *");
    }

    private void wrongTimerExpression(String timer) {
        String drl = "package org.simple \nrule xxx \n  timer (" + timer + ") when \nthen \nend  \n";
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{drl});
        Assertions.assertThat((List)kieBuilder.getResults().getMessages()).isNotEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testCronTimer() throws Exception {
        String drl = "package org.simple \nglobal java.util.List list \nrule xxx \n  timer (cron:15 * * * * ?) when \nthen \n  list.add(\"fired\"); \nend  \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"timer-and-calendar-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.simple \nglobal java.util.List list \nrule xxx \n  timer (cron:15 * * * * ?) when \nthen \n  list.add(\"fired\"); \nend  \n"});
        KieSession ksession = kbase.newKieSession(KieSessionTestConfiguration.STATEFUL_PSEUDO.getKieSessionConfiguration(), null);
        try {
            ArrayList list = new ArrayList();
            PseudoClockScheduler timeService = (PseudoClockScheduler)ksession.getSessionClock();
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
            Date date = df.parse("2009-01-01T00:00:00.000-0000");
            timeService.advanceTime(date.getTime(), TimeUnit.MILLISECONDS);
            ksession.setGlobal("list", list);
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(0);
            timeService.advanceTime(10L, TimeUnit.SECONDS);
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(0);
            timeService.advanceTime(10L, TimeUnit.SECONDS);
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(1);
            timeService.advanceTime(30L, TimeUnit.SECONDS);
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(1);
            timeService.advanceTime(30L, TimeUnit.SECONDS);
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(2);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testCalendarNormalRuleSingleCalendar() throws Exception {
        String drl = "package org.simple \nglobal java.util.List list \nrule xxx \n  calendars \"cal1\"\nwhen \n  String()\nthen \n  list.add(\"fired\"); \nend  \n";
        Calendar calFalse = timestamp -> false;
        Calendar calTrue = timestamp -> true;
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"timer-and-calendar-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.simple \nglobal java.util.List list \nrule xxx \n  calendars \"cal1\"\nwhen \n  String()\nthen \n  list.add(\"fired\"); \nend  \n"});
        KieSession ksession = kbase.newKieSession(KieSessionTestConfiguration.STATEFUL_PSEUDO.getKieSessionConfiguration(), null);
        try {
            ArrayList list = new ArrayList();
            PseudoClockScheduler timeService = (PseudoClockScheduler)ksession.getSessionClock();
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
            Date date = df.parse("2009-01-01T00:00:00.000-0000");
            ksession.getCalendars().set("cal1", calTrue);
            timeService.advanceTime(date.getTime(), TimeUnit.MILLISECONDS);
            ksession.setGlobal("list", list);
            ksession.insert((Object)"o1");
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(1);
            timeService.advanceTime(10L, TimeUnit.SECONDS);
            ksession.insert((Object)"o2");
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(2);
            ksession.getCalendars().set("cal1", calFalse);
            timeService.advanceTime(10L, TimeUnit.SECONDS);
            ksession.insert((Object)"o3");
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(2);
            ksession.getCalendars().set("cal1", calTrue);
            timeService.advanceTime(30L, TimeUnit.SECONDS);
            ksession.insert((Object)"o4");
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(3);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUndefinedCalendar() {
        String drl = "rule xxx \n  calendars \"cal1\"\nwhen \nthen \nend  \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"timer-and-calendar-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"rule xxx \n  calendars \"cal1\"\nwhen \nthen \nend  \n"});
        KieSession ksession = kbase.newKieSession();
        try {
            try {
                ksession.fireAllRules();
                Assertions.fail((String)"should throw UndefinedCalendarExcption");
            }
            catch (UndefinedCalendarExcption undefinedCalendarExcption) {
                // empty catch block
            }
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testCalendarNormalRuleMultipleCalendars() throws Exception {
        String drl = "package org.simple \nglobal java.util.List list \nrule xxx \n  calendars \"cal1\", \"cal2\"\nwhen \n  String()\nthen \n  list.add(\"fired\"); \nend  \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"timer-and-calendar-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.simple \nglobal java.util.List list \nrule xxx \n  calendars \"cal1\", \"cal2\"\nwhen \n  String()\nthen \n  list.add(\"fired\"); \nend  \n"});
        KieSession ksession = kbase.newKieSession(KieSessionTestConfiguration.STATEFUL_PSEUDO.getKieSessionConfiguration(), null);
        try {
            Calendar calFalse = timestamp -> false;
            Calendar calTrue = timestamp -> true;
            ArrayList list = new ArrayList();
            PseudoClockScheduler timeService = (PseudoClockScheduler)ksession.getSessionClock();
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
            Date date = df.parse("2009-01-01T00:00:00.000-0000");
            ksession.getCalendars().set("cal1", calTrue);
            ksession.getCalendars().set("cal2", calTrue);
            timeService.advanceTime(date.getTime(), TimeUnit.MILLISECONDS);
            ksession.setGlobal("list", list);
            ksession.insert((Object)"o1");
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(1);
            ksession.getCalendars().set("cal2", calFalse);
            timeService.advanceTime(10L, TimeUnit.SECONDS);
            ksession.insert((Object)"o2");
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(1);
            ksession.getCalendars().set("cal1", calFalse);
            timeService.advanceTime(10L, TimeUnit.SECONDS);
            ksession.insert((Object)"o3");
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(1);
            ksession.getCalendars().set("cal1", calTrue);
            ksession.getCalendars().set("cal2", calTrue);
            timeService.advanceTime(30L, TimeUnit.SECONDS);
            ksession.insert((Object)"o4");
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(2);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testCalendarsWithCron() throws Exception {
        String drl = "package org.simple \nglobal java.util.List list \nrule xxx \n  calendars \"cal1\", \"cal2\"\n  timer (cron:15 * * * * ?) when \nthen \n  list.add(\"fired\"); \nend  \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"timer-and-calendar-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.simple \nglobal java.util.List list \nrule xxx \n  calendars \"cal1\", \"cal2\"\n  timer (cron:15 * * * * ?) when \nthen \n  list.add(\"fired\"); \nend  \n"});
        KieSession ksession = kbase.newKieSession(KieSessionTestConfiguration.STATEFUL_PSEUDO.getKieSessionConfiguration(), null);
        try {
            ArrayList list = new ArrayList();
            PseudoClockScheduler timeService = (PseudoClockScheduler)ksession.getSessionClock();
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
            Date date = df.parse("2009-01-01T00:00:00.000-0000");
            timeService.advanceTime(date.getTime(), TimeUnit.MILLISECONDS);
            Date date1 = new Date(date.getTime() + 15000L);
            Date date2 = new Date(date1.getTime() + 60000L);
            Date date3 = new Date(date2.getTime() + 60000L);
            Date date4 = new Date(date3.getTime() + 60000L);
            Calendar cal1 = timestamp -> {
                if (timestamp == date1.getTime()) {
                    return true;
                }
                return timestamp != date4.getTime();
            };
            Calendar cal2 = timestamp -> {
                if (timestamp == date2.getTime()) {
                    return false;
                }
                if (timestamp == date3.getTime()) {
                    return true;
                }
                return true;
            };
            ksession.getCalendars().set("cal1", cal1);
            ksession.getCalendars().set("cal2", cal2);
            ksession.setGlobal("list", list);
            ksession.fireAllRules();
            timeService.advanceTime(20L, TimeUnit.SECONDS);
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(1);
            timeService.advanceTime(60L, TimeUnit.SECONDS);
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(1);
            timeService.advanceTime(60L, TimeUnit.SECONDS);
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(2);
            timeService.advanceTime(60L, TimeUnit.SECONDS);
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(2);
            timeService.advanceTime(60L, TimeUnit.SECONDS);
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(3);
            timeService.advanceTime(60L, TimeUnit.SECONDS);
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(4);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testCalendarsWithIntervals() throws Exception {
        String drl = "package org.simple \nglobal java.util.List list \nrule xxx \n  calendars \"cal1\", \"cal2\"\n  timer (15s 60s) when \nthen \n  list.add(\"fired\"); \nend  \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"timer-and-calendar-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.simple \nglobal java.util.List list \nrule xxx \n  calendars \"cal1\", \"cal2\"\n  timer (15s 60s) when \nthen \n  list.add(\"fired\"); \nend  \n"});
        KieSession ksession = kbase.newKieSession(KieSessionTestConfiguration.STATEFUL_PSEUDO.getKieSessionConfiguration(), null);
        try {
            ArrayList list = new ArrayList();
            PseudoClockScheduler timeService = (PseudoClockScheduler)ksession.getSessionClock();
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
            Date date = df.parse("2009-01-01T00:00:00.000-0000");
            timeService.advanceTime(date.getTime(), TimeUnit.MILLISECONDS);
            Date date1 = new Date(date.getTime() + 15000L);
            Date date2 = new Date(date1.getTime() + 60000L);
            Date date3 = new Date(date2.getTime() + 60000L);
            Date date4 = new Date(date3.getTime() + 60000L);
            Calendar cal1 = timestamp -> {
                if (timestamp == date1.getTime()) {
                    return true;
                }
                return timestamp != date4.getTime();
            };
            Calendar cal2 = timestamp -> {
                if (timestamp == date2.getTime()) {
                    return false;
                }
                if (timestamp == date3.getTime()) {
                    return true;
                }
                return true;
            };
            ksession.getCalendars().set("cal1", cal1);
            ksession.getCalendars().set("cal2", cal2);
            ksession.setGlobal("list", list);
            ksession.fireAllRules();
            timeService.advanceTime(20L, TimeUnit.SECONDS);
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(1);
            timeService.advanceTime(60L, TimeUnit.SECONDS);
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(1);
            timeService.advanceTime(60L, TimeUnit.SECONDS);
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(2);
            timeService.advanceTime(60L, TimeUnit.SECONDS);
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(2);
            timeService.advanceTime(60L, TimeUnit.SECONDS);
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(3);
            timeService.advanceTime(60L, TimeUnit.SECONDS);
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(4);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testCalendarsWithIntervalsAndStartAndEnd() throws Exception {
        String drl = "package org.simple \nglobal java.util.List list \nrule xxx \n  calendars \"cal1\"\n  timer (0d 1d; start=3-JAN-2010, end=5-JAN-2010) when \nthen \n  list.add(\"fired\"); \nend  \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"timer-and-calendar-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.simple \nglobal java.util.List list \nrule xxx \n  calendars \"cal1\"\n  timer (0d 1d; start=3-JAN-2010, end=5-JAN-2010) when \nthen \n  list.add(\"fired\"); \nend  \n"});
        KieSession ksession = kbase.newKieSession(KieSessionTestConfiguration.STATEFUL_PSEUDO.getKieSessionConfiguration(), null);
        try {
            ArrayList list = new ArrayList();
            PseudoClockScheduler timeService = (PseudoClockScheduler)ksession.getSessionClock();
            SimpleDateFormat df = new SimpleDateFormat("dd-MMM-yyyy", Locale.UK);
            Date date = df.parse("1-JAN-2010");
            Calendar cal1 = timestamp -> true;
            long oneDay = 86400L;
            ksession.getCalendars().set("cal1", cal1);
            ksession.setGlobal("list", list);
            timeService.advanceTime(date.getTime(), TimeUnit.MILLISECONDS);
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(0);
            timeService.advanceTime(86400L, TimeUnit.SECONDS);
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(0);
            timeService.advanceTime(86400L, TimeUnit.SECONDS);
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(1);
            timeService.advanceTime(86400L, TimeUnit.SECONDS);
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(2);
            timeService.advanceTime(86400L, TimeUnit.SECONDS);
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(3);
            timeService.advanceTime(86400L, TimeUnit.SECONDS);
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(3);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testCalendarsWithIntervalsAndStartAndLimit() throws Exception {
        String drl = "package org.simple \nglobal java.util.List list \nrule xxx \n  calendars \"cal1\"\n  timer (0d 1d; start=3-JAN-2010, repeat-limit=4) when \nthen \n  list.add(\"fired\"); \nend  \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"timer-and-calendar-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.simple \nglobal java.util.List list \nrule xxx \n  calendars \"cal1\"\n  timer (0d 1d; start=3-JAN-2010, repeat-limit=4) when \nthen \n  list.add(\"fired\"); \nend  \n"});
        KieSession ksession = kbase.newKieSession(KieSessionTestConfiguration.STATEFUL_PSEUDO.getKieSessionConfiguration(), null);
        try {
            ArrayList list = new ArrayList();
            PseudoClockScheduler timeService = (PseudoClockScheduler)ksession.getSessionClock();
            SimpleDateFormat df = new SimpleDateFormat("dd-MMM-yyyy", Locale.UK);
            Date date = df.parse("1-JAN-2010");
            Calendar cal1 = timestamp -> true;
            long oneDay = 86400L;
            ksession.getCalendars().set("cal1", cal1);
            ksession.setGlobal("list", list);
            timeService.advanceTime(date.getTime(), TimeUnit.MILLISECONDS);
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(0);
            timeService.advanceTime(86400L, TimeUnit.SECONDS);
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(0);
            timeService.advanceTime(86400L, TimeUnit.SECONDS);
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(1);
            timeService.advanceTime(86400L, TimeUnit.SECONDS);
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(2);
            timeService.advanceTime(86400L, TimeUnit.SECONDS);
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(3);
            timeService.advanceTime(86400L, TimeUnit.SECONDS);
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(3);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testCalendarsWithCronAndStartAndEnd() throws Exception {
        Locale defaultLoc = Locale.getDefault();
        try {
            Locale.setDefault(Locale.UK);
            String drl = "package org.simple \nglobal java.util.List list \nrule xxx \n  date-effective \"2-JAN-2010\"\n  date-expires \"6-JAN-2010\"\n  calendars \"cal1\"\n  timer (cron: 0 0 0 * * ?) when \nthen \n  list.add(\"fired\"); \nend  \n";
            KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"timer-and-calendar-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.simple \nglobal java.util.List list \nrule xxx \n  date-effective \"2-JAN-2010\"\n  date-expires \"6-JAN-2010\"\n  calendars \"cal1\"\n  timer (cron: 0 0 0 * * ?) when \nthen \n  list.add(\"fired\"); \nend  \n"});
            KieSession ksession = kbase.newKieSession(KieSessionTestConfiguration.STATEFUL_PSEUDO.getKieSessionConfiguration(), null);
            try {
                ArrayList list = new ArrayList();
                PseudoClockScheduler timeService = (PseudoClockScheduler)ksession.getSessionClock();
                SimpleDateFormat df = new SimpleDateFormat("dd-MMM-yyyy", Locale.UK);
                Date date = df.parse("1-JAN-2010");
                Calendar cal1 = timestamp -> true;
                long oneDay = 86400L;
                ksession.getCalendars().set("cal1", cal1);
                ksession.setGlobal("list", list);
                timeService.advanceTime(date.getTime(), TimeUnit.MILLISECONDS);
                ksession.fireAllRules();
                Assertions.assertThat((int)list.size()).isEqualTo(0);
                timeService.advanceTime(86400L, TimeUnit.SECONDS);
                ksession.fireAllRules();
                Assertions.assertThat((int)list.size()).isEqualTo(0);
                timeService.advanceTime(86400L, TimeUnit.SECONDS);
                ksession.fireAllRules();
                Assertions.assertThat((int)list.size()).isEqualTo(1);
                timeService.advanceTime(86400L, TimeUnit.SECONDS);
                ksession.fireAllRules();
                Assertions.assertThat((int)list.size()).isEqualTo(2);
                timeService.advanceTime(86400L, TimeUnit.SECONDS);
                ksession.fireAllRules();
                Assertions.assertThat((int)list.size()).isEqualTo(3);
                timeService.advanceTime(86400L, TimeUnit.SECONDS);
                ksession.fireAllRules();
                Assertions.assertThat((int)list.size()).isEqualTo(3);
            }
            finally {
                ksession.dispose();
            }
        }
        finally {
            Locale.setDefault(defaultLoc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testCalendarsWithCronAndStartAndLimit() throws Exception {
        Locale defaultLoc = Locale.getDefault();
        try {
            Locale.setDefault(Locale.UK);
            String drl = "package org.simple \nglobal java.util.List list \nrule xxx \n  date-effective \"2-JAN-2010\"\n  calendars \"cal1\"\n  timer (cron: 0 0 0 * * ?; repeat-limit=6) when \nthen \n  list.add(\"fired\"); \nend  \n";
            KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"timer-and-calendar-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.simple \nglobal java.util.List list \nrule xxx \n  date-effective \"2-JAN-2010\"\n  calendars \"cal1\"\n  timer (cron: 0 0 0 * * ?; repeat-limit=6) when \nthen \n  list.add(\"fired\"); \nend  \n"});
            KieSession ksession = kbase.newKieSession(KieSessionTestConfiguration.STATEFUL_PSEUDO.getKieSessionConfiguration(), null);
            try {
                ArrayList list = new ArrayList();
                PseudoClockScheduler timeService = (PseudoClockScheduler)ksession.getSessionClock();
                SimpleDateFormat df = new SimpleDateFormat("dd-MMM-yyyy", Locale.UK);
                Date date = df.parse("1-JAN-2010");
                Calendar cal1 = timestamp -> true;
                long oneDay = 86400L;
                ksession.getCalendars().set("cal1", cal1);
                ksession.setGlobal("list", list);
                timeService.advanceTime(date.getTime(), TimeUnit.MILLISECONDS);
                ksession.fireAllRules();
                Assertions.assertThat((int)list.size()).isEqualTo(0);
                timeService.advanceTime(86400L, TimeUnit.SECONDS);
                ksession.fireAllRules();
                Assertions.assertThat((int)list.size()).isEqualTo(0);
                timeService.advanceTime(86400L, TimeUnit.SECONDS);
                ksession.fireAllRules();
                Assertions.assertThat((int)list.size()).isEqualTo(1);
                timeService.advanceTime(86400L, TimeUnit.SECONDS);
                ksession.fireAllRules();
                Assertions.assertThat((int)list.size()).isEqualTo(2);
                timeService.advanceTime(86400L, TimeUnit.SECONDS);
                ksession.fireAllRules();
                Assertions.assertThat((int)list.size()).isEqualTo(3);
                timeService.advanceTime(86400L, TimeUnit.SECONDS);
                ksession.fireAllRules();
                Assertions.assertThat((int)list.size()).isEqualTo(4);
            }
            finally {
                ksession.dispose();
            }
        }
        finally {
            Locale.setDefault(defaultLoc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testIntervalTimerWithLongExpressions() {
        String drl = "package org.simple;\nglobal java.util.List list;\n\ndeclare Bean\n  delay   : long = 30000\n  period  : long = 10000\nend\n\nrule init \nwhen \nthen \n insert( new Bean() );\nend \n\nrule xxx\n  salience ($d) \n  timer( expr: $d, $p; start=3-JAN-2010 )\nwhen\n  Bean( $d : delay, $p : period )\nthen\n  list.add( \"fired\" );\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"timer-and-calendar-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.simple;\nglobal java.util.List list;\n\ndeclare Bean\n  delay   : long = 30000\n  period  : long = 10000\nend\n\nrule init \nwhen \nthen \n insert( new Bean() );\nend \n\nrule xxx\n  salience ($d) \n  timer( expr: $d, $p; start=3-JAN-2010 )\nwhen\n  Bean( $d : delay, $p : period )\nthen\n  list.add( \"fired\" );\nend"});
        KieSession ksession = kbase.newKieSession(KieSessionTestConfiguration.STATEFUL_PSEUDO.getKieSessionConfiguration(), null);
        try {
            ArrayList list = new ArrayList();
            PseudoClockScheduler timeService = (PseudoClockScheduler)ksession.getSessionClock();
            timeService.setStartupTime(DateUtils.parseDate((String)"3-JAN-2010").getTime());
            ksession.setGlobal("list", list);
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(0);
            timeService.advanceTime(20L, TimeUnit.SECONDS);
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(0);
            timeService.advanceTime(15L, TimeUnit.SECONDS);
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(1);
            timeService.advanceTime(3L, TimeUnit.SECONDS);
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(1);
            timeService.advanceTime(2L, TimeUnit.SECONDS);
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(2);
            timeService.advanceTime(10L, TimeUnit.SECONDS);
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(3);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testIntervalTimerAfterEnd() {
        String drl = "package org.simple;\nglobal java.util.List list;\n\ndeclare Bean\n  delay   : long = 30000\n  period  : long = 10000\nend\n\nrule init \nwhen \nthen \n insert( new Bean() );\nend \n\nrule xxx\n  salience ($d) \n  timer( expr: $d, $p; end=3-JAN-2010 )\nwhen\n  Bean( $d : delay, $p : period )\nthen\n  list.add( \"fired\" );\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"timer-and-calendar-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.simple;\nglobal java.util.List list;\n\ndeclare Bean\n  delay   : long = 30000\n  period  : long = 10000\nend\n\nrule init \nwhen \nthen \n insert( new Bean() );\nend \n\nrule xxx\n  salience ($d) \n  timer( expr: $d, $p; end=3-JAN-2010 )\nwhen\n  Bean( $d : delay, $p : period )\nthen\n  list.add( \"fired\" );\nend"});
        KieSession ksession = kbase.newKieSession(KieSessionTestConfiguration.STATEFUL_PSEUDO.getKieSessionConfiguration(), null);
        try {
            ArrayList list = new ArrayList();
            PseudoClockScheduler timeService = (PseudoClockScheduler)ksession.getSessionClock();
            timeService.setStartupTime(DateUtils.parseDate((String)"3-JAN-2010").getTime());
            ksession.setGlobal("list", list);
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(0);
        }
        finally {
            ksession.dispose();
        }
    }

    @Test(timeout=10000L)
    public void testIntervalTimerWithStringExpressions() {
        this.checkIntervalTimerWithStringExpressions(false, "3-JAN-2010");
    }

    @Test(timeout=10000L)
    public void testIntervalTimerWithAllExpressions() {
        this.checkIntervalTimerWithStringExpressions(true, "3-JAN-2010");
    }

    @Test(timeout=10000L)
    public void testIntervalTimerWithStringExpressionsAfterStart() {
        this.checkIntervalTimerWithStringExpressions(false, "3-FEB-2010");
    }

    @Test(timeout=10000L)
    public void testIntervalTimerWithAllExpressionsAfterStart() {
        this.checkIntervalTimerWithStringExpressions(true, "3-FEB-2010");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkIntervalTimerWithStringExpressions(boolean useExprForStart, String startTime) {
        String drl = "package org.simple;\nglobal java.util.List list;\n\ndeclare Bean\n  delay   : String = \"30s\"\n  period  : long = 60000\n  start   : String = \"3-JAN-2010\"\nend\n\nrule init \nwhen \nthen \n insert( new Bean() );\nend \n\nrule xxx\n  salience ($d) \n  timer( expr: $d, $p; start=" + (useExprForStart ? "$s" : "3-JAN-2010") + " )\nwhen\n  Bean( $d : delay, $p : period, $s : start )\nthen\n  list.add( \"fired\" );\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"timer-and-calendar-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession(KieSessionTestConfiguration.STATEFUL_PSEUDO.getKieSessionConfiguration(), null);
        try {
            ArrayList list = new ArrayList();
            PseudoClockScheduler timeService = (PseudoClockScheduler)ksession.getSessionClock();
            timeService.setStartupTime(DateUtils.parseDate((String)startTime).getTime());
            ksession.setGlobal("list", list);
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(0);
            timeService.advanceTime(20L, TimeUnit.SECONDS);
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(0);
            timeService.advanceTime(20L, TimeUnit.SECONDS);
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(1);
            timeService.advanceTime(20L, TimeUnit.SECONDS);
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(1);
            timeService.advanceTime(40L, TimeUnit.SECONDS);
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(2);
            timeService.advanceTime(60L, TimeUnit.SECONDS);
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(3);
            timeService.setStartupTime(DateUtils.parseDate((String)"3-MAR-2010").getTime());
            list.clear();
            timeService.advanceTime(20L, TimeUnit.SECONDS);
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(1);
            timeService.advanceTime(20L, TimeUnit.SECONDS);
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(2);
            timeService.advanceTime(20L, TimeUnit.SECONDS);
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(2);
            timeService.advanceTime(40L, TimeUnit.SECONDS);
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(3);
            timeService.advanceTime(60L, TimeUnit.SECONDS);
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(4);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testIntervalTimerExpressionWithOr() {
        String drl = "package org.kie.test\nglobal java.util.List list\nimport " + FactA.class.getCanonicalName() + "\nimport " + FactB.class.getCanonicalName() + "\nimport " + Pet.class.getCanonicalName() + "\nrule r1 timer (expr: f1.field2, f1.field2; repeat-limit=3)\nwhen\n    foo: FactB()\n    ( Pet()  and f1 : FactA( field1 == 'f1') ) or \n    f1 : FactA(field1 == 'f2') \nthen\n    list.add( f1 );\n    foo.setF1( 'xxx' );\nend\n\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"timer-and-calendar-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession(KieSessionTestConfiguration.STATEFUL_PSEUDO.getKieSessionConfiguration(), null);
        try {
            PseudoClockScheduler timeService = (PseudoClockScheduler)ksession.getSessionClock();
            timeService.advanceTime(new Date().getTime(), TimeUnit.MILLISECONDS);
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            ksession.insert((Object)new FactB());
            ksession.insert((Object)new Pet("cinchilla"));
            FactA fact1 = new FactA();
            fact1.setField1("f1");
            fact1.setField2(Integer.valueOf(250));
            FactA fact3 = new FactA();
            fact3.setField1("f2");
            fact3.setField2(Integer.valueOf(1000));
            ksession.insert((Object)fact1);
            ksession.insert((Object)fact3);
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(0);
            timeService.advanceTime(300L, TimeUnit.MILLISECONDS);
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(1);
            Assertions.assertThat(list.get(0)).isEqualTo((Object)fact1);
            timeService.advanceTime(300L, TimeUnit.MILLISECONDS);
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(2);
            Assertions.assertThat(list.get(1)).isEqualTo((Object)fact1);
            timeService.advanceTime(300L, TimeUnit.MILLISECONDS);
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(2);
            timeService.advanceTime(300L, TimeUnit.MILLISECONDS);
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(3);
            Assertions.assertThat(list.get(2)).isEqualTo((Object)fact3);
            timeService.advanceTime(1000L, TimeUnit.MILLISECONDS);
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(4);
            Assertions.assertThat(list.get(3)).isEqualTo((Object)fact3);
            timeService.advanceTime(1000L, TimeUnit.MILLISECONDS);
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(4);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testExprTimeRescheduled() {
        String drl = "package org.kie.test\nglobal java.util.List list\nimport " + FactA.class.getCanonicalName() + "\nrule r1 timer (expr: f1.field2, f1.field4)\nwhen\n    f1 : FactA() \nthen\n    list.add( f1 );\nend\n\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"timer-and-calendar-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession(KieSessionTestConfiguration.STATEFUL_PSEUDO.getKieSessionConfiguration(), null);
        try {
            PseudoClockScheduler timeService = (PseudoClockScheduler)ksession.getSessionClock();
            timeService.advanceTime(new Date().getTime(), TimeUnit.MILLISECONDS);
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            FactA fact1 = new FactA();
            fact1.setField1("f1");
            fact1.setField2(Integer.valueOf(500));
            fact1.setField4(Integer.valueOf(1000));
            FactHandle fh = ksession.insert((Object)fact1);
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(0);
            timeService.advanceTime(1100L, TimeUnit.MILLISECONDS);
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(1);
            Assertions.assertThat(list.get(0)).isEqualTo((Object)fact1);
            timeService.advanceTime(1100L, TimeUnit.MILLISECONDS);
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(2);
            Assertions.assertThat(list.get(1)).isEqualTo((Object)fact1);
            timeService.advanceTime(400L, TimeUnit.MILLISECONDS);
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(3);
            Assertions.assertThat(list.get(2)).isEqualTo((Object)fact1);
            list.clear();
            fact1.setField2(Integer.valueOf(300));
            fact1.setField4(Integer.valueOf(2000));
            ksession.update(fh, (Object)fact1);
            ksession.fireAllRules();
            timeService.advanceTime(1950L, TimeUnit.MILLISECONDS);
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(1);
            Assertions.assertThat(list.get(0)).isEqualTo((Object)fact1);
            list.clear();
            timeService.advanceTime(1000L, TimeUnit.MILLISECONDS);
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(0);
            timeService.advanceTime(700L, TimeUnit.MILLISECONDS);
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(0);
            timeService.advanceTime(300L, TimeUnit.MILLISECONDS);
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(1);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExpiredPropagations() {
        String drl = "package org.drools.test;\n\nimport " + StockTick.class.getCanonicalName() + ";\nglobal java.util.List list;\n\ndeclare StockTick\n    @role( event )\n    @timestamp( time )\nend\n\ndeclare window ATicks\n StockTick( company == \"AAA\" ) over window:time( 1s )  from entry-point \"AAA\"\nend\n\ndeclare window BTicks\n StockTick( company == \"BBB\" ) over window:time( 1s )  from entry-point \"BBB\"\nend\n\nrule Ticks \n when\n String()\n accumulate( $x : StockTick() from window ATicks, $a : count( $x ) )\n accumulate( $y : StockTick() from window BTicks, $b : count( $y ) )\n accumulate( $z : StockTick() over window:time( 1s ), $c : count( $z ) )\n then\n list.add( $a );\n list.add( $b );\n list.add( $c );\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"timer-and-calendar-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession(KieSessionTestConfiguration.STATEFUL_PSEUDO.getKieSessionConfiguration(), null);
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            SessionPseudoClock clock = (SessionPseudoClock)ksession.getSessionClock();
            clock.advanceTime(1100L, TimeUnit.MILLISECONDS);
            StockTick tick = new StockTick(0L, "AAA", 1.0, 0L);
            StockTick tock = new StockTick(1L, "BBB", 1.0, 2500L);
            StockTick tack = new StockTick(1L, "CCC", 1.0, 2700L);
            EntryPoint epa = ksession.getEntryPoint("AAA");
            EntryPoint epb = ksession.getEntryPoint("BBB");
            epa.insert((Object)tick);
            epb.insert((Object)tock);
            ksession.insert((Object)tack);
            FactHandle handle = ksession.insert((Object)"go1");
            ksession.fireAllRules();
            Assertions.assertThat(list).isEqualTo(Arrays.asList(0L, 1L, 1L));
            list.clear();
            ksession.delete(handle);
            clock.advanceTime(2550L, TimeUnit.MILLISECONDS);
            handle = ksession.insert((Object)"go2");
            ksession.fireAllRules();
            Assertions.assertThat(list).isEqualTo(Arrays.asList(0L, 0L, 1L));
            list.clear();
            ksession.delete(handle);
            clock.advanceTime(500L, TimeUnit.MILLISECONDS);
            handle = ksession.insert((Object)"go3");
            ksession.fireAllRules();
            Assertions.assertThat(list).isEqualTo(Arrays.asList(0L, 0L, 0L));
            list.clear();
            ksession.delete(handle);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCronFire() {
        String drl = "package test.drools\nrule TestRule   timer (cron:* * * * * ?) when\n    String()     Integer() then\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"timer-and-calendar-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package test.drools\nrule TestRule   timer (cron:* * * * * ?) when\n    String()     Integer() then\nend\n"});
        KieSession ksession = kbase.newKieSession();
        try {
            int repetitions = 10000;
            for (int j = 0; j < 10000; ++j) {
                ksession.insert((Object)j);
            }
            ksession.insert((Object)"go");
            ksession.fireAllRules();
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    @Ignore(value="the listener callback holds some locks so blocking in it is not safe")
    public void testRaceConditionWithTimedRuleExectionOption() throws Exception {
        String drl = "package org.simple \nglobal java.util.List list \nrule xxx @Propagation(EAGER)\n  timer (int:30s 10s) when \n  $s: String()\nthen \n  list.add($s); \nend  \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"timer-and-calendar-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.simple \nglobal java.util.List list \nrule xxx @Propagation(EAGER)\n  timer (int:30s 10s) when \n  $s: String()\nthen \n  list.add($s); \nend  \n"});
        KieSessionConfiguration kieSessionConfiguration = KieSessionTestConfiguration.STATEFUL_PSEUDO.getKieSessionConfiguration();
        kieSessionConfiguration.setOption((KieSessionOption)TimedRuleExecutionOption.YES);
        KieSession ksession = kbase.newKieSession(kieSessionConfiguration, null);
        try {
            final CyclicBarrier barrier = new CyclicBarrier(2);
            final AtomicBoolean aBool = new AtomicBoolean(true);
            DefaultAgendaEventListener agendaEventListener = new DefaultAgendaEventListener(){

                public void afterMatchFired(AfterMatchFiredEvent event) {
                    try {
                        if (aBool.get()) {
                            barrier.await();
                            aBool.set(false);
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            };
            ksession.addEventListener((AgendaEventListener)agendaEventListener);
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            SessionClock clock = ksession.getSessionClock();
            SessionPseudoClock pseudoClock = (SessionPseudoClock)clock;
            String eventOne = "one";
            ksession.insert((Object)"one");
            pseudoClock.advanceTime(10000L, TimeUnit.MILLISECONDS);
            ksession.fireAllRules();
            pseudoClock.advanceTime(30000L, TimeUnit.MILLISECONDS);
            barrier.await();
            barrier.reset();
            aBool.set(true);
            pseudoClock.advanceTime(10000L, TimeUnit.MILLISECONDS);
            barrier.await();
            barrier.reset();
            aBool.set(true);
            String eventTwo = "two";
            ksession.insert((Object)"two");
            ksession.fireAllRules();
            pseudoClock.advanceTime(10000L, TimeUnit.MILLISECONDS);
            barrier.await();
            barrier.reset();
            aBool.set(true);
            pseudoClock.advanceTime(10000L, TimeUnit.MILLISECONDS);
            barrier.await();
            barrier.reset();
            aBool.set(true);
            pseudoClock.advanceTime(10000L, TimeUnit.MILLISECONDS);
            barrier.await();
            barrier.reset();
            aBool.set(true);
            pseudoClock.advanceTime(20000L, TimeUnit.MILLISECONDS);
            barrier.await();
            barrier.reset();
            pseudoClock.advanceTime(20000L, TimeUnit.MILLISECONDS);
            aBool.set(true);
            barrier.await();
            barrier.reset();
            pseudoClock.advanceTime(20000L, TimeUnit.MILLISECONDS);
            aBool.set(true);
            barrier.await();
            barrier.reset();
        }
        finally {
            ksession.dispose();
        }
    }
}

