/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.KieModule;
import org.kie.api.builder.Message;
import org.kie.api.builder.model.KieBaseModel;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.conf.DeclarativeAgendaOption;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.event.rule.AfterMatchFiredEvent;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.event.rule.AgendaGroupPoppedEvent;
import org.kie.api.event.rule.AgendaGroupPushedEvent;
import org.kie.api.event.rule.BeforeMatchFiredEvent;
import org.kie.api.event.rule.MatchCancelledEvent;
import org.kie.api.event.rule.MatchCreatedEvent;
import org.kie.api.event.rule.RuleFlowGroupActivatedEvent;
import org.kie.api.event.rule.RuleFlowGroupDeactivatedEvent;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.api.runtime.rule.Match;

@RunWith(value=Parameterized.class)
public class DeclarativeAgendaTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public DeclarativeAgendaTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)false);
    }

    @Test(timeout=10000L)
    public void testSimpleBlockingUsingForall() {
        String str = "";
        str = str + "package org.domain.test \n";
        str = str + "import " + Match.class.getName() + "\n";
        str = str + "global java.util.List list \n";
        str = str + "dialect 'mvel' \n";
        str = str + "rule rule1 @department(sales) salience -100 \n";
        str = str + "when \n";
        str = str + "     $s : String( this == 'go1' ) \n";
        str = str + "then \n";
        str = str + "    list.add( kcontext.rule.name + ':' + $s ); \n";
        str = str + "end \n";
        str = str + "rule rule2 salience 200\n";
        str = str + "when \n";
        str = str + "     $s : String( this == 'go1' ) \n";
        str = str + "     exists  Match( department == 'sales' ) \n";
        str = str + "     forall ( $a : Match( department == 'sales' ) Match( this == $a, active == false ) ) \n";
        str = str + "then \n";
        str = str + "    list.add( kcontext.rule.name + ':' + $s ); \n";
        str = str + "end \n";
        KieModule kieModule = KieUtil.getKieModuleFromDrls((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieBase kbase = KieBaseUtil.newKieBaseFromKieModuleWithAdditionalOptions((KieModule)kieModule, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieBaseOption[])new KieBaseOption[]{DeclarativeAgendaOption.ENABLED});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)"go1");
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(2);
        Assertions.assertThat((boolean)list.contains("rule1:go1")).isTrue();
        Assertions.assertThat((boolean)list.contains("rule2:go1")).isTrue();
        ksession.dispose();
    }

    @Test(timeout=10000L)
    public void testBasicBlockOnAnnotation() {
        String str = "";
        str = str + "package org.domain.test \n";
        str = str + "import " + Match.class.getName() + "\n";
        str = str + "global java.util.List list \n";
        str = str + "dialect 'mvel' \n";
        str = str + "rule rule1 @department(sales) \n";
        str = str + "when \n";
        str = str + "     $s : String( this == 'go1' ) \n";
        str = str + "then \n";
        str = str + "    list.add( kcontext.rule.name + ':' + $s ); \n";
        str = str + "end \n";
        str = str + "rule rule2 @department(sales) \n";
        str = str + "when \n";
        str = str + "     $s : String( this == 'go1' ) \n";
        str = str + "then \n";
        str = str + "    list.add( kcontext.rule.name + ':' + $s ); \n";
        str = str + "end \n";
        str = str + "rule rule3 @department(sales) \n";
        str = str + "when \n";
        str = str + "     $s : String( this == 'go1' ) \n";
        str = str + "then \n";
        str = str + "    list.add( kcontext.rule.name + ':' + $s ); \n";
        str = str + "end \n";
        str = str + "rule blockerAllSalesRules @activationListener('direct') \n";
        str = str + "when \n";
        str = str + "     $s : String( this == 'go2' ) \n";
        str = str + "     $i : Match( department == 'sales' ) \n";
        str = str + "then \n";
        str = str + "    list.add( $i.rule.name + ':' + $s  ); \n";
        str = str + "    kcontext.blockMatch( $i ); \n";
        str = str + "end \n";
        KieModule kieModule = KieUtil.getKieModuleFromDrls((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieBase kbase = KieBaseUtil.newKieBaseFromKieModuleWithAdditionalOptions((KieModule)kieModule, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieBaseOption[])new KieBaseOption[]{DeclarativeAgendaOption.ENABLED});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)"go1");
        FactHandle go2 = ksession.insert((Object)"go2");
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(3);
        Assertions.assertThat((boolean)list.contains("rule1:go2")).isTrue();
        Assertions.assertThat((boolean)list.contains("rule2:go2")).isTrue();
        Assertions.assertThat((boolean)list.contains("rule3:go2")).isTrue();
        list.clear();
        ksession.retract(go2);
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(3);
        Assertions.assertThat((boolean)list.contains("rule1:go1")).isTrue();
        Assertions.assertThat((boolean)list.contains("rule2:go1")).isTrue();
        Assertions.assertThat((boolean)list.contains("rule3:go1")).isTrue();
        ksession.dispose();
    }

    @Test(timeout=10000L)
    public void testApplyBlockerFirst() {
        KieSession ksession = this.getStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        FactHandle go2 = ksession.insert((Object)"go2");
        FactHandle go1 = ksession.insert((Object)"go1");
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(1);
        Assertions.assertThat((boolean)list.contains("rule1:go2")).isTrue();
        list.clear();
        ksession.retract(go2);
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(1);
        Assertions.assertThat((boolean)list.contains("rule1:go1")).isTrue();
    }

    @Test(timeout=10000L)
    public void testApplyBlockerFirstWithFireAllRulesInbetween() {
        KieSession ksession = this.getStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        FactHandle go2 = ksession.insert((Object)"go2");
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(0);
        FactHandle go1 = ksession.insert((Object)"go1");
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(1);
        Assertions.assertThat((boolean)list.contains("rule1:go2")).isTrue();
        list.clear();
        ksession.retract(go2);
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(1);
        Assertions.assertThat((boolean)list.contains("rule1:go1")).isTrue();
    }

    @Test(timeout=10000L)
    public void testApplyBlockerSecond() {
        KieSession ksession = this.getStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        FactHandle go1 = ksession.insert((Object)"go1");
        FactHandle go2 = ksession.insert((Object)"go2");
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(1);
        Assertions.assertThat((boolean)list.contains("rule1:go2")).isTrue();
        list.clear();
        ksession.retract(go2);
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(1);
        Assertions.assertThat((boolean)list.contains("rule1:go1")).isTrue();
    }

    @Test(timeout=10000L)
    public void testApplyBlockerSecondWithUpdate() {
        KieSession ksession = this.getStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        FactHandle go1 = ksession.insert((Object)"go1");
        FactHandle go2 = ksession.insert((Object)"go2");
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(1);
        Assertions.assertThat((boolean)list.contains("rule1:go2")).isTrue();
        list.clear();
        ksession.update(go2, (Object)"go2");
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(1);
        Assertions.assertThat((boolean)list.contains("rule1:go2")).isTrue();
        list.clear();
        ksession.retract(go2);
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(1);
        Assertions.assertThat((boolean)list.contains("rule1:go1")).isTrue();
    }

    @Test(timeout=10000L)
    public void testApplyBlockerSecondAfterUpdate() {
        KieSession ksession = this.getStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        FactHandle go1 = ksession.insert((Object)"go1");
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(1);
        Assertions.assertThat((boolean)list.contains("rule1:go1")).isTrue();
        list.clear();
        FactHandle go2 = ksession.insert((Object)"go2");
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(1);
        Assertions.assertThat((boolean)list.contains("rule1:go2")).isTrue();
        list.clear();
        ksession.update(go1, (Object)"go1");
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(1);
        Assertions.assertThat((boolean)list.contains("rule1:go2")).isTrue();
        list.clear();
        ksession.retract(go2);
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(1);
        Assertions.assertThat((boolean)list.contains("rule1:go1")).isTrue();
    }

    public KieSession getStatefulKnowledgeSession() {
        String str = "";
        str = str + "package org.domain.test \n";
        str = str + "import " + Match.class.getName() + "\n";
        str = str + "global java.util.List list \n";
        str = str + "dialect 'mvel' \n";
        str = str + "rule rule1 @department(sales) \n";
        str = str + "when \n";
        str = str + "     $s : String( this == 'go1' ) \n";
        str = str + "then \n";
        str = str + "    list.add( kcontext.rule.name + ':' + $s ); \n";
        str = str + "end \n";
        str = str + "rule blockerAllSalesRules @activationListener('direct') \n";
        str = str + "when \n";
        str = str + "     $s : String( this == 'go2' ) \n";
        str = str + "     $i : Match( department == 'sales' ) \n";
        str = str + "then \n";
        str = str + "    list.add( $i.rule.name + ':' + $s  ); \n";
        str = str + "    kcontext.blockMatch( $i ); \n";
        str = str + "end \n";
        KieModule kieModule = KieUtil.getKieModuleFromDrls((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieBase kbase = KieBaseUtil.newKieBaseFromKieModuleWithAdditionalOptions((KieModule)kieModule, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieBaseOption[])new KieBaseOption[]{DeclarativeAgendaOption.ENABLED});
        KieSession ksession = kbase.newKieSession();
        return ksession;
    }

    @Test(timeout=10000L)
    public void testMultipleBlockers() {
        String str = "";
        str = str + "package org.domain.test \n";
        str = str + "import " + Match.class.getName() + "\n";
        str = str + "global java.util.List list \n";
        str = str + "dialect 'mvel' \n";
        str = str + "rule rule0 @department(sales) \n";
        str = str + "when \n";
        str = str + "     $s : String( this == 'go0' ) \n";
        str = str + "then \n";
        str = str + "    list.add( kcontext.rule.name + ':' + $s ); \n";
        str = str + "end \n";
        str = str + "rule blockerAllSalesRules1 @activationListener('direct') \n";
        str = str + "when \n";
        str = str + "     $s : String( this == 'go1' ) \n";
        str = str + "     $i : Match( department == 'sales' ) \n";
        str = str + "then \n";
        str = str + "    list.add( $i.rule.name + ':' + $s  ); \n";
        str = str + "    kcontext.blockMatch( $i ); \n";
        str = str + "end \n";
        str = str + "rule blockerAllSalesRules2 @activationListener('direct') \n";
        str = str + "when \n";
        str = str + "     $s : String( this == 'go2' ) \n";
        str = str + "     $i : Match( department == 'sales' ) \n";
        str = str + "then \n";
        str = str + "    list.add( $i.rule.name + ':' + $s  ); \n";
        str = str + "    kcontext.blockMatch( $i ); \n";
        str = str + "end \n";
        str = str + "rule blockerAllSalesRules3 @activationListener('direct') \n";
        str = str + "when \n";
        str = str + "     $s : String( this == 'go3' ) \n";
        str = str + "     $i : Match( department == 'sales' ) \n";
        str = str + "then \n";
        str = str + "    list.add( $i.rule.name + ':' + $s  ); \n";
        str = str + "    kcontext.blockMatch( $i ); \n";
        str = str + "end \n";
        KieModule kieModule = KieUtil.getKieModuleFromDrls((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieBase kbase = KieBaseUtil.newKieBaseFromKieModuleWithAdditionalOptions((KieModule)kieModule, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieBaseOption[])new KieBaseOption[]{DeclarativeAgendaOption.ENABLED});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        FactHandle go0 = ksession.insert((Object)"go0");
        FactHandle go1 = ksession.insert((Object)"go1");
        FactHandle go2 = ksession.insert((Object)"go2");
        FactHandle go3 = ksession.insert((Object)"go3");
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(3);
        Assertions.assertThat((boolean)list.contains("rule0:go1")).isTrue();
        Assertions.assertThat((boolean)list.contains("rule0:go2")).isTrue();
        Assertions.assertThat((boolean)list.contains("rule0:go3")).isTrue();
        list.clear();
        ksession.retract(go3);
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(0);
        ksession.retract(go2);
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(0);
        ksession.retract(go1);
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(1);
        Assertions.assertThat((boolean)list.contains("rule0:go0")).isTrue();
        ksession.dispose();
    }

    @Test(timeout=10000L)
    public void testMultipleBlockersWithUnblockAll() {
        String str = "";
        str = str + "package org.domain.test \n";
        str = str + "import " + Match.class.getName() + "\n";
        str = str + "global java.util.List list \n";
        str = str + "dialect 'mvel' \n";
        str = str + "rule rule0 @Propagation(EAGER) @department(sales) \n";
        str = str + "when \n";
        str = str + "     $s : String( this == 'go0' ) \n";
        str = str + "then \n";
        str = str + "    list.add( kcontext.rule.name + ':' + $s ); \n";
        str = str + "end \n";
        str = str + "rule blockerAllSalesRules1 @activationListener('direct') \n";
        str = str + "when \n";
        str = str + "     $s : String( this == 'go1' ) \n";
        str = str + "     $i : Match( department == 'sales' ) \n";
        str = str + "then \n";
        str = str + "    list.add( kcontext.rule.name + ':' + $i.rule.name + ':' + $s  ); \n";
        str = str + "    kcontext.blockMatch( $i ); \n";
        str = str + "end \n";
        str = str + "rule blockerAllSalesRules2 @activationListener('direct') \n";
        str = str + "when \n";
        str = str + "     $s : String( this == 'go2' ) \n";
        str = str + "     $i : Match( department == 'sales' ) \n";
        str = str + "then \n";
        str = str + "    list.add( kcontext.rule.name + ':' + $i.rule.name + ':' + $s  ); \n";
        str = str + "    kcontext.blockMatch( $i ); \n";
        str = str + "end \n";
        str = str + "rule blockerAllSalesRules3 @activationListener('direct') \n";
        str = str + "when \n";
        str = str + "     $s : String( this == 'go3' ) \n";
        str = str + "     $i : Match( department == 'sales' ) \n";
        str = str + "then \n";
        str = str + "    list.add( kcontext.rule.name + ':' + $i.rule.name + ':' + $s  ); \n";
        str = str + "    kcontext.blockMatch( $i ); \n";
        str = str + "end \n";
        str = str + "rule unblockAll @activationListener('direct') \n";
        str = str + "when \n";
        str = str + "     $s : String( this == 'go4' ) \n";
        str = str + "     $i : Match( department == 'sales', active == true ) \n";
        str = str + "then \n";
        str = str + "    list.add( kcontext.rule.name + ':' + $i.rule.name + ':' + $s  ); \n";
        str = str + "    kcontext.unblockAllMatches( $i ); \n";
        str = str + "end \n";
        KieModule kieModule = KieUtil.getKieModuleFromDrls((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieBase kbase = KieBaseUtil.newKieBaseFromKieModuleWithAdditionalOptions((KieModule)kieModule, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieBaseOption[])new KieBaseOption[]{DeclarativeAgendaOption.ENABLED});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        FactHandle go0 = ksession.insert((Object)"go0");
        FactHandle go1 = ksession.insert((Object)"go1");
        FactHandle go2 = ksession.insert((Object)"go2");
        FactHandle go3 = ksession.insert((Object)"go3");
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(3);
        System.out.println(list);
        Assertions.assertThat((boolean)list.contains("blockerAllSalesRules1:rule0:go1")).isTrue();
        Assertions.assertThat((boolean)list.contains("blockerAllSalesRules2:rule0:go2")).isTrue();
        Assertions.assertThat((boolean)list.contains("blockerAllSalesRules3:rule0:go3")).isTrue();
        list.clear();
        FactHandle go4 = ksession.insert((Object)"go4");
        ksession.fireAllRules();
        System.out.println(list);
        Assertions.assertThat((int)list.size()).isEqualTo(5);
        Assertions.assertThat((boolean)list.contains("unblockAll:rule0:go4")).isTrue();
        Assertions.assertThat((boolean)list.contains("rule0:go0")).isTrue();
        Assertions.assertThat((boolean)list.contains("blockerAllSalesRules1:rule0:go1")).isTrue();
        Assertions.assertThat((boolean)list.contains("blockerAllSalesRules2:rule0:go2")).isTrue();
        Assertions.assertThat((boolean)list.contains("blockerAllSalesRules3:rule0:go3")).isTrue();
    }

    @Test(timeout=10000L)
    public void testIterativeUpdate() {
        String str = "";
        str = str + "package org.domain.test \n";
        str = str + "import " + Match.class.getName() + "\n";
        str = str + "global java.util.List list \n";
        str = str + "dialect 'mvel' \n";
        str = str + "rule rule0 \n";
        str = str + "when \n";
        str = str + "     $s : String( this == 'rule0' ) \n";
        str = str + "then \n";
        str = str + "    list.add( kcontext.rule.name ); \n";
        str = str + "end \n";
        str = str + "rule rule1 \n";
        str = str + "when \n";
        str = str + "     $s : String( this == 'rule1' ) \n";
        str = str + "then \n";
        str = str + "    list.add( kcontext.rule.name ); \n";
        str = str + "end \n";
        str = str + "rule rule2 \n";
        str = str + "when \n";
        str = str + "     $s : String( this == 'rule2' ) \n";
        str = str + "then \n";
        str = str + "    list.add( kcontext.rule.name ); \n";
        str = str + "end \n";
        str = str + "rule blockerAllSalesRules1 @activationListener('direct') \n";
        str = str + "when \n";
        str = str + "     $l : List( ) \n";
        str = str + "     $i : Match( rule.name == $l[0] ) \n";
        str = str + "then \n";
        str = str + "    list.add( 'block:' + $i.rule.name  ); \n";
        str = str + "    kcontext.blockMatch( $i ); \n";
        str = str + "end \n";
        KieModule kieModule = KieUtil.getKieModuleFromDrls((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieBase kbase = KieBaseUtil.newKieBaseFromKieModuleWithAdditionalOptions((KieModule)kieModule, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieBaseOption[])new KieBaseOption[]{DeclarativeAgendaOption.ENABLED});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        FactHandle rule0 = ksession.insert((Object)"rule0");
        FactHandle rule1 = ksession.insert((Object)"rule1");
        FactHandle rule2 = ksession.insert((Object)"rule2");
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(3);
        Assertions.assertThat((boolean)list.contains("rule0")).isTrue();
        Assertions.assertThat((boolean)list.contains("rule1")).isTrue();
        Assertions.assertThat((boolean)list.contains("rule2")).isTrue();
        list.clear();
        ArrayList<String> l = new ArrayList<String>();
        l.add("rule0");
        FactHandle lh = ksession.insert(l);
        ksession.update(rule0, (Object)"rule0");
        ksession.update(rule1, (Object)"rule1");
        ksession.update(rule2, (Object)"rule2");
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(4);
        Assertions.assertThat((boolean)list.contains("block:rule0")).isTrue();
        Assertions.assertThat((boolean)list.contains("rule1")).isTrue();
        Assertions.assertThat((boolean)list.contains("rule2")).isTrue();
        Assertions.assertThat((boolean)list.contains("rule0")).isFalse();
        list.clear();
        ksession.update(rule0, (Object)"rule0");
        ksession.update(rule1, (Object)"rule1");
        ksession.update(rule2, (Object)"rule2");
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(3);
        Assertions.assertThat((boolean)list.contains("block:rule0")).isTrue();
        Assertions.assertThat((boolean)list.contains("rule1")).isTrue();
        Assertions.assertThat((boolean)list.contains("rule2")).isTrue();
        Assertions.assertThat((boolean)list.contains("rule0")).isFalse();
        list.clear();
        l.set(0, "rule1");
        ksession.update(lh, l);
        ksession.fireAllRules();
        System.out.println(list);
        Assertions.assertThat((int)list.size()).isEqualTo(2);
        Assertions.assertThat((boolean)list.contains("rule0")).isTrue();
        Assertions.assertThat((boolean)list.contains("block:rule1")).isTrue();
        list.clear();
        ksession.update(rule0, (Object)"rule0");
        ksession.update(rule1, (Object)"rule1");
        ksession.update(rule2, (Object)"rule2");
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(3);
        Assertions.assertThat((boolean)list.contains("block:rule1")).isTrue();
        Assertions.assertThat((boolean)list.contains("rule0")).isTrue();
        Assertions.assertThat((boolean)list.contains("rule2")).isTrue();
        Assertions.assertThat((boolean)list.contains("rule1")).isFalse();
        list.clear();
        l.set(0, "rule2");
        ksession.update(lh, l);
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(2);
        Assertions.assertThat((boolean)list.contains("rule1")).isTrue();
        Assertions.assertThat((boolean)list.contains("block:rule2")).isTrue();
    }

    @Test(timeout=10000L)
    public void testCancelActivation() {
        String str = "";
        str = str + "package org.domain.test \n";
        str = str + "import " + Match.class.getName() + "\n";
        str = str + "global java.util.List list \n";
        str = str + "dialect 'mvel' \n";
        str = str + "rule rule1 @department(sales) \n";
        str = str + "when \n";
        str = str + "     $s : String( this == 'go1' ) \n";
        str = str + "then \n";
        str = str + "    list.add( kcontext.rule.name + ':' + $s ); \n";
        str = str + "end \n";
        str = str + "rule blockerAllSalesRules @activationListener('direct') \n";
        str = str + "when \n";
        str = str + "     $s : String( this == 'go2' ) \n";
        str = str + "     $i : Match( department == 'sales' ) \n";
        str = str + "then \n";
        str = str + "    kcontext.cancelMatch( $i ); \n";
        str = str + "end \n";
        KieModule kieModule = KieUtil.getKieModuleFromDrls((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieBase kbase = KieBaseUtil.newKieBaseFromKieModuleWithAdditionalOptions((KieModule)kieModule, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieBaseOption[])new KieBaseOption[]{DeclarativeAgendaOption.ENABLED});
        KieSession ksession = kbase.newKieSession();
        final ArrayList cancelled = new ArrayList();
        ksession.addEventListener(new AgendaEventListener(){

            public void beforeMatchFired(BeforeMatchFiredEvent event) {
            }

            public void agendaGroupPushed(AgendaGroupPushedEvent event) {
            }

            public void agendaGroupPopped(AgendaGroupPoppedEvent event) {
            }

            public void afterMatchFired(AfterMatchFiredEvent event) {
            }

            public void matchCreated(MatchCreatedEvent event) {
            }

            public void beforeRuleFlowGroupActivated(RuleFlowGroupActivatedEvent event) {
            }

            public void afterRuleFlowGroupActivated(RuleFlowGroupActivatedEvent event) {
            }

            public void beforeRuleFlowGroupDeactivated(RuleFlowGroupDeactivatedEvent event) {
            }

            public void afterRuleFlowGroupDeactivated(RuleFlowGroupDeactivatedEvent event) {
            }

            public void matchCancelled(MatchCancelledEvent event) {
                cancelled.add(event);
            }
        });
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)"go1");
        FactHandle go2 = ksession.insert((Object)"go2");
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(0);
        Assertions.assertThat((int)cancelled.size()).isEqualTo(1);
        Assertions.assertThat((String)((MatchCancelledEvent)cancelled.get(0)).getMatch().getRule().getName()).isEqualTo("rule1");
        ksession.dispose();
    }

    @Test(timeout=10000L)
    public void testActiveInActiveChanges() {
        String str = "";
        str = str + "package org.domain.test \n";
        str = str + "import " + Match.class.getName() + "\n";
        str = str + "global java.util.List list \n";
        str = str + "dialect 'mvel' \n";
        str = str + "rule rule1 @department(sales) \n";
        str = str + "when \n";
        str = str + "     $s : String( this == 'go1' ) \n";
        str = str + "then \n";
        str = str + "    list.add( kcontext.rule.name + ':' + $s ); \n";
        str = str + "end \n";
        str = str + "rule rule2 @department(sales) \n";
        str = str + "when \n";
        str = str + "     $s : String( this == 'go1' ) \n";
        str = str + "then \n";
        str = str + "    list.add( kcontext.rule.name + ':' + $s ); \n";
        str = str + "end \n";
        str = str + "rule rule3 @department(sales) \n";
        str = str + "when \n";
        str = str + "     $s : String( this == 'go1' ) \n";
        str = str + "then \n";
        str = str + "    list.add( kcontext.rule.name + ':' + $s ); \n";
        str = str + "end \n";
        str = str + "rule countActivateInActive @activationListener('direct') \n";
        str = str + "when \n";
        str = str + "     $s : String( this == 'go2' ) \n";
        str = str + "     $active : Number( this == 1 ) from accumulate( $a : Match( department == 'sales', active == true ), count( $a ) )\n";
        str = str + "     $inActive : Number( this == 2 ) from  accumulate( $a : Match( department == 'sales', active == false ), count( $a ) )\n";
        str = str + "then \n";
        str = str + "    list.add( $active + ':' + $inActive  ); \n";
        str = str + "    kcontext.halt( ); \n";
        str = str + "end \n";
        KieModule kieModule = KieUtil.getKieModuleFromDrls((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieBase kbase = KieBaseUtil.newKieBaseFromKieModuleWithAdditionalOptions((KieModule)kieModule, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieBaseOption[])new KieBaseOption[]{DeclarativeAgendaOption.ENABLED});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)"go1");
        FactHandle go2 = ksession.insert((Object)"go2");
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(3);
        System.out.println(list);
        Assertions.assertThat((boolean)list.contains("1:2")).isTrue();
        Assertions.assertThat((boolean)list.contains("rule1:go1")).isTrue();
        Assertions.assertThat((boolean)list.contains("rule2:go1")).isTrue();
        ksession.dispose();
    }

    @Test(timeout=10000L)
    public void testCancelMultipleActivations() {
        String str = "package org.domain.test\nimport " + Match.class.getName() + "\nglobal java.util.List list\nrule sales1 @department('sales')\nwhen\n    String( this == 'fireRules' )\nthen\n    list.add(\"sales1\");\nend\n\nrule sales2 @department('sales') \nwhen\n    String( this == 'fireRules' )\nthen\n    list.add(\"sales2\");\nend\n\nrule salesCancel @activationListener('direct')\nwhen\n    $i : Match( department == 'sales' )\nthen\n    kcontext.cancelMatch($i);\nend";
        KieModule kieModule = KieUtil.getKieModuleFromDrls((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieBase kbase = KieBaseUtil.newKieBaseFromKieModuleWithAdditionalOptions((KieModule)kieModule, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieBaseOption[])new KieBaseOption[]{DeclarativeAgendaOption.ENABLED});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)"fireRules");
        ksession.fireAllRules();
        System.out.println(list);
        Assertions.assertThat((int)list.size()).isEqualTo(0);
        ksession.dispose();
    }

    @Test(timeout=10000L)
    public void testCancelActivationOnInsertAndUpdate() {
        String str = "package org.domain.test\nimport " + Match.class.getName() + "\nglobal java.util.List list\nrule sales1 @department('sales') @category('special')\nsalience 10\nwhen\n    String( this == 'fireRules' )\nthen\n    list.add(\"sales1\");\nend\n\nrule sales2 @department('sales') \nwhen\n    String( this == 'fireRules' )\nthen\n    list.add(\"sales2\");\nend\n\nrule salesCancel @activationListener('direct')\nwhen\n    String(this == 'fireCancelRule')\n    $i : Match( department == 'sales', category == 'special' )\nthen\n    kcontext.cancelMatch($i);\nend";
        KieModule kieModule = KieUtil.getKieModuleFromDrls((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieBase kbase = KieBaseUtil.newKieBaseFromKieModuleWithAdditionalOptions((KieModule)kieModule, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieBaseOption[])new KieBaseOption[]{DeclarativeAgendaOption.ENABLED});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        FactHandle fireRules = ksession.insert((Object)"fireRules");
        FactHandle fireCancelRule = ksession.insert((Object)"fireCancelRule");
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(1);
        ksession.update(fireRules, (Object)"fireRules");
        ksession.update(fireCancelRule, (Object)"fireCancelRule");
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(2);
        ksession.dispose();
    }

    @Test
    public void testFiredRuleDoNotRefireAfterUnblock() {
        String drl = "package org.drools.mvel.integrationtests\n\nimport org.kie.api.runtime.rule.Match\nimport java.util.List\n\nglobal List list\n\nrule startAgenda\nsalience 100\nwhen\n    String( this == 'startAgenda' )\nthen\n    drools.getKnowledgeRuntime().getAgenda().getAgendaGroup(\"agenda\").setFocus();\n    list.add(kcontext.getRule().getName());\nend\n\nrule sales @department('sales')\nagenda-group \"agenda\"\nwhen\n    $s : String( this == 'fireRules' )\nthen\n    list.add(kcontext.getRule().getName());\nend\n\nrule salesBlocker salience 10\nwhen\n    $s : String( this == 'fireBlockerRule' )\n    $i : Match( department == 'sales' )\nthen\n    kcontext.blockMatch( $i );\n    list.add(kcontext.getRule().getName());\nend\n";
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem();
        KieModuleModel kmodule = ks.newKieModuleModel();
        KieBaseModel baseModel = kmodule.newKieBaseModel("defaultKBase").setDefault(true).setDeclarativeAgenda(DeclarativeAgendaOption.ENABLED);
        baseModel.newKieSessionModel("defaultKSession").setDefault(true);
        kfs.writeKModuleXML(kmodule.toXML());
        kfs.write("src/main/resources/block_rule.drl", drl);
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromKieFileSystem((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieFileSystem)kfs, (boolean)false);
        Assertions.assertThat((int)kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR}).size()).isEqualTo(0);
        KieSession ksession = ks.newKieContainer(ks.getRepository().getDefaultReleaseId()).newKieSession();
        DebugList list = new DebugList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)"startAgenda");
        ksession.insert((Object)"fireRules");
        FactHandle fireBlockerRule = ksession.insert((Object)"fireBlockerRule");
        ksession.fireAllRules();
        String[] expected = new String[]{"startAgenda", "sales", "salesBlocker"};
        Assertions.assertThat((int)list.size()).isEqualTo(expected.length);
        for (int i = 0; i < list.size(); ++i) {
            Assertions.assertThat((String)((String)list.get(i))).isEqualTo(expected[i]);
        }
        ksession.delete(fireBlockerRule);
        list.clear();
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(0);
        ksession.dispose();
        list.clear();
    }

    @Test
    public void testExplicitUndercutWithDeclarativeAgenda() {
        String drl = "package org.drools.test;\n\nimport org.kie.api.runtime.rule.Match;\n\nglobal java.util.List list;\n\ndeclare Foo\n    type  : String\n    value : double\nend\n\ndeclare Bar\n    type  : String\n    total : double\nend\n\n\nrule \"Init\"\nwhen\nthen\n    insert( new Foo( \"first\", 10 ) );\n    insert( new Foo( \"first\", 11 ) );\n    insert( new Foo( \"second\", 20 ) );\n    insert( new Foo( \"second\", 22 ) );\n    insert( new Foo( \"third\", 30 ) );\n    insert( new Foo( \"third\", 40 ) );\nend\n\nrule \"Accumulate\"\nsalience 100\ndialect \"mvel\"\n  when\n    $type : String() from [ \"first\", \"second\", \"third\" ]\n    accumulate ( Foo( type == $type, $value : value ),\n                 $total : sum( $value );\n                 $total > 0 )\n  then\n    insert(new Bar($type, $total));\nend\n\nrule \"handle all Bars of type first\"\n@Undercuts( others )\n  when\n    $bar : Bar( type == 'first', $total : total )\n  then\n    System.out.println( \"First bars \" + $total );\n    list.add( $total );\nend\n\nrule \"handle all Bars of type second\"\n@Undercuts( others )\n  when\n    $bar : Bar( type == 'second', $total : total )\n  then\n    System.out.println( \"Second bars \" + $total );\n    list.add( $total );\nend\n\nrule \"others\"\n  when\n    $bar : Bar( $total : total )\n  then\n    System.out.println( \"Other bars \" + $total );\n    list.add( $total );\nend\n\n\nrule \"Undercut\"\n@Direct \nwhen\n    $m : Match( $handles : factHandles )\n    $v : Match( rule.name == $m.Undercuts, factHandles == $handles )\nthen\n    System.out.println( \"Activation of rule \" + $m.getRule().getName() + \" overrides \" + $v.getRule().getName() + \" for tuple \" + $handles );\n    kcontext.cancelMatch( $v );\nend\n\n\n";
        KieModule kieModule = KieUtil.getKieModuleFromDrls((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieBase kbase = KieBaseUtil.newKieBaseFromKieModuleWithAdditionalOptions((KieModule)kieModule, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieBaseOption[])new KieBaseOption[]{DeclarativeAgendaOption.ENABLED});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        Assertions.assertThat(list).isEqualTo(Arrays.asList(21.0, 42.0, 70.0));
        ksession.dispose();
    }

    public static class DebugList<T>
    extends ArrayList<T> {
        @Override
        public boolean add(T t) {
            return super.add(t);
        }
    }
}

