/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.common.InternalAgenda;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.impl.EnvironmentFactory;
import org.drools.core.impl.RuleBaseFactory;
import org.drools.core.marshalling.ClassObjectMarshallingStrategyAcceptor;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.mvel.compiler.Cheese;
import org.drools.mvel.compiler.FactA;
import org.drools.mvel.compiler.FactB;
import org.drools.mvel.compiler.Order;
import org.drools.mvel.compiler.OrderItem;
import org.drools.mvel.compiler.Person;
import org.drools.mvel.compiler.Precondition;
import org.drools.mvel.compiler.StockTick;
import org.drools.mvel.integrationtests.SerializationHelper;
import org.drools.serialization.protobuf.marshalling.IdentityPlaceholderResolverStrategy;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.KieBaseConfiguration;
import org.kie.api.builder.KieModule;
import org.kie.api.builder.ReleaseId;
import org.kie.api.definition.KiePackage;
import org.kie.api.event.rule.AfterMatchFiredEvent;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.event.rule.MatchCreatedEvent;
import org.kie.api.io.Resource;
import org.kie.api.marshalling.ObjectMarshallingStrategy;
import org.kie.api.marshalling.ObjectMarshallingStrategyAcceptor;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.EntryPoint;
import org.kie.api.runtime.rule.FactHandle;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=Parameterized.class)
public class DynamicRulesTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public DynamicRulesTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)false);
    }

    @Test(timeout=10000L)
    public void testDynamicRuleAdditions() throws Exception {
        InternalKnowledgeBase kbase = (InternalKnowledgeBase)KieBaseUtil.getKieBaseFromClasspathResources((String)"test", this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_Dynamic1.drl"});
        KieSession workingMemory = kbase.newKieSession();
        workingMemory.setGlobal("total", (Object)new Integer(0));
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("list", list);
        Person bob = new Person("bob", "stilton");
        bob.setStatus("Not evaluated");
        workingMemory.insert((Object)bob);
        Cheese stilton = new Cheese("stilton", 5);
        workingMemory.insert((Object)stilton);
        Cheese cheddar = new Cheese("cheddar", 5);
        workingMemory.insert((Object)cheddar);
        workingMemory.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(1);
        Assertions.assertThat(list.get(0)).isEqualTo((Object)"stilton");
        Collection kpkgs = KieBaseUtil.getKieBaseFromClasspathResources((String)"tmp", this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_Dynamic2.drl"}).getKiePackages();
        kbase.addPackages(kpkgs);
        workingMemory.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(5);
        Assertions.assertThat(list.get(0)).isEqualTo((Object)"stilton");
        Assertions.assertThat(("cheddar".equals(list.get(1)) || "cheddar".equals(list.get(2)) ? 1 : 0) != 0).isTrue();
        Assertions.assertThat(("stilton".equals(list.get(1)) || "stilton".equals(list.get(2)) ? 1 : 0) != 0).isTrue();
        list.clear();
        kpkgs = KieBaseUtil.getKieBaseFromClasspathResources((String)"tmp", this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_Dynamic3.drl"}).getKiePackages();
        kbase.addPackages(kpkgs);
        workingMemory.fireAllRules();
        ((AbstractStringAssert)Assertions.assertThat((String)bob.getStatus()).as("Rule from package 3 should have been fired", new Object[0])).isEqualTo("match Person ok");
        Assertions.assertThat((int)list.size()).isEqualTo(1);
        Assertions.assertThat(list.get(0)).isEqualTo((Object)bob);
        kpkgs = KieBaseUtil.getKieBaseFromClasspathResources((String)"tmp", this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_Dynamic4.drl"}).getKiePackages();
        kbase.addPackages(kpkgs);
        workingMemory.fireAllRules();
        ((AbstractStringAssert)Assertions.assertThat((String)bob.getStatus()).as("Rule from package 4 should have been fired", new Object[0])).isEqualTo("Who likes Stilton ok");
        Assertions.assertThat((int)list.size()).isEqualTo(2);
        Assertions.assertThat(list.get(1)).isEqualTo((Object)bob);
    }

    @Test(timeout=10000L)
    public void testDynamicRuleRemovals() throws Exception {
        InternalKnowledgeBase kbase = (InternalKnowledgeBase)KieBaseUtil.getKieBaseFromClasspathResources((String)"test", this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_Dynamic1.drl", "test_Dynamic3.drl", "test_Dynamic4.drl"});
        Collection kpkgs = KieBaseUtil.getKieBaseFromClasspathResources((String)"tmp", this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_Dynamic2.drl"}).getKiePackages();
        kbase.addPackages(kpkgs);
        KieSession wm = kbase.newKieSession();
        ArrayList list = new ArrayList();
        wm.setGlobal("list", list);
        Person bob = new Person("bob", "stilton");
        bob.setStatus("Not evaluated");
        FactHandle fh0 = wm.insert((Object)bob);
        Cheese stilton1 = new Cheese("stilton", 5);
        FactHandle fh1 = wm.insert((Object)stilton1);
        Cheese stilton2 = new Cheese("stilton", 3);
        FactHandle fh2 = wm.insert((Object)stilton2);
        Cheese stilton3 = new Cheese("stilton", 1);
        FactHandle fh3 = wm.insert((Object)stilton3);
        Cheese cheddar = new Cheese("cheddar", 5);
        FactHandle fh4 = wm.insert((Object)cheddar);
        wm.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(15);
        list.clear();
        kbase.removeRule("org.drools.mvel.compiler.test", "Who likes Stilton");
        wm.update(fh0, (Object)bob);
        wm.update(fh1, (Object)stilton1);
        wm.update(fh2, (Object)stilton2);
        wm.update(fh3, (Object)stilton3);
        wm.update(fh4, (Object)cheddar);
        wm.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(12);
        list.clear();
        kbase.removeRule("org.drools.mvel.compiler.test", "like cheese");
        wm.update(fh0, (Object)bob);
        wm.update(fh1, (Object)stilton1);
        wm.update(fh2, (Object)stilton2);
        wm.update(fh3, (Object)stilton3);
        wm.update(fh4, (Object)cheddar);
        wm.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(8);
        list.clear();
        Cheese muzzarela = new Cheese("muzzarela", 5);
        wm.insert((Object)muzzarela);
        wm.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(1);
        list.clear();
    }

    @Test(timeout=10000L)
    public void testDynamicRuleRemovalsUnusedWorkingMemory() throws Exception {
        InternalKnowledgeBase kbase = (InternalKnowledgeBase)KieBaseUtil.getKieBaseFromClasspathResources((String)"test", this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_Dynamic1.drl", "test_Dynamic2.drl", "test_Dynamic3.drl", "test_Dynamic4.drl"});
        KieSession workingMemory = kbase.newKieSession();
        Assertions.assertThat((int)kbase.getKiePackages().size()).isEqualTo(2);
        KiePackage knowledgePackage = null;
        for (KiePackage pkg : kbase.getKiePackages()) {
            if (!pkg.getName().equals("org.drools.mvel.compiler.test")) continue;
            knowledgePackage = pkg;
            break;
        }
        Assertions.assertThat((int)knowledgePackage.getRules().size()).isEqualTo(5);
        kbase.removeRule("org.drools.mvel.compiler.test", "Who likes Stilton");
        Assertions.assertThat((int)knowledgePackage.getRules().size()).isEqualTo(4);
        kbase.removeRule("org.drools.mvel.compiler.test", "like cheese");
        Assertions.assertThat((int)knowledgePackage.getRules().size()).isEqualTo(3);
        kbase.removeKiePackage("org.drools.mvel.compiler.test");
        Assertions.assertThat((int)kbase.getKiePackages().size()).isEqualTo(1);
    }

    @Ignore(value="Fails with standard-drl after changing to new API. See DROOLS-6060")
    @Test(timeout=10000L)
    public void testDynamicFunction() throws Exception {
        Collection kpkgs = KieBaseUtil.getKieBaseFromClasspathResources((String)"tmp", this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_DynamicFunction1.drl"}).getKiePackages();
        InternalKnowledgeBase kbase = (InternalKnowledgeBase)KieBaseUtil.getKieBaseFromClasspathResources((String)"test", this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[0]);
        kbase.addPackages(kpkgs);
        KieSession workingMemory = kbase.newKieSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("list", list);
        Cheese stilton = new Cheese("stilton", 5);
        workingMemory.insert((Object)stilton);
        workingMemory.fireAllRules();
        Assertions.assertThat(list.get(0)).isEqualTo((Object)new Integer(5));
        kbase.removeFunction("org.drools.mvel.compiler.test", "addFive");
        Cheese cheddar = new Cheese("cheddar", 5);
        workingMemory.insert((Object)cheddar);
        try {
            workingMemory.fireAllRules();
            Assertions.fail((String)"Function should have been removed and NoClassDefFoundError thrown from the Consequence");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Collection kpkgs2 = KieBaseUtil.getKieBaseFromClasspathResources((String)"tmp", this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_DynamicFunction2.drl"}).getKiePackages();
        kbase.addPackages(kpkgs2);
        Cheese brie = new Cheese("brie", 5);
        workingMemory.insert((Object)brie);
        workingMemory.fireAllRules();
        Assertions.assertThat(list.get(1)).isEqualTo((Object)new Integer(6));
        Collection kpkgs3 = KieBaseUtil.getKieBaseFromClasspathResources((String)"tmp", this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_DynamicFunction3.drl"}).getKiePackages();
        kbase.addPackages(kpkgs3);
        Cheese feta = new Cheese("feta", 5);
        workingMemory.insert((Object)feta);
        workingMemory.fireAllRules();
        Assertions.assertThat(list.get(2)).isEqualTo((Object)new Integer(5));
    }

    @Test(timeout=10000L)
    public void testRemovePackage() throws Exception {
        Collection kpkgs = KieBaseUtil.getKieBaseFromClasspathResources((String)"tmp", this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_RemovePackage.drl"}).getKiePackages();
        String packageName = ((KiePackage)kpkgs.iterator().next()).getName();
        InternalKnowledgeBase kbase = (InternalKnowledgeBase)KieBaseUtil.getKieBaseFromClasspathResources((String)"test", this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[0]);
        kbase.addPackages(kpkgs);
        KieSession session = kbase.newKieSession();
        session.insert((Object)new Precondition("genericcode", "genericvalue"));
        session.fireAllRules();
        InternalKnowledgeBase ruleBaseWM = (InternalKnowledgeBase)session.getKieBase();
        ruleBaseWM.removeKiePackage(packageName);
        kpkgs = KieBaseUtil.getKieBaseFromClasspathResources((String)"tmp", this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_RemovePackage.drl"}).getKiePackages();
        ruleBaseWM.addPackages(kpkgs);
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession(session, true);
        session.fireAllRules();
        ruleBaseWM.removeKiePackage(packageName);
        ruleBaseWM.addPackages(SerializationHelper.serializeObject(kpkgs));
        ruleBaseWM.removeKiePackage(packageName);
        ruleBaseWM.addPackages(SerializationHelper.serializeObject(kpkgs));
    }

    @Test(timeout=10000L)
    public void testDynamicRules() throws Exception {
        InternalKnowledgeBase kbase = (InternalKnowledgeBase)KieBaseUtil.getKieBaseFromClasspathResources((String)"test", this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[0]);
        KieSession session = kbase.newKieSession();
        Cheese a = new Cheese("stilton", 10);
        Cheese b = new Cheese("stilton", 15);
        Cheese c = new Cheese("stilton", 20);
        session.insert((Object)a);
        session.insert((Object)b);
        session.insert((Object)c);
        Collection kpkgs = KieBaseUtil.getKieBaseFromClasspathResources((String)"tmp", this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_DynamicRules.drl"}).getKiePackages();
        kbase.addPackages(kpkgs);
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession(session, true);
        session.fireAllRules();
    }

    @Test(timeout=10000L)
    public void testDynamicRules2() throws Exception {
        InternalKnowledgeBase kbase = (InternalKnowledgeBase)KieBaseUtil.getKieBaseFromClasspathResources((String)"test", this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[0]);
        KieSession session = kbase.newKieSession();
        FactA a = new FactA("hello", new Integer(1), new Float(3.14));
        FactB b = new FactB("hello", new Integer(2), new Float(6.28));
        session.insert((Object)a);
        session.insert((Object)b);
        Collection kpkgs = KieBaseUtil.getKieBaseFromClasspathResources((String)"tmp", this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_DynamicRules2.drl"}).getKiePackages();
        kbase.addPackages(kpkgs);
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession(session, true);
        session.fireAllRules();
    }

    @Test(timeout=10000L)
    public void testRuleBaseAddRemove() throws Exception {
        InternalKnowledgeBase kbase = (InternalKnowledgeBase)KieBaseUtil.getKieBaseFromClasspathResources((String)"test", this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[0]);
        Collection kpkgs = KieBaseUtil.getKieBaseFromClasspathResources((String)"tmp", this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_Dynamic1.drl"}).getKiePackages();
        String pkgName = ((KiePackage)kpkgs.iterator().next()).getName();
        kbase.addPackages(kpkgs);
        kbase.removeKiePackage(pkgName);
        kpkgs = KieBaseUtil.getKieBaseFromClasspathResources((String)"tmp", this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_Dynamic1.drl"}).getKiePackages();
        pkgName = ((KiePackage)kpkgs.iterator().next()).getName();
        kbase.addPackages(kpkgs);
        kbase.removeKiePackage(pkgName);
    }

    @Test(timeout=10000L)
    public void testClassLoaderSwitchsUsingConf() throws Exception {
        try {
            SubvertedClassLoader loader1 = new SubvertedClassLoader(new URL[]{this.getClass().getResource("/")}, this.getClass().getClassLoader());
            Class<?> cheeseClass = loader1.loadClass("org.drools.mvel.compiler.Cheese");
            InternalKnowledgeBase kbase = (InternalKnowledgeBase)KieBaseUtil.getKieBaseFromClasspathResourcesWithClassLoaderForKieBuilder((String)"test", this.getClass(), (ClassLoader)loader1, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_Dynamic1.drl"});
            KieSession wm = kbase.newKieSession();
            wm.insert(cheeseClass.newInstance());
            wm.fireAllRules();
            SubvertedClassLoader loader2 = new SubvertedClassLoader(new URL[]{this.getClass().getResource("/")}, this.getClass().getClassLoader());
            cheeseClass = loader2.loadClass("org.drools.mvel.compiler.Cheese");
            kbase = (InternalKnowledgeBase)KieBaseUtil.getKieBaseFromClasspathResourcesWithClassLoaderForKieBuilder((String)"test", this.getClass(), (ClassLoader)loader2, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_Dynamic1.drl"});
            wm = kbase.newKieSession();
            wm.insert(cheeseClass.newInstance());
            wm.fireAllRules();
        }
        catch (ClassCastException cce) {
            cce.printStackTrace();
            Assertions.fail((String)"No ClassCastException should be raised.");
        }
    }

    @Test(timeout=10000L)
    public void testClassLoaderSwitchsUsingContext() throws Exception {
        try {
            ClassLoader original = Thread.currentThread().getContextClassLoader();
            SubvertedClassLoader loader1 = new SubvertedClassLoader(new URL[]{this.getClass().getResource("/")}, this.getClass().getClassLoader());
            Thread.currentThread().setContextClassLoader(loader1);
            Class<?> cheeseClass = loader1.loadClass("org.drools.mvel.compiler.Cheese");
            KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_Dynamic1.drl"});
            KieSession wm = kbase.newKieSession();
            wm.insert(cheeseClass.newInstance());
            wm.fireAllRules();
            SubvertedClassLoader loader2 = new SubvertedClassLoader(new URL[]{this.getClass().getResource("/")}, this.getClass().getClassLoader());
            Thread.currentThread().setContextClassLoader(loader2);
            cheeseClass = loader2.loadClass("org.drools.mvel.compiler.Cheese");
            kbase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_Dynamic1.drl"});
            wm = kbase.newKieSession();
            wm.insert(cheeseClass.newInstance());
            wm.fireAllRules();
            Thread.currentThread().setContextClassLoader(original);
        }
        catch (ClassCastException cce) {
            cce.printStackTrace();
            Assertions.fail((String)"No ClassCastException should be raised.");
        }
    }

    @Test(timeout=10000L)
    public void testCollectDynamicRules() throws Exception {
        this.checkCollectWithDynamicRules("test_CollectDynamicRules1.drl");
    }

    @Test(timeout=10000L)
    public void testCollectDynamicRulesWithExistingOTN() throws Exception {
        this.checkCollectWithDynamicRules("test_CollectDynamicRules1a.drl");
    }

    private void checkCollectWithDynamicRules(String originalDrl) throws IOException, ClassNotFoundException {
        InternalKnowledgeBase kbase = (InternalKnowledgeBase)KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{originalDrl});
        KieSession session = kbase.newKieSession();
        ArrayList list = new ArrayList();
        session.setGlobal("results", list);
        session.insert((Object)new Cheese("stilton", 10));
        session.insert((Object)new Cheese("brie", 10));
        session.insert((Object)new Cheese("stilton", 10));
        session.insert((Object)new Cheese("muzzarela", 10));
        Collection kpkgs = KieBaseUtil.getKieBaseFromClasspathResources((String)"tmp", this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_CollectDynamicRules2.drl"}).getKiePackages();
        kbase.addPackages(kpkgs);
        session.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(1);
        Assertions.assertThat((int)((List)list.get(0)).size()).isEqualTo(2);
    }

    @Test(timeout=10000L)
    public void testDynamicNotNode() throws Exception {
        InternalKnowledgeBase kbase = (InternalKnowledgeBase)KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_CollectDynamicRules1.drl"});
        Environment env = EnvironmentFactory.newEnvironment();
        env.set("org.kie.api.marshalling.ObjectMarshallingStrategies", (Object)new ObjectMarshallingStrategy[]{new IdentityPlaceholderResolverStrategy((ObjectMarshallingStrategyAcceptor)ClassObjectMarshallingStrategyAcceptor.DEFAULT)});
        KieSession ksession = kbase.newKieSession(null, env);
        List results = new ArrayList();
        ksession.setGlobal("results", results);
        Cheese a = new Cheese("stilton", 10);
        Cheese b = new Cheese("stilton", 15);
        Cheese c = new Cheese("stilton", 20);
        ksession.insert((Object)a);
        ksession.insert((Object)b);
        ksession.insert((Object)c);
        Collection kpkgs = KieBaseUtil.getKieBaseFromClasspathResources((String)"tmp", this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_DynamicNotNode.drl"}).getKiePackages();
        kbase.addPackages(kpkgs);
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, false);
        results = (List)ksession.getGlobal("results");
        ksession.fireAllRules();
        Assertions.assertThat((int)results.size()).isEqualTo(0);
        kbase.removeKiePackage("org.drools.mvel.compiler");
        ksession.retract(ksession.getFactHandle((Object)b));
        kpkgs = KieBaseUtil.getKieBaseFromClasspathResources((String)"tmp", this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_DynamicNotNode.drl"}).getKiePackages();
        kbase.addPackages(kpkgs);
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, false);
        results = (List)ksession.getGlobal("results");
        ksession.fireAllRules();
        Assertions.assertThat((int)results.size()).isEqualTo(1);
    }

    @Test(timeout=10000L)
    public void testDynamicRulesAddRemove() {
        try {
            InternalKnowledgeBase kbase = (InternalKnowledgeBase)KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_DynamicRulesTom.drl"});
            KieSession session = kbase.newKieSession();
            ArrayList results = new ArrayList();
            session.setGlobal("results", results);
            InternalFactHandle h1 = (InternalFactHandle)session.insert((Object)new Person("tom", 1));
            InternalFactHandle h2 = (InternalFactHandle)session.insert((Object)new Person("fred", 2));
            InternalFactHandle h3 = (InternalFactHandle)session.insert((Object)new Person("harry", 3));
            InternalFactHandle h4 = (InternalFactHandle)session.insert((Object)new Person("fred", 4));
            InternalFactHandle h5 = (InternalFactHandle)session.insert((Object)new Person("ed", 5));
            InternalFactHandle h6 = (InternalFactHandle)session.insert((Object)new Person("tom", 6));
            InternalFactHandle h7 = (InternalFactHandle)session.insert((Object)new Person("sreeni", 7));
            InternalFactHandle h8 = (InternalFactHandle)session.insert((Object)new Person("jill", 8));
            InternalFactHandle h9 = (InternalFactHandle)session.insert((Object)new Person("ed", 9));
            InternalFactHandle h10 = (InternalFactHandle)session.insert((Object)new Person("tom", 10));
            session.fireAllRules();
            Assertions.assertThat((int)results.size()).isEqualTo(3);
            Assertions.assertThat((boolean)results.contains(h1.getObject())).isTrue();
            Assertions.assertThat((boolean)results.contains(h6.getObject())).isTrue();
            Assertions.assertThat((boolean)results.contains(h10.getObject())).isTrue();
            results.clear();
            Collection kpkgs = KieBaseUtil.getKieBaseFromClasspathResources((String)"tmp", this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_DynamicRulesFred.drl"}).getKiePackages();
            kbase.addPackages(kpkgs);
            session.fireAllRules();
            Assertions.assertThat((int)results.size()).isEqualTo(2);
            Assertions.assertThat((boolean)results.contains(h2.getObject())).isTrue();
            Assertions.assertThat((boolean)results.contains(h4.getObject())).isTrue();
            results.clear();
            kbase.removeKiePackage("tom");
            kpkgs = KieBaseUtil.getKieBaseFromClasspathResources((String)"tmp", this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_DynamicRulesEd.drl"}).getKiePackages();
            kbase.addPackages(kpkgs);
            session.fireAllRules();
            Assertions.assertThat((int)results.size()).isEqualTo(2);
            Assertions.assertThat((boolean)results.contains(h5.getObject())).isTrue();
            Assertions.assertThat((boolean)results.contains(h9.getObject())).isTrue();
            results.clear();
            ((Person)h3.getObject()).setName("ed");
            session.update((FactHandle)h3, h3.getObject());
            session.fireAllRules();
            Assertions.assertThat((int)results.size()).isEqualTo(1);
            Assertions.assertThat((boolean)results.contains(h3.getObject())).isTrue();
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((String)("Should not raise any exception: " + e.getMessage()));
        }
    }

    @Test(timeout=10000L)
    public void testDynamicRuleRemovalsSubNetwork() throws Exception {
        Collection kpkgs = KieBaseUtil.getKieBaseFromClasspathResources((String)"tmp", this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_DynamicRulesWithSubnetwork1.drl", "test_DynamicRulesWithSubnetwork.drl"}).getKiePackages();
        InternalKnowledgeBase kbase = (InternalKnowledgeBase)KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[0]);
        kbase.addPackages(kpkgs);
        kpkgs = KieBaseUtil.getKieBaseFromClasspathResources((String)"tmp", this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_DynamicRulesWithSubnetwork2.drl"}).getKiePackages();
        kbase.addPackages(kpkgs);
        KieSession session = kbase.newKieSession();
        ArrayList list = new ArrayList();
        session.setGlobal("results", list);
        Order order = new Order();
        OrderItem item1 = new OrderItem(order, 1, "Adventure Guide Brazil", 1, 24);
        order.addItem(item1);
        FactHandle item1Fh = session.insert((Object)item1);
        OrderItem item2 = new OrderItem(order, 2, "Prehistoric Britain", 1, 15);
        order.addItem(item2);
        FactHandle item2Fh = session.insert((Object)item2);
        OrderItem item3 = new OrderItem(order, 3, "Holiday Music", 2, 9);
        order.addItem(item3);
        FactHandle item3Fh = session.insert((Object)item3);
        OrderItem item4 = new OrderItem(order, 4, "Very Best of Mick Jagger", 2, 11);
        order.addItem(item4);
        FactHandle item4Fh = session.insert((Object)item4);
        session.insert((Object)order);
        session.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(11);
        kbase.removeRule("org.drools.mvel.compiler", "Apply Discount on all books");
        list.clear();
        session.update(item1Fh, (Object)item1);
        session.update(item2Fh, (Object)item2);
        session.update(item3Fh, (Object)item3);
        session.update(item4Fh, (Object)item4);
        session.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(10);
        kbase.removeRule("org.drools.mvel.compiler", "like book");
        list.clear();
        session.update(item1Fh, (Object)item1);
        session.update(item2Fh, (Object)item2);
        session.update(item3Fh, (Object)item3);
        session.update(item4Fh, (Object)item4);
        session.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(8);
        OrderItem item5 = new OrderItem(order, 5, "Sinatra : Vegas", 2, 5);
        FactHandle item5Fh = session.insert((Object)item5);
        session.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(10);
        kbase.removeKiePackage("org.drools.mvel.compiler");
        list.clear();
        session.update(item1Fh, (Object)item1);
        session.update(item2Fh, (Object)item2);
        session.update(item3Fh, (Object)item3);
        session.update(item4Fh, (Object)item4);
        session.update(item5Fh, (Object)item5);
        session.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(0);
    }

    @Test(timeout=10000L)
    public void testDynamicRuleRemovalsUnusedWorkingMemorySubNetwork() throws Exception {
        InternalKnowledgeBase kbase = (InternalKnowledgeBase)KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_DynamicRulesWithSubnetwork1.drl", "test_DynamicRulesWithSubnetwork2.drl", "test_DynamicRulesWithSubnetwork.drl"});
        Assertions.assertThat((int)kbase.getKiePackages().size()).isEqualTo(2);
        Assertions.assertThat((int)((InternalKnowledgePackage)kbase.getPackagesMap().get("org.drools.mvel.compiler")).getRules().size()).isEqualTo(4);
        kbase.removeRule("org.drools.mvel.compiler", "Apply Discount on all books");
        Assertions.assertThat((int)((InternalKnowledgePackage)kbase.getPackagesMap().get("org.drools.mvel.compiler")).getRules().size()).isEqualTo(3);
        kbase.removeRule("org.drools.mvel.compiler", "like book");
        Assertions.assertThat((int)((InternalKnowledgePackage)kbase.getPackagesMap().get("org.drools.mvel.compiler")).getRules().size()).isEqualTo(2);
        kbase.removeKiePackage("org.drools.mvel.compiler");
        Assertions.assertThat((int)kbase.getKiePackages().size()).isEqualTo(1);
    }

    @Test(timeout=10000L)
    public void testRemovePackageSubNetwork() throws Exception {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_DynamicRulesWithSubnetwork.drl"});
        String packageName = ((KiePackage)kbase.getKiePackages().iterator().next()).getName();
        KieSession workingMemory = kbase.newKieSession();
        List results = new ArrayList();
        workingMemory.setGlobal("results", results);
        Order order = new Order();
        OrderItem item1 = new OrderItem(order, 1, "Adventure Guide Brazil", 1, 24);
        OrderItem item2 = new OrderItem(order, 2, "Prehistoric Britain", 1, 15);
        OrderItem item3 = new OrderItem(order, 3, "Holiday Music", 2, 9);
        OrderItem item4 = new OrderItem(order, 4, "Very Best of Mick Jagger", 2, 11);
        OrderItem item5 = new OrderItem(order, 5, "The Master and Margarita", 1, 29);
        order.addItem(item1);
        order.addItem(item2);
        order.addItem(item3);
        order.addItem(item4);
        order.addItem(item5);
        workingMemory.insert((Object)order);
        workingMemory.fireAllRules();
        Assertions.assertThat((int)results.size()).isEqualTo(1);
        Assertions.assertThat((int)((List)results.get(0)).size()).isEqualTo(3);
        results.clear();
        InternalKnowledgeBase ruleBaseWM = (InternalKnowledgeBase)workingMemory.getKieBase();
        ruleBaseWM.removeKiePackage(packageName);
        Collection kpkgs = KieBaseUtil.getKieBaseFromClasspathResources((String)"tmp", this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_DynamicRulesWithSubnetwork.drl"}).getKiePackages();
        ruleBaseWM.addPackages(kpkgs);
        workingMemory.fireAllRules();
        results = (List)workingMemory.getGlobal("results");
        Assertions.assertThat((int)results.size()).isEqualTo(1);
        Assertions.assertThat((int)((List)results.get(0)).size()).isEqualTo(3);
        results.clear();
        ruleBaseWM.removeKiePackage(packageName);
        ruleBaseWM.addPackages(kpkgs);
        workingMemory.fireAllRules();
        Assertions.assertThat((int)results.size()).isEqualTo(1);
        Assertions.assertThat((int)((List)results.get(0)).size()).isEqualTo(3);
        results.clear();
        ruleBaseWM.removeKiePackage(packageName);
        ruleBaseWM.addPackages(kpkgs);
        workingMemory.fireAllRules();
        Assertions.assertThat((int)results.size()).isEqualTo(1);
        Assertions.assertThat((int)((List)results.get(0)).size()).isEqualTo(3);
        results.clear();
    }

    @Test(timeout=10000L)
    public void testRuleBaseAddRemoveSubNetworks() throws Exception {
        try {
            InternalKnowledgeBase kbase = (InternalKnowledgeBase)KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[0]);
            Collection kpkgs = KieBaseUtil.getKieBaseFromClasspathResources((String)"tmp", this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_DynamicRulesWithSubnetwork.drl"}).getKiePackages();
            KiePackage kpkg = (KiePackage)kpkgs.toArray()[0];
            kbase.addPackages(kpkgs);
            kbase.removeKiePackage(kpkg.getName());
            kpkgs = KieBaseUtil.getKieBaseFromClasspathResources((String)"tmp", this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_DynamicRulesWithSubnetwork.drl"}).getKiePackages();
            kpkg = (KiePackage)kpkgs.toArray()[0];
            kbase.addPackages(kpkgs);
            kbase.removeKiePackage(kpkg.getName());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((String)"Should not raise any exception");
        }
    }

    @Test(timeout=10000L)
    public void testDynamicRuleAdditionsWithEntryPoints() throws Exception {
        InternalKnowledgeBase kbase = (InternalKnowledgeBase)KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[0]);
        Collection kpkgs = KieBaseUtil.getKieBaseFromClasspathResources((String)"tmp", this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_DynamicWithEntryPoint.drl"}).getKiePackages();
        KieSession ksession = kbase.newKieSession();
        kbase.addPackages(kpkgs);
        ArrayList results = new ArrayList();
        ksession.setGlobal("results", results);
        EntryPoint ep = ksession.getEntryPoint("in-channel");
        ep.insert((Object)new StockTick(1L, "RHT", 20.0, 10000L));
        ep.insert((Object)new StockTick(2L, "RHT", 21.0, 15000L));
        ep.insert((Object)new StockTick(3L, "RHT", 22.0, 20000L));
        ksession.fireAllRules();
        Assertions.assertThat((int)results.size()).isEqualTo(3);
    }

    @Test(timeout=10000L)
    public void testIsolatedClassLoaderWithEnumsPkgBuilder() throws Exception {
        try {
            SubvertedClassLoader loader1 = new SubvertedClassLoader(new URL[]{this.getClass().getResource("/testEnum.jar")}, this.getClass().getClassLoader());
            loader1.loadClass("org.drools.Primitives");
            loader1.loadClass("org.drools.TestEnum");
            Collection kpkgs = KieBaseUtil.getKieBaseFromClasspathResourcesWithClassLoaderForKieBuilder((String)"test", this.getClass(), (ClassLoader)loader1, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_EnumSerialization.drl"}).getKiePackages();
            KieBaseConfiguration kbaseConf = RuleBaseFactory.newKnowledgeBaseConfiguration(null, (ClassLoader[])new ClassLoader[]{loader1});
            KieModule kieModule = KieUtil.getKieModuleFromResourcesWithClassLoaderForKieBuilder((String)"test", (ClassLoader)loader1, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (Resource[])new Resource[0]);
            InternalKnowledgeBase kbase = (InternalKnowledgeBase)KieBaseUtil.newKieBaseFromReleaseId((ReleaseId)kieModule.getReleaseId(), (KieBaseConfiguration)kbaseConf);
            kbase.addPackages(kpkgs);
            KieSession ksession = kbase.newKieSession();
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(1);
            Assertions.assertThat((int)list.size()).isEqualTo(1);
            SubvertedClassLoader loader2 = new SubvertedClassLoader(new URL[]{this.getClass().getResource("/testEnum.jar")}, this.getClass().getClassLoader());
            loader2.loadClass("org.drools.Primitives");
            loader2.loadClass("org.drools.TestEnum");
            KieBaseConfiguration kbaseConf2 = RuleBaseFactory.newKnowledgeBaseConfiguration(null, (ClassLoader[])new ClassLoader[]{loader2});
            KieModule kieModule2 = KieUtil.getKieModuleFromResourcesWithClassLoaderForKieBuilder((String)"test2", (ClassLoader)loader2, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (Resource[])new Resource[0]);
            InternalKnowledgeBase kbase2 = (InternalKnowledgeBase)KieBaseUtil.newKieBaseFromReleaseId((ReleaseId)kieModule2.getReleaseId(), (KieBaseConfiguration)kbaseConf2);
            kbase2.addPackages(kpkgs);
            ksession = kbase2.newKieSession();
            list = new ArrayList();
            ksession.setGlobal("list", list);
            Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(1);
            Assertions.assertThat((int)list.size()).isEqualTo(1);
        }
        catch (ClassCastException cce) {
            cce.printStackTrace();
            Assertions.fail((String)"No ClassCastException should be raised.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testIsolatedClassLoaderWithEnumsContextClassloader() throws Exception {
        try {
            SubvertedClassLoader loader1 = new SubvertedClassLoader(new URL[]{this.getClass().getResource("/testEnum.jar")}, this.getClass().getClassLoader());
            loader1.loadClass("org.drools.Primitives");
            loader1.loadClass("org.drools.TestEnum");
            ClassLoader ccl = Thread.currentThread().getContextClassLoader();
            Collection kpkgs = null;
            try {
                Thread.currentThread().setContextClassLoader(loader1);
                kpkgs = KieBaseUtil.getKieBaseFromClasspathResources((String)"tmp", this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_EnumSerialization.drl"}).getKiePackages();
                InternalKnowledgeBase kbase = (InternalKnowledgeBase)KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[0]);
                kbase.addPackages(kpkgs);
                KieSession ksession = kbase.newKieSession();
                ArrayList list = new ArrayList();
                ksession.setGlobal("list", list);
                Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(1);
                Assertions.assertThat((int)list.size()).isEqualTo(1);
            }
            finally {
                Thread.currentThread().setContextClassLoader(ccl);
            }
            SubvertedClassLoader loader2 = new SubvertedClassLoader(new URL[]{this.getClass().getResource("/testEnum.jar")}, this.getClass().getClassLoader());
            loader2.loadClass("org.drools.Primitives");
            loader2.loadClass("org.drools.TestEnum");
            ccl = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(loader2);
                InternalKnowledgeBase kbase2 = (InternalKnowledgeBase)KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test2", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[0]);
                kbase2.addPackages(kpkgs);
                KieSession ksession = kbase2.newKieSession();
                ArrayList list = new ArrayList();
                ksession.setGlobal("list", list);
                Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(1);
                Assertions.assertThat((int)list.size()).isEqualTo(1);
            }
            finally {
                Thread.currentThread().setContextClassLoader(ccl);
            }
        }
        catch (ClassCastException cce) {
            cce.printStackTrace();
            Assertions.fail((String)"No ClassCastException should be raised.");
        }
    }

    @Test(timeout=10000L)
    public void testDynamicRuleRemovalsSubNetworkAndNot() throws Exception {
        InternalKnowledgeBase kbase = (InternalKnowledgeBase)KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_DynamicRulesWithNotSubnetwork.drl"});
        KieSession ksession = kbase.newKieSession();
        AgendaEventListener alistener = (AgendaEventListener)Mockito.mock(AgendaEventListener.class);
        ksession.addEventListener(alistener);
        ksession.insert((Object)new Person("toni"));
        ksession.fireAllRules();
        ((AgendaEventListener)Mockito.verify((Object)alistener, (VerificationMode)Mockito.never())).matchCreated((MatchCreatedEvent)ArgumentMatchers.any(MatchCreatedEvent.class));
        ksession.insert((Object)new Person("bob"));
        ksession.fireAllRules();
        ((AgendaEventListener)Mockito.verify((Object)alistener, (VerificationMode)Mockito.times((int)1))).matchCreated((MatchCreatedEvent)ArgumentMatchers.any(MatchCreatedEvent.class));
        ksession.insert((Object)new Person("mark"));
        ksession.fireAllRules();
        ((AgendaEventListener)Mockito.verify((Object)alistener, (VerificationMode)Mockito.times((int)1))).matchCreated((MatchCreatedEvent)ArgumentMatchers.any(MatchCreatedEvent.class));
        kbase.removeKiePackage("org.drools.mvel.compiler");
        Assertions.assertThat((int)kbase.getKiePackages().size()).isEqualTo(0);
        Collection kpkgs = KieBaseUtil.getKieBaseFromClasspathResources((String)"tmp", this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_DynamicRulesWithNotSubnetwork.drl"}).getKiePackages();
        kbase.addPackages(kpkgs);
        ksession.fireAllRules();
        ((AgendaEventListener)Mockito.verify((Object)alistener, (VerificationMode)Mockito.times((int)2))).matchCreated((MatchCreatedEvent)ArgumentMatchers.any(MatchCreatedEvent.class));
    }

    @Test(timeout=10000L)
    public void testSharedLIANodeRemoval() throws Exception {
        String str = "global java.util.List list;\n";
        str = str + "rule \"test\"\n";
        str = str + "when\n";
        str = str + "  exists(eval(true))\n";
        str = str + "then\n";
        str = str + " list.add(\"fired\");\n";
        str = str + "end\n";
        InternalKnowledgeBase kbase = (InternalKnowledgeBase)KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[0]);
        Collection kpkgs = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"tmp", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str}).getKiePackages();
        kbase.addPackages(kpkgs);
        ArrayList list = new ArrayList();
        KieSession session = kbase.newKieSession();
        session.setGlobal("list", list);
        session.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(1);
        list.clear();
        KiePackage kpkg = (KiePackage)kpkgs.toArray()[0];
        kbase.removeKiePackage(kpkg.getName());
        kbase.addPackages(kpkgs);
        session = kbase.newKieSession();
        session.setGlobal("list", list);
        session.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(1);
    }

    @Test(timeout=10000L)
    public void testDynamicRulesWithTypeDeclarations() {
        String type = "package com.sample\ndeclare type Foo\n  id : int\nend\n";
        String r1 = "package com.sample\nrule R1 when\n  not Foo()\nthen\n  insert( new Foo(1) );\nend\n";
        String r2 = "package com.sample\nrule R2 when\n  $f : Foo()\nthen\n  $f.setId( 2 );\nend\n";
        InternalKnowledgeBase kbase = (InternalKnowledgeBase)KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[0]);
        Collection kpkgs = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"tmp", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{type}).getKiePackages();
        kbase.addPackages(kpkgs);
        KieSession ksession = kbase.newKieSession();
        AgendaEventListener ael = (AgendaEventListener)Mockito.mock(AgendaEventListener.class);
        ksession.addEventListener(ael);
        ksession.fireAllRules();
        ((AgendaEventListener)Mockito.verify((Object)ael, (VerificationMode)Mockito.never())).afterMatchFired((AfterMatchFiredEvent)ArgumentMatchers.any(AfterMatchFiredEvent.class));
        kpkgs = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"tmp", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{type, r1}).getKiePackages();
        kbase.addPackages(kpkgs);
        ksession.fireAllRules();
        ArgumentCaptor capt = ArgumentCaptor.forClass(AfterMatchFiredEvent.class);
        ((AgendaEventListener)Mockito.verify((Object)ael, (VerificationMode)Mockito.times((int)1))).afterMatchFired((AfterMatchFiredEvent)capt.capture());
        Assertions.assertThat((String)((AfterMatchFiredEvent)capt.getValue()).getMatch().getRule().getName()).isEqualTo("R1");
        kpkgs = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"tmp", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{type, r2}).getKiePackages();
        kbase.addPackages(kpkgs);
        ksession.fireAllRules();
        ((AgendaEventListener)Mockito.verify((Object)ael, (VerificationMode)Mockito.times((int)2))).afterMatchFired((AfterMatchFiredEvent)capt.capture());
        Assertions.assertThat((String)((AfterMatchFiredEvent)capt.getAllValues().get(2)).getMatch().getRule().getName()).isEqualTo("R2");
        ksession.dispose();
    }

    @Test(timeout=10000L)
    public void testJBRULES_2206() {
        KieBaseConfiguration config = RuleBaseFactory.newKnowledgeBaseConfiguration();
        ((RuleBaseConfiguration)config).setRuleBaseUpdateHandler(null);
        KieModule kieModule = KieUtil.getKieModuleFromResources((ReleaseId)KieUtil.generateReleaseId((String)"test"), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (Resource[])new Resource[0]);
        InternalKnowledgeBase kbase = (InternalKnowledgeBase)KieBaseUtil.newKieBaseFromReleaseId((ReleaseId)kieModule.getReleaseId(), (KieBaseConfiguration)config);
        KieSession session = kbase.newKieSession();
        AgendaEventListener ael = (AgendaEventListener)Mockito.mock(AgendaEventListener.class);
        session.addEventListener(ael);
        for (int i = 0; i < 5; ++i) {
            session.insert((Object)new Cheese());
        }
        Collection kpkgs = KieBaseUtil.getKieBaseFromClasspathResources((String)"tmp", this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_JBRULES_2206_1.drl"}).getKiePackages();
        kbase.addPackages(kpkgs);
        ((InternalAgenda)session.getAgenda()).evaluateEagerList();
        ((AgendaEventListener)Mockito.verify((Object)ael, (VerificationMode)Mockito.times((int)2))).matchCreated((MatchCreatedEvent)ArgumentMatchers.any(MatchCreatedEvent.class));
        int fireCount = session.fireAllRules();
        Assertions.assertThat((int)fireCount).isEqualTo(2);
        kpkgs = KieBaseUtil.getKieBaseFromClasspathResources((String)"tmp", this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_JBRULES_2206_2.drl"}).getKiePackages();
        kbase.addPackages(kpkgs);
        ((InternalAgenda)session.getAgenda()).evaluateEagerList();
        ((AgendaEventListener)Mockito.verify((Object)ael, (VerificationMode)Mockito.times((int)3))).matchCreated((MatchCreatedEvent)ArgumentMatchers.any(MatchCreatedEvent.class));
        fireCount = session.fireAllRules();
        Assertions.assertThat((int)fireCount).isEqualTo(1);
        session.dispose();
    }

    @Test
    public void testSegmentMerging() {
        String drl1 = "global java.util.List list\nrule R1 when\n  $s : String()\n  $i : Integer( this == $s.length() )\n  $j : Integer( this == $i * 2 )\nthen\n  list.add( $j );\nend\n";
        String drl2 = "global java.util.List list\nrule R2 when\n  $s : String()\n  $i : Integer( this == $s.length() )\n  $j : Integer( this == $i * 3 )\nthen\n  list.add( $j );\nend\n";
        InternalKnowledgeBase kbase = (InternalKnowledgeBase)KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[0]);
        Collection kpkgs = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"tmp", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl1}).getKiePackages();
        kbase.addPackages(kpkgs);
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)"test");
        ksession.insert((Object)4);
        ksession.insert((Object)8);
        ksession.insert((Object)12);
        ksession.fireAllRules();
        Assertions.assertThat((int)((Integer)list.get(0))).isEqualTo(8);
        list.clear();
        kpkgs = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"tmp", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl2}).getKiePackages();
        kbase.addPackages(kpkgs);
        kbase.removeRule("defaultpkg", "R1");
        ksession.fireAllRules();
        Assertions.assertThat((int)((Integer)list.get(0))).isEqualTo(12);
    }

    public class SubvertedClassLoader
    extends URLClassLoader {
        private static final long serialVersionUID = 510L;

        public SubvertedClassLoader(URL[] urls, ClassLoader parentClassLoader) {
            super(urls, parentClassLoader);
        }

        protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
            Class<?> c = this.findLoadedClass(name);
            if (c == null) {
                try {
                    c = this.findClass(name);
                }
                catch (ClassNotFoundException e) {
                    c = super.loadClass(name, resolve);
                }
            }
            return c;
        }
    }
}

