/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.util.ArrayList;
import java.util.Collection;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.drools.mvel.compiler.Cheese;
import org.drools.mvel.compiler.Person;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.EntryPoint;
import org.kie.api.runtime.rule.FactHandle;

@RunWith(value=Parameterized.class)
public class FireUntilHaltTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public FireUntilHaltTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    @Test
    public void testSubmitOnFireUntilHalt() throws InterruptedException {
        String drl = "import " + Person.class.getCanonicalName() + "\nglobal java.util.List list;rule R when\n    Person( happy, age >= 18 )\nthen\n    list.add(\"happy adult\");end";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession kSession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        kSession.setGlobal("list", list);
        new Thread(() -> ((KieSession)kSession).fireUntilHalt()).start();
        Person p = new Person("me", 17, true);
        FactHandle fh = kSession.insert((Object)p);
        Thread.sleep(100L);
        Assertions.assertThat((int)list.size()).isEqualTo(0);
        kSession.submit(kieSession -> {
            p.setAge(18);
            p.setHappy(false);
            kieSession.update(fh, (Object)p);
        });
        Thread.sleep(100L);
        Assertions.assertThat((int)list.size()).isEqualTo(0);
        kSession.submit(kieSession -> {
            p.setHappy(true);
            kieSession.update(fh, (Object)p);
        });
        Thread.sleep(100L);
        Assertions.assertThat((int)list.size()).isEqualTo(1);
        kSession.halt();
        kSession.dispose();
    }

    @Test
    public void testFireAllWhenFiringUntilHalt() throws InterruptedException {
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[0]);
        KieSession ksession = kbase.newKieSession();
        Thread t1 = new Thread(() -> ((KieSession)ksession).fireUntilHalt());
        Thread t2 = new Thread(() -> ((KieSession)ksession).fireAllRules());
        t1.start();
        Thread.sleep(500L);
        t2.start();
        Thread.sleep(1000L);
        boolean aliveT2 = t2.isAlive();
        ksession.halt();
        Thread.sleep(1000L);
        boolean aliveT1 = t1.isAlive();
        if (t2.isAlive()) {
            t2.interrupt();
        }
        if (t1.isAlive()) {
            t1.interrupt();
        }
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)aliveT2).as("T2 should have finished", new Object[0])).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)aliveT1).as("T1 should have finished", new Object[0])).isFalse();
    }

    @Test
    public void testFireUntilHaltFailingAcrossEntryPoints() throws Exception {
        String rule1 = "package org.drools.mvel.compiler\n";
        rule1 = rule1 + "global java.util.List list\n";
        rule1 = rule1 + "rule testFireUntilHalt\n";
        rule1 = rule1 + "when\n";
        rule1 = rule1 + "       Cheese()\n";
        rule1 = rule1 + "  $p : Person() from entry-point \"testep2\"\n";
        rule1 = rule1 + "then \n";
        rule1 = rule1 + "  list.add( $p ) ;\n";
        rule1 = rule1 + "end\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{rule1});
        KieSession ksession = kbase.newKieSession();
        EntryPoint ep = ksession.getEntryPoint("testep2");
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)new Cheese("cheddar"));
        ksession.fireAllRules();
        Thread t1 = new Thread(() -> ((KieSession)ksession).fireUntilHalt());
        t1.start();
        Thread.sleep(500L);
        ep.insert((Object)new Person("darth"));
        Thread.sleep(500L);
        ksession.halt();
        t1.join(5000L);
        boolean alive = t1.isAlive();
        if (alive) {
            t1.interrupt();
        }
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)alive).as("Thread should have died!", new Object[0])).isFalse();
        Assertions.assertThat((int)list.size()).isEqualTo(1);
    }
}

