/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.assertj.core.api.Assertions;
import org.drools.core.rule.MapBackedClassLoader;
import org.drools.mvel.compiler.Bar;
import org.drools.mvel.compiler.Cheese;
import org.drools.mvel.compiler.FactA;
import org.drools.mvel.compiler.FactB;
import org.drools.mvel.compiler.Foo;
import org.drools.mvel.compiler.Message;
import org.drools.mvel.compiler.Person;
import org.drools.mvel.compiler.Primitives;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.Message;
import org.kie.api.event.rule.AfterMatchFiredEvent;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderConfiguration;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.io.ResourceFactory;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mvel2.MVEL;

@RunWith(value=Parameterized.class)
public class JBRULESTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public JBRULESTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    @Test
    public void testJBRules2055() {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_JBRules2055.drl"});
        KieSession ksession = kbase.newKieSession();
        ArrayList results = new ArrayList();
        ksession.setGlobal("results", results);
        ksession.insert((Object)new Cheese("stilton"));
        ksession.insert((Object)new Cheese("brie"));
        ksession.insert((Object)new Cheese("muzzarella"));
        ksession.insert((Object)new Person("bob", "stilton"));
        ksession.fireAllRules();
        Assertions.assertThat((int)results.size()).isEqualTo(2);
        Assertions.assertThat((String)((String)results.get(0))).isEqualTo("stilton");
        Assertions.assertThat((String)((String)results.get(1))).isEqualTo("brie");
    }

    @Test
    public void testJBRules2369() {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_JBRules2369.drl"});
        KieSession ksession = kbase.newKieSession();
        ArrayList results = new ArrayList();
        ksession.setGlobal("results", results);
        FactA a = new FactA();
        FactB b = new FactB(0);
        FactHandle aHandle = ksession.insert((Object)a);
        FactHandle bHandle = ksession.insert((Object)b);
        ksession.fireAllRules();
        Assertions.assertThat((int)results.size()).isEqualTo(1);
        ksession.update(aHandle, (Object)a);
        ksession.fireAllRules();
        Assertions.assertThat((int)results.size()).isEqualTo(2);
    }

    @Test
    public void testJBRules2140() {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_JBRules2140.drl"});
        KieSession ksession = kbase.newKieSession();
        ArrayList results = new ArrayList();
        ksession.setGlobal("results", results);
        ksession.fireAllRules();
        Assertions.assertThat((int)results.size()).isEqualTo(2);
        Assertions.assertThat((boolean)results.contains("java")).isTrue();
        Assertions.assertThat((boolean)results.contains("mvel")).isTrue();
    }

    @Test
    public void testJBRULES_2995() {
        String str = "package org.drools.mvel.compiler\nrule r1\nwhen\n    Primitives( classAttr == java.lang.String.class, \n                eval(classAttr.equals( java.lang.String.class ) ),\n                classAttr == String.class )\nthen\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.drools.mvel.compiler\nrule r1\nwhen\n    Primitives( classAttr == java.lang.String.class, \n                eval(classAttr.equals( java.lang.String.class ) ),\n                classAttr == String.class )\nthen\nend\n"});
        KieSession ksession = kbase.newKieSession();
        Primitives primitives = new Primitives();
        primitives.setClassAttr(String.class);
        ksession.insert((Object)primitives);
        int rules = ksession.fireAllRules();
        Assertions.assertThat((int)rules).isEqualTo(1);
    }

    @Test
    public void testJBRULES2872() {
        String str = "package org.drools.mvel.compiler.test\nimport org.drools.mvel.compiler.FactA\nrule X\nwhen\n    FactA( enumVal == TestEnum.ONE || == TestEnum.TWO )\nthen\nend\n";
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{"package org.drools.mvel.compiler.test\nimport org.drools.mvel.compiler.FactA\nrule X\nwhen\n    FactA( enumVal == TestEnum.ONE || == TestEnum.TWO )\nthen\nend\n"});
        List errors = kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR});
        Assertions.assertThat((int)errors.size()).isEqualTo(1);
        org.kie.api.builder.Message error = (org.kie.api.builder.Message)errors.get(0);
        Assertions.assertThat((int)error.getLine()).isEqualTo(5);
    }

    @Test
    public void testJBRULES3030() {
        String str = "package org.drools.mvel.compiler\nrule X\nwhen\n    $gp : GrandParent()    $ch : ChildHolder( child == $gp )\nthen\nend\n";
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{"package org.drools.mvel.compiler\nrule X\nwhen\n    $gp : GrandParent()    $ch : ChildHolder( child == $gp )\nthen\nend\n"});
        List errors = kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR});
        Assertions.assertThat((!errors.isEmpty() ? 1 : 0) != 0).isFalse();
    }

    @Test
    public void testJBRULES3111() {
        String str = "package org.drools.compiler\ndeclare Bool123\n    bool1 : boolean\n    bool2 : boolean\n    bool3 : boolean\nend\ndeclare Thing\n    name : String\n    bool123 : Bool123\nend\nrule kickOff\nwhen\nthen\n    insert( new Thing( \"one\", new Bool123( true, false, false ) ) );\n    insert( new Thing( \"two\", new Bool123( false, false, false ) ) );\n    insert( new Thing( \"three\", new Bool123( false, false, false ) ) );\nend\nrule r1\nwhen\n    $t: Thing( bool123.bool1 == true )\nthen\nend\nrule r2\nwhen\n    $t: Thing( bool123.bool2 == true )\nthen\nend\nrule r3\nwhen\n    $t: Thing( bool123.bool3 == true )\nthen\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.drools.compiler\ndeclare Bool123\n    bool1 : boolean\n    bool2 : boolean\n    bool3 : boolean\nend\ndeclare Thing\n    name : String\n    bool123 : Bool123\nend\nrule kickOff\nwhen\nthen\n    insert( new Thing( \"one\", new Bool123( true, false, false ) ) );\n    insert( new Thing( \"two\", new Bool123( false, false, false ) ) );\n    insert( new Thing( \"three\", new Bool123( false, false, false ) ) );\nend\nrule r1\nwhen\n    $t: Thing( bool123.bool1 == true )\nthen\nend\nrule r2\nwhen\n    $t: Thing( bool123.bool2 == true )\nthen\nend\nrule r3\nwhen\n    $t: Thing( bool123.bool3 == true )\nthen\nend"});
        KieSession ksession = kbase.newKieSession();
        AgendaEventListener ael = (AgendaEventListener)Mockito.mock(AgendaEventListener.class);
        ksession.addEventListener(ael);
        int rulesFired = ksession.fireAllRules();
        Assertions.assertThat((int)rulesFired).isEqualTo(2);
        ArgumentCaptor captor = ArgumentCaptor.forClass(AfterMatchFiredEvent.class);
        ((AgendaEventListener)Mockito.verify((Object)ael, (VerificationMode)Mockito.times((int)2))).afterMatchFired((AfterMatchFiredEvent)captor.capture());
        List aafe = captor.getAllValues();
        Assertions.assertThat((String)((AfterMatchFiredEvent)aafe.get(0)).getMatch().getRule().getName()).isEqualTo("kickOff");
        Assertions.assertThat((String)((AfterMatchFiredEvent)aafe.get(1)).getMatch().getRule().getName()).isEqualTo("r1");
        Object value = ((AfterMatchFiredEvent)aafe.get(1)).getMatch().getDeclarationValue("$t");
        String name = (String)MVEL.eval((String)"$t.name", Collections.singletonMap("$t", value));
        Assertions.assertThat((String)name).isEqualTo("one");
    }

    @Test
    public void testJBRULES3323() throws Exception {
        StringBuilder rule = new StringBuilder();
        rule.append("package de.orbitx.accumulatetesettest;\n");
        rule.append("import java.util.Set;\n");
        rule.append("import java.util.HashSet;\n");
        rule.append("import org.drools.mvel.compiler.Foo;\n");
        rule.append("import org.drools.mvel.compiler.Bar;\n");
        rule.append("rule \"Sub optimal foo parallelism - this rule is causing NPE upon reverse\"\n");
        rule.append("when\n");
        rule.append("$foo : Foo($leftId : id, $leftBar : bar != null)\n");
        rule.append("$fooSet : Set()\n");
        rule.append("from accumulate ( Foo(id > $leftId, bar != null && != $leftBar, $bar : bar),\n");
        rule.append("collectSet( $bar ) )\n");
        rule.append("then\n");
        rule.append("//System.out.println(\"ok\");\n");
        rule.append("end\n");
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{rule.toString()});
        KieSession ksession = kbase.newKieSession();
        Bar[] barList = new Bar[3];
        for (int i = 0; i < barList.length; ++i) {
            barList[i] = new Bar(String.valueOf(i));
        }
        Foo[] fooList = new Foo[4];
        for (int i = 0; i < fooList.length; ++i) {
            fooList[i] = new Foo(String.valueOf(i), i == 3 ? barList[2] : barList[i]);
        }
        for (Foo foo : fooList) {
            ksession.insert((Object)foo);
        }
        int[] magicFoos = new int[]{3, 3, 1, 1, 0, 0, 2, 2, 1, 1, 0, 0, 3, 3, 2, 2, 3, 1, 1};
        int[] magicBars = new int[]{1, 2, 0, 1, 1, 0, 1, 2, 2, 1, 2, 0, 0, 2, 0, 2, 0, 0, 1};
        for (int i = 0; i < magicFoos.length; ++i) {
            Foo tehFoo = fooList[magicFoos[i]];
            FactHandle fooFactHandle = ksession.getFactHandle((Object)tehFoo);
            tehFoo.setBar(barList[magicBars[i]]);
            ksession.update(fooFactHandle, (Object)tehFoo);
            int fired = ksession.fireAllRules();
            Assertions.assertThat((fired > 0 ? 1 : 0) != 0).isTrue();
        }
        ksession.dispose();
    }

    @Test
    public void testJBRULES3326() throws Exception {
        StringBuilder rule = new StringBuilder();
        rule.append("package org.drools.mvel.compiler\n");
        rule.append("rule X\n");
        rule.append("when\n");
        rule.append("    Message(!!!false)\n");
        rule.append("then\n");
        rule.append("end\n");
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{rule.toString()});
        KieSession ksession = kbase.newKieSession();
        ksession.insert((Object)new Message("test"));
        int rules = ksession.fireAllRules();
        Assertions.assertThat((int)rules).isEqualTo(1);
        ksession.dispose();
    }

    @Test
    public void testGUVNOR578_2() throws Exception {
        MapBackedClassLoader loader = new MapBackedClassLoader(this.getClass().getClassLoader());
        JarInputStream jis = new JarInputStream(this.getClass().getResourceAsStream("/primespoc.jar"));
        JarEntry entry = null;
        byte[] buf = new byte[1024];
        int len = 0;
        while ((entry = jis.getNextJarEntry()) != null) {
            if (entry.isDirectory()) continue;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            while ((len = jis.read(buf)) >= 0) {
                out.write(buf, 0, len);
            }
            loader.addResource(entry.getName(), out.toByteArray());
        }
        ArrayList<JarInputStream> jarInputStreams = new ArrayList<JarInputStream>();
        jarInputStreams.add(jis);
        KnowledgeBuilderConfiguration conf = KnowledgeBuilderFactory.newKnowledgeBuilderConfiguration(null, (ClassLoader)loader);
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder((KnowledgeBuilderConfiguration)conf);
        String header = "import fr.gouv.agriculture.dag.agorha.business.primes.SousPeriodePrimeAgent\n";
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])"import fr.gouv.agriculture.dag.agorha.business.primes.SousPeriodePrimeAgent\n".getBytes()), ResourceType.DRL);
        Assertions.assertThat((boolean)kbuilder.hasErrors()).isFalse();
        String passingRule = "rule \"rule1\"\ndialect \"mvel\"\nwhen\nSousPeriodePrimeAgent( echelle == \"abc\" )then\nend\n";
        String failingRule = "rule \"rule2\"\ndialect \"mvel\"\nwhen\nSousPeriodePrimeAgent( quotiteRemuneration == 123 , echelle == \"abc\" )then\nend\n";
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])"rule \"rule1\"\ndialect \"mvel\"\nwhen\nSousPeriodePrimeAgent( echelle == \"abc\" )then\nend\n".getBytes()), ResourceType.DRL);
        Assertions.assertThat((boolean)kbuilder.hasErrors()).isFalse();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])"rule \"rule2\"\ndialect \"mvel\"\nwhen\nSousPeriodePrimeAgent( quotiteRemuneration == 123 , echelle == \"abc\" )then\nend\n".getBytes()), ResourceType.DRL);
        Assertions.assertThat((boolean)kbuilder.hasErrors()).isFalse();
    }
}

