/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.util.ArrayList;
import java.util.Collection;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.mvel.compiler.Cheese;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.definition.KiePackage;
import org.kie.api.definition.rule.Rule;
import org.kie.api.runtime.KieSession;

@RunWith(value=Parameterized.class)
public class MergePackageTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public MergePackageTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    @Test
    public void testMergingDifferentPackages2() throws Exception {
        try {
            Collection kpkgs1 = KieBaseUtil.getKieBaseFromClasspathResources((String)"tmp", this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_RuleNameClashes1.drl"}).getKiePackages();
            KiePackage kpkg1 = kpkgs1.stream().filter(pkg -> pkg.getName().equals("org.drools.package1")).findFirst().get();
            Assertions.assertThat((int)kpkg1.getRules().size()).isEqualTo(1);
            Collection kpkgs2 = KieBaseUtil.getKieBaseFromClasspathResources((String)"tmp", this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_RuleNameClashes2.drl"}).getKiePackages();
            KiePackage kpkg2 = kpkgs2.stream().filter(pkg -> pkg.getName().equals("org.drools.package2")).findFirst().get();
            Assertions.assertThat((int)kpkg2.getRules().size()).isEqualTo(1);
            InternalKnowledgeBase kbase = (InternalKnowledgeBase)KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[0]);
            kbase.addPackages(kpkgs1);
            kbase.addPackages(kpkgs2);
            KieSession ksession = kbase.newKieSession();
            ArrayList results = new ArrayList();
            ksession.setGlobal("results", results);
            ksession.insert((Object)new Cheese("stilton", 10));
            ksession.insert((Object)new Cheese("brie", 5));
            ksession.fireAllRules();
            ((AbstractIntegerAssert)Assertions.assertThat((int)results.size()).as(((Object)results).toString(), new Object[0])).isEqualTo(2);
            Assertions.assertThat((boolean)results.contains("p1.r1")).isTrue();
            Assertions.assertThat((boolean)results.contains("p2.r1")).isTrue();
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((String)("unexpected exception: " + e.getMessage()));
        }
    }

    @Test
    public void testMergePackageWithSameRuleNames() throws Exception {
        InternalKnowledgeBase kbase = (InternalKnowledgeBase)KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_MergePackageWithSameRuleNames1.drl"});
        Collection kpkgs = KieBaseUtil.getKieBaseFromClasspathResources((String)"tmp", this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_MergePackageWithSameRuleNames2.drl"}).getKiePackages();
        kbase.addPackages(kpkgs);
        KieSession ksession = kbase.newKieSession();
        ArrayList results = new ArrayList();
        ksession.setGlobal("results", results);
        ksession.fireAllRules();
        Assertions.assertThat((int)results.size()).isEqualTo(1);
        Assertions.assertThat(results.get(0)).isEqualTo((Object)"rule1 for the package2");
    }

    @Test
    public void testMergingDifferentPackages() throws Exception {
        try {
            Collection kpkgs = KieBaseUtil.getKieBaseFromClasspathResources((String)"tmp", this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_RuleNameClashes1.drl", "test_RuleNameClashes2.drl"}).getKiePackages();
            Assertions.assertThat((int)kpkgs.size()).isEqualTo(3);
            for (KiePackage kpkg : kpkgs) {
                if (!kpkg.getName().equals("org.drools.package1")) continue;
                Assertions.assertThat((String)((Rule)kpkg.getRules().iterator().next()).getName()).isEqualTo("rule 1");
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            Assertions.fail((String)("unexpected exception: " + e.getMessage()));
        }
    }
}

