/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.Policy;
import java.util.ArrayList;
import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.mvel.CommonTestMethodBase;
import org.drools.mvel.integrationtests.SerializationHelper;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.definition.KiePackage;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;

public class SerializationSecurityPolicyTest
extends CommonTestMethodBase {
    @Before
    public void init() {
        String policy = SerializationSecurityPolicyTest.class.getResource("serialization-rules.policy").getFile();
        System.setProperty("java.security.policy", policy);
        System.setProperty("kie.security.policy", policy);
        Policy.getPolicy().refresh();
        System.setSecurityManager(new SecurityManager());
    }

    @After
    public void close() {
        System.setSecurityManager(null);
        System.clearProperty("java.security.policy");
        System.clearProperty("kie.security.policy");
    }

    @Test
    public void testSerialization() throws IOException, ClassNotFoundException {
        String rule = " rule R  when  then      System.out.println(\"consequence!\");  end";
        KieServices kieServices = KieServices.get();
        Resource drlResource = kieServices.getResources().newByteArrayResource(" rule R  when  then      System.out.println(\"consequence!\");  end".getBytes(StandardCharsets.UTF_8.name()), StandardCharsets.UTF_8.name());
        drlResource.setResourceType(ResourceType.DRL);
        drlResource.setTargetPath("test.drl");
        KieFileSystem kieFileSystem = kieServices.newKieFileSystem();
        kieFileSystem.write(drlResource);
        KieBuilder kieBuilder = kieServices.newKieBuilder(kieFileSystem);
        kieBuilder.buildAll();
        KieBase kieBase = kieServices.newKieContainer(kieBuilder.getKieModule().getReleaseId()).getKieBase();
        Collection kpkgs = kieBase.getKiePackages();
        ArrayList<KiePackage> newCollection = new ArrayList<KiePackage>();
        for (KiePackage kpkg : kpkgs) {
            kpkg = SerializationHelper.serializeObject(kpkg);
            newCollection.add(kpkg);
        }
        ((InternalKnowledgeBase)kieBase).addPackages(newCollection);
        KieSession kieSession = kieBase.newKieSession();
        Assertions.assertThat((int)kieSession.fireAllRules()).isEqualTo(1);
    }
}

