/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.util.ArrayList;
import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.drools.mvel.compiler.Cheesery;
import org.drools.mvel.compiler.Child;
import org.drools.mvel.compiler.MockPersistentSet;
import org.drools.mvel.compiler.ObjectWithSet;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;

@RunWith(value=Parameterized.class)
public class ShadowProxyTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public ShadowProxyTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    @Test
    public void testShadowProxyInHierarchies() throws Exception {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_ShadowProxyInHierarchies.drl"});
        KieSession ksession = kbase.newKieSession();
        try {
            ksession.insert((Object)new Child("gp"));
            ksession.fireAllRules();
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testShadowProxyOnCollections() throws Exception {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_ShadowProxyOnCollections.drl"});
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList results = new ArrayList();
            ksession.setGlobal("results", results);
            Cheesery cheesery = new Cheesery();
            ksession.insert((Object)cheesery);
            ksession.fireAllRules();
            Assertions.assertThat((int)results.size()).isEqualTo(1);
            Assertions.assertThat((int)cheesery.getCheeses().size()).isEqualTo(1);
            Assertions.assertThat((Object)cheesery.getCheeses().get(0)).isEqualTo(results.get(0));
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testShadowProxyOnCollections2() throws Exception {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_ShadowProxyOnCollections2.drl"});
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList results = new ArrayList();
            ksession.setGlobal("results", results);
            ArrayList<String> list = new ArrayList<String>();
            list.add("example1");
            list.add("example2");
            MockPersistentSet mockPersistentSet = new MockPersistentSet(false);
            mockPersistentSet.addAll(list);
            ObjectWithSet objectWithSet = new ObjectWithSet();
            objectWithSet.setSet(mockPersistentSet);
            ksession.insert((Object)objectWithSet);
            ksession.fireAllRules();
            Assertions.assertThat((int)results.size()).isEqualTo(1);
            Assertions.assertThat((String)objectWithSet.getMessage()).isEqualTo("show");
        }
        finally {
            ksession.dispose();
        }
    }
}

