/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests.phreak;

import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.PhreakPropagationContext;
import org.drools.core.common.PropagationContext;
import org.drools.core.common.TupleSets;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.SegmentMemory;
import org.drools.core.reteoo.Tuple;
import org.drools.mvel.integrationtests.phreak.RightBuilder;
import org.drools.mvel.integrationtests.phreak.Scenario;
import org.drools.mvel.integrationtests.phreak.StagedBuilder;

public class LeftBuilder {
    private InternalWorkingMemory wm;
    private LeftTupleSink sink;
    private TupleSets<LeftTuple> leftTuples;
    private Scenario scenario;

    public LeftBuilder(Scenario scenario) {
        this.scenario = scenario;
        this.wm = scenario.getWorkingMemory();
        this.sink = scenario.getBetaNode();
        this.leftTuples = scenario.getLeftTuples();
    }

    public LeftBuilder insert(Object ... objects) {
        for (Object object : objects) {
            InternalFactHandle fh = (InternalFactHandle)this.wm.insert(object);
            LeftTuple leftTuple = this.sink.createLeftTuple(fh, true);
            leftTuple.setPropagationContext((PropagationContext)new PhreakPropagationContext());
            this.leftTuples.addInsert((Tuple)leftTuple);
        }
        return this;
    }

    public LeftBuilder update(Object ... objects) {
        for (Object object : objects) {
            InternalFactHandle fh = this.wm.getFactHandle(object);
            LeftTuple leftTuple = fh.getFirstLeftTuple();
            leftTuple.setPropagationContext((PropagationContext)new PhreakPropagationContext());
            this.leftTuples.addUpdate((Tuple)leftTuple);
        }
        return this;
    }

    public LeftBuilder delete(Object ... objects) {
        for (Object object : objects) {
            InternalFactHandle fh = this.wm.getFactHandle(object);
            LeftTuple leftTuple = fh.getFirstLeftTuple();
            leftTuple.setPropagationContext((PropagationContext)new PhreakPropagationContext());
            this.leftTuples.addDelete((Tuple)leftTuple);
        }
        return this;
    }

    TupleSets<LeftTuple> get() {
        return this.leftTuples;
    }

    public RightBuilder right() {
        return new RightBuilder(this.scenario);
    }

    public StagedBuilder result() {
        StagedBuilder stagedBuilder = new StagedBuilder(this.scenario, null);
        this.scenario.setExpectedResultBuilder(stagedBuilder);
        return stagedBuilder;
    }

    public StagedBuilder preStaged(SegmentMemory sm) {
        StagedBuilder stagedBuilder = new StagedBuilder(this.scenario, sm);
        this.scenario.addPreStagedBuilder(stagedBuilder);
        return stagedBuilder;
    }

    public StagedBuilder postStaged(SegmentMemory sm) {
        StagedBuilder stagedBuilder = new StagedBuilder(this.scenario, sm);
        this.scenario.addPostStagedBuilder(stagedBuilder);
        return stagedBuilder;
    }

    public Scenario run() {
        return this.scenario.run();
    }
}

