/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.util;

import java.lang.reflect.Field;
import java.util.ArrayList;
import org.assertj.core.api.Assertions;
import org.drools.core.base.ClassFieldAccessorCache;
import org.drools.core.base.ClassObjectType;
import org.drools.core.base.ObjectType;
import org.drools.core.common.DefaultFactHandle;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.reteoo.LeftTupleImpl;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.reteoo.RightTupleImpl;
import org.drools.core.reteoo.Tuple;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.Pattern;
import org.drools.core.rule.accessor.ReadAccessor;
import org.drools.core.rule.accessor.TupleValueExtractor;
import org.drools.core.test.model.Cheese;
import org.drools.core.util.AbstractHashTable;
import org.drools.core.util.Entry;
import org.drools.core.util.index.TupleIndexHashTable;
import org.drools.core.util.index.TupleList;
import org.drools.mvel.accessors.ClassFieldAccessorStore;
import org.drools.mvel.accessors.ClassFieldReader;
import org.junit.Before;
import org.junit.Test;

public class RightTupleIndexHashTableTest {
    ClassFieldAccessorStore store = new ClassFieldAccessorStore();

    @Before
    public void setUp() throws Exception {
        this.store.setClassFieldAccessorCache(new ClassFieldAccessorCache(Thread.currentThread().getContextClassLoader()));
        this.store.setEagerWire(true);
    }

    @Test
    public void testSingleEntry() throws Exception {
        ClassFieldReader extractor = this.store.getReader(Cheese.class, "type");
        Pattern pattern = new Pattern(0, (ObjectType)new ClassObjectType(Cheese.class));
        Declaration declaration = new Declaration("typeOfCheese", (ReadAccessor)extractor, pattern);
        AbstractHashTable.FieldIndex fieldIndex = new AbstractHashTable.FieldIndex((ReadAccessor)extractor, (TupleValueExtractor)declaration);
        TupleIndexHashTable map = new TupleIndexHashTable(new AbstractHashTable.FieldIndex[]{fieldIndex}, false);
        Cheese cheddar = new Cheese("cheddar", 10);
        DefaultFactHandle cheddarHandle1 = new DefaultFactHandle(0L, (Object)cheddar);
        Assertions.assertThat((int)map.size()).isEqualTo(0);
        Assertions.assertThat((Object)map.getFirst((Tuple)new LeftTupleImpl((InternalFactHandle)cheddarHandle1, null, true))).isNull();
        Cheese stilton1 = new Cheese("stilton", 35);
        RightTupleImpl stiltonRighTuple = new RightTupleImpl((InternalFactHandle)new DefaultFactHandle(1L, (Object)stilton1), null);
        map.add((Tuple)stiltonRighTuple);
        Assertions.assertThat((int)map.size()).isEqualTo(1);
        Assertions.assertThat((int)this.tablePopulationSize((AbstractHashTable)map)).isEqualTo(1);
        Cheese stilton2 = new Cheese("stilton", 80);
        DefaultFactHandle stiltonHandle2 = new DefaultFactHandle(2L, (Object)stilton2);
        Tuple tuple = map.getFirst((Tuple)new LeftTupleImpl((InternalFactHandle)stiltonHandle2, null, true));
        Assertions.assertThat((Object)tuple.getFactHandle()).isSameAs((Object)stiltonRighTuple.getFactHandle());
        Assertions.assertThat((Object)((Tuple)tuple.getNext())).isNull();
    }

    @Test
    public void testTwoDifferentEntries() throws Exception {
        ClassFieldReader extractor = this.store.getReader(Cheese.class, "type");
        Pattern pattern = new Pattern(0, (ObjectType)new ClassObjectType(Cheese.class));
        Declaration declaration = new Declaration("typeOfCheese", (ReadAccessor)extractor, pattern);
        AbstractHashTable.FieldIndex fieldIndex = new AbstractHashTable.FieldIndex((ReadAccessor)extractor, (TupleValueExtractor)declaration);
        TupleIndexHashTable map = new TupleIndexHashTable(new AbstractHashTable.FieldIndex[]{fieldIndex}, false);
        Assertions.assertThat((int)map.size()).isEqualTo(0);
        Cheese stilton1 = new Cheese("stilton", 35);
        DefaultFactHandle stiltonHandle1 = new DefaultFactHandle(1L, (Object)stilton1);
        map.add((Tuple)new RightTupleImpl((InternalFactHandle)stiltonHandle1, null));
        Cheese cheddar1 = new Cheese("cheddar", 35);
        DefaultFactHandle cheddarHandle1 = new DefaultFactHandle(2L, (Object)cheddar1);
        map.add((Tuple)new RightTupleImpl((InternalFactHandle)cheddarHandle1, null));
        Assertions.assertThat((int)map.size()).isEqualTo(2);
        Assertions.assertThat((int)this.tablePopulationSize((AbstractHashTable)map)).isEqualTo(2);
        Cheese stilton2 = new Cheese("stilton", 77);
        DefaultFactHandle stiltonHandle2 = new DefaultFactHandle(2L, (Object)stilton2);
        Tuple tuple = map.getFirst((Tuple)new LeftTupleImpl((InternalFactHandle)stiltonHandle2, null, true));
        Assertions.assertThat((Object)tuple.getFactHandle()).isSameAs((Object)stiltonHandle1);
        Assertions.assertThat((Object)((Tuple)tuple.getNext())).isNull();
        Cheese cheddar2 = new Cheese("cheddar", 5);
        DefaultFactHandle cheddarHandle2 = new DefaultFactHandle(2L, (Object)cheddar2);
        tuple = map.getFirst((Tuple)new LeftTupleImpl((InternalFactHandle)cheddarHandle2, null, true));
        Assertions.assertThat((Object)tuple.getFactHandle()).isSameAs((Object)cheddarHandle1);
        Assertions.assertThat((Object)((Tuple)tuple.getNext())).isNull();
    }

    @Test
    public void testTwoEqualEntries() throws Exception {
        ClassFieldReader extractor = this.store.getReader(Cheese.class, "type");
        Pattern pattern = new Pattern(0, (ObjectType)new ClassObjectType(Cheese.class));
        Declaration declaration = new Declaration("typeOfCheese", (ReadAccessor)extractor, pattern);
        AbstractHashTable.FieldIndex fieldIndex = new AbstractHashTable.FieldIndex((ReadAccessor)extractor, (TupleValueExtractor)declaration);
        TupleIndexHashTable map = new TupleIndexHashTable(new AbstractHashTable.FieldIndex[]{fieldIndex}, false);
        Assertions.assertThat((int)map.size()).isEqualTo(0);
        Cheese stilton1 = new Cheese("stilton", 35);
        DefaultFactHandle stiltonHandle1 = new DefaultFactHandle(1L, (Object)stilton1);
        map.add((Tuple)new RightTupleImpl((InternalFactHandle)stiltonHandle1, null));
        Cheese cheddar1 = new Cheese("cheddar", 35);
        DefaultFactHandle cheddarHandle1 = new DefaultFactHandle(2L, (Object)cheddar1);
        map.add((Tuple)new RightTupleImpl((InternalFactHandle)cheddarHandle1, null));
        Cheese stilton2 = new Cheese("stilton", 81);
        DefaultFactHandle stiltonHandle2 = new DefaultFactHandle(3L, (Object)stilton2);
        map.add((Tuple)new RightTupleImpl((InternalFactHandle)stiltonHandle2, null));
        Assertions.assertThat((int)map.size()).isEqualTo(3);
        Assertions.assertThat((int)this.tablePopulationSize((AbstractHashTable)map)).isEqualTo(2);
        Cheese stilton3 = new Cheese("stilton", 89);
        DefaultFactHandle stiltonHandle3 = new DefaultFactHandle(4L, (Object)stilton2);
        Tuple tuple = map.getFirst((Tuple)new LeftTupleImpl((InternalFactHandle)stiltonHandle3, null, true));
        Assertions.assertThat((Object)tuple.getFactHandle()).isSameAs((Object)stiltonHandle1);
        Assertions.assertThat((Object)((RightTuple)tuple.getNext()).getFactHandle()).isSameAs((Object)stiltonHandle2);
    }

    @Test
    public void testTwoDifferentEntriesSameHashCode() throws Exception {
        ClassFieldReader extractor = this.store.getReader(TestClass.class, "object");
        Pattern pattern = new Pattern(0, (ObjectType)new ClassObjectType(TestClass.class));
        Declaration declaration = new Declaration("theObject", (ReadAccessor)extractor, pattern);
        AbstractHashTable.FieldIndex fieldIndex = new AbstractHashTable.FieldIndex((ReadAccessor)extractor, (TupleValueExtractor)declaration);
        TupleIndexHashTable map = new TupleIndexHashTable(new AbstractHashTable.FieldIndex[]{fieldIndex}, false);
        TestClass c1 = new TestClass(0, new TestClass(20, "stilton"));
        DefaultFactHandle ch1 = new DefaultFactHandle(1L, (Object)c1);
        map.add((Tuple)new RightTupleImpl((InternalFactHandle)ch1, null));
        TestClass c2 = new TestClass(0, new TestClass(20, "cheddar"));
        DefaultFactHandle ch2 = new DefaultFactHandle(2L, (Object)c2);
        map.add((Tuple)new RightTupleImpl((InternalFactHandle)ch2, null));
        Assertions.assertThat((int)map.size()).isEqualTo(2);
        Assertions.assertThat((int)this.tablePopulationSize((AbstractHashTable)map)).isEqualTo(1);
        Entry[] entries = this.getEntries((AbstractHashTable)map);
        Assertions.assertThat((int)entries.length).isEqualTo(1);
        TupleList list = (TupleList)entries[0];
        Assertions.assertThat((Object)list.getFirst().getFactHandle()).isSameAs((Object)ch2);
        Assertions.assertThat((Object)((Tuple)list.getFirst().getNext())).isNull();
        Assertions.assertThat((Object)list.getNext().getFirst().getFactHandle()).isSameAs((Object)ch1);
        Assertions.assertThat((Object)((Tuple)list.getNext().getFirst().getNext())).isNull();
        Assertions.assertThat((Object)list.getNext().getNext()).isNull();
    }

    @Test
    public void testRemove() throws Exception {
        ClassFieldReader extractor = this.store.getReader(Cheese.class, "type");
        Pattern pattern = new Pattern(0, (ObjectType)new ClassObjectType(Cheese.class));
        Declaration declaration = new Declaration("typeOfCheese", (ReadAccessor)extractor, pattern);
        AbstractHashTable.FieldIndex fieldIndex = new AbstractHashTable.FieldIndex((ReadAccessor)extractor, (TupleValueExtractor)declaration);
        TupleIndexHashTable map = new TupleIndexHashTable(new AbstractHashTable.FieldIndex[]{fieldIndex}, false);
        Assertions.assertThat((int)map.size()).isEqualTo(0);
        Cheese stilton1 = new Cheese("stilton", 35);
        DefaultFactHandle stiltonHandle1 = new DefaultFactHandle(1L, (Object)stilton1);
        RightTupleImpl stiltonRightTuple1 = new RightTupleImpl((InternalFactHandle)stiltonHandle1, null);
        map.add((Tuple)stiltonRightTuple1);
        Cheese cheddar1 = new Cheese("cheddar", 35);
        DefaultFactHandle cheddarHandle1 = new DefaultFactHandle(2L, (Object)cheddar1);
        RightTupleImpl cheddarRightTuple1 = new RightTupleImpl((InternalFactHandle)cheddarHandle1, null);
        map.add((Tuple)cheddarRightTuple1);
        Cheese stilton2 = new Cheese("stilton", 81);
        DefaultFactHandle stiltonHandle2 = new DefaultFactHandle(3L, (Object)stilton2);
        RightTupleImpl stiltonRightTuple2 = new RightTupleImpl((InternalFactHandle)stiltonHandle2, null);
        map.add((Tuple)stiltonRightTuple2);
        Assertions.assertThat((int)map.size()).isEqualTo(3);
        Assertions.assertThat((int)this.tablePopulationSize((AbstractHashTable)map)).isEqualTo(2);
        map.remove((Tuple)cheddarRightTuple1);
        Assertions.assertThat((int)map.size()).isEqualTo(2);
        Assertions.assertThat((int)this.tablePopulationSize((AbstractHashTable)map)).isEqualTo(1);
        map.remove((Tuple)stiltonRightTuple2);
        Assertions.assertThat((int)map.size()).isEqualTo(1);
        Assertions.assertThat((int)this.tablePopulationSize((AbstractHashTable)map)).isEqualTo(1);
        map.remove((Tuple)stiltonRightTuple1);
        Assertions.assertThat((int)map.size()).isEqualTo(0);
        Assertions.assertThat((int)this.tablePopulationSize((AbstractHashTable)map)).isEqualTo(0);
    }

    @Test
    public void testResize() throws Exception {
        ClassFieldReader extractor = this.store.getReader(Cheese.class, "type");
        Pattern pattern = new Pattern(0, (ObjectType)new ClassObjectType(Cheese.class));
        Declaration declaration = new Declaration("typeOfCheese", (ReadAccessor)extractor, pattern);
        AbstractHashTable.FieldIndex fieldIndex = new AbstractHashTable.FieldIndex((ReadAccessor)extractor, (TupleValueExtractor)declaration);
        TupleIndexHashTable map = new TupleIndexHashTable(16, 0.75f, new AbstractHashTable.FieldIndex[]{fieldIndex}, false);
        Assertions.assertThat((int)map.size()).isEqualTo(0);
        Cheese stilton1 = new Cheese("stilton", 35);
        map.add((Tuple)this.newRightTuple(1, stilton1));
        Cheese stilton2 = new Cheese("stilton", 81);
        map.add((Tuple)this.newRightTuple(2, stilton2));
        Cheese cheddar1 = new Cheese("cheddar", 35);
        map.add((Tuple)this.newRightTuple(3, cheddar1));
        Cheese cheddar2 = new Cheese("cheddar", 38);
        map.add((Tuple)this.newRightTuple(4, cheddar2));
        Cheese brie = new Cheese("brie", 293);
        map.add((Tuple)this.newRightTuple(5, brie));
        Cheese mozerella = new Cheese("mozerella", 15);
        map.add((Tuple)this.newRightTuple(6, mozerella));
        Cheese dolcelatte = new Cheese("dolcelatte", 284);
        map.add((Tuple)this.newRightTuple(7, dolcelatte));
        Cheese camembert1 = new Cheese("camembert", 924);
        map.add((Tuple)this.newRightTuple(8, camembert1));
        Cheese camembert2 = new Cheese("camembert", 765);
        map.add((Tuple)this.newRightTuple(9, camembert2));
        Cheese redLeicestor = new Cheese("red leicestor", 23);
        map.add((Tuple)this.newRightTuple(10, redLeicestor));
        Cheese wensleydale = new Cheese("wensleydale", 20);
        map.add((Tuple)this.newRightTuple(11, wensleydale));
        Cheese edam = new Cheese("edam", 12);
        map.add((Tuple)this.newRightTuple(12, edam));
        Cheese goude1 = new Cheese("goude", 93);
        map.add((Tuple)this.newRightTuple(13, goude1));
        Cheese goude2 = new Cheese("goude", 88);
        map.add((Tuple)this.newRightTuple(14, goude2));
        Cheese gruyere = new Cheese("gruyere", 82);
        map.add((Tuple)this.newRightTuple(15, gruyere));
        Cheese emmental = new Cheese("emmental", 98);
        map.add((Tuple)this.newRightTuple(16, emmental));
        Assertions.assertThat((int)map.size()).isEqualTo(16);
        Entry[] table = map.getTable();
        Assertions.assertThat((int)table.length).isEqualTo(16);
        Cheese feta = new Cheese("feta", 48);
        map.add((Tuple)this.newRightTuple(2, feta));
        Assertions.assertThat((int)map.size()).isEqualTo(17);
        table = map.getTable();
        Assertions.assertThat((int)table.length).isEqualTo(32);
        Cheese haloumi = new Cheese("haloumi", 48);
        map.add((Tuple)this.newRightTuple(2, haloumi));
        Cheese chevre = new Cheese("chevre", 48);
        map.add((Tuple)this.newRightTuple(2, chevre));
    }

    private RightTuple newRightTuple(int id, Object object) {
        return new RightTupleImpl((InternalFactHandle)new DefaultFactHandle((long)id, object), null);
    }

    private int tablePopulationSize(AbstractHashTable map) throws Exception {
        Field field = AbstractHashTable.class.getDeclaredField("table");
        field.setAccessible(true);
        Entry[] array = (Entry[])field.get(map);
        int size = 0;
        int length = array.length;
        for (int i = 0; i < length; ++i) {
            if (array[i] == null) continue;
            ++size;
        }
        return size;
    }

    private Entry[] getEntries(AbstractHashTable map) throws Exception {
        Field field = AbstractHashTable.class.getDeclaredField("table");
        field.setAccessible(true);
        ArrayList<Entry> list = new ArrayList<Entry>();
        Entry[] array = (Entry[])field.get(map);
        int length = array.length;
        for (int i = 0; i < length; ++i) {
            if (array[i] == null) continue;
            list.add(array[i]);
        }
        return list.toArray(new Entry[list.size()]);
    }

    @Test
    public void testEmptyIterator() {
        ClassFieldReader extractor = this.store.getReader(Cheese.class, "type");
        Pattern pattern = new Pattern(0, (ObjectType)new ClassObjectType(Cheese.class));
        Declaration declaration = new Declaration("typeOfCheese", (ReadAccessor)extractor, pattern);
        AbstractHashTable.FieldIndex fieldIndex = new AbstractHashTable.FieldIndex((ReadAccessor)extractor, (TupleValueExtractor)declaration);
        TupleIndexHashTable map = new TupleIndexHashTable(new AbstractHashTable.FieldIndex[]{fieldIndex}, false);
        Cheese stilton = new Cheese("stilton", 55);
        DefaultFactHandle stiltonHandle = new DefaultFactHandle(2L, (Object)stilton);
        Assertions.assertThat((Object)map.getFirst((Tuple)new LeftTupleImpl((InternalFactHandle)stiltonHandle, null, true))).isNull();
    }

    public static class TestClass {
        private int hashCode;
        private Object object;

        public TestClass() {
        }

        public TestClass(int hashCode, Object object) {
            this.hashCode = hashCode;
            this.object = object;
        }

        public Object getObject() {
            return this.object;
        }

        public void setObject(Object object) {
            this.object = object;
        }

        public void setHashCode(int hashCode) {
            this.hashCode = hashCode;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TestClass other = (TestClass)obj;
            return !(this.object == null ? other.object != null : !this.object.equals(other.object));
        }
    }
}

