/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.drools.testcoverage.common.util.TimeUtil;
import org.junit.Ignore;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.model.KieBaseModel;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.conf.EventProcessingOption;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.conf.ClockTypeOption;
import org.kie.api.time.SessionPseudoClock;

@Ignore
public class CepFireUntilHaltTimerTest {
    private KieSession ksession;
    private List<Long> result;
    private SessionPseudoClock clock;

    public void init() {
        String drl = "package org.drools.compiler.integrationtests\n\nimport " + MetadataEvent.class.getCanonicalName() + ";\nimport java.util.List;\n\nglobal List countResult;\n\ndeclare MetadataEvent\n    @role( event )\n    @timestamp( metadataTimestamp )\n    @duration( metadataDuration )\n    @expires (24h)\nend\n\nrule \"Number of metadata events in the last 10 seconds\"\ntimer (int: 1s 10s)\n//timer (int: 0s 10s) // this works\nwhen\n    String( this == \"events_inserted\" )\n    $count: Number() from accumulate( $event: MetadataEvent() over window:time(10s),  count( $event ) )\nthen\n    System.out.println(\"Events count: \" + $count);\n    countResult.add($count);\nend\n";
        KieServices ks = KieServices.Factory.get();
        KieModuleModel module = ks.newKieModuleModel();
        KieBaseModel defaultBase = module.newKieBaseModel("defaultKBase").setDefault(true).addPackage("*").setEventProcessingMode(EventProcessingOption.STREAM);
        defaultBase.newKieSessionModel("defaultKSession").setDefault(true).setClockType(ClockTypeOption.PSEUDO);
        KieFileSystem kfs = ks.newKieFileSystem().write("src/main/resources/r1.drl", drl);
        kfs.writeKModuleXML(module.toXML());
        ks.newKieBuilder(kfs).buildAll();
        this.ksession = ks.newKieContainer(ks.getRepository().getDefaultReleaseId()).newKieSession();
        this.result = new ArrayList<Long>();
        this.ksession.setGlobal("countResult", this.result);
        this.clock = (SessionPseudoClock)this.ksession.getSessionClock();
        this.ksession.insert((Object)this.clock);
    }

    public void cleanup() {
        this.ksession.dispose();
    }

    @Test
    public void testTwoRunsTimerAccumulateFireUntilHalt() throws Exception {
        this.init();
        this.performTest();
        this.cleanup();
        this.init();
        this.performTest();
        this.cleanup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performTest() throws Exception {
        ExecutorService thread = Executors.newSingleThreadExecutor();
        Future<?> fireUntilHaltResult = thread.submit(() -> this.ksession.fireUntilHalt());
        try {
            int ITEMS = 10;
            Date eventTime = new Date(this.clock.getCurrentTime());
            for (int i = 0; i < 10; ++i) {
                this.ksession.insert((Object)new MetadataEvent(eventTime, 0L));
            }
            this.ksession.insert((Object)"events_inserted");
            TimeUtil.sleepMillis((long)500L);
            for (int count = 0; count < 40; ++count) {
                this.clock.advanceTime(1L, TimeUnit.SECONDS);
            }
            TimeUtil.sleepMillis((long)500L);
            ((AbstractBooleanAssert)Assertions.assertThat((this.result.size() >= 2 ? 1 : 0) != 0).as("The result does not contain at least 2 elements", new Object[0])).isTrue();
            Assertions.assertThat((long)this.result.get(0)).isEqualTo(10L);
            Assertions.assertThat((long)this.result.get(1)).isEqualTo(0L);
        }
        finally {
            this.ksession.halt();
            fireUntilHaltResult.get(60000L, TimeUnit.SECONDS);
            thread.shutdownNow();
        }
    }

    public static class MetadataEvent
    implements Serializable {
        private static final long serialVersionUID = 6827172457832354239L;
        private Date metadataTimestamp;
        private Long metadataDuration;
        private String name;

        public MetadataEvent() {
        }

        public MetadataEvent(Date timestamp, Long duration) {
            this.metadataTimestamp = timestamp;
            this.metadataDuration = duration;
        }

        public MetadataEvent(String name, Date timestamp, Long duration) {
            this.name = name;
            this.metadataTimestamp = timestamp;
            this.metadataDuration = duration;
        }

        public Date getMetadataTimestamp() {
            return this.metadataTimestamp != null ? (Date)this.metadataTimestamp.clone() : null;
        }

        public void setMetadataTimestamp(Date metadataTimestamp) {
            this.metadataTimestamp = metadataTimestamp != null ? (Date)metadataTimestamp.clone() : null;
        }

        public Long getMetadataDuration() {
            return this.metadataDuration;
        }

        public void setMetadataDuration(Long metadataDuration) {
            this.metadataDuration = metadataDuration;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String toString() {
            return String.format("MetadataEvent[name='%s' timestamp='%s', duration='%s']", this.name, this.metadataTimestamp, this.metadataDuration);
        }
    }
}

