/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.compiler.testframework;

import java.util.HashSet;
import org.assertj.core.api.Assertions;
import org.drools.compiler.testframework.RuleCoverageListener;
import org.drools.core.event.rule.impl.AfterActivationFiredEventImpl;
import org.drools.mvel.compiler.testframework.MockActivation;
import org.junit.Test;
import org.kie.api.event.rule.AfterMatchFiredEvent;
import org.kie.api.runtime.rule.Match;

public class RuleCoverageListenerTest {
    @Test
    public void testCoverage() throws Exception {
        HashSet<String> rules = new HashSet<String>();
        rules.add("rule1");
        rules.add("rule2");
        rules.add("rule3");
        RuleCoverageListener ls = new RuleCoverageListener(rules);
        Assertions.assertThat((int)ls.getRules().size()).isEqualTo(3);
        Assertions.assertThat((int)ls.getPercentCovered()).isEqualTo(0);
        ls.afterMatchFired((AfterMatchFiredEvent)new AfterActivationFiredEventImpl((Match)new MockActivation("rule1"), null, null));
        Assertions.assertThat((int)ls.getRules().size()).isEqualTo(2);
        Assertions.assertThat((boolean)ls.getRules().contains("rule2")).isTrue();
        Assertions.assertThat((boolean)ls.getRules().contains("rule3")).isTrue();
        Assertions.assertThat((boolean)ls.getRules().contains("rule1")).isFalse();
        Assertions.assertThat((int)ls.getPercentCovered()).isEqualTo(33);
        ls.afterMatchFired((AfterMatchFiredEvent)new AfterActivationFiredEventImpl((Match)new MockActivation("rule2"), null, null));
        Assertions.assertThat((int)ls.getRules().size()).isEqualTo(1);
        Assertions.assertThat((boolean)ls.getRules().contains("rule2")).isFalse();
        Assertions.assertThat((boolean)ls.getRules().contains("rule1")).isFalse();
        Assertions.assertThat((boolean)ls.getRules().contains("rule3")).isTrue();
        Assertions.assertThat((int)ls.getPercentCovered()).isEqualTo(66);
        ls.afterMatchFired((AfterMatchFiredEvent)new AfterActivationFiredEventImpl((Match)new MockActivation("rule3"), null, null));
        Assertions.assertThat((int)ls.getRules().size()).isEqualTo(0);
        Assertions.assertThat((boolean)ls.getRules().contains("rule2")).isFalse();
        Assertions.assertThat((boolean)ls.getRules().contains("rule1")).isFalse();
        Assertions.assertThat((boolean)ls.getRules().contains("rule3")).isFalse();
        Assertions.assertThat((int)ls.getPercentCovered()).isEqualTo(100);
    }
}

