/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.util.Collection;
import org.drools.mvel.integrationtests.SerializationHelper;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;

@RunWith(value=Parameterized.class)
public class ObjectTypeNodeTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public ObjectTypeNodeTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    @Test
    public void testDeterministicOTNOrdering() throws Exception {
        String str = "package indexingproblem.remove.me.anditworks;\ndeclare Criteria\n   processed : boolean\nend\n\ndeclare CheeseCriteria extends Criteria end\n\nrule setUp salience 10000 when\nthen\n   insert(new CheeseCriteria());\nend\n\nrule aaa when\n   CheeseCriteria( )\nthen\nend\n\nrule bbb when\n   CheeseCriteria( )\nthen\nend\n\nrule ccc when\n   CheeseCriteria( )\nthen\nend\n\nrule eeeFalse when\n   Criteria( processed == false )\nthen\nend\n\ndeclare Filter end\n\nrule fffTrue when\n   Criteria( processed == true )\n   Filter( )\nthen\nend\n\nrule ruleThatFails when\n   $criteria : Criteria( processed == false )\nthen\n   modify($criteria) { setProcessed(true) }\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ksession.fireAllRules();
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ksession.fireAllRules();
    }
}

